-- ------------------------------------------------------------------------- --
-- Project: Quest Intern module for Executive Assistant 
-- Author:  VincentSDSH				
-- ------------------------------------------------------------------------- --
local AddonName = ...
local debug = function(...) exQM.LEA_debug(exQM, ...) end
local L   = LibStub("AceLocale-3.0"):GetLocale(AddonName)
local exL = LibStub("AceLocale-3.0"):GetLocale(L.parent_AddonName)

function exQM:Quest_Accepted(event, logIndex, questID)
	local groupStem, sdbc = self.db.global.groupStem, self.db.char
	local questName, _, _, _, _, _, frequencyType = GetQuestLogTitle(logIndex) -- questType 1=normal; 2=daily; 3=weekly
		-- DEBUG DEBUG DEBUG DEBUG DEBUG DEBUG DEBUG DEBUG DEBUG DEBUG --
		-- Alter frequencyType to force the quest type being tested		 --
		-- frequencyType = 2; debug("Forced f=2")
		-- ----------------------------------------------------------- --
	if frequencyType == 1 and sdbc.autoAdd_ALL_toExecAssist then
		local taskID = sdbc.HereBeDragons[questID] -- paranoia check								-- (actually this can happen if the savedvars file isn't saved...prolly should add a validator at startup (checking quest IDs against open quests)
		if taskID then self:setChecked(taskID, false) -- and slink away carefully  	-- but this is a feature for idiots like the author, and users WERE warned off; will reconsider if it proves a popular (ha!) feature.)
		else
			local ea_taskID, ea_groupID = self:Create_Task( exQM:ExecAssist_tgtGroup(L.eaTgtGroup_Dragons), questName, exL.Manual) -- manual reset type
			sdbc.HereBeDragons[questID] = ea_taskID
			-- Make it Exclusive for the Current Character
			self:Edit_Task(ea_taskID, nil, nil, false, 2)
		end
		--debug("-- ADDING sdbc.HereBeDragons"); for k,v in pairs(sdbc.HereBeDragons) do debug(v, "tracking: "..k) end; debug("-- --")

	elseif frequencyType == 2 or frequencyType == 3 then 
		local tinder, phonebook = groupStem.tinder, groupStem.phonebook
		local tagID, tagName = GetQuestTagInfo(questID) -- 102 / Account
		local hTask, hGroup

		if not tinder[questID] then -- make Quest Entry		
		  hTask, hGroup = self:addQuestTask(questName, questID, frequencyType==2 and exL.DailyAutomatic or exL.WeeklyAutomatic)		
		  hTask.isAcctWide = tagID==102 and true or nil

			tinder[questID] = hTask.id

			if sdbc.autoAdd_toExecAssist and not hGroup.isHub then
				local ea_taskID, ea_groupID = self:Create_Task( exQM:ExecAssist_tgtGroup(), hTask.taskName,  hTask.resetType)
				hTask.ExecAssist_ID = ea_taskID -- remember
				hTask.inExecAssist = true;
				hTask.isAcctWide = tagID==102 and true or nil
				if hTask.isAcctWide then self:Edit_Task(ea_taskID, nil, nil, nil, nil, hTask.isAcctWide) end

				phonebook[ea_taskID] = hTask.id

				self:semiSmart_regrow(groupStem.agg[ hTask.p ].G) -- updates display
			end

		end

		if not hTask then hTask = groupStem.agg[ tinder[questID] ] end
		if not hGroup then hGroup = groupStem.agg[ hTask.p ] end

		if hGroup.isHub then self:promptHubBehavior_forNewQuest(hTask, hGroup) end
	end

	if sdbc.ShowQuestIDs then self:alert("Accepted: QuestID ("..tostring(questID):cf("sky", false)..")") end	
end

function exQM:Quest_TurnedIn(event, questID) -- fires when quest is turned in (=complete)
	local isDaily, isWeekly = QuestIsDaily(), QuestIsWeekly()
	-- It seems that Blizzard has burried some quests like a war crime. At least some straight-to-complete quests (like Blingtron)
	-- only seem to trigger 2 events, only one of which is relevant to our purpose here (_TurnedIn) and none of them
	-- give you the courtesy of a QuestLogIndex to get rather important things like the bleedin' name.
	-- (Not doing this for /every/ quest of this type but since I know about the Blingtrons I'll add them in as a courtesy.)
	-- LOGIC: If isDaily or isWeekly we should (technically) know about it, even if turned off
	-- 				if DorW=true and not isKnown, then add-as-best-we-can, even if the name is {Orphaned Repeatable}

	local groupStem, sdbc = self.db.global.groupStem, self.db.char
	local taskID = groupStem.tinder[questID]

	if taskID then	------------------------------------------------------------------------------------- repeatable, tracked quest
		local hTask = groupStem.agg[ taskID ]
		local hGroup = groupStem.agg[ hTask.p ]		

		if hGroup.isHub and hGroup.TrackQuestHub then  -- Largely a Blingtron/Turn-In-Only adjustment, so some redundencies
			if not hGroup.hubDataFor[ self:getCurrentUser() ] then hGroup.hubDataFor[ self:getCurrentUser() ] = {} end
			local hubData = hGroup.hubDataFor[ self:getCurrentUser() ]

			if not hubData[questID] then -- can't turn in and not be tracked
				hGroup.hubIsActiveFor[ self:getCurrentUser() ] = true
				self:Quest_TrackInExecAssist(hTask, true, hubData)
			end

			self:setChecked(hubData[questID] , true) -- mark complete b/c turn-in
 			self:assessHub(hGroup) 
		else
			if hTask.inExecAssist then self:setChecked(hTask.ExecAssist_ID, true) end -- taskID, markComplete
		end
		
	elseif not taskID and (isDaily or isWeekly) then ---------------------------------------------------- existing daily/weekly at module enable OR a war-crime quest like Blingtron
		local tagID, tagName = GetQuestTagInfo(questID) -- 102 / Account
		local tinder, phonebook = groupStem.tinder, groupStem.phonebook
		local questName = L.OrphanQuest_prefix..tostring(questID)..L.OrphanQuest_suffix
		local hTask, hGroup = self:addQuestTask(questName, questID, isDaily and exL.DailyAutomatic or exL.WeeklyAutomatic)	
		hTask.isAcctWide = tagID==102 and true or nil	

		tinder[questID] = hTask.id
		
		if (not hGroup.isHub and self.db.char.autoAdd_toExecAssist) then
				local ea_taskID, ea_groupID = self:Create_Task( exQM:ExecAssist_tgtGroup(), hTask.taskName,  hTask.resetType)
				hTask.ExecAssist_ID = ea_taskID 
				hTask.inExecAssist = true;				
				self:Edit_Task(ea_taskID, nil, nil, nil, nil, hTask.isAcctWide) -- update as true or leave it alone
 				self:setChecked(ea_taskID, true)

				phonebook[ea_taskID] = hTask.id
				self:semiSmart_regrow(groupStem.agg[ hTask.p ].G) -- updates display
		end
	elseif sdbc.autoAdd_ALL_toExecAssist then ----------------------------------------------------------- normal quest
		taskID = sdbc.HereBeDragons[questID]
		if taskID then self:setChecked(taskID, true) end
	end

	if sdbc.ShowQuestIDs then self:alert("Turned In: QuestID ("..tostring(questID):cf("sky", false)..")") end	
	-- debug("-- TURNING IN sdbc.HereBeDragons"); for k,v in pairs(sdbc.HereBeDragons) do debug(v, "tracking: "..k) end; debug("-- --")
end

function exQM:Quest_Removed(event, questID) -- fires when quest is removed from the list (=abandon, =complete)
	-- if ThereBeDragons, look for the questID and remove it. If task NOT COMPLETED, remove it; otherwise leave the Task.
	-- (if completed, it was turned in; otherwise, it was abandoned and the tracking task shouldn't be there.
	local groupStem, sdbc = self.db.global.groupStem, self.db.char
	local tinder = groupStem.tinder
	local taskID = tinder[questID]
	
	if taskID then	
		local hTask  = groupStem.agg[ taskID ]
		local hGroup = groupStem.agg[ hTask.p ]
		if hGroup.isHub then
			if hGroup.TrackQuestHub then
				local hubData = hGroup.hubDataFor[ self:getCurrentUser() ]
				if hubData and hubData[questID] then 
					if not self:getChecked(hubData[questID]) then -- it's been Abandonded				
						self:Quest_TrackInExecAssist(hTask, false, hubData) -- Abandoned
					-- else
					-- 	Not Abandoned, just cleared from the log: Complated Quests can't be Abandoned & :GetChecked()==TRUE=>Complete (unless the user is messing with us by checking the EA Task manually)
					end
				end
			end

			self:assessHub(hGroup)
		end
	elseif (not taskID) and sdbc.autoAdd_ALL_toExecAssist then -- not a currently tracked 'frequency > 1' repeatable
		taskID = sdbc.HereBeDragons[questID]
		if taskID then
			if not self:getChecked(taskID) then -- if checked, complete; otherwise quest abandoned
				self:Delete_Task(taskID)
				sdbc.HereBeDragons[questID] = nil
			end
		end
	end

	if sdbc.ShowQuestIDs then self:alert("Removed: QuestID ("..tostring(questID):cf("sky", false)..")") end	
  -- debug("-- REMOVED sdbc.HereBeDragons"); for k,v in pairs(sdbc.HereBeDragons) do debug(v, "tracking: "..k) end; debug("-- --")
end

function exQM:EventArgInvestigator(event, a, b, c, d, e)
	debug("------");debug(event, "Event: ");debug(a, "a");debug(b, "b");debug(c, "c");debug(d, "d");debug(e, "e")
end
