-- ------------------------------------------------------------------------- --
-- Project: Quest Intern module for Executive Assistant 
-- Author:  VincentSDSH				
-- Version: 1.0.1b - w7.3.5
-- ------------------------------------------------------------------------- --
-- Command: /iquest
-- ------------------------------------------------------------------------- --

local AddonName = ...
local MODULE = "Quest Intern"
local hExecAssist = LibStub("AceAddon-3.0"):GetAddon("Executive_Assistant")
exQM = hExecAssist:NewModule(MODULE, "AceEvent-3.0", "LibExecAssist-1.0")
exQM:SetEnabledState(true)
exQM.Dialog = LibStub("AceConfigDialog-3.0")
exQM.wowVer = "7.3"
local debug = function(...) exQM.LEA_debug(exQM, ...) end
local L = LibStub("AceLocale-3.0"):GetLocale(AddonName)

function exQM:OnInitialize()
	-- Plumbing --------------------------------------------- --
	self.alert = self.LEA_alert -- dev being lazy
  -- ------------------------------------------------------ --  

  -- Defaults -------------------------------------------------------------- --
	self.EventsRegistered = {}; self.prototype = {}
  self.prototype.Group = {
  	["id"] = "", -- self handle :: pass (hGroup) rather than (hGroup, groupID) when asking a parent to operate on the child's /reference/ not just the child (e.g., .DO ops, etc)
		["p"] = "", -- parent GroupID
		["listName"] = "Default New Group Name",
		["DO"] = {}
  }	
	self.prototype.Task = {
		["id"] = "", -- taskID
		["p"] = "",  -- parent GroupID
		["taskName"] = "Default New Task Name",
	}	
  self.icons = {
    ["defaultLDBIcon"]   = ([[Interface\Addons\%s\icons\QuestIntern_appIcon]]):format(AddonName),
  	["used"]  			     = ([[Interface\Addons\%s\icons\QuestIntern_used]]):format(AddonName),
  	["notused"] 			   = ([[Interface\Addons\%s\icons\QuestIntern_notused]]):format(AddonName),
  	["tool"]             = ([[Interface\Addons\%s\icons\QuestIntern_Tools]]):format(AddonName),
  	["group"]            = ([[Interface\Addons\%s\icons\QuestIntern_Group]]):format(AddonName),
  	["tgtgroup"]         = ([[Interface\Addons\%s\icons\QuestIntern_tgtGroup]]):format(AddonName),
  	["hubGroup"] 				 = ([[Interface\Addons\%s\icons\QuestIntern_hubGroup]]):format(AddonName),
  	["hubGroup_Used"] 	 = ([[Interface\Addons\%s\icons\QuestIntern_hubUsed]]):format(AddonName),
  	["hubGroup_NotUsed"] = ([[Interface\Addons\%s\icons\QuestIntern_hubNotUsed]]):format(AddonName),
  } 

  -- Setup AceDB
	self.DBDefaults = {
		["char"] = {
			["autoAdd_toExecAssist"] = true,
			["HereBeDragons"] = {} -- ThereBeDragons[questID] = eq_taskID
		},
    ["global"] = {
    	["ShowToolIntro"] = true,
    	["Options"] = {
    		["showLoginAlerts"] = false,
				["cfg_groupColor"] = {["r"] = 1, ["g"] = 1, ["b"] = 0},
    	},
    	["acctwideStem"] = { -- subbing agg to make space for possible future metadata...
				["agg"] = { -- Not /technically/ an agglomeration since only taskID completion tags would be in play 
				}    	
    	},
			["charStem"] = {
			},
			["groupStem"] = {
				["garden"] = { -- Starting Point (DO) for Groups (it was this or a hidden faux-'parent')
				},
				["hubStyle"] = {
					["hubPrefix"] = "|cffff0066[HUB]|r ",
					["hubChildPrefix"] = "|cffff0066[c]|r ",
				},
				["hubs"] = {},
				["agg"] = { -- The Great Agglomeration, groupIDs and taskIDs >> groupID.DO = Display Order
					["garden"] = { -- Starting Point (DO) for Groups (it was this or a hidden faux-'parent')
						["id"] = "garden",
						["listName"] = "garden",
						["DO"] = {}
					},				
				},
				["tinder"] = { -- Cross Index of QuestID = taskID so incoming tasks can find their local Tasks
				},
				["phonebook"] = { -- reverse Index of ea_taskID = taskID so the deleteHandler knows when to regrow the garden
				},
			},

    },
  }
  self.db = LibStub("AceDB-3.0"):New("ExecAssistQuestDB", self.DBDefaults, true)    

	-- Prime char vars and charStem
	self.userCurrent = UnitName("player").." - "..GetRealmName(); self.userConfigDisplay = self.userCurrent
 	if not self.db.global.charStem[self.userCurrent] then self.db.global.charStem[self.userCurrent] = {["agg"] = {}} end -- new user, establish agglomeration

	self:LEA_msgSetup(L.appName, L.appName_short)

	self:LEA_enableDebug( exQM.db.sv.debug )
	debug("* Debugging Mode Active *") -- dev sanity check

	-- Rebuild & Refresh Hubs, Quest Index ----------------------------------- --
	self:rebuildQuestHubs()
	
	-- Register Options ------------------------------------------------------ --
	self:regOptions()

  -- Commandline ----------------------------------------------------------- --
	local cmdLine = {
		type = "group",
		name = "",
		args = {
      config = {
        type = "execute",
        name = "",
        desc = L.AddonConfiguration,
        func = function() exQM:doLoadConfig() end,
        order = 0
      },
      help = {
        type = "execute",
        name = "",
        desc = L.HelpAndInformation,
        func = function() exQM:doLoadHelp() end,
        order = 2
      },
      debug = {
        cmdHidden = true, 
        type = "execute",
        name = "Toggle Debug",
        desc = "Toggles Debug Mode",
        func = function() exQM:doDebuggingMode() end,
        order = 3
      },      
    }
  }
 	LibStub("AceConfig-3.0"):RegisterOptionsTable(L.appName.." CmdLine", cmdLine, {"iquest"}) -- Intern - Quest => iquest

end

function exQM:OnEnable()
	local sdbg = self.db.global
	-- char prime
	sdbg.charStem[self.userCurrent].charClass = select(2, UnitClass("player")) -- reset each time in case a char is deleted and remade w/ new class and same name
	
	-- Load the DB into Options Tables
	self:loadGroups_toOptionsTable()		
	
	-- Brand New User, Setup Initial Tasks and Clickmapping
	if not sdbg.IsOldHat then	
		local groupStem = sdbg.groupStem
		local groupID = self:AddGroup(L.NewlyAddedQuests, groupStem.agg["garden"])
		local hGroup = groupStem.agg[groupID]
		sdbg.NewQuestHomeID = groupID

		-- Blingtron Quest Hub
		self:mkBlingtronQuestHub()
		-- ----------------------------------- --

		self:loadGroups_toOptionsTable()	

		sdbg.IsOldHat = true
	end

	-- Register Events
 	self:Register("QUEST_ACCEPTED",   "Quest_Accepted")
 	self:Register("QUEST_REMOVED",    "Quest_Removed")
 	self:Register("QUEST_TURNED_IN",  "Quest_TurnedIn")
end

-- Intern Functions ---------------------------------------------------------------- --
function exQM:intern_getClickMap()
	local mapStub = {
					["code"] = nil, ["m"] = false, ["s"] = nil, ["a"] = nil, ["c"] = nil, ["notify"] = true,
					["name"] = L.clickmap_QUEST_INTERN_name,
					["desc"] = L.clickmap_QUEST_INTERN_desc,
			--	["func"] = nil, -- AceDB doesn't save inline functions; they are injected separately 
				}
	
	local func = function() exQM:doLoadConfig() end
	
	return mapStub, func	
end
function exQM:intern_getNewTaskTypes() end -- this module adds no new task types

function exQM:intern_clickHandler() end -- this modules does nothing w/ clicks
function exQM:intern_resetHandler(resetDaily, resetWeekly)
	if resetDaily or resetWeekly then
		local exL = LibStub("AceLocale-3.0"):GetLocale(L.parent_AddonName)
		local groupStem = self.db.global.groupStem
		local agg, hubs = groupStem.agg, groupStem.hubs
		for i=1,#hubs do 
			local hGroup = agg[ hubs[i] ]
			if hGroup and hGroup.TrackQuestHub then 
				if (resetDaily and hGroup.resetType == exL.DailyAutomatic) 
				or (resetWeekly and hGroup.resetType == exL.WeeklyAutomatic) 
				then
					hGroup.hubIsActiveFor = {}; self:assessHub(hGroup) 
				end
			end
		end

	end
end
function exQM:intern_elementDeletionHandler(trashbin)
	-- debug(#trashbin, "exQM elementDeletionHandler")
	local refreshNeeded = false
	
	local groupStem = self.db.global.groupStem
	for n=1,#trashbin do
	-- debug(tostring(n), trashbin[n].." ------")	
		local eleID = groupStem.phonebook[ trashbin[n] ] -- =nil at some point
		if eleID then
			refreshNeeded = true
			-- it's one we're watching...
			-- have taskID, will travel...
			if self:isTask(eleID) then
				local hTask = groupStem.agg[eleID]
				if hTask then -- This shouldn't happen in normal use but just on the extreme off-chance the user is recovering one one bug, we don't need to give them a second.
					local hGroup = groupStem.agg[ hTask.p ]
					if hGroup.isHub then
						for user, hubData in pairs(hGroup.hubDataFor) do
							self:Quest_TrackInExecAssist(hTask, false, hubData, true) -- Stop ExecAssist Tracking (trailing true=ExecAssist_AlreadyDeleted)
						end
						groupStem.phonebook[trashbin[n]] = nil
					else
						hTask.ExecAssist_ID = nil
						hTask.inExecAssist = nil
						-- nix & rebuild
						groupStem.phonebook[trashbin[n]] = nil
					end		
				end
			else -- if :isGroup(eleID) then the Hub Group Task was deleted; untrack Hub Group
				local hGroup = groupStem.agg[eleID]
				if hGroup and hGroup.isHub then -- paranoia
					-- if we unburden ourselves here, we don't a recursive deletion
					groupStem.phonebook[trashbin[n]] = nil
					
					hGroup.TrackQuestHub = nil
					self:assessHub(hGroup, true) -- , true = ExecAssist_AlreadyDeleted
				end
			end
		end
	end
-- /dump exQM.db.global.groupStem.phonebook	
	if refreshNeeded then self:loadGroups_toOptionsTable() end
end
-- ----------------------------------------------------------------- Intern Functions --

function exQM:mkBlingtronQuestHub()	
	local sdbg = self.db.global
	local groupStem = sdbg.groupStem
	local exL = LibStub("AceLocale-3.0"):GetLocale(L.parent_AddonName)

	-- Blingtron Quest Hub
	local groupID = self:AddGroup("|cffff0066[HUB]|r "..L.Blingtron) -- garden
	local hGroup = groupStem.agg[groupID]
	hGroup.isHub = true
	hGroup.resetType = exL.DailyAutomatic -- default
	hGroup.isAcctWide = true              -- Quests are Acct Wide
	hGroup.hubIsActiveFor = {}
	hGroup.hubDataFor = {}
	sdbg.NewQuestTargetOverride = groupID -- temp override

	-- Blingtron 4k
	local hTask, parentIsHub, parentIsActiveHub = self:addQuestTask(L.Blingtron4K, 31752, exL.DailyAutomatic)
	hTask.isAcctWide = true		  
	groupStem.tinder[31752] = hTask.id
	
	-- Blingtron 5k
	local hTask, parentIsHub, parentIsActiveHub = self:addQuestTask(L.Blingtron5K, 34774, exL.DailyAutomatic)
	hTask.isAcctWide = true		  
	groupStem.tinder[34774] = hTask.id
	
	-- Blingtron 5k
	local hTask, parentIsHub, parentIsActiveHub = self:addQuestTask(L.Blingtron6K, 40753, exL.DailyAutomatic)
	hTask.isAcctWide = true		  
	groupStem.tinder[40753] = hTask.id
	
	sdbg.NewQuestTargetOverride = nil

	-- ----------------------------------- --
end

	-- simple actions
function exQM:doDebuggingMode() exQM.db.sv.debug = not exQM.db.sv.debug; self:alert("Debugging is: "..(exQM.db.sv.debug and "on" or "off")); self:LEA_enableDebug( exQM.db.sv.debug ) end --ReloadUI() 
function exQM:doLoadConfig() ExecAssist:doOpenConfigWindow(L.module_optionsTag1) end 
function exQM:doLoadHelp()	 ExecAssist:doLoadHelp(L.module_optionsHelp1)        end 

function exQM:rebuildQuestHubs() -- paranoia function; may be removed at some point
	-- we rely on groupStem.hubs so it must be accurate for later efficiency but
	-- a bad shutdown wouldn't write changes so it has to be reassessed at enable
	local groupStem = self.db.global.groupStem
	local agg = groupStem.agg
	groupStem.hubs = {}

	for k, v in pairs(agg) do
		if self:isGroup(k) and v.isHub then
			table.insert(groupStem.hubs, k)
		end		
	end
end

function exQM:assessHub(hGroup, ExecAssist_AlreadyDeleted)
	local groupStem = self.db.global.groupStem
	local hubs, agg = groupStem.hubs, groupStem.agg
	local hTask

-- hGroup.hubIsActiveFor[ USER ] = {
--	USER = true,
-- }
-- hGroup.hubDataFor[ USER ] = {
--	USER = {
-- 		[questID] = taskID,
--  }
-- }

	if hGroup.TrackQuestHub	then
		local reactivateHub = false
		local hubIsActive = hGroup.hubIsActiveFor[ self:getCurrentUser() ]
		local hubData = hGroup.hubDataFor[ self:getCurrentUser() ]

		if hubIsActive then														-- if hubIsActive, and all ExecAssist Tasks = checked, hub=complete else hub=uncomplete
			if hubData then -- paranoia wrapper
				local allDone, numTasks = true, 0

				for n=1,#hGroup.DO do
					hTask = agg[ hGroup.DO[n] ]

					if hubData[hTask.questID] then -- has an ExecAssist Task
						numTasks=numTasks+1
						if not self:getChecked(hubData[hTask.questID]) then
							allDone = false
							break;
						end
					end				
				end
				-- need to check existence of _show; if it's deleted it's extremely hard to check or uncheck
				if allDone and self:getHandle(hGroup.hubID_show) then self:setChecked( hGroup.hubID_show, numTasks>0 and true or false) end -- 0 Children = Unchecked, regardless
			end
		else
			-- there's no condition where _show=true if _hide=false; better safe than sorry, esp if the user checked it themselves
			self:setChecked( hGroup.hubID_show, false )

			-- if not .hubIsActiveFor(user), it's a) a new day or b) no quests logged
			-- We want to clear it out /however/ daily quests will carry over so we don't want to nix any that are in the quest log
			-- SO if _hide=unchecked and hub-quest-in-log then we have to set _hide=checked and _show=unchecked
			if hubData then -- paranoia wrapper
				local questLogIndex
				for n=1,#hGroup.DO do
					hTask = agg[ hGroup.DO[n] ]
					questLogIndex = GetQuestLogIndexByID(hTask.questID)
					
					if hubData[hTask.questID] then -- has an ExecAssist Task
						if questLogIndex == 0 then
							self:Quest_TrackInExecAssist(hTask, false, hubData) -- Stop ExecAssist Tracking
						else
							if not reactivateHub then -- so we don't reset these several times
								hGroup.hubIsActiveFor[ self:getCurrentUser() ] = true
								reactivateHub = true
							end
						end
						
					end
				end	
			end
			
		end			
	else -- not hGroup.TrackQuestHub	
	-- called this way for decommissioning a Quest Hub Group.
		for n=1,#hGroup.DO do
			hTask = agg[ hGroup.DO[n] ]			
			for user, hubData in pairs(hGroup.hubDataFor) do
				self:Quest_TrackInExecAssist(hTask, false, hubData) -- Stop ExecAssist Tracking
			end			
		end			
		hGroup.hubDataFor = {}
		hGroup.hubIsActiveFor = {} 
		if not ExecAssist_AlreadyDeleted then self:Delete_Task( hGroup.hubID_show ); hGroup.hubID_show = nil end
	end
		
end

------- Misc Functions --------
	-- makes text hyperlinks for graphics to be used inline
function exQM:mkLink(path, size) return ("\124T"..path..":%d:%d:1:0\124t"):format(size, size) end
	-- plumbing functions
function exQM:rCopyTable(O)
	-- Recursive table copy, handles metatables and avoids __pairs metamethod
    local O_type = type(O)
    local C
    if O_type == 'table' then
        C = {}
        for O_key, O_value in next, O, nil do
            C[exQM:rCopyTable(O_key)] = exQM:rCopyTable(O_value)
        end
        setmetatable(C, exQM:rCopyTable(getmetatable(O)))
    else  -- numbers, strings, small dancing frogs named Hector, booleans, etc, etc
        C = O
    end
    return C
end
	-- event handling
function exQM:Register(E, F) if (not self.EventsRegistered[E]) then self.EventsRegistered[E] = true;  self:RegisterEvent(E, F) end end
function exQM:Unregister(E)  if (self.EventsRegistered[E])     then self.EventsRegistered[E] = false; self:UnregisterEvent(E)  end end

local function dec2hex(dec)
	local base = 16
	local key = "0123456789ABCDEF"
	local i=0
	local rc = ""
	
	if dec==0 then rc = "00"
	else
		while dec>0 do
			i=i+1
			dec, D = math.floor(dec/base), math.fmod(dec, base)+1 -- nb: must remain same line
			rc = string.sub(key, D, D)..rc
		end
	end
	if string.len(rc) == 1 then rc = "0"..rc end
	return rc
end
function exQM:tbl_pcColorToHex(tbl) return dec2hex(tbl.r*255)..dec2hex(tbl.g*255)..dec2hex(tbl.b*255) end
