--[[ DISABLE ADDON IF CHAR ISN'T A PALADIN]]--
if select(2, UnitClass('player')) ~= "PALADIN" then
    DisableAddOn("QuiHolyPower")
    return
else
	--PaladinPowerBarFrame:SetAlpha(0)
end


--[[ Add the foldername of style pack in the avalibleStyles table  ]]--
local avalibleStyles = { ["basic"] = true, ["basic-2"] = true }

--[[ Path to styles directory ]]--
local gfxPath = "Interface\\AddOns\\QuiHolyPower\\gfx\\";

--[[ File names of the style pack images ]]--
local hpGfx = { [0]="0.tga", [1]= "1.tga", [2]= "2.tga", [3]= "3.tga", [4]= "4.tga", [5]= "5.tga"}

local locked = true;
local barStyle = nil;
local emptyStyle = nil;
local hpBar, events = CreateFrame("Frame", "QUIHP", UIParent ), {}
local tex = hpBar:CreateTexture( )


function events:ADDON_LOADED()
	

	if( not options ) then 
		DEFAULT_CHAT_FRAME:AddMessage('no saved variables, setting default')
		hpBar:SetPoint("CENTER", 0, 0 )
		hpBar:SetScale( 1.4 )
		barStyle = "basic"
		emptyStyle = 0
	else 
		barStyle = options.style
		emptyStyle = options.showEmpty
		hpBar:SetPoint( options.point, options.xOffset, options.yOffset )
		hpBar:SetScale( options.scale )
	end
	
	hpBar:SetWidth(128)
	hpBar:SetHeight(128)
	hpBar:SetAlpha(1)
	hpBar:SetMovable()
	tex:SetAllPoints(hpBar)
	tex:SetAlpha(1)

	if( emptyStyle == 1 and GetSpecialization() == 3 ) then
		tex:SetTexture( gfxPath..barStyle.."\\0.tga" )
		hpBar:Show()	
	end
end





function events:UNIT_POWER( source,type )
	hpGfx = { [0]= "0.tga", [1]= "1.tga", [2]= "2.tga", [3]= "3.tga", [4]= "4.tga", [5]= "5.tga"}
	if( (UnitPower("player", 9 ) == 0  and emptyStyle == 0 ) or GetSpecialization() ~= 3  ) then
		hpBar:Hide()
	else
		hpBar:Show()
	end
	tex:SetTexture( gfxPath..barStyle.."\\"..hpGfx[ UnitPower("player",9 )] )
end

function events:PET_BATTLE_OPENING_START( source, type )
	hpBar:Hide()
end
	
function events:PET_BATTLE_CLOSE( source, type )
	hpBar:Show()
end	

function events:UNIT_ENTERING_VEHICLE( )
	hpBar:Hide()
end

function events:UNIT_EXITING_VEHICLE( )
	hpBar:Show()
end	

function events:PLAYER_LOGOUT()
	local p, rt, rp, x, y = hpBar:GetPoint(index)
	options = { 
				style = barStyle,
				showEmpty = emptyStyle,
				scale = hpBar:GetScale(),
				point = p, 
				xOffset = x,
				yOffset = y,
			}
end


hpBar:SetScript("OnEvent",function(self,event,...) events[event](self,...) end)

for k,v in pairs(events) do
    hpBar:RegisterEvent(k)
end


--[[ Command line options ]]--
SLASH_QUIHP1  = "/quihp";
SlashCmdList["QUIHP"] = function( cmd_line )
	local cmd, param = strsplit(" ", cmd_line, 2)
	if( cmd == "lock") then 
		hpBar:toggleLock()
	elseif( cmd == "scale" ) then
		if( not param ) then
			DEFAULT_CHAT_FRAME:AddMessage( "QUI HolyPowerBar:")
			DEFAULT_CHAT_FRAME:AddMessage( " Scale is set to: "..hpBar:GetScale() )
		else
			hpBar:SetScale( param )
			DEFAULT_CHAT_FRAME:AddMessage( "QUI holyPowerBar:") 
			DEFAULT_CHAT_FRAME:AddMessage( " Scale set to: "..param )
		end
	elseif( cmd == "style" ) then
		if(  not param ) then 
			DEFAULT_CHAT_FRAME:AddMessage("QUI HolyPowerBar:" )
			DEFAULT_CHAT_FRAME:AddMessage(" Avalible Styles")
			for k,v in pairs( avalibleStyles ) do
				DEFAULT_CHAT_FRAME:AddMessage( "  "..k )
			end
		elseif(  param  ) then	
			if( avalibleStyles[ param ] ) then
				barStyle = param
				tex:SetTexture( gfxPath..barStyle.."\\"..hpGfx[ UnitPower("player",9 )] )
				DEFAULT_CHAT_FRAME:AddMessage( "QUI HolyPowerBar:")
				DEFAULT_CHAT_FRAME:AddMessage( " Style set to: "..param )
			else 
				DEFAULT_CHAT_FRAME:AddMessage( "QUI HolyPowerBar:")
				DEFAULT_CHAT_FRAME:AddMessage( " Style '"..param.."' is not avalible!" )
			end
		end
	elseif( cmd == "emptybar" ) then
		if( emptyStyle == 1 ) then
			if( UnitPower("player",9 ) == 0 ) then
				hpBar:Hide()
			end
			emptyStyle = 0
			
			DEFAULT_CHAT_FRAME:AddMessage( "QUI HolyPowerBar:" )
			DEFAULT_CHAT_FRAME:AddMessage( " Hide empty holypower bar" )
		
		else
			if( UnitPower("player",9 ) == 0 ) then
				hpBar:Show()
			end
			emptyStyle = 1
			
			DEFAULT_CHAT_FRAME:AddMessage( "QUI HolyPowerBar:" )
			DEFAULT_CHAT_FRAME:AddMessage( " Show empty holypower bar" )
			
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage( "QUI HolyPowerBar:" )
		DEFAULT_CHAT_FRAME:AddMessage( "Command line options:" )
		DEFAULT_CHAT_FRAME:AddMessage( "   /quihp lock   (To lock or unlock frame)" )
		DEFAULT_CHAT_FRAME:AddMessage( "   /quihp scale [<value>] (To set scale. Default value is 1.4)" )
		DEFAULT_CHAT_FRAME:AddMessage( "   /quihp style [<style>] (To set style. Default style is basic)" )
		DEFAULT_CHAT_FRAME:AddMessage( "   /quihp emptybar  (Toggles empty bar visibility. Default is visible )" )
	end
end

function hpBar:toggleLock()
	if locked then
		DEFAULT_CHAT_FRAME:AddMessage( 'QUI HolyPowerBar unlocked' )
		locked = false
		
		hpBar:SetMovable(true)
		hpBar:EnableMouse(true)
		hpBar:RegisterForDrag("LeftButton")
		hpBar:SetScript("OnDragStart", hpBar.StartMoving)
		hpBar:SetScript("OnDragStop", hpBar.StopMovingOrSizing)
		
		hpBar:Show()
 
	else  
		DEFAULT_CHAT_FRAME:AddMessage( 'QUI HolyPowerBar locked' )
		
		locked = true
		hpBar:EnableMouse(false)
		hpBar:RegisterForDrag(nil)
		hpBar:SetScript("OnDragStart", nil)
		hpBar:SetScript("OnDragStop", nil)
		
		if( (emptyStyle == 0  and  UnitPower("player",9) == 0) and GetSpecialization() ~=3  ) then
			hpBar:Hide()
		end
	end
end


