--[[
-- Utilities--
-- ]]

-- splits the string at the spaces to an array
function splitSpace(string)
    local returnArray = {};
    local counter = 1;
    for i in string.gmatch(string, "%S+") do
        returnArray[counter] = i;
        counter = counter + 1;
    end
    return returnArray;
end

-- load language files
function loadLocalizedStrings()
    local locale = GetLocale();
    local lang = _G["language" .. firstToUpper(locale)];
    if(lang == nil) then
        return languageEnUS;
    else
        return lang;
    end
end

-- returns localized role
function getLocalizedRole(role)
    return language["wow.role." .. role:lower()];
end

-- sends the message depending on the languagekey with replacements
function sendLocalizedMsg(key, ...)
    if(... == nil) then
        sendMsg(language[key]);
    else
        sendMsg(string.format(language[key], ...));
    end

end


-- sends the row of language keys with .1, .2, .3, .4 ...
function sendHelp(key)
    local counter = 1;

    while (language[key .. "." .. counter] == nil) == false  do
        sendLocalizedMsg(key .. "." .. counter);
        counter = counter + 1;
    end

end

-- check if a string (text) ends with pattern
function str_ends(text, pattern)
    return pattern == '' or string.sub(text,-string.len(pattern))==pattern
end

-- taken from http://lua-users.org/wiki/StringRecipes
function firstToUpper(str)
    return (str:gsub("^%l", string.upper))
end

function str_contains(text, pattern)
    return (string.match(text, pattern) == nil) == false;
end

-- get the faction from a text [0 -> Horde; 1 -> Alliance; nil -> neither one of the two]
function getFactionFromText(factionName)
    if(factionName == "Horde" or factionName == "HORDE" or factionName == "horde" or 0) then
        return 0;
    elseif(factionName == "Alliance" or factionName == "ALLIANCE" or factionName == "alliance" or 1) then
        return 1
    end
        return nil;
end

-- returns the factionID from the current player;
function getFactionOfPlayer()
    local englishFaction, _ = UnitFactionGroup("Player");
    return getFactionFromText(englishFaction);
end


-- merging two arrays
function tableMerge(t1, t2)
    for k,v in pairs(t2) do
        if type(v) == "table" then
            if type(t1[k] or false) == "table" then
                tableMerge(t1[k] or {}, t2[k] or {})
            else
                t1[k] = v
            end
        else
            t1[k] = v
        end
    end
    return t1
end

function replaceOnOff(input)
    if(input:lower() == "on") then
        return "1";
    else
        return "0";
    end
end