-- init specs
iconSets = {"blizz", "modern", "retro"};

-- checks if the given sets exists
function setExists(setName)
    for i=1, table.getn(iconSets), 1 do
        if(iconSets[i] == setName) then
            return true;
        end
    end
    return false;
end

-- resets the saved vars
function getDefaultSaveVars()
    local tmp = {
        ["left"] = -10,	-- to TargetFrame
        ["top"] = 10,	-- to Top of TargetFrame
        ["iconSet"] = 2,-- iconSet for images
        ["debug"] = 0,   -- if set to 1, debug messages will happen
        ["printSpecs"] = 0, -- if set to 1, print spec of your target in chat
        ["playSound"] = 1, -- if set to 1, sounds are enabled
        ["playTankSound"] = 0, -- if set to 1, sound will be played when a tank is targeted
        ["playHealerSound"] = 0, -- if set to 1, sound will be played when a healer is targeted
        ["playDamagerSound"] = 0, -- if set to 1, sound will be played when a damager is targeted
        ["playSoundOwnFaction"] = 0, -- set to 1 to play sounds, if target is friendly
        ["tankSound"] = "Sound\\interface\\AlarmClockWarning1.ogg", -- sound for tank
        ["healerSound"] = "Sound\\interface\\AlarmClockWarning3.ogg", -- sound for healer
        ["damagerSound"] = "Sound\\interface\\AlarmClockWarning2.ogg", -- sound for damager
        ["whatsNewStamp"] = "0" -- stamp to compare if version was already loaded
    };

    return tmp;
end

-- will add non existing parts of the save variables
function initSaveVars()
    debug("Init Save Vars");
    local defaults = getDefaultSaveVars();
    PVPRole_SV = tableMerge(defaults, PVPRole_SV);
    debug("Init Save Vars END");
end

-- will reset the save variables to default
function resetVars()
    debug("reset Vars");
    PVPRole_SV = getDefaultSaveVars();
end

-- load available specs and roles in locale
function loadLocalizedSpecs()
    specRole = { };
    for classID=1, MAX_CLASSES do
        local numTabs = GetNumSpecializationsForClassID(classID);
        for i=1, numTabs do
            local _, name, _, _, _, role = GetSpecializationInfoForClassID(classID, i);
            specRole[name] = role;
        end
    end
end


-- returns the specific role name for the spec
-- returns [TANK, HEALER, DAMAGER]
function getRoleForLocalizedSpec(spec)
    local role = specRole[spec];
    if(role == nil) then
        return 0;
    end
    return role;
end



-- sets the icon set
-- allowed values [1,2] or ["blizz", "modern"]
function setIconSet(newStyle)
    if(newStyle == "blizz" or newStyle == 1) then
        PVPRole_SV.iconSet = 1;
    elseif(newStyle == "modern" or newStyle == 2) then
        PVPRole_SV.iconSet = 2;
    end

    debug("Set style to " .. PVPRole_SV.iconSet);
end

-- loads the players in the table and returns it
function loadPlayers()
    debug("load players");
    local tmp = {};
    local playersInBattlefield = GetNumBattlefieldScores();		-- num of players in bg
    for i = 1, playersInBattlefield, 1 do -- check all players in battleground stats
        -- load in array
        local name, _, _, _, _, faction, _, _, _, _, _, _, _, _, _, talentSpec = GetBattlefieldScore(i);
        tmp[name] = {name=name, faction=faction, spec=talentSpec, role=getRoleForLocalizedSpec(talentSpec)};
    end

    return tmp;
end

--[[
-- ICON FUNCTIONS
-- ]]
    -- Returns the string for the icon for the given role
    function getIconForRole(role)
        local baseDir = "Interface\\AddOns\\PvPRoles\\textures\\";
        local fileType = ".blp";
        local iconSet = tonumber(PVPRole_SV.iconSet);

        -- secured up not to allow style not provided
        if(iconSet > 0 and iconSet <= table.getn(iconSets)) then
            baseDir = baseDir .. iconSets[iconSet] .. "\\";
        end

        if(role == "TANK" or role == 1) then
            return baseDir .. "Tank" .. fileType;
        end

        if(role == "HEALER" or role == 2) then
            return baseDir .. "Heal" .. fileType;
        end

        if(role == "DAMAGER" or role == 3) then
            return baseDir .. "Damage" .. fileType;
        end
    end


    -- shows the icon for the player
    function showPlayerRoleIcon(p)
        showFrame(p.role);
    end

    -- show icon for role
    function showFrame(role)
        pvprolesFrame:SetBackdrop({bgFile = getIconForRole(role), 0, tile = false, tileSize = 0, edgeSize = 0, insets = { left = 0, right = 0, top = 0, bottom = 0 }});
        pvprolesFrame:Show();
    end

    function hidePlayerRoleIcon()
        pvprolesFrame:Hide();
    end

--[[
-- ICON ENDS
-- ]]

--[[
-- TEXT FUNCTIONS
-- ]]
    -- prints the player roleText in chat
    function sendPlayerRoleText(p)
        if(PVPRole_SV.printspec == 1) then
            sendLocalizedMsg("pvproles.printspec", p.name, p.spec, p.role);
        end
    end
--[[
--  TEXT ENDS
-- ]]

--[[
-- SOUND FUNCTIONS
-- ]]
    -- plays the sound of the role
    function playRoleSound(role)
        if(PVPRole_SV.playSound == 1) then
            if((role == "TANK" or role == 1) and PVPRole_SV.playTankSound == 1) then
                playFromSoundFile(PVPRole_SV.tankSound);
            end

            if(role == "HEALER" or role == 2 and PVPRole_SV.playHealerSound == 1) then
                playFromSoundFile(PVPRole_SV.healerSound);
            end

            if(role == "DAMAGER" or role == 3 and PVPRole_SV.playDamagerSound == 1) then
                playFromSoundFile(PVPRole_SV.damagerSound);
            end
        end
    end

    -- chooses the sound engine depending on the filename
    function playFromSoundFile (fileName)
        debug("playFromSoundFile");
        debug(fileName);
        if(str_contains(fileName, "\\") and (str_ends(fileName, ".ogg") or str_ends(fileName, ".mp3"))) then
            debug("matched general file");
            PlaySoundFile(fileName, "SFX");
        elseif (str_ends(fileName, ".ogg") or str_ends(fileName, ".mp3")) then
            debug("matched addon file");
            PlaySoundFile("Interface\\AddOns\\PvPRoles\\sounds\\" .. fileName, "SFX");
        else
            debug("matched internal sound");
            PlaySound(fileName, "SFX");
        end
    end

    -- plays the sound for the given player if active
    function playPlayerRoleSound(p)
        if((p.faction == getFactionOfPlayer() and PVPRole_SV.playSoundOwnFaction == 1) or (p.faction == getFactionOfPlayer()) == false) then
            playRoleSound(p.role);
        end
    end

--[[
-- SOUNDS ENDS
-- ]]

-- triggers all parts needed for the target (sound, text, icon
function handleTarget()
    if(UnitIsPlayer("target")  == true) then
        local targetName, targetRealm = UnitName("target");
        if(targetName and targetRealm) then
            targetName = targetName .."-".. targetRealm;
        end

        if((players[targetName] == nil) == false) then
            local player = players[targetName];
            showPlayerRoleIcon(player);
            playPlayerRoleSound(player);
            sendPlayerRoleText(player);
        else
            loadPlayers();
            handleTarget();
        end
    else
        hidePlayerRoleIcon();
    end
end

-- prints texts if debug is activated
function debug(message)
    if(PVPRole_SV.debug == 1) then
        print("|cFFFF0000[PVPRoles - DEBUG]|r " .. message);
    end
end

-- prints message in the chat with prefix
function sendMsg(message)
    print("|cFFAAAA66[PvPRoles]|r " .. message);
end

function setDebug(debugValue)
    PVPRole_SV.debug = debugValue;
end


--[[
-- COMMAND FUNCTIONS
-- ]]

-- debug
function doDebugCommand(params)
    local newDebug = 1
    if((params[1] == nil) == false and (tonumber(params[1]) == 1 or tonumber(params[1]) == 0)) then
        newDebug = tonumber(params[1]);
    else
        if(PVPRole_SV.debug == 0) then
            newDebug = 1;
        else
            newDebug = 0;
        end
    end
    setDebug(newDebug);

    sendLocalizedMsg("pvproles.cmd.debug." .. newDebug);
end

-- reset
function doResetCommand()
    resetVars();
    sendLocalizedMsg("pvproles.cmd.reset.executed");
end

-- reload
function doReloadCommand()
    loadLocalizedSpecs();
    sendLocalizedMsg("pvproles.cmd.reload.executed");
end

-- options iconset
function doOptionsIconsetCommand(params)
    pvprolesFrame:Hide();
    if((params[2] == nil) == false and setExists(params[2]:lower())) then
        setIconSet(params[2]:lower());

        sendLocalizedMsg("pvproles.cmd.options.iconset.changed", {iconSets[PVPRole_SV.iconSet]});
    else

        sendLocalizedMsg("pvproles.cmd.options.iconset.help.1");
        for i=1, table.getn(iconSets), 1 do
            sendMsg(iconSets[i]);
        end

        sendLocalizedMsg("pvproles.cmd.options.iconset.help.2", {iconSets[PVPRole_SV.iconSet]});
    end
end

-- options printspec
function doOptionsPrintspecCommand(params)
    if(tonumber(params[2]) == 0 or tonumber(params[2]) == 1) then
        PVPRole_SV.printSpec = tonumber(params[2]);
        if(tonumber(params[2]) == 0) then
            sendLocalizedMsg("pvproles.cmd.options.printspec.toOff");
        else
            sendLocalizedMsg("pvproles.cmd.options.printspec.toOn");
        end
    else
        sendHelp("pvproles.cmd.options.printspec.help")
    end
end

-- sound setsound
function doSoundSetSound(params)

    --[===[@debug
    debug("Do sound set sound")
    for index,value in ipairs(params) do
        debug(index .. " > " .. value)
    end
    --@end-debug]===]

    if(params[2] == nil or params[3] == nil) then
        sendHelp("pvproles.cmd.sounds.setsound.help");
    else
        params[2] = params[2]:lower();
        if(params[2] == "tank" or params[2] == "healer" or params[2] == "damager") then
            PVPRole_SV[params[2] .. "Sound"] = params[3];
            sendLocalizedMsg("pvproles.cmd.sounds.setSound.changed", getLocalizedRole(params[2]));
        else
            sendHelp("pvproles.cmd.sounds.setsound.help");
        end
    end
end


-- sound set
function doSoundSet(params)

    --[===[@debug
    debug("Do sound set")
    for index,value in ipairs(params) do
        debug(index .. " > " .. value)
    end
    --@end-debug]===]

    if(params[2] == nil) then
        sendHelp("pvproles.cmd.sound.set.help");
    else
        params[2] = params[2]:lower();
        if(params[2] == "tank" or params[2] == "healer" or params[2] == "damager") then
            if(params[3] == nil) then
                sendHelp("pvproles.cmd.sound.set.help");
            elseif(params[3]:lower() == "on" or params[3]:lower() == "off") then
                params[3] = replaceOnOff(params[3]);
                doSoundSet(params);
            elseif(tonumber(params[3]) == 0 or tonumber(params[3]) == 1) then
                params[2] = firstToUpper(params[2]);
                PVPRole_SV["play" .. params[2] .. "Sound"] = tonumber(params[3]);
                sendLocalizedMsg("pvproles.cmd.sounds.set.changed.role.".. params[3], getLocalizedRole(params[2]));
            else
                sendHelp("pvproles.cmd.sound.set.help");
            end

        elseif(params[2] == "on" or params[2] == "off") then
            params[2] = replaceOnOff(params[2]);
            doSoundSet(params);
        elseif(tonumber(params[2]) == 0 or tonumber(params[2]) == 1) then
            PVPRole_SV["playSound"] = tonumber(params[2]);
            sendLocalizedMsg("pvproles.cmd.sounds.set.changed.global.".. params[2]);
        else
            sendHelp("pvproles.cmd.sounds.set.help");
        end
    end
end