PVPRole_SV = nil;

local name = "PVPRoles"
PVPRoles = LibStub("AceAddon-3.0"):NewAddon(name, "AceConsole-3.0");



pvprolesFrame = nil;
specRole = {};
players = {};
language = {};


-- command line options
function PVPRoles:SlashProcessor_PVPRoles(input)
    local command, paramList= input:match("^(%S*)%s*(.-)$")
    command = command:lower()
    local params = splitSpace(paramList);

    debug("Params: " .. command .. " " .. paramList);

    --[===[@debug
    for index,value in ipairs(params) do
        debug(index .. " > " .. value)
    end
    --@end-debug]===]

    if(command == "debug") then
        doDebugCommand(params);
    elseif(command == "reset") then
        doResetCommand();
    elseif(command == "reload") then
        doReloadCommand();
    elseif(command == "options") then
        if(params[1] == nil or params[2] == nil) then
            sendHelp("pvproles.cmd.options.help");
        else
            -- options
            -- iconset
            if(params[1]:lower() == "iconset") then
                doOptionsIconsetCommand(params);
            -- printspec
            elseif(params[1]:lower() == "printspec") then
                doOptionsPrintspecCommand(params);
            end

        end
    elseif(command == "sounds") then
        if(params[1] == nil) then
            sendHelp("pvproles.cmd.sounds.help");
        elseif(params[1]:lower() ==  "sound") then
            doSoundSetSound(params);
        elseif(params[1]:lower() == "set") then
            doSoundSet(params);
        else
            sendHelp("pvproles.cmd.sounds.help");
        end

    --[===[@debug
    elseif(command == "showinfo") then
        debug("showing options");
        for key,value in pairs(PVPRole_SV) do
            debug(key .. " >> " .. value);
        end

    --@end-debug]===]
    else
        sendHelp("pvproles.cmd.help");
    end
end


function PVPRoles:OnInitialize()
    -- Standard saved variables
    if(PVPRole_SV == nil) then
        PVPRole_SV = getDefaultSaveVars();
    else
        initSaveVars();
    end



    PVPRoles:RegisterChatCommand("PVPRoles", "SlashProcessor_PVPRoles");
    language = loadLocalizedStrings();
    loadLocalizedSpecs();


    -- show whatsnew message the first time loading a new version
    if((language["pvproles.whatsnew.stamp"] == PVPRole_SV["whatsNewStamp"]) == false) then
        sendHelp("pvproles.whatsnew");
        PVPRole_SV["whatsNewStamp"] = language["pvproles.whatsnew.stamp"];
    end

    -- get Information about TargetFrame
    local left = TargetFrame:GetWidth() + PVPRole_SV.left;
    local top = -1 * PVPRole_SV.top;

    pvprolesFrame = CreateFrame("frame", "Roles", UIParent);
    pvprolesFrame:SetPoint("TOPLEFT", TargetFrame,"TOPLEFT",left,top);
    pvprolesFrame:RegisterEvent("PLAYER_TARGET_CHANGED");
    pvprolesFrame:RegisterEvent("PLAYER_ENTERING_WORLD");
    pvprolesFrame:RegisterEvent("UPDATE_BATTLEFIELD_SCORE");
    pvprolesFrame:RegisterEvent("GROUP_ROSTER_UPDATE");
    pvprolesFrame:SetFrameStrata("BACKGROUND");
    pvprolesFrame:SetWidth(64);
    pvprolesFrame:SetHeight(64);

    pvprolesFrame:SetScript("OnEvent",function(s,event,a)

        if(event == "PLAYER_TARGET_CHANGED" and select(2, IsInInstance()) == "pvp") then
            handleTarget();
        elseif(event == "GROUP_ROSTER_UPDATE" and select(2, IsInInstance()) == "pvp") then
            RequestBattlefieldScoreData();
        elseif(event == "PLAYER_ENTERING_WORLD" and select(2, IsInInstance()) == "pvp") then
            RequestBattlefieldScoreData();
        elseif(event == "UPDATE_BATTLEFIELD_SCORE" and select(2, IsInInstance()) == "pvp") then
            players = loadPlayers();
        else
            pvprolesFrame:Hide();       -- hide in general
        end
    end);
    debug("Init completed");
end