-----------------------------
-- Bunch of functions inc! --
-----------------------------
function PA_ButtonControl(Button,state)
	if(Button == "Master") then
		if(state == "Enable") then
			PA_SavedSettings["MasterChecked"] = true
			if(PA_SavedSettings["MinimapChecked"]) then
				MinimapButton:Enable()
				if not(PA_Minimap==nil and PA_Minimap:IsShown()) then PA_Minimap:Show(); end
			end
			MillingButton:Enable()
			HerbButton:Enable()
			HerbalismButton:Enable()
			ProspectingButton:Enable()
			OreButton:Enable()
			MiningButton:Enable()
			EnchantingButton:Enable()
			MaterialButton:Enable()
			if(PA_SavedSettings["MillingChecked"]) then
				MillingChatButton:Enable()
				MillingBind:Enable()
			end
			if(PA_SavedSettings["HerbChecked"]) then
				HerbChatButton:Enable()
				HerbBind:Enable()
			end
			if(PA_SavedSettings["HerbalismChecked"]) then
				HerbalismChatButton:Enable()
				HerbalismBind:Enable()
			end
			if(PA_SavedSettings["ProspectingChecked"]) then
				ProspectingChatButton:Enable()
				ProspectingBind:Enable()
			end
			if(PA_SavedSettings["OreChecked"]) then
				OreChatButton:Enable()
				OreBind:Enable()
			end
			if(PA_SavedSettings["MiningChecked"]) then
				MiningChatButton:Enable()
				MiningBind:Enable()
			end
			if(PA_SavedSettings["EnchantingChecked"]) then
				EnchantingChatButton:Enable()
				EnchantingBind:Enable()
			end
			if(PA_SavedSettings["MaterialChecked"]) then
				MaterialChatButton:Enable()
				MaterialBind:Enable()
			end
		end
		if(state == "Disable") then
			PA_SavedSettings["MasterChecked"] = false
			if not(PA_SavedSettings["MinimapChecked"]) then
				MinimapButton:Disable()
				if(PA_Minimap~=nil and PA_Minimap:IsShown()) then PA_Minimap:Hide(); end
			end
			MillingButton:Disable()
			MillingChatButton:Disable()
			MillingBind:Disable()
			HerbButton:Disable()
			HerbChatButton:Disable()
			HerbBind:Disable()
			HerbalismButton:Disable()
			HerbalismChatButton:Disable()
			HerbalismBind:Disable()
			ProspectingButton:Disable()
			ProspectingChatButton:Disable()
			ProspectingBind:Disable()
			OreButton:Disable()
			OreChatButton:Disable()
			OreBind:Disable()
			MiningButton:Disable()
			MiningChatButton:Disable()
			MiningBind:Disable()
			EnchantingButton:Disable()
			EnchantingChatButton:Disable()
			EnchantingBind:Disable()
			MaterialButton:Disable()
			MaterialChatButton:Disable()
			MaterialBind:Disable()
		end
	end
	if(Button == "Minimap") then
		if(state == "Enable") then PA_SavedSettings["MinimapChecked"] = true end
		if(state == "Disable") then PA_SavedSettings["MinimapChecked"] = false end
	end
	if(Button == "Milling") then
		if(state == "Enable") then
			PA_SavedSettings["MillingChecked"] = true
			MillingChatButton:Enable()
			MillingBind:Enable()
		end
		if(state == "Disable") then
			PA_SavedSettings["MillingChecked"] = false
			MillingChatButton:Disable()
			MillingBind:Disable()
		end
		MillingButton:SetChecked(PA_SavedSettings["MillingChecked"])
	end
	if(Button == "Herb") then
		if(state == "Enable") then
			PA_SavedSettings["HerbChecked"] = true
			HerbChatButton:Enable()
			HerbBind:Enable()
		end
		if(state == "Disable") then
			PA_SavedSettings["HerbChecked"] = false
			HerbChatButton:Disable()
			HerbBind:Disable()
		end
		HerbButton:SetChecked(PA_SavedSettings["HerbChecked"])
	end
	if(Button == "Herbalism") then
		if(state == "Enable") then
			PA_SavedSettings["HerbalismChecked"] = true
			HerbalismChatButton:Enable()
			HerbalismBind:Enable()
		end
		if(state == "Disable") then
			PA_SavedSettings["HerbalismChecked"] = false
			HerbalismChatButton:Disable()
			HerbalismBind:Disable()
		end
		HerbalismButton:SetChecked(PA_SavedSettings["HerbalismChecked"])
	end
	if(Button == "Prospecting") then
		if(state == "Enable") then
			PA_SavedSettings["ProspectingChecked"] = true
			ProspectingChatButton:Enable()
			ProspectingBind:Enable()
		end
		if(state == "Disable") then
			PA_SavedSettings["ProspectingChecked"] = false
			ProspectingChatButton:Disable()
			ProspectingBind:Disable()
		end
		ProspectingButton:SetChecked(PA_SavedSettings["ProspectingChecked"])
	end
	if(Button == "Ore") then
		if(state == "Enable") then
			PA_SavedSettings["OreChecked"] = true
			OreChatButton:Enable()
			OreBind:Enable()
		end
		if(state == "Disable") then
			PA_SavedSettings["OreChecked"] = false
			OreChatButton:Disable()
			OreBind:Disable()
		end
		OreButton:SetChecked(PA_SavedSettings["OreChecked"])
	end
	if(Button == "Mining") then
		if(state == "Enable") then
			PA_SavedSettings["MiningChecked"] = true
			MiningChatButton:Enable()
			MiningBind:Enable()
		end
		if(state == "Disable") then
			PA_SavedSettings["MiningChecked"] = false
			MiningChatButton:Disable()
			MiningBind:Disable()
		end
		MiningButton:SetChecked(PA_SavedSettings["MiningChecked"])
	end
	if(Button == "Enchanting") then
		if(state == "Enable") then
			PA_SavedSettings["EnchantingChecked"] = true
			EnchantingChatButton:Enable()
			EnchantingBind:Enable()
		end
		if(state == "Disable") then
			PA_SavedSettings["EnchantingChecked"] = false
			EnchantingChatButton:Disable()
			EnchantingBind:Disable()
		end
		EnchantingButton:SetChecked(PA_SavedSettings["EnchantingChecked"])
	end
	if(Button == "Material") then
		if(state == "Enable") then
			PA_SavedSettings["MaterialChecked"] = true
			MaterialChatButton:Enable()
			MaterialBind:Enable()
		end
		if(state == "Disable") then
			PA_SavedSettings["MaterialChecked"] = false
			MaterialChatButton:Disable()
			MaterialBind:Disable()
		end
		MaterialButton:SetChecked(PA_SavedSettings["MaterialChecked"])
	end
end
--------------------------
-- Button creator stuff --
--------------------------
local function createCheckButton(parent, x_loc, y_loc, IDname, displayname, description)
	local checkbutton = CreateFrame("CheckButton", IDname.."CheckButton", parent);
	checkbutton:SetNormalTexture("Interface/Buttons/UI-CheckBox-Up")
	checkbutton:SetPushedTexture("Interface/Buttons/UI-CheckBox-Down")
	checkbutton:SetHighlightTexture("Interface/Buttons/UI-CheckBox-Highlight","ADD")
	checkbutton:SetCheckedTexture("Interface/Buttons/UI-CheckBox-Check")
	checkbutton:SetDisabledCheckedTexture("Interface/Buttons/UI-CheckBox-Check-Disabled")
	checkbutton:SetPoint("TOPLEFT", x_loc, y_loc);
	checkbutton:SetSize(32,32);
	checkbuttonText = checkbutton:CreateFontString("checkbuttonText", "ARTWORK","GameFontHighlight")
	checkbuttonText:SetText(displayname);
	checkbuttonText:SetPoint("LEFT", "$parent", "RIGHT", 0, 1)
	checkbutton:SetScript("OnEnter", function(self)
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
		GameTooltip:SetText(displayname, nil, nil, nil, nil, 1);
		GameTooltip:AddLine(description, 1.0, 1.0, 1.0, 1.0);
		GameTooltip:Show();
	end)
	checkbutton:SetScript("OnLeave", function(self) GameTooltip:Hide() end)
	return checkbutton;
end

----------------------------
-- FontText creator stuff --
----------------------------
local function createFonttext(parent, x_loc, y_loc, text, fonttemplate)
	local title = parent:CreateFontString(nil, "ARTWORK", fonttemplate);
	title:SetPoint("TOPLEFT", x_loc, y_loc);
	title:SetJustifyH("LEFT");
	title:SetText(text);
end

-------------------
-- Minimap stuff --
-------------------
local function moveButton(self)
	local centerX, centerY = Minimap:GetCenter()
	local x, y = GetCursorPosition()
	x, y = x / self:GetEffectiveScale() - centerX, y / self:GetEffectiveScale() - centerY
	centerX, centerY = math.abs(x), math.abs(y)
	centerX, centerY = (centerX / math.sqrt(centerX^2 + centerY^2)) * 80, (centerY / sqrt(centerX^2 + centerY^2)) * 80
	centerX = x < 0 and -centerX or centerX
	centerY = y < 0 and -centerY or centerY
	self:ClearAllPoints()
	self:SetPoint("CENTER", centerX, centerY)
	PA_SavedSettings["Minimap_PosX"] = centerX
	PA_SavedSettings["Minimap_PosY"] = centerY
end
local function PA_Minimap_Create()
	PA_Minimap = CreateFrame("Button", "Profession Assistance", Minimap)
	PA_Minimap:SetSize(31, 31)
	PA_Minimap:SetFrameStrata("MEDIUM")
	PA_Minimap:SetPoint("CENTER", PA_SavedSettings["Minimap_PosX"], PA_SavedSettings["Minimap_PosY"])
	PA_Minimap:SetMovable(true)
	PA_Minimap:SetHighlightTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight")
	
	local overlay = PA_Minimap:CreateTexture(nil, "OVERLAY")
	overlay:SetSize(53, 53)
	overlay:SetTexture("Interface\\Minimap\\MiniMap-TrackingBorder")
	overlay:SetPoint("TOPLEFT")
	
	local icon = PA_Minimap:CreateTexture(nil, "ARTWORK")
	icon:SetSize(18.5, 18.5)
	icon:SetTexture("Interface\\ICONS\\INV_Hammer_20")
	icon:SetPoint("TOPLEFT", 7, -5.5)
	
	PA_Minimap:SetScript("OnMouseDown", function(self, button)
		if button == "LeftButton" then
			icon:SetPoint("TOPLEFT", 7, -5.5)
			icon:SetSize(18,18)
			PA_Panel:Show();
		else
			if IsShiftKeyDown() then
				icon:SetPoint("TOPLEFT", 7, -5.5)
				icon:SetSize(18,18)
				self:SetScript("OnUpdate", moveButton)
			end
		end
	end)
	PA_Minimap:SetScript("OnMouseUp", function(self)
		self:SetScript("OnUpdate", nil)
		icon:SetSize(18.5,18.5)
		icon:SetPoint("TOPLEFT", 7, -5.5)
	end)
	
	PA_Minimap:SetScript("OnEnter", function(self)
		GameTooltip:SetOwner(self,"ANCHOR_BOTTOMLEFT")
		GameTooltip:SetText("Profession Assistance", nil, nil, nil, 1, 1)
		GameTooltip:AddLine(" ")
		GameTooltip:AddLine("|cff00ff00Left-click|r to open interface panel.", 1, 1, 1)
		GameTooltip:AddLine("|cff00ff00Shift+Right-hold|r to drag this icon.", 1, 1, 1)
		GameTooltip:Show()
	end)
	PA_Minimap:SetScript("OnLeave", function(self) GameTooltip:Hide() end)
	
	if(MinimapButton:IsEnabled() and MinimapButton:GetChecked()) then PA_Minimap:Show() else PA_Minimap:Hide() end
	MinimapButton:SetScript("OnClick", function()
		if(MinimapButton:GetChecked()) then
			PA_ButtonControl("Minimap","Enable")
			PA_Minimap:Show()
		else
			PA_ButtonControl("Minimap","Disable")
			PA_Minimap:Hide()
		end
	end);
end

--------------------------
-- Interface AddOns tab --
--------------------------
local InterfaceFrame = CreateFrame("Frame")
InterfaceFrame:RegisterEvent("PLAYER_LOGIN");
InterfaceFrame:SetScript("OnEvent", function(self,event,...)
	if(type(PA_SavedSettings) ~= "table") then PA_SavedSettings = {} end
	
	-- Global tab
	--if(PA_SavedSettings["LightmodeChecked"] == nil) then PA_SavedSettings["LightmodeChecked"] = false end
	
	if(PA_SavedSettings["MasterChecked"] == nil) then PA_SavedSettings["MasterChecked"] = true end
	
	if(PA_SavedSettings["MinimapChecked"] == nil) then PA_SavedSettings["MinimapChecked"] = true end
	if(PA_SavedSettings["Minimap_PosX"] == nil) then PA_SavedSettings["Minimap_PosX"] = -78.5 end
	if(PA_SavedSettings["Minimap_PosY"] == nil) then PA_SavedSettings["Minimap_PosY"] = -16 end
	
	-- Professions tab
	-- Herbalism
	if(PA_SavedSettings["HerbalismChecked"] == nil) then PA_SavedSettings["HerbalismChecked"] = true end
	if(PA_SavedSettings["HerbalismChatChecked"] == nil) then PA_SavedSettings["HerbalismChatChecked"] = true end
	if(PA_SavedSettings["HerbalismBindChecked"] == nil) then PA_SavedSettings["HerbalismBindChecked"] = true end
	if(PA_SavedSettings["HerbalismKey"] == nil) then PA_SavedSettings["HerbalismKey"] = 1 end
	if(PA_SavedSettings["HerbalismBind"] == nil) then PA_SavedSettings["HerbalismBind"] = "Not Bound" end
	
	-- Milling
	if(PA_SavedSettings["MillingChecked"] == nil) then PA_SavedSettings["MillingChecked"] = true end
	if(PA_SavedSettings["MillingChatChecked"] == nil) then PA_SavedSettings["MillingChatChecked"] = true end
	if(PA_SavedSettings["MillingKey"] == nil) then PA_SavedSettings["MillingKey"] = 1 end
	if(PA_SavedSettings["MillingBind"] == nil) then PA_SavedSettings["MillingBind"] = "Not Bound" end
	
	if(PA_SavedSettings["HerbChecked"] == nil) then PA_SavedSettings["HerbChecked"] = true end
	if(PA_SavedSettings["HerbChatChecked"] == nil) then PA_SavedSettings["HerbChatChecked"] = true end
	if(PA_SavedSettings["HerbKey"] == nil) then PA_SavedSettings["HerbKey"] = 1 end
	if(PA_SavedSettings["HerbBind"] == nil) then PA_SavedSettings["HerbBind"] = "Not Bound" end
	
	-- Mining
	if(PA_SavedSettings["MiningChecked"] == nil) then PA_SavedSettings["MiningChecked"] = true end
	if(PA_SavedSettings["MiningChatChecked"] == nil) then PA_SavedSettings["MiningChatChecked"] = true end
	if(PA_SavedSettings["MiningKey"] == nil) then PA_SavedSettings["MiningKey"] = 1 end
	if(PA_SavedSettings["MiningBind"] == nil) then PA_SavedSettings["MiningBind"] = "Not Bound" end
	
	-- Prospecting
	if(PA_SavedSettings["ProspectingChecked"] == nil) then PA_SavedSettings["ProspectingChecked"] = true end
	if(PA_SavedSettings["ProspectingChatChecked"] == nil) then PA_SavedSettings["ProspectingChatChecked"] = true end
	if(PA_SavedSettings["ProspectingKey"] == nil) then PA_SavedSettings["ProspectingKey"] = 1 end
	if(PA_SavedSettings["ProspectingBind"] == nil) then PA_SavedSettings["ProspectingBind"] = "Not Bound" end
	
	if(PA_SavedSettings["OreChecked"] == nil) then PA_SavedSettings["OreChecked"] = true end
	if(PA_SavedSettings["OreChatChecked"] == nil) then PA_SavedSettings["OreChatChecked"] = true end
	if(PA_SavedSettings["OreKey"] == nil) then PA_SavedSettings["OreKey"] = 1 end
	if(PA_SavedSettings["OreBind"] == nil) then PA_SavedSettings["OreBind"] = "Not Bound" end
	
	-- Enchanting
	if(PA_SavedSettings["EnchantingChecked"] == nil) then PA_SavedSettings["EnchantingChecked"] = true end
	if(PA_SavedSettings["EnchantingChatChecked"] == nil) then PA_SavedSettings["EnchantingChatChecked"] = true end
	if(PA_SavedSettings["EnchantingKey"] == nil) then PA_SavedSettings["EnchantingKey"] = 1 end
	if(PA_SavedSettings["EnchantingBind"] == nil) then PA_SavedSettings["EnchantingBind"] = "Not Bound" end
	
	if(PA_SavedSettings["MaterialChecked"] == nil) then PA_SavedSettings["MaterialChecked"] = true end
	if(PA_SavedSettings["MaterialChatChecked"] == nil) then PA_SavedSettings["MaterialChatChecked"] = true end
	if(PA_SavedSettings["MaterialKey"] == nil) then PA_SavedSettings["MaterialKey"] = 1 end
	if(PA_SavedSettings["MaterialBind"] == nil) then PA_SavedSettings["MaterialBind"] = "Not Bound" end
	
	if(PA_SavedSettings["HerbalismKey"] == nil or type(PA_SavedSettings["HerbalismKey"]) == 'number') then PA_SavedSettings["HerbalismKey"] = false end
	if(PA_SavedSettings["MillingKey"] == nil or type(PA_SavedSettings["MillingKey"]) == 'number') then PA_SavedSettings["MillingKey"] = false end
	if(PA_SavedSettings["HerbKey"] == nil or type(PA_SavedSettings["HerbKey"]) == 'number') then PA_SavedSettings["HerbKey"] = false end
	if(PA_SavedSettings["MiningKey"] == nil or type(PA_SavedSettings["MiningKey"]) == 'number') then PA_SavedSettings["MiningKey"] = false end
	if(PA_SavedSettings["ProspectingKey"] == nil or type(PA_SavedSettings["ProspectingKey"]) == 'number') then PA_SavedSettings["ProspectingKey"] = false end
	if(PA_SavedSettings["OreKey"] == nil or type(PA_SavedSettings["OreKey"]) == 'number') then PA_SavedSettings["OreKey"] = false end
	if(PA_SavedSettings["EnchantingKey"] == nil or type(PA_SavedSettings["EnchantingKey"]) == 'number') then PA_SavedSettings["EnchantingKey"] = false end
	if(PA_SavedSettings["MaterialKey"] == nil or type(PA_SavedSettings["MaterialKey"]) == 'number') then PA_SavedSettings["MaterialKey"] = false end
	
	------------------
	-- Prompt panel --
	------------------
	
	PA_Panel_Prompt = CreateFrame( "Frame", "PA_Panel_Prompt", UIParent);
	PA_Panel_Prompt:SetFrameStrata("HIGH");
	PA_Panel_Prompt:SetBackdrop({
		bgFile = "Interface/DialogFrame/UI-DialogBox-Background",
		edgeFile = "Interface/DialogFrame/UI-DialogBox-Border", tile = true, tileSize = 32, edgeSize = 32,
		insets = { left = 11, right = 11, top = 12, bottom = 10 }
	});
	PA_Panel_Prompt:SetSize(380,100);
	PA_Panel_Prompt:SetPoint("CENTER");
	
	PA_Panel_Prompt:CreateTexture("$parent_Header", "ARTWORK");
	PA_Panel_Prompt_Header:SetTexture("Interface/DialogFrame/UI-DialogBox-Header");
	PA_Panel_Prompt_Header:SetSize(200,68);
	PA_Panel_Prompt_Header:SetPoint("TOP",0,12);
	PA_Panel_Prompt:CreateFontString("$parent_Header_Text","ARTWORK","GameFontNormal");
	PA_Panel_Prompt_Header_Text:SetPoint("TOP","$parent_Header","TOP",0,-14);
	PA_Panel_Prompt_Header_Text:SetText("Light mode");
	
	createFonttext(PA_Panel_Prompt, 23, -35, "This options requires a reload to work, reload now?", "GameFontHighlight");
	
	PA_Panel_Prompt_Reload = CreateFrame("BUTTON", "$parent_Reload", PA_Panel_Prompt, "UIPanelButtonTemplate");
	PA_Panel_Prompt_Reload:SetPoint("BOTTOMLEFT",22,15);
	PA_Panel_Prompt_Reload:SetWidth(100);
	PA_Panel_Prompt_Reload:SetText("Reload");
	PA_Panel_Prompt_Reload:SetScript("OnClick", function() ReloadUI(); end);
	
	PA_Panel_Prompt_Cancel = CreateFrame("BUTTON", "$parent_Cancel", PA_Panel_Prompt, "UIPanelButtonTemplate");
	PA_Panel_Prompt_Cancel:SetPoint("BOTTOMRIGHT",-22,15);
	PA_Panel_Prompt_Cancel:SetWidth(100);
	PA_Panel_Prompt_Cancel:SetText("Later");
	PA_Panel_Prompt_Cancel:SetScript("OnClick", function() PA_Panel_Prompt:Hide() end);
	
	--Hide it because we don't need to see it straight away!
	PA_Panel_Prompt:Hide();
	
	------------------
	-- Layout panel --
	------------------
	PA_Panel = CreateFrame( "Frame", "PA_Panel", UIParent);
	PA_Panel:SetBackdrop({
		bgFile = "Interface/DialogFrame/UI-DialogBox-Background",
		edgeFile = "Interface/DialogFrame/UI-DialogBox-Border", tile = true, tileSize = 32, edgeSize = 32,
		insets = { left = 11, right = 11, top = 12, bottom = 10 }
	});
	
	PA_Panel:SetFrameStrata("MEDIUM");
	PA_Panel:SetPoint("CENTER",0,0);
	PA_Panel:SetSize(824,568);
	PA_Panel:SetClampedToScreen(true);
	PA_Panel:EnableMouse(true);
	tinsert(UISpecialFrames, PA_Panel:GetName()); -- Makes it able to close when ESC is pressed
	
	PA_Panel:CreateTexture("$parentHeader", "ARTWORK");
	PA_PanelHeader:SetTexture("Interface/DialogFrame/UI-DialogBox-Header");
	PA_PanelHeader:SetSize(300,68);
	PA_PanelHeader:SetPoint("TOP",0,12);
	PA_Panel:CreateFontString("$parentHeaderText","ARTWORK","GameFontNormal");
	PA_PanelHeaderText:SetPoint("TOP","$parentHeader","TOP",0,-14);
	PA_PanelHeaderText:SetText("Profession Assistance");
	
	PA_Panel_Button = CreateFrame("BUTTON", "$parent_Button", PA_Panel, "UIPanelButtonTemplate");
	PA_Panel_Button:SetPoint("BOTTOMRIGHT",-22,15);
	PA_Panel_Button:SetWidth(100);
	PA_Panel_Button:SetText("Close");
	PA_Panel_Button:SetScript("OnClick", function(self) PA_Panel:Hide(); end);
	
	--Hide it because we don't need to see it straight away!
	PA_Panel:Hide();
	
	-- Show the panel with slash command
	SLASH_PA1,SLASH_PA2,SLASH_PA3,SLASH_PA4 = '/PA','/Profession','/Proffesion Assistance','/Profession_Assistance';
	function SlashCmdList.PA(msg, editbox) PA_Panel:Show(); end
	
	-----------------------
	-- Categories frames --
	-----------------------
	PA_Panel_Categories = CreateFrame( "Frame", "$parent_Categories", PA_Panel);
	PA_Panel_Categories:SetBackdrop({edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tileSize = 16, edgeSize = 16,});
	PA_Panel_Categories:SetSize(780,489);
	PA_Panel_Categories:SetPoint("TOPLEFT",22,-40);
	
	-----------------
	-- create tabs --
	-----------------
	PA_Panel_Categories.selectedTab = 1;
	PA_Panel_Categories.subFrames = {};
	PA_Panel_Categories.name = PA_Panel_Categories:GetName();
	
	PA_Panel_Categories.showSubFrame = function(name)
		for index, value in pairs(PA_Panel_Categories.subFrames) do
			if("$parentTab"..index == "$parentTab"..PA_Panel_Categories.selectedTab) then
				_G[value]:Show();
			else _G[value]:Hide(); end
		end
	end

	local setPanel = function(panel,id)
		if(id) then PanelTemplates_SetTab(panel, id); end
		PanelTemplates_UpdateTabs(panel);
		panel.showSubFrame(panel.name.."Tab"..panel.selectedTab);
	end

	local createTab = function(parent, index, name)
		local tab = CreateFrame("Button", "$parentTab"..index, parent, "OptionsFrameTabButtonTemplate");
		tab.id = index;
		tab:SetWidth(50);
		if index == 1 then tab:SetPoint("TOPLEFT",5,24); else tab:SetPoint("LEFT", "$parentTab"..index-1, "RIGHT", -15, 0); end
		tab:HookScript("OnClick", function(self) setPanel(self:GetParent(), self.id); end);
		tab:SetText(string.sub(name,string.len(parent.name)+2));
		PanelTemplates_TabResize(tab);
	end
	
	--create subframes
	local createSubFrame = function(parent,name)
		local subframe = CreateFrame("Frame", "$parent_"..name, parent);
		subframe:SetAllPoints();
		tinsert(parent.subFrames,subframe:GetName());
	end
	
	-- createSubFrame(parent,name)
	createSubFrame(PA_Panel_Categories,"Main");
	createSubFrame(PA_Panel_Categories,"Global");
	createSubFrame(PA_Panel_Categories,"Professions");
	PA_Panel_Categories.numTabs = #PA_Panel_Categories.subFrames;
	
	for i = 1, PA_Panel_Categories.numTabs do
		--createTab(Parent,Index,Name)
		createTab(PA_Panel_Categories,i,PA_Panel_Categories.subFrames[i]);
	end
	
	setPanel(PA_Panel_Categories);
	PA_Panel_Categories:HookScript("OnShow",setPanel);
	
	-- Main panel
	
	-- title
	--createFonttext(Parent, Positionx, Positiony, text, template)
	createFonttext(PA_Panel_Categories_Main, 15, -15, "Profession Assistance", "GameFontNormalLarge");
	
	-- content
	createFonttext(PA_Panel_Categories_Main, 20, -40, "|cffffcc00Version|r     "..GetAddOnMetadata("Profession_Assistance","Version"), "GameFontHighlight");
	createFonttext(PA_Panel_Categories_Main, 20, -55, "|cffffcc00Notes|r       "..GetAddOnMetadata("Profession_Assistance","Notes"), "GameFontHighlight");
	createFonttext(PA_Panel_Categories_Main, 20, -85, "|cffffcc00Author|r      "..GetAddOnMetadata("Profession_Assistance","Author"), "GameFontHighlight");
	createFonttext(PA_Panel_Categories_Main, 20, -100, "|cffffcc00Credits|r     "..GetAddOnMetadata("Profession_Assistance","X-Credits"), "GameFontHighlight");
	
	local BfaNote = [[
I've done my best to gather all the information there currently is available, as this expansion is still
very fresh and new. Please give me a bit of time to confirm/adjust all the data to be as accurate as possible!
Locations on ores/herbs will be altered as soon more details are known!

Enjoy Battle for Azeroth! For the Alliance/Horde!
]]
	
	createFonttext(PA_Panel_Categories_Main, 20, -130, "|cffffcc00Battle for Azeroth Note:|r", "GameFontHighlightLarge");
	createFonttext(PA_Panel_Categories_Main, 20, -145,BfaNote, "GameFontHighlight");
	
	local DisenchantingNote = [[
The information about Disenchanting materials has been made as accurate as I could.
There is always a chance that you get a different material than promised, please tell me if you do!

However I've decided to drop the information shown on gear as this became extremely hard to keep accurate.
This is mostly due to how the item level scales, as this is what I used to check what the results could be.
And I can't possibly check what expansion the gear originates from more accurately unless I manually
add every piece of gear in the game into my database. I hope this is understandable!

If anyone has an idea how I could achieve this without having to do this manually.
Please share it with me and if it works I'll get it implemented as soon as possible.
I will obviously give the proper credits :)
]]
	
	createFonttext(PA_Panel_Categories_Main, 20, -220, "|cffffcc00Disenchanting Note:|r", "GameFontHighlightLarge");
	createFonttext(PA_Panel_Categories_Main, 20, -235,DisenchantingNote, "GameFontHighlight");
	
	-- Options panel
	
	-- title
	createFonttext(PA_Panel_Categories_Global, 15, -15, "Options", "GameFontNormalLarge");
	
	-- Lightmode
	--[[createFonttext(PA_Panel_Categories_Global, 20, -60, "|cffffcc00Light mode|r", "GameFontNormalLarge");
	LightModeButton = createCheckButton(PA_Panel_Categories_Global, 15, -80, "LightMode", "Enable Light mode", "Removes all the other options (and prevents errors from appearing).");
	LightModeButton:SetChecked(PA_SavedSettings["LightmodeChecked"]);
	
	LightModeButton:SetScript("OnClick", function()
		PA_Panel_Prompt:Show();
		PA_SavedSettings["LightmodeChecked"] = LightModeButton:GetChecked()
	end);
	]]--
	
	-- Options panel
	
	-- title
	createFonttext(PA_Panel_Categories_Professions, 15, -15, "Professions", "GameFontNormalLarge");
	
	--if not(PA_SavedSettings["LightmodeChecked"]) then
		Frame_Profession = PA_Panel_Categories_Professions
		-- global
		createFonttext(PA_Panel_Categories_Global, 20, -60, "|cffffcc00Global|r", "GameFontNormalLarge");
		-- createCheckButton(Parent, Positionx, positiony, label, description);
		MasterButton = createCheckButton(PA_Panel_Categories_Global, 15, -80, "Master", "Enable Master", "Master switch");
		MasterButton:SetChecked(PA_SavedSettings["MasterChecked"]);
		
		-- Minimap
		createFonttext(PA_Panel_Categories_Global, 20, -140, "|cffffcc00Minimap Button|r", "GameFontNormalLarge");
		MinimapButton = createCheckButton(PA_Panel_Categories_Global, 15, -160, "Minimap", "Enable Minimap", "Toggle minimap button");
		MinimapButton:SetChecked(PA_SavedSettings["MinimapChecked"]);
		
		-- Herbalism
		createFonttext(PA_Panel_Categories_Professions, 20, -60, "|cffffcc00Herbalism|r", "GameFontNormalLarge")	;
		HerbalismButton = createCheckButton(Frame_Profession, 15, -80, "Herbalism", "Enable Herbalism", "Toggle herbalism information on herbs");
		HerbalismButton:SetChecked(PA_SavedSettings["HerbalismChecked"]);
		
		HerbalismChatButton = createCheckButton(Frame_Profession, 255, -80, "HerbalismChat", "Enable chat", "Toggle chat information on herbs");
		HerbalismChatButton:SetChecked(PA_SavedSettings["HerbalismChatChecked"]);
		
		createFonttext(Frame_Profession, 20, -115, "Shown when: ", "GameFontNormalSmall");
		HerbalismBind = createCheckButton(Frame_Profession, 15, -130, "HerbalismBind", "On Shift", "Hold Shift to show Herbalism information")
		HerbalismBind:SetChecked(PA_SavedSettings["HerbalismKey"]);
		
		-- Milling
		createFonttext(Frame_Profession, 420, -60, "|cffffcc00Milling|r", "GameFontNormalLarge")	;
		MillingButton = createCheckButton(Frame_Profession, 415, -80, "Milling", "Enable Milling", "Toggle milling information on herbs");
		MillingButton:SetChecked(PA_SavedSettings["MillingChecked"]);
		
		MillingChatButton = createCheckButton(Frame_Profession, 655, -80, "MillingChat", "Enable chat", "Toggle chat information on herbs");
		MillingChatButton:SetChecked(PA_SavedSettings["MillingChatChecked"]);
		
		createFonttext(Frame_Profession, 420, -115, "Shown when: ", "GameFontNormalSmall");
		MillingBind = createCheckButton(Frame_Profession, 415, -130, "MillingBind", "On Shift", "Hold Shift to show Milling information")
		MillingBind:SetChecked(PA_SavedSettings["MillingKey"]);
		
		HerbButton = createCheckButton(Frame_Profession, 415, -170, "Herb", "Enable Herb", "Toggle herb information on pigments");
		HerbButton:SetChecked(PA_SavedSettings["HerbChecked"]);
		
		HerbChatButton = createCheckButton(Frame_Profession, 655, -170, "HerbChat", "Enable chat", "Toggle chat information on pigments");
		HerbChatButton:SetChecked(PA_SavedSettings["HerbChatChecked"]);
		
		createFonttext(Frame_Profession, 420, -205, "Shown when: ", "GameFontNormalSmall");
		HerbBind = createCheckButton(Frame_Profession, 415, -220, "HerbBind", "On Shift", "Hold Shift to show Herb information")
		HerbBind:SetChecked(PA_SavedSettings["HerbKey"]);
		
		-- Mining
		createFonttext(Frame_Profession, 20, -170, "|cffffcc00Mining|r", "GameFontNormalLarge");
		MiningButton = createCheckButton(Frame_Profession, 15, -190, "Mining", "Enable Mining", "Toggle mining information on ores");
		MiningButton:SetChecked(PA_SavedSettings["MiningChecked"]);
		
		MiningChatButton = createCheckButton(Frame_Profession, 255, -190, "MiningChat", "Enable chat", "Toggle chat information on ores");
		MiningChatButton:SetChecked(PA_SavedSettings["MiningChatChecked"]);
		
		createFonttext(Frame_Profession, 20, -225, "Shown when: ", "GameFontNormalSmall");
		
		MiningBind = createCheckButton(Frame_Profession, 15, -240, "MiningBind", "On Shift", "Hold Shift to show Mining information")
		MiningBind:SetChecked(PA_SavedSettings["MiningKey"]);
		
		-- Prospecting
		createFonttext(Frame_Profession, 20, -280, "|cffffcc00Prospecting|r", "GameFontNormalLarge");
		ProspectingButton = createCheckButton(Frame_Profession, 15, -300, "Prospecting", "Enable Prospecting", "Toggle prospecting information on ores");
		ProspectingButton:SetChecked(PA_SavedSettings["ProspectingChecked"]);
		
		ProspectingChatButton = createCheckButton(Frame_Profession, 255, -300, "ProspectingChat", "Enable chat", "Toggle chat information on ores");
		ProspectingChatButton:SetChecked(PA_SavedSettings["ProspectingChatChecked"]);
		
		createFonttext(Frame_Profession, 20, -335, "Shown when: ", "GameFontNormalSmall");
		
		ProspectingBind = createCheckButton(Frame_Profession, 15, -350, "ProspectingBind", "On Shift", "Hold Shift to show Prospecting information")
		ProspectingBind:SetChecked(PA_SavedSettings["ProspectingKey"]);
		
		OreButton = createCheckButton(Frame_Profession, 15, -390, "Ore", "Enable Ore", "Toggle ore information on gems");
		OreButton:SetChecked(PA_SavedSettings["OreChecked"]);
		
		OreChatButton = createCheckButton(Frame_Profession, 255, -390, "OreChat", "Enable chat", "Toggle chat information on gems");
		OreChatButton:SetChecked(PA_SavedSettings["OreChatChecked"]);
		
		createFonttext(Frame_Profession, 20, -425, "Shown when: ", "GameFontNormalSmall");
		
		OreBind = createCheckButton(Frame_Profession, 15, -440, "OreBind", "On Shift", "Hold Shift to show Ore information")
		OreBind:SetChecked(PA_SavedSettings["OreKey"]);
		
		-- Enchanting
		createFonttext(Frame_Profession, 420, -280, "|cffffcc00Enchanting|r", "GameFontNormalLarge");
		EnchantingButton = createCheckButton(Frame_Profession, 415, -300, "Enchanting", "Enable Enchanting", "Toggle enchanting information on gear");
		EnchantingButton:SetChecked(PA_SavedSettings["EnchantingChecked"]);
		
		EnchantingChatButton = createCheckButton(Frame_Profession, 655, -300, "EnchantingChat", "Enable chat", "Toggle chat information on gear");
		EnchantingChatButton:SetChecked(PA_SavedSettings["EnchantingChatChecked"]);
		
		createFonttext(Frame_Profession, 420, -335, "Shown when: ", "GameFontNormalSmall");
		
		EnchantingBind = createCheckButton(Frame_Profession, 415, -350, "EnchantingBind", "On Shift", "Hold Shift to show Enchanting information")
		EnchantingBind:SetChecked(PA_SavedSettings["EnchantingKey"]);
		
		MaterialButton = createCheckButton(Frame_Profession, 415, -390, "Material", "Enable Materials", "Toggle gear source information on enchanting materials");
		MaterialButton:SetChecked(PA_SavedSettings["MaterialChecked"]);
		
		MaterialChatButton = createCheckButton(Frame_Profession, 655, -390, "MaterialChat", "Enable chat", "Toggle chat information on enchanting materials");
		MaterialChatButton:SetChecked(PA_SavedSettings["MaterialChatChecked"]);
		
		createFonttext(Frame_Profession, 420, -425, "Shown when: ", "GameFontNormalSmall");
		
		MaterialBind = createCheckButton(Frame_Profession, 415, -440, "MaterialBind", "On Shift", "Hold Shift to show Material information")
		MaterialBind:SetChecked(PA_SavedSettings["MaterialKey"]);
		
		-- Minimap button
		PA_Minimap_Create()
		
		---------------------------
		-- Changing settings part --
		---------------------------
		-- Master button
		MasterButton:SetScript("OnClick", function(self) PA_ButtonControl("Master",self:GetChecked() and "Enable" or "Disable") end);
		--PA_ButtonControl(ButtonName,state)
		-- \/ is to check upon start up
		PA_ButtonControl("Master",PA_SavedSettings["MasterChecked"] and "Enable" or "Disable")
		
		-- Herbalism stuff
		HerbalismButton:SetScript("OnClick", function(self) PA_ButtonControl("Herbalism",self:GetChecked() and "Enable" or "Disable") end);
		HerbalismBind:SetScript("OnClick", function(self) PA_SavedSettings["HerbalismKey"] = self:GetChecked() end);
		
		HerbalismChatButton:SetScript("OnClick", function(self) PA_SavedSettings["HerbalismChatChecked"] = self:GetChecked() end);
		if(HerbalismButton:GetChecked() and HerbalismButton:IsEnabled()) then HerbalismChatButton:Enable() else HerbalismChatButton:Disable() end
		
		-- Mining stuff
		MiningButton:SetScript("OnClick", function(self) PA_ButtonControl("Mining",self:GetChecked() and "Enable" or "Disable") end);
		MiningBind:SetScript("OnClick", function(self) PA_SavedSettings["MiningKey"] = self:GetChecked() end);
		
		MiningChatButton:SetScript("OnClick", function(self) PA_SavedSettings["MiningChatChecked"] = self:GetChecked() end);
		if(MiningButton:GetChecked() and MiningButton:IsEnabled()) then MiningChatButton:Enable() else MiningChatButton:Disable() end
		
		-- Milling stuff
		MillingButton:SetScript("OnClick", function(self) PA_ButtonControl("Milling",self:GetChecked() and "Enable" or "Disable") end);
		MillingBind:SetScript("OnClick", function(self) PA_SavedSettings["MillingKey"] = self:GetChecked() end);
		
		MillingChatButton:SetScript("OnClick", function(self) PA_SavedSettings["MillingChatChecked"] = self:GetChecked() end);
		if(MillingButton:GetChecked() and MillingButton:IsEnabled()) then MillingChatButton:Enable() else MillingChatButton:Disable() end		
		
		
		HerbButton:SetScript("OnClick", function(self) PA_ButtonControl("Herb",self:GetChecked() and "Enable" or "Disable") end);
		HerbBind:SetScript("OnClick", function(self) PA_SavedSettings["HerbKey"] = self:GetChecked() end);
		
		HerbChatButton:SetScript("OnClick", function(self) PA_SavedSettings["HerbChatChecked"] = self:GetChecked() end);
		if(HerbButton:GetChecked() and HerbButton:IsEnabled()) then HerbChatButton:Enable() else HerbChatButton:Disable() end
		
		-- Prospecting stuff
		ProspectingButton:SetScript("OnClick", function(self) PA_ButtonControl("Prospecting",self:GetChecked() and "Enable" or "Disable") end);
		ProspectingBind:SetScript("OnClick", function(self) PA_SavedSettings["ProspectingKey"] = self:GetChecked() end);
		
		ProspectingChatButton:SetScript("OnClick", function(self) PA_SavedSettings["ProspectingChatChecked"] = self:GetChecked() end);
		if(ProspectingButton:GetChecked() and ProspectingButton:IsEnabled()) then ProspectingChatButton:Enable() else ProspectingChatButton:Disable() end
		
		
		OreButton:SetScript("OnClick", function(self) PA_ButtonControl("Ore",self:GetChecked() and "Enable" or "Disable") end);
		OreBind:SetScript("OnClick", function(self) PA_SavedSettings["OreKey"] = self:GetChecked() end);
		
		OreChatButton:SetScript("OnClick", function(self) PA_SavedSettings["OreChatChecked"] = self:GetChecked() end);
		if(OreButton:GetChecked() and OreButton:IsEnabled()) then OreChatButton:Enable() else OreChatButton:Disable() end
		
		
		-- Enchanting stuff
		EnchantingButton:SetScript("OnClick", function() PA_ButtonControl("Enchanting",self:GetChecked() and "Enable" or "Disable") end);
		EnchantingBind:SetScript("OnClick", function(self) PA_SavedSettings["EnchantingKey"] = self:GetChecked() end);
		
		EnchantingChatButton:SetScript("OnClick", function(self) PA_SavedSettings["EnchantingChatChecked"] = self:GetChecked() end);
		if(EnchantingButton:GetChecked() and EnchantingButton:IsEnabled()) then EnchantingChatButton:Enable() else EnchantingChatButton:Disable() end
		
		
		MaterialButton:SetScript("OnClick", function() PA_ButtonControl("Material",self:GetChecked() and "Enable" or "Disable") end);
		MaterialBind:SetScript("OnClick", function(self) PA_SavedSettings["MaterialKey"] = self:GetChecked() end);
		
		MaterialChatButton:SetScript("OnClick", function(self) PA_SavedSettings["MaterialChatChecked"] = self:GetChecked() end);
		if(MaterialButton:GetChecked() and MaterialButton:IsEnabled()) then MaterialChatButton:Enable() else MaterialChatButton:Disable() end
	--end
end);