---------------------------------------------------------------------------------
--
-- Prat - A framework for World of Warcraft chat mods
--
-- Copyright (C) 2006-2018  Prat Development Team
--
-- This program is free software; you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to:
--
-- Free Software Foundation, Inc.,
-- 51 Franklin Street, Fifth Floor,
-- Boston, MA  02110-1301, USA.
--
--
-------------------------------------------------------------------------------

Prat:AddModuleToLoad(function()
    local PRAT_MODULE = Prat:RequestModuleName("HoverTips")

    if PRAT_MODULE == nil then
        return
    end

    local module = Prat:NewModule(PRAT_MODULE, "AceHook-3.0")

    -- define localized strings
    local PL = module.PL

    --[===[@debug@
    PL:AddLocale(PRAT_MODULE, "enUS", {
        ["module_name"] = "Hover Tips",
        ["module_desc"] = "Shows tooltip when hovering over link in chat",
    } )
    --@end-debug@]===]

    -- These Localizations are auto-generated. To help with localization
    -- please go to http://www.wowace.com/projects/prat-3-0/localization/


    --@non-debug@
  do
      local L

  L=
{
	["HoverTips"] = {
		["module_desc"] = "Shows tooltip when hovering over link in chat",
		["module_name"] = "Hover Tips",
	}
}
  PL:AddLocale(PRAT_MODULE, "enUS", L)


  L=
{
	["HoverTips"] = {
		--[[Translation missing --]]
		--[[ ["module_desc"] = "",--]] 
		--[[Translation missing --]]
		--[[ ["module_name"] = "",--]] 
	}
}
  PL:AddLocale(PRAT_MODULE, "itIT", L)


  L=
{
	["HoverTips"] = {
		--[[Translation missing --]]
		--[[ ["module_desc"] = "",--]] 
		--[[Translation missing --]]
		--[[ ["module_name"] = "",--]] 
	}
}
  PL:AddLocale(PRAT_MODULE, "ptBR", L)


  L=
{
	["HoverTips"] = {
		--[[Translation missing --]]
		--[[ ["module_desc"] = "",--]] 
		--[[Translation missing --]]
		--[[ ["module_name"] = "",--]] 
	}
}
  PL:AddLocale(PRAT_MODULE, "frFR", L)


  L=
{
	["HoverTips"] = {
		--[[Translation missing --]]
		--[[ ["module_desc"] = "",--]] 
		--[[Translation missing --]]
		--[[ ["module_name"] = "",--]] 
	}
}
  PL:AddLocale(PRAT_MODULE, "deDE", L)


  L=
{
	["HoverTips"] = {
		--[[Translation missing --]]
		--[[ ["module_desc"] = "",--]] 
		--[[Translation missing --]]
		--[[ ["module_name"] = "",--]] 
	}
}
  PL:AddLocale(PRAT_MODULE, "koKR",  L)

  L=
{
	["HoverTips"] = {
		--[[Translation missing --]]
		--[[ ["module_desc"] = "",--]] 
		--[[Translation missing --]]
		--[[ ["module_name"] = "",--]] 
	}
}
  PL:AddLocale(PRAT_MODULE, "esMX",  L)

  L=
{
	["HoverTips"] = {
		["module_desc"] = "Показывает подсказку при наведении курсора на ссылку в чате",
		--[[Translation missing --]]
		--[[ ["module_name"] = "",--]] 
	}
}
  PL:AddLocale(PRAT_MODULE, "ruRU",  L)

  L=
{
	["HoverTips"] = {
		--[[Translation missing --]]
		--[[ ["module_desc"] = "",--]] 
		--[[Translation missing --]]
		--[[ ["module_name"] = "",--]] 
	}
}
  PL:AddLocale(PRAT_MODULE, "zhCN",  L)

  L=
{
	["HoverTips"] = {
		--[[Translation missing --]]
		--[[ ["module_desc"] = "",--]] 
		--[[Translation missing --]]
		--[[ ["module_name"] = "",--]] 
	}
}
  PL:AddLocale(PRAT_MODULE, "esES",  L)

  L=
{
	["HoverTips"] = {
		--[[Translation missing --]]
		--[[ ["module_desc"] = "",--]] 
		--[[Translation missing --]]
		--[[ ["module_name"] = "",--]] 
	}
}
  PL:AddLocale(PRAT_MODULE, "zhTW",  L)
  end
  --@end-non-debug@

    Prat:SetModuleDefaults(module.name, {
        profile = {
            on = true,
        }
    })

    -- basic code from Chatter

    local strmatch = string.match
    local linkTypes = {
        item = true,
        enchant = true,
        spell = true,
        quest = true,
        achievement = true,
    }

    function module:OnEnable()
        for i = 1, NUM_CHAT_WINDOWS do
            local frame = _G["ChatFrame"..i]
            self:HookScript(frame, "OnHyperlinkEnter", OnHyperlinkEnter)
            self:HookScript(frame, "OnHyperlinkLeave", OnHyperlinkLeave)
        end
    end

    function module:OnDisable()
        for i = 1, NUM_CHAT_WINDOWS do
            local frame = _G["ChatFrame"..i]
            self:Unhook(frame, "OnHyperlinkEnter")
            self:Unhook(frame, "OnHyperlinkLeave")
        end
    end

    local showingTooltip = false
    function module:OnHyperlinkEnter(f, link)
        local t = strmatch(link, "^(.-):")
        if linkTypes[t] then
            showingTooltip = true
            ShowUIPanel(GameTooltip)
            GameTooltip:SetOwner(UIParent, "ANCHOR_CURSOR")
            GameTooltip:SetHyperlink(link)
            GameTooltip:Show()
        end
    end

    function module:OnHyperlinkLeave(f, link)
        if showingTooltip then
            showingTooltip = false
            HideUIPanel(GameTooltip)
        end
    end

end)
