Pokedex = LibStub("AceAddon-3.0"):NewAddon("Pokedex", "AceConsole-3.0", "AceEvent-3.0", "AceHook-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("Pokedex")

-- upvalues
local _G, Pokedex, assert, format, pairs, setmetatable, type = _G, Pokedex, assert, format, pairs, setmetatable, type
local bnot, band, bor, bxor = bit.bnot, bit.band, bit.bor, bit.bxor

--=========================================================================--
-- Keybinding globals --
--=========================================================================--
BINDING_HEADER_POKEDEX = L["Pokedex"]
BINDING_NAME_POKEDEXSUMMONMOUNT = L["Summon Mount"]
BINDING_NAME_POKEDEXDISMISSMOUNT = L["Dismiss Mount"]
BINDING_NAME_POKEDEXTOGGLEMOUNT = L["Toggle Mount"]
BINDING_NAME_POKEDEXSUMMONNEXTMOUNT = L["Summon Next Mount"]
BINDING_NAME_POKEDEXSUMMONOTHERMOUNT = L["Summon Other Mount"]
BINDING_NAME_POKEDEXSUMMONCOMPANION = L["Summon Companion"]
BINDING_NAME_POKEDEXDISMISSCOMPANION = L["Dismiss Companion"]
BINDING_NAME_POKEDEXTOGGLECOMPANION = L["Toggle Companion"]
BINDING_NAME_POKEDEXSUMMONNEXTCOMPANION = L["Summon Next Companion"]
BINDING_NAME_POKEDEXSUMMONVENDOR = L["Summon Vendor"]
BINDING_NAME_POKEDEXCHANGETITLE = L["Change Title"]



Pokedex.Globals = {}

--=========================================================================--
-- (fake) Enum Types		TODO: find a way to make these constants
--=========================================================================--

Pokedex.Globals.Types = {}

local function BuildReverseSet(list)
	local set = {}
	for k, v in pairs(list) do set[v] = k end
	return set
end


-- Initialization States
local IS = {
	INITIALIZED   = 0,
	INITIALIZING  = 1,
	UNINITIALIZED = 2,
}
Pokedex.Globals.Types.InitStates = IS


-- Debug Levels
local DL = {
	NONE   = 0,   -- no debug output
	BASIC  = 1,   -- most basic level of information
	EXCEP  = 2,   -- interesting exceptions and special cases
	AV     = 3,   -- annoyingly verbose
	MAX    = 3,   -- used for range checking
}
Pokedex.Globals.Types.DebugLevels = DL


-- Skill Levels - max rank of each skill level
local SL = {
	ZenMaster   = 600,
	Illustrious = 525,
	GrandMaster = 450,
	Master      = 375,
	Artisan     = 300,
	Expert      = 225,
	Journeyman  = 150,
	Apprentice  = 75,
	None        = 0
}
Pokedex.Globals.Types.SkillLevels = SL

-- Skill Ids - skillLine constant for a profession
local SI = {
	[762] = "Riding",

	[182] = "Herbalism",
	[186] = "Mining",
	[393] = "Skinning",

	[171] = "Alchemy",
	[164] = "Blacksmithing",
	[333] = "Enchanting",
	[202] = "Engineering",
	[773] = "Inscription",
	[755] = "Jewelcrafting",
	[165] = "Leatherworking",
	[197] = "Tailoring",
}
Pokedex.Globals.Types.SkillIds = SI


-- Mount Flags
local rgstrMountFlags = {
	[0x0001] = "Unusable",
	[0x0002] = "Unknown",
	[0x0004] = "Flyer",
	[0x0008] = "Swimmer",    -- has a faster than normal swim speed. implies Underwater_Legal, REVIEW whether both flags should be set
	[0x0010] = "Sidecar",    -- chauffeured motorcycles are between runners and walkers. implies NoFlyZone_Legal, REVIEW whether both flags should be set
	[0x0020] = "Walker",     -- has a slower than normal ground speed. implies NoFlyZone_Legal, REVIEW whether both flags should be set
	[0x0040] = "Vashjir",    -- abyssal seahorse
	[0x0080] = "Ahn_Qiraj",  -- quiraji scarab mounts
	[0x0100] = "NoFlyZone_Legal",
	[0x0200] = "Underwater_Legal",
	[0x0400] = "Indoors_Legal",
	[0x0800] = "Combat_Legal",
	[0x1000] = "Moving_Legal",
}
local MF = BuildReverseSet(rgstrMountFlags)
Pokedex.Globals.Types.MountFlags = MF

-- a composite flagset lets us only do the bit operation only once instead of once per mount of that type
local MFS_ATV          = bor(MF.Flyer, MF.NoFlyZone_Legal, MF.Underwater_Legal)
local MFS_Runner       = bor(MF.NoFlyZone_Legal, MF.Underwater_Legal)
local MFS_Hydroplane   = bor(MF.Flyer, MF.Underwater_Legal)
local MFS_Hydrophobe   = bor(MF.Flyer, MF.NoFlyZone_Legal)
local MFS_Black_Scarab = bor(MF.NoFlyZone_Legal, MF.Underwater_Legal, MF.Ahn_Qiraj)
local MFS_Sea_Turtle   = bor(MF.Swimmer, MF.Walker)



-- event monitor class - used to temporarily ignore an event in a recursion/rentrancy safe way
local CEventMonitor = { module = Pokedex }
CEventMonitor.__index = CEventMonitor
function CEventMonitor:Create(eventName, handler)
	assert(type(eventName) == "string")
	return setmetatable( { refCount = 0, eventName = eventName, handler = handler or eventName }, CEventMonitor )
end
function CEventMonitor:Suspend()
	if self.refCount == 1 then 
		self.module:UnregisterEvent(self.eventName)
	end
	self.refCount = self.refCount - 1
end
function CEventMonitor:Resume()
	self.refCount = self.refCount + 1
	if self.refCount == 1 then 
		self.module:RegisterEvent(self.eventName, self.handler)
	end
end
Pokedex.Globals.Types.CEventMonitor = CEventMonitor


--=========================================================================--
-- global format methods
-- functions construct a formatted string from an objects properties
--=========================================================================--

Pokedex.Globals.FormatMethods = {}
local gf = Pokedex.Globals.FormatMethods

-- gf.strFormatHotName = "|TInterface\\Icons\\spell_fire_fire:0|t|cFFD82619%s|r|TInterface\\Icons\\spell_fire_fire:0|t"
-- gf.RankNameChance = function(name, rank, chance) return format("%3i - %s  (%.2f%%)", rank, name, chance) end

gf.Name = function(obj) return obj.name end
gf.RankName = function(obj) return format("%i - %s", obj.rank, obj.name) end
gf.NameRank = function(obj) return format("%s (%i)", obj.name, obj.rank) end

gf.IndexByName = {    Name = 1,       RankName = 2,     NameRank = 3 }
gf.NameByIndex = {   "Name",         "RankName",       "NameRank" }
gf.DescByIndex = { L["name only"], L["rank - name"], L["name (rank)"] }

gf.Mounts = function(...)
	gf.Mounts = gf[Pokedex.db.profile.mounts.format]
	return gf.Mounts(...)
end

gf.Pets = function(...)
	gf.Pets = gf[Pokedex.db.profile.pets.format]
	return gf.Pets(...)
end

gf.Titles = function(...)
	gf.Titles = gf[Pokedex.db.profile.titles.format]
	return gf.Titles(...)
end

--=========================================================================--
-- global sort methods
-- tables can be sorted against each other if they each  have the same __lt metamethod
--=========================================================================--

Pokedex.Globals.SortMethods = {}
local gs = Pokedex.Globals.SortMethods

gs.ByOrder = function(a,b) return a.order < b.order end 

gs.ByChance = function(a,b) 
	if a.chance == b.chance then
		return a.name < b.name
	else
		return a.chance > b.chance 
	end
end

gs.ByRankA = function(a,b) 
	if a.rank == b.rank then
		return a.name < b.name
	else
		return a.rank < b.rank 
	end
end
gs.ByRankD = function(a,b) 
	if a.rank == b.rank then
		return a.name < b.name
	else
		return a.rank > b.rank 
	end
end

gs.ByName = function(a, b)
	if a.id > 0 and b.id > 0 then
		return a.name <  b.name
	else
		return a.id < b.id
	end
end

gs.IndexByName = {  ByName = 1, ByRankD = 2, ByRankA = 3, }
gs.NameByIndex = { "ByName",   "ByRankD",   "ByRankA",    }
gs.DescByIndex = { 
	L["sort by name"], 
	L["sort by rank (descending)"], 
	L["sort by rank (ascending)"],
}

gs.Mounts = function(...)
	gs.Mounts = gs[Pokedex.db.profile.mounts.sort]
	return gs.Mounts(...)
end

gs.pfMounts = function(...)
	return gs.Mounts(...)
end

gs.Pets = function(...)
	gs.Pets = gs[Pokedex.db.profile.pets.sort]
	return gs.Pets(...)
end

gs.pfPets = function(...)
	return gs.Pets(...)
end

gs.Titles = function(...)
	gs.Titles = gs[Pokedex.db.profile.titles.sort]
	return gs.Titles(...)
end

gs.pfTitles = function(...)
	return gs.Titles(...)
end


local nomount = setmetatable( { name = "NONE", index =  0, rank = 0, profile_rank = 0, id = 0, flags = 0, fActive = false, fHas = false, fCan = false }, 
                              { __lt = gs.pfMounts } )
local nopet   = setmetatable( { name = "NONE", index =  0, rank = 0, profile_rank = 0, id = 0, cid = 0, pids = {0} }, 
                              { __lt = gs.pfPets   } )
local notitle = setmetatable( { name = "NONE", id = -1 }, 
                              { __lt = gs.pfTitles } )

--=========================================================================--
-- global variables
--=========================================================================--

Pokedex.Globals.Variables = {
-- addon infrastructure
	InitState = IS.UNINITIALIZED,

-- skills
	Skills = {},

-- mounts
	SelectedMountBucket,
	SelectedMount = nomount,
	HotMount = nomount,
	HotMountIndex = 0,
	
-- companions
	SelectedPet = nopet,
	HotPet = nopet,
	HotPetIndex = 0,

-- titles
	SelectedTitle = notitle,
	HotTitle = notitle,
	HotTitleIndex = 0,

-- dismount
	iAutoDismountFlying,
	fCanDismountForCombat = false,	-- means dismount is currently turned on because the in combat condition is true
	fCanDismountForAttack = false,	-- means dismount is currently turned on because the can attack condition is true

}

--=========================================================================--
-- "constants"				TODO: find a way to make these constants
--=========================================================================--

Pokedex.Globals.Constants = {
	strVersionedTitle = L["Pokedex"] .. "      v"  .. GetAddOnMetadata("Pokedex", "Version"),
	iCurDataFormat = 15,

	nomount = nomount,
	nopet   = nopet,
	notitle = notitle,

	rgstrChannelDescs = { L["personal"], L["party"], L["raid"], L["emote"], L["say"], L["yell"] },
	rgstrChannels = { "ERROR", "PARTY", "RAID", "EMOTE", "SAY", "YELL" }, -- CHATID types, not localized, ERROR is just placeholder

	-- reverse look up for the MF and MB enum types
	rgstrMountFlags  = rgstrMountFlags,
	rgstrMountBreeds = rgstrMountBreeds,

	rgstrSkillRankName = { [SL.ZenMaster] = _G.ZEN_MASTER, [SL.Illustrious] = _G.ILLUSTRIOUS, [SL.GrandMaster] = _G.GRAND_MASTER, [SL.Master] = _G.MASTER, [SL.Artisan] = _G.ARTISAN, [SL.Expert] = _G.EXPERT, [SL.Journeyman] = _G.JOURNEYMAN, [SL.Apprentice] = _G.APPRENTICE, [SL.None] = _G.NONE },

	rgRidingSkills = { 
		{ id = 90265, level = SL.Master },
		{ id = 34091, level = SL.Artisan },
		{ id = 34090, level = SL.Expert },
		{ id = 33391, level = SL.Journeyman },
		{ id = 33388, level = SL.Apprentice } },

	tblArgentMinion = {
		Alliance = 214,  -- speciesID for Argent Squire
		Horde = 216,     -- speciesID for Argent Gruntling
	},
	tblTravelersTundraMammoth = {
		Alliance = 61425,  -- spellID for Alliance version
		Horde = 61447,     -- spellID for Horde version
	},
	idSpellGrandExpeditionYak = 122708,
	idSpeciesLilXT = 256,
	idSpeciesLandrosLilXT = 285,

	idTitleMatron = 104,
	idTitlePatron = 105,
	idTitleMinionSlayer = 147,
	-- idSpellColdWeatherFlying = 54197,
	-- idSpellFlightMastersLicense = 90267,
	idSpellAbyssalSeahorse = 75207,    -- swimming
	idSpellSubduedSeahorse = 98718,    -- wading
	idSpellRedDrake = 59570,           -- hydroplane
	idSpellRedFlyingCloud = 130092,    -- hdyrophobe
	idSpellRedMechanostrider = 10873,  -- runner
	idSpellRedScarab = 26054,          -- AQ
	idSpellRidingTurtle = 30174,       -- does not require riding skill to use
	idSpellSeaTurtle = 64731,          -- does not require riding skill to use
	idSpellBattlePet = 118301,
	idSpellGlyphOfAquaticForm = 57856,
	idSpellGlyphOfNightmares = 56232,
	idSpellGlyphOfZenFlight = 125893,
	idSpellGoldenGlider = 148773,
	idItemGoldenGlider = 104346,
	idSpellGoblinGlider = 126389,
	idItemGoblinGliderKit = 109076,
	idSpellGoblinGliderKit = 126389,
	idSpellFlexweaveUnderlay = 55001,
	idSpellForbearance = 25771,
	idAchieveLegendaryDaggers = 6181,
	idSpellLegendaryDaggers = 107082,
	idItemMHLegendaryDagger = 77949,
	idItemOHLegendaryDagger = 77950,
	idSpellSnowfallLager = 58441,
	idItemSnowfallLager = 43472,
	idSpellGarrisonAbility = 161691,
	idSpellCorralHorde = 164222,
	idSpellCorralAlliance = 165803,
	idItemFishingRaft = 85500,
	idSpellBobbingBerg = 152421,
	idItemBobbingBerg = 107950,
	idSpellMoonkinForm = 24858,
	idItemSkyhornKite = 131811,
	idItemRatstallionHarness = 139421,
	idSpellRatstallionHarness = 220124,
	idSpellCoinOfManyFaces = 192225,
	idSpellDressedToKill = 222256,
	idSpellPolyformicAcidPotion = 124293,

	-- monitored spells - must be included in table as well
	idSpellBearForm = 5487,
	idSpellBlazingBarrier = 235313,
	idSpellBurningRush = 111400,
	idSpellCatForm = 768,
	idSpellCenarionWard = 102351,
	idSpellDisguise = 121308,
	idSpellDivineShield = 642,
	idSpellFishingRaft = 124036,
	idSpellFlap = 164862,
	idSpellFoNMoonkin = 197625,
	idSpellGlide = 131347,
	idSpellGhostWolf = 2645,
	idSpellHandOfProtection = 1022,
	idSpellIceBarrier = 11426,
	idSpellLevitate = 1706,
	idSpellMoonkinForm = 24858,
	idSpellPathOfFrost = 3714,
	idSpellPrismaticBarrier = 235450,
	idSpellSkyhornKite = 196768,
	idSpellRoll = 109132,
	idSpellSlowFall = 130,
	idSpellStagForm = 210053,
	idSpellTravelForm = 783,
	idSpellTreantForm = 114282,
	idSpellTreeForm = 33891,
	idSpellWaterWalking = 546,
	idSpellZenFlight = 125883,


	-- learning a spell in this table triggers an update
	rgidMonitoredSpell = { 
		   [130] = true,
		   [546] = true,
		   [642] = true,
		   [768] = true,
		   [783] = true,
		  [1022] = true,
		  [1706] = true,
		  [2645] = true,
		  [3714] = true,
		  [5487] = true,
		 [11426] = true,
		 [24858] = true,
		 [33891] = true,
		[102351] = true,
		[109132] = true,
		[111400] = true,
		[114282] = true,
		[121308] = true,
		[124036] = true,
		[125883] = true,
		[164862] = true,
		[196768] = true,
		[197625] = true,
		[235313] = true,
		[235450] = true,
	},

	-- array by spellId of every companion that requires a snowball to summon
	-- these no longer need a snowball but will disappear after summoning, do we want to check calender?
	rgNeedsSnowball = { [26533] = true, [26045] = true, [26541] = true },		-- [26529] = true, -- reindeer loses costume but doesn't disappear

	-- array by spellId of mounts requiring a minimum skill level to use
	rgSkillMounts = {
		 [61451] = { rank = 300, name = "Tailoring"      },  -- Flying Carpet
		 [75596] = { rank = 300, name = "Tailoring"      },  -- Frosty Flying Carpet
		 [61309] = { rank = 300, name = "Tailoring"      },  -- Magnificent Flying Carpet
		[169952] = { rank = 300, name = "Tailoring"      },  -- Creeping Carpet
		 [44153] = { rank = 300, name = "Engineering"    },  -- Flying Machine
		 [44151] = { rank = 300, name = "Engineering"    },  -- Turbo-Charged Flying Machine
		[171844] = { rank = 300, name = "Leatherworking" },  -- Dustmane Direwolf
	},

	-- array by spellId of mounts requiring a specific class to use
	rgClassMounts = {
		 [48778] = "DEATHKNIGHT",  -- Acherus Deathcharger
		 [54729] = "DEATHKNIGHT",  -- Winged Steed of the Ebon Blade
		[229387] = "DEATHKNIGHT",  -- Deathlord's Vilebrood Vanquisher
		[200175] = "DEMONHUNTER",  -- Felsaber
		[229417] = "DEMONHUNTER",  -- Slayer's Felbroken Shrieker
		[229386] = "HUNTER",       -- Huntmaster's Loyal Wolfhawk
		[229438] = "HUNTER",       -- Huntmaster's Fierce Wolfhawk
		[229439] = "HUNTER",       -- Huntmaster's Dire Wolfhawk
		[229376] = "MAGE",         -- Archmage's Prismatic Disc
		[229385] = "MONK",         -- Ban-Lu, Grandmaster's Companion
		 [13819] = "PALADIN",      -- Warhorse
		 [23214] = "PALADIN",      -- Charger
		 [66906] = "PALADIN",      -- Argent Charger
		[231435] = "PALADIN",      -- Highlord's Golden Charger
		[231587] = "PALADIN",      -- Highlord's Vengeful Charger
		[231588] = "PALADIN",      -- Highlord's Vigilant Charger
		[231589] = "PALADIN",      -- Highlord's Valorous Charger
		[229377] = "PRIEST",       -- High Priest's Lightsworn Seeker
		[231434] = "ROGUE",        -- Shadowblade's Murderous Omen
		[231523] = "ROGUE",        -- Shadowblade's Lethal Omen
		[231524] = "ROGUE",        -- Shadowblade's Baneful Omen
		[231525] = "ROGUE",        -- Shadowblade's Crimson Omen
		[231442] = "SHAMAN",       -- Farseer's Raging Tempest
		  [5784] = "WARLOCK",      -- Felsteed
		 [23161] = "WARLOCK",      -- Dreadsteed
		[232412] = "WARLOCK",      -- Netherlord's Chaotic Wrathsteed
		[238452] = "WARLOCK",      -- Netherlord's Brimstone Wrathsteed
		[238454] = "WARLOCK",      -- Netherlord's Accursed  Wrathsteed
		[229388] = "WARRIOR",      -- Battlelord's Bloodthirsty War Wyrm
	},

	-- array by spellId of mounts that can walk on water
	-- glyphed warlock mounts added/removed by Player class
	rgWaterWalkingMounts = {
		[118089] = true,  -- Azure Water Strider
		[127271] = true,  -- Crimson Water Strider
		[127278] = true,  -- Golden Water Strider
		[127274] = true,  -- Jade Water Strider
		[127272] = true,  -- Orange Water Strider
	},

	-- array by spellId of mounts that can carry passengers
	rgPassengerMounts = {
		 [93326] = 1,  -- Sandstone Drake
		 [61465] = 2,  -- Grand Black War Mammoth (Alliance)
		 [61467] = 2,  -- Grand Black War Mammoth (Horde)
		 [61469] = 2,  -- Grand Ice Mammoth (Alliance)
		 [61470] = 2,  -- Grand Ice Mammoth (Horde)
		 [61425] = 2,  -- Traveler's Tundra Mammoth (Alliance)
		 [61447] = 2,  -- Traveler's Tundra Mammoth (Horde)
		 [55531] = 1,  -- Mechano-Hog
		 [60424] = 1,  -- Mekgineer's Chopper
		[121820] = 1,  -- Obsidian Nightwing
		 [75973] = 1,  -- X-53 Touring Rocket
		[122708] = 2,  -- Grand Expedition Yak
	},
}
