local kPartyNone, kPartyGroup, kPartyRaid = 0,1,2
local playerName = UnitName("Player")




function getPartyType()
	local partyType = kPartyNone
	if IsInGroup() then
		partyType = kPartyGroup
	end
	if IsInRaid() then
		partyType = kPartyRaid
	end
	-- print("party type finished")
	return partyType
end

function getPartyTypeString()
	local partyType = getPartyType()
	local pType
	if partyType == kPartyGroup then
		pType = "party"
	elseif partyType == kPartyRaid then
		pType = "raid"
	else
		pType = ""
	end
	-- print("p type finished")
	return pType
end

function getChatType()
	local partyType = getPartyType()
	local chatType
	if partyType == kPartyGroup then
		chatType = "party"
	elseif partyType == kPartyRaid then
		chatType = "raid"
	else
		chatType = "say"
	end
	return chatType
end

function getPartyMembers()
	local members = {}

	if getPartyType() == kPartyNone then
		table.insert(members, playerName)
		return members
	end

	local count = GetNumGroupMembers()

	local partyType = getPartyType()
	local partyTypeStr = getPartyTypeString()
	-- special cases
	if partyType == kPartyRaid then
		members = {}
	elseif partyType == kPartyGroup then --groups dont include the player
		table.insert(members, playerName)
	end


	for i = 1,count do
		-- generate query type and value (party/raid and which index of said grouping)
		local unitQuery = partyTypeStr .. i
		-- query server for the name of the unit at the index
		local name = UnitName(unitQuery, false)
		if name ~= nil then
			table.insert(members, name)
		end
	end

	return members
end

function generatePPSValue()
	local roll = random(100,9001) -- might need to be math.random
	return roll
end



function generatePPSArray(count)
	local ppsArray = {}
	for i = 1,count do
		local pps = generatePPSValue()
		table.insert(ppsArray, pps)
	end
	table.sort(ppsArray)
	ppsArray = reverseArray(ppsArray)
	return ppsArray
end



function printPPS()
	local lines = {}
	-- insert first line
	lines[1] = "Skada: Pizza Per Second for Last Fight"

	local members = getPartyMembers()
	members = shuffleArray(members)
	local ppsArray = generatePPSArray(#members)
	-- iterate through member array and attach the matching pps random value into a stored string
	for i, player in ipairs(members) do
		local thePlayerEntry = i .. ". " .. player .. " " .. ppsArray[i]
		table.insert(lines, thePlayerEntry)
	end

	-- iterate through strings and print them to chat
	local partyType = getChatType()
	for i, line in ipairs(lines) do
		SendChatMessage(line, partyType)
	end
end
