local addonName, at = ...
if not at.core then return end  -- "YOU SHALL NOT PASS!" - Gandolf
local core = at.core
local main = CreateFrame("Frame", "PetshipConfig")
main.name = "Petship"

	local Profile_OnChange = {}
	
--optional
--[[
main.okay = function() end
main.cancel = function() end
main.refresh = function() end--]]
main.default = function()
	local guid = core.PLAYER_GUID
	
	PetshipDB = PetshipDB:CopyTable(core.defaults)
	
	for x, v in pairs(Profile_OnChange) do
		v(x)
	end
	ReloadUI()
end

local tooltip = CreateFrame("GameTooltip", addonName .. "Tooltip", nil, "GameTooltipTemplate")

core:AddCallback('VariablesLoaded', 'options', function(self)
	local OptionsScrollFrame = CreateFrame('ScrollFrame', gsub(addonName, " ", "") .. 'OptionsScrollFrame', main, 'UIPanelScrollFrameTemplate')
	OptionsScrollFrame:SetPoint('TOPLEFT', main, 'TOPLEFT', 10, -32)
	OptionsScrollFrame:SetPoint('BOTTOMRIGHT', main, 'BOTTOMRIGHT', -30, 10)
	
	local OptionsScrollChild = CreateFrame('Frame', '$parentChild', OptionsScrollFrame)
	OptionsScrollChild:SetPoint('TOPLEFT', OptionsScrollFrame, 'TOPLEFT')
	OptionsScrollChild:SetSize(580, 750)
	OptionsScrollFrame:SetScrollChild(OptionsScrollChild)


	local Title = main:CreateFontString( nil, "ARTWORK", "GameFontNormalLarge" )
	Title:SetPoint( "TOP", 0, -10 )
	Title:SetText( addonName )

	
	local GameTooltip = GameTooltip
	local function Frame_OnEnter(self)
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
		local tooltip = self.tooltip
		for x = 1, #tooltip do
			GameTooltip:AddLine(tooltip[x], 1, 1, 1)
		end
		GameTooltip:Show()
	end
	local function Frame_OnLeave(self)
		GameTooltip:Hide()
	end
	
	local prev
	local function CreateContainer( name, func )
		local Container = CreateFrame( "Frame", "$parent".. gsub(name, " ", ""), OptionsScrollChild, "OptionsBoxTemplate" )
		Container:SetPoint("LEFT", OptionsScrollChild, 10, 0)
		Container:SetPoint("RIGHT", OptionsScrollChild, -10, 0)
		if prev then
			Container:SetPoint("TOP", prev, "BOTTOM", 0, -8)
		else
			Container:SetPoint("TOP", OptionsScrollChild, "TOP", 0, -8)
		end
		
		local title = Container:CreateFontString( nil, "ARTWORK", "GameFontNormalLarge" )
		title:SetPoint( 'CENTER', Container, 'TOP', 0, 0 )
		title:SetText( name )
		
		local Background = Container:CreateTexture( nil, "BACKGROUND" )
		Background:SetTexture(0, 0, 0, 0.15)
		Background:SetPoint("TOPLEFT", 5, -5)
		Background:SetPoint("BOTTOMRIGHT", -5, 5)
		
		func( Container, name )
		
		prev = Container
		return Container
	end
	local function TextField_OnEnterPressed(self)
		local text = self:GetText()
		if text:len() > 0 then
			local num =  tonumber(text)
			if num then
				core.db[self.category][self.setting] = num
			end
		end
		self:ClearFocus()
	end
	local function TextField_OnEscapePressed(self)
		self:SetText(core.db[self.category][self.setting])
		self:ClearFocus()
	end
	local function TextField_OnMouseUp(self)
		self:SetFocus()
	end
	local function TextField_OnHide(self)
		self:ClearFocus()
	end
	local function CreateTextField(name, parent, category, setting, tooltip, width, height)
		local TextField = CreateFrame( 'EditBox', "$parent".. gsub(name, " ", ""), parent, 'InputBoxTemplate')
		TextField:SetAutoFocus(false)
		TextField:ClearFocus()
		TextField:SetSize(width, height)
		TextField:SetJustifyH('CENTER')
		
		TextField:Insert(core.db[category][setting])
		TextField:SetCursorPosition(0)
		TextField.category = category
		TextField.setting = setting
		
		if tooltip then
			TextField.tooltip = tooltip
			TextField:HookScript('OnEnter', Frame_OnEnter)
			TextField:HookScript('OnLeave', Frame_OnLeave)
		end
		
		TextField:HookScript('OnEnterPressed', TextField_OnEnterPressed)
		TextField:HookScript('OnEscapePressed', TextField_OnEscapePressed)
		TextField:HookScript('OnEditFocusLost', TextField_OnEscapePressed)
		TextField:HookScript('OnMouseUp', TextField_OnMouseUp)
		TextField:HookScript('OnHide', TextField_OnHide)
		
		local Label = parent:CreateFontString( nil, "ARTWORK", "GameFontNormal" )
		Label:SetText( name .. " : " )
		Label.Field = TextField
		
		Profile_OnChange[#Profile_OnChange +1] = function()
			TextField:SetText(self.db[category][setting])
			TextField:SetCursorPosition(0)
		end
		
		TextField:SetPoint('LEFT', Label, 'RIGHT', 11, 0)
		return Label
	end
	local function Slider_OnValueChanged(self, num)
		 local cur = core.db[self.category][self.setting]
		 if num + cur > cur + self:GetValueStep() then
			num = floor(num)
		end
		core.db[self.category][self.setting] = num
		self.text:SetText( num )
	end
	local function CreateSlider(name, parent, category, setting, tooltip, min, max, step)
		local Slider = CreateFrame( "Slider", "$parent".. gsub(name, " ", ""), parent, "OptionsSliderTemplate" );
		Slider:SetMinMaxValues( min or 0, max or 2 )
		Slider:SetValue( core.db[category][setting] )
		Slider:SetValueStep(step or 0.02)
		Slider:HookScript( "OnValueChanged", Slider_OnValueChanged )
		local Text = _G[ Slider:GetName().."Text" ]
		Text:ClearAllPoints();
		Text:SetPoint( "TOP", Slider, "BOTTOM", 0, 0 )
		Text:SetText( core.db[category][setting] )
		Slider.text = Text
		Slider.category = category
		Slider.setting = setting
		
		if tooltip then
			Slider.tooltip = tooltip
			Slider:HookScript('OnEnter', Frame_OnEnter)
			Slider:HookScript('OnLeave', Frame_OnLeave)
		end
		
		local Label = parent:CreateFontString( nil, "ARTWORK", "GameFontNormal" )
		Label:SetText( name .. " : " )
		Label.Slider = Slider
		
		Profile_OnChange[#Profile_OnChange +1] = function()
			Slider:SetValue( core.db[Slider.category][Slider.setting] )
			Text:SetText( core.db[Slider.category][Slider.setting] )
		end
		
		Slider:SetPoint('LEFT', Label, 'RIGHT', 11, 0)
		Slider:SetPoint('RIGHT', parent, 'RIGHT', -11, 0)
		return Label
	end

	
	local totalHeight = 0
	CreateContainer('Happiness', function(self)
		local HappyScale = CreateSlider('Happiness Scale', self, 'happiness', 'scale', {"Increase or decrease the rate happiness is gained."}, 1, 20, 1)
		HappyScale:SetPoint('TOPLEFT', self, 'TOPLEFT', 10, -16)
		
		local Influence = CreateTextField("Loyalty Influence", self, 'happiness', 'influence', {"% of experience gained/lost when loyalty is earned."}, 100, 8)
		Influence:SetPoint('TOPLEFT', HappyScale, 'BOTTOMLEFT', 0, -14)
		
		self:SetHeight(90)
		totalHeight = totalHeight + 90
	end)
	CreateContainer('Loyalty', function(self)
		local LoyaltyScale = CreateSlider('Loyalty Scale', self, 'loyalty', 'scale', {"Increase or decrease the rate loyalty is gained."}, 1, 20, 1)
		LoyaltyScale:SetPoint('TOPLEFT', self, 'TOPLEFT', 10, -16)
		
		local KillsRequired = CreateTextField("Kills Required", self, 'loyalty', 'killsRequired', {"Number of kills required to level loyalty at max level.", "Multiplied by the next loyalty level.", "At 100.  For rank 2, 200 kills required; rank 3 requires 300 kills."}, 100, 8)
		KillsRequired:SetPoint('TOPLEFT', LoyaltyScale, 'BOTTOMLEFT', 0, -14)
		
		self:SetHeight(90)
		totalHeight = totalHeight + 90
	end)
	
	
	OptionsScrollChild:SetHeight(totalHeight)
end)


InterfaceOptions_AddCategory( main )
_G['SLASH_' .. addonName .. 1] = "/petship"
SlashCmdList[addonName] = function(msg)
	if InCombatLockdown() then return print('Commands disabled in combat.') end
	if msg == 'reset' then
		PetshipDB = nil
		PetshipPets = nil
		core:UnregisterEvent('PLAYER_LOGOUT')
		ReloadUI()
	else
		InterfaceOptionsFrame_Show() -- redundant, yes; safer, also yes.
		InterfaceOptionsFrame_OpenToCategory(main.name)
	end
end
