local addonName, at = ...
if not at.core then return end

local core = at.core
core:AddCallback('Initialize', 'loyalty', function(self, ...)
	local tab = {}

	tab.enabled = true
	tab.scale = 1
	tab.killsRequired = 100
	tab.isMaxLevel = false
	
	self.db.loyalty = tab
end)

local NewTicker = at.NewTicker

local Loyalty = { 0, 30, 45, 60, 90 }
local Ranks = {
	[0] = 'Rebellious',
	[1] = 'Unruly',
	[2] = 'Submissive',
	[3] = 'Dependable',
	[4] = 'Faithful',
	[5] = 'Best Friend',
}
local Scale = 1
local KillsToLevel = 100
local isMaxLevel = false

local PetTimer
local PetTimer_LastTick = 0
local uptime = 0


-- frames/textures
local LoyaltyFrame = CreateFrame('Frame', nil, PetModelFrame)
LoyaltyFrame:SetSize(100, 16)

local LoyaltyFontString = LoyaltyFrame:CreateFontString()
LoyaltyFontString:SetFont([[Fonts\FRIZQT__.TTF]], 14, 'NONE')
LoyaltyFontString:SetTextColor(1.0, 1.0, 0.0)
LoyaltyFontString:SetPoint('TOP', PetModelFrame, 'TOP')
LoyaltyFrame:SetAllPoints(LoyaltyFontString)
LoyaltyFontString:SetJustifyH('CENTER')
LoyaltyFontString:SetText( Ranks[ 0 ] )

-- maybe display images to show loyalty level; possible icons: Achievement_Level_# 10, 20, 30... 85... 90, 100


local function UpdateLoyalty()
	if at.slot then
		local tab = at.pets[ at.slot ]
		
		if isMaxLevel then
			if tab.xp >= core.db.loyalty.killsRequired * ( tab.loyalty +1 ) then
				tab.loyalty = tab.loyalty +1
			end
			
		else
			if tab.xp >= UnitXPMax('player') * 0.05 and tab.active > Loyalty[ tab.loyalty +1 ] * core.db.loyalty.scale then
				-- yes, if the player levels up it will increase the required xp
				tab.xp = 0
				tab.loyalty = tab.loyalty +1
			end
			
		end
		if tab.loyalty > 5 then
			tab.loyalty = 5
		end
		
		LoyaltyFontString:SetText( Ranks[ tab.loyalty ] )
		
		at.pets[ at.slot ] = tab
	end
end

local function PetTimer_OnTick()
	local dub = GetTime()
	uptime = uptime + floor((dub - PetTimer_LastTick) / 60) -- get the difference and add it
	PetTimer_LastTick = dub

	UpdateLoyalty()
end
local function PetTimer_Stop(self, slot, ...)
	if PetTimer then
		if slot then
			PetTimer_OnTick() -- do one last tick
			at.pets[ slot ].active = at.pets[ slot ].active + (uptime * core.db.loyalty.scale)
			uptime = at.pets[ slot ].active
		end
		
		PetTimer:Cancel()
		PetTimer = nil
	end
end
local function PetActive()
	--if not PetTimer and at.slot then
		PetTimer = NewTicker(60, PetTimer_OnTick) -- infinite iteration; check pet uptime every minute
		PetTimer_LastTick = GetTime()
		uptime = at.pets[ at.slot ].active
		
		UpdateLoyalty()
	--end
end

local prevXP = 0
core:AddCallback('AddonLoaded', 'loyalty', function(self)
	prevXP = UnitXP('player')
	Scale = self.db.scale
	KillsToLevel = self.db.killsRequired
	
	local function Register_PlayerKill(OnLoad)
		-- tracking kills instead of XP
		isMaxLevel = true
		if not self.db.isMaxLevel then
			for x = 1, #at.pets do
				at.pets[x].xp = 1
			end
			self.db.isMaxLevel = true
		end
		self:AddCallback('PlayerKilledUnit', 'loyalty', function(self, level)
			if at.slot then
				-- modify the value for adding a kill, should work... but at this point I'm working off pure conjecture.
				-- forgotten realm... it's a joke about how I left out a table
				local gainedXP = 1
				local tab = at.pets[ at.slot ]
				if tab.happiness < 350 then
					gainedXP = floor(gainedXP + (1 + (self.db.happiness.influence / 100)))
					
				elseif tab.happiness >= 700 then
					gainedXP = floor(gainedXP + (1.5 + (self.db.happiness.influence / 100)))
					
				end
				at.pets[ at.slot ].xp = tab.xp + gainedXP
				UpdateLoyalty()
			end
		end)
	end
	
	if UnitLevel('player') == GetMaxPlayerLevel() then
		Register_PlayerKill()
	else
		core:RegisterEvent('PLAYER_XP_UPDATE')
		core:RegisterEvent('QUEST_TURNED_IN')
		function core:PLAYER_XP_UPDATE()
			if at.slot then
				local tab = at.pets[ at.slot ]
				local gainedXP = UnitXP('player') - prevXP
				
				if tab.happiness < 350 then
					gainedXP = floor(gainedXP * (1 + (core.db.happiness.influence / 100)))
					
				elseif tab.happiness >= 700 then
					gainedXP = floor(gainedXP * (1.5 + (core.db.happiness.influence / 100)))
					
				end--]]
				at.pets[ at.slot ].xp = tab.xp + gainedXP
			end
			prevXP = UnitXP('player')
		end
		function core:QUEST_TURNED_IN()
			self:RegisterEvent('QUEST_LOG_UPDATE')
			self:UnregisterEvent('PLAYER_XP_UPDATE')
		end
		function core:QUEST_LOG_UPDATE()
			self:UnregisterEvent('QUEST_LOG_UPDATE')
			self:RegisterEvent('PLAYER_XP_UPDATE')
		end
		core:AddCallback('OnPlayerLevelUp', 'loyalty', function(self, level)
			if level == GetMaxPlayerLevel() then
				Register_PlayerKill()
				core:UnregisterEvent('QUEST_LOG_UPDATE')
				core:UnregisterEvent('PLAYER_XP_UPDATE')
				core:UnregisterEvent('QUEST_TURNED_IN')
			end
		end)
	end
end)
core:AddCallback('Logout', 'loyalty', function(self)
	if PetTimer then PetTimer_Stop() end
end)

core:AddCallback('OnPetDismissed', 'loyalty', PetTimer_Stop)
core:AddCallback('OnPetVanished', 'loyalty', PetTimer_Stop)
core:AddCallback('OnPetAbandoned', 'loyalty', PetTimer_Stop)

core:AddCallback('OnPetCalled', 'loyalty', PetActive)
core:AddCallback('OnPetAppeared', 'loyalty', PetActive)

core:AddCallback('OnStableInfoAdded', 'loyalty', function(self, slot, icon, name, level, family, talent)
	at.pets[ slot ].loyalty = at.pets[ slot ].loyalty or 0
	at.pets[ slot ].active = at.pets[ slot ].active or 0
	at.pets[ slot ].xp = at.pets[ slot ].xp or 0
end)
