local addonName, at = ...
if not at.core then return end  -- "YOU SHALL NOT PASS!" - Gandolf


local core = at.core
core:AddCallback('Initialize', 'happiness', function(self, ...)
	local tab = {}

	tab.enabled = true
	tab.scale = 1
	tab.influence = 10
	
	self.db.happiness = tab
end)

local Ranks = {}
tinsert(Ranks, PET_HAPPINESS1) -- "Unhappy";
tinsert(Ranks, PET_HAPPINESS2) -- "Content";
tinsert(Ranks, PET_HAPPINESS3) -- "Happy";

local Icons = {}
tinsert(Icons, 'PetHappiness_Unhappy') -- "Unhappy";
tinsert(Icons, 'PetHappiness_Content') -- "Content";
tinsert(Icons, 'PetHappiness_Happy') -- "Happy"


local PLAYER_IS_MOVING = false

local FeedTimer
local PetWasFed = false
local MovementTimer

local bags = {}

-- frames/textures

local HappinessPetFrame = CreateFrame('Frame', nil, PetFrame)
HappinessPetFrame:SetSize(24, 23)
HappinessPetFrame:SetPoint('LEFT', PetFrame, 'RIGHT', 0, -5)
HappinessPetFrame:SetScript('OnEnter', function(self)
	GameTooltip:SetOwner(self, "ANCHOR_CURSOR")
	GameTooltip:SetText(self.TooltipText)
end)
HappinessPetFrame:SetScript('OnLeave', function(self)
	GameTooltip:Hide()
end)

local HappinessPetTexture = HappinessPetFrame:CreateTexture()
HappinessPetTexture:SetAllPoints(HappinessPetFrame)

HappinessPetTexture:SetTexture(at.mediaPath .. Icons[1])
HappinessPetFrame.TooltipText = Ranks[1]


local HappinessModelFrame = CreateFrame('Frame', nil, PetModelFrame)
HappinessModelFrame:SetSize(24, 23)
HappinessModelFrame:SetPoint('TOP', PetPaperDollPetInfo, 'BOTTOM', 0, -8)
HappinessModelFrame:SetScript('OnEnter', function(self)
	GameTooltip:SetOwner(self, "ANCHOR_CURSOR")
	GameTooltip:SetText(self.TooltipText)
end)
HappinessModelFrame:SetScript('OnLeave', function(self)
	GameTooltip:Hide()
end)

local HappinessModelTexture = HappinessModelFrame:CreateTexture()
HappinessModelTexture:SetAllPoints(HappinessModelFrame)

HappinessModelTexture:SetTexture(at.mediaPath .. Icons[1])
HappinessModelFrame.TooltipText = Ranks[1]




local function UpdateHappiness()
	if at.slot then
		local sub = at.pets[ at.slot ].happiness
		if sub < 0 then
			sub = 0
		end
		local dub = floor( sub / 350 ) + 1 -- 1, 2, 3
		
		HappinessModelTexture:SetTexture(at.mediaPath .. Icons[dub])
		HappinessModelFrame.TooltipText = Ranks[dub]
		HappinessPetTexture:SetTexture(at.mediaPath .. Icons[dub])
		HappinessPetFrame.TooltipText = Ranks[dub]
		
		at.pets[ at.slot ].happiness = sub
	end
end

local function FeedTimer_Stop()
	if FeedTimer then
		FeedTimer:Cancel()
		PetWasFed_PerTick = nil
		FeedTimer.Iterations = 0
	end
end
local function FeedTimer_OnTick()
	if not InCombatLockdown() then
		local tab = at.pets[ at.slot ]
		tab.happiness = tab.happiness + ( PetWasFed_PerTick * core.db.happiness.scale )
		FeedTimer.Iterations = FeedTimer.Iterations - 1
		if tab.happiness > 1049 then
			tab.happiness = 1049 -- keeps it from having a fourth rank
		end
		
		at.pets[ at.slot ] = tab
		if FeedTimer.Iterations == 0 then
			PetWasFed_PerTick = nil
			FeedTimer:Cancel()
		end
		
	else
		-- combat cancels the timer
		FeedTimer_Stop()
		
	end
	UpdateHappiness()
end


local function MovementTimer_OnTick()
	-- 50 in 6 minutes was what WoWPedia said... so until something rears its ugly head it stays
	at.pets[ at.slot ].happiness = at.pets[ at.slot ].happiness - 50
	UpdateHappiness()
end
local function MovementTimer_Stop()
	if MovementTimer then
		MovementTimer:Cancel()
		MovementTimer = nil
	end
end
local function TrackPlayerMovement()
	if not PLAYER_IS_MOVING then
		MovementTimer = at.NewTicker(6 * 60, MovementTimer_OnTick)
	elseif MovementTimer then
		MovementTimer_Stop()
	end
end
local function PetVisible()
	TrackPlayerMovement()
	UpdateHappiness()
end
local function PetVanish()
	FeedTimer_Stop()
	MovementTimer_Stop()
end

at.spells[6991] = function() --Feed Pet
	PetWasFed = PetWasFed_PerTick == nil
end

core:AddCallback('AddonLoaded', 'happiness', function(self)
	for bagID = 0, 4 do
		bags[bagID] = {}
		for slotID = 1, GetContainerNumSlots(bagID) or 0 do
			local _, itemCount, _, _, _, _, itemLink = GetContainerItemInfo(bagID, slotID)
			local itemLevel
			if itemLink then
				_, _, _, itemLevel = GetItemInfo(itemLink)
			end
			bags[bagID][slotID] = {
				level = itemLevel or 0,
				count = itemCount or 0,
			}
		end
	end
	core:RegisterEvent("BAG_UPDATE_DELAYED")
	function core:BAG_UPDATE_DELAYED() -- fires after any/all BAG_UPDATE's, simplified.  Also, BAG_UPDATE is fired for every slot when switching minor zones...........
		local dif
		for bagID = 0, 4 do
			for slotID = 1, GetContainerNumSlots(bagID) or 0 do
				local _, itemCount, _, _, _, _, itemLink = GetContainerItemInfo(bagID, slotID)
				local itemLevel
				if itemLink then
					_, _, _, itemLevel = GetItemInfo(itemLink)
				end
				if bags[bagID][slotID].count ~= itemCount or bags[bagID][slotID].level ~= itemLevel then
					if PetWasFed and not dif then
						-- this is assuming someone isn't using an addon that will feed the pet and move items in the bags
						-- we can't just break out of the update.
						dif = bags[bagID][slotID].level
						PetWasFed = false
					end
					bags[bagID][slotID].count = itemCount or 0
					bags[bagID][slotID].level = itemLevel or 0
				end
			end
		end
		if dif then
			-- so apparently pets can eat anything but players are level restricted... yeah, that's dumb.
			
			--dif = math.abs( dif - at.pets[ at.slot ].level ) -- the pet was fed something, anything > 10 level difference gives nothing
			--if dif < 10 then
				FeedTimer = at.NewTicker( 2, FeedTimer_OnTick, 10 ) -- fire every 2 seconds 10 times, total of 20 seconds
				FeedTimer.Iterations = 10

				local dub = floor( dif / 3 ) + 1
				if dif == 0 then
					dif = 1
				end
				PetWasFed_PerTick = floor( dif * ( 3.8888 * dub ) ) -- easy enough, it's not exactly the same but oh well.
			--end
		end
	end
end)
core:AddCallback('OnPetVanished', 'happiness', function(self, slot)
	if PLAYER_IS_MOVING then
		at.pets[ slot ].happiness = at.pets[ slot ].happiness - 10
	end
	PetVanish()
end)
core:AddCallback('OnPetDismissed', 'happiness', function(self, slot)
	at.pets[ slot ].happiness = at.pets[ slot ].happiness - 50
	PetVanish()
end)
core:AddCallback('OnPetAbandoned', 'happiness', PetVanish)
core:AddCallback('OnPetCalled', 'happiness', PetVisible)
core:AddCallback('OnPetAppeared', 'happiness', PetVisible)
core:AddCallback('PetDied', 'happiness', function()
	at.pets[ at.slot ].happiness = at.pets[ at.slot ].happiness - 350
	MovementTimer_Stop()
	UpdateHappiness()
end)

core:AddCallback('OnStableInfoAdded', 'happiness', function(self, slot, icon, name, level, family, talent)
	at.pets[ slot ].happiness = at.pets[ slot ].happiness or 0
end)



core:RegisterEvent('PLAYER_STARTED_MOVING')
function core:PLAYER_STARTED_MOVING(...)
	if at.slot then
		PLAYER_IS_MOVING = at.slot and true
		TrackPlayerMovement()
	end
end
core:RegisterEvent('PLAYER_STOPPED_MOVING')
function core:PLAYER_STOPPED_MOVING(...)
	if at.slot then
		PLAYER_IS_MOVING = at.slot and false
		TrackPlayerMovement()
	end
end
