local addonName, at = ...

if select(2, UnitClass("player")) ~= 'HUNTER' then
	DisableAddOn(addonName)
	return
 end

local core = CreateFrame('Frame', nil, UIParent)
core:SetScript("OnEvent", function(self, event, ...)
	self[event](self, ...)
end)
at.core = core

core.callbacks = {}
function core:Callback(name, ...)
	local tab = self.callbacks[name]
	if tab then
		for x, v in pairs(tab) do
			v(self, ...)
		end
	end
end
function core:CallbackKey(name, key, ...)
	local tab = self.callbacks[name]
	if tab[key] then
		tab[key](self, ...)
	end
end
function core:AddCallback(name, key, func)
	local tab = self.callbacks[name] or {}
	tab[key or #tab +1] = func
	self.callbacks[name] = tab
end
function core:RemoveCallback(name, key)
	if self.callbacks[name] then
		self.callbacks[name][key] = nil
	end
end
function core:CallOnce(name, ...)
	local tab = self.callbacks[name]
	for key, v in pairs(tab) do
		v(self, ...)
	end
	self.callbacks[name] = nil
end
function core:CopyTable(t, t2, wipeOld)
	if not t then return {} end
	if t2 then
		if wipeOld then t2 = wipe(t2) end
		for k,v in pairs(t) do
			if type(v) == 'table' then
				v = self:CopyTable(v, t2[k])
			end
			t2[k] = v
		end
		return t2
	else
		local t3 = {}
		for k,v in pairs(t) do
			if type(v) == 'table' then
				v = self:CopyTable(v)
			end
			t3[k] = v
		end
		return t3
	end
end

-- upvalues
local UnitPlayerControlled = UnitPlayerControlled
local UnitIsTapDenied = UnitIsTapDenied
local UnitIsTrivial = UnitIsTrivial
local UnitExists = UnitExists


-- both use this so I'll just keep these here.
at.NewTicker = C_Timer.NewTicker
at.GetTime = GetTime


local units = {}
local CallSpells = { 883, 83242, 83243, 83244, 83245 } -- Call Pet 1-5
at.pets = {}
at.spells = {}


local Pet_Called = false
local Pet_Dismissed = false
at.mediaPath = "Interface\\AddOns\\" .. addonName .. "\\Media\\"


--shows spec texture for pet when you open its frame
local function PetPaperDollFrame_OnShow()
	-- works like a charm
	if PetHasActionBar() then
		SetPortraitToTexture(CharacterFramePortrait, at.pets[ at.slot ].specialization[4]);
	end
end
PetPaperDollFrame:HookScript('OnShow', PetPaperDollFrame_OnShow)
PetPaperDollFrame:HookScript('OnHide', function()
	CharacterFrame_UpdatePortrait()
end)

core:RegisterEvent('PET_SPECIALIZATION_CHANGED')
function core:PET_SPECIALIZATION_CHANGED()
	if at.slot then
		at.pets[ at.slot ].specID = GetSpecialization(false, true) or at.pets[ at.slot ].specID or 1
		at.pets[ at.slot ].specialization = { GetSpecializationInfo(at.pets[ at.slot ].specID, nil, true) }
		if PetPaperDollFrame:IsShown() then
			PetPaperDollFrame_OnShow()
		end
	end
	self:Callback('OnPetSpecializationChanged')
end


at.spells[883] = function()
	Pet_Called = true
end
at.spells[83242] = at.spells[883]
at.spells[83243] = at.spells[883]
at.spells[83244] = at.spells[883]
at.spells[83245] = at.spells[883]

at.spells[2641] = function()
	Pet_Dismissed = true
end

local function UpdatePet()
	if PetHasActionBar() and UnitIsVisible("pet") and not at.slot then
		-- get the currently active Call Pet #, this doubles as a stable slotID
		for x =1, #CallSpells do
			if IsCurrentSpell(CallSpells[x]) then
				at.slot = x
				break
			end
		end
		
		--local id  = tonumber(UnitGUID('pet'):match("-(%d+)-%x+$"), 10)
		local icon, name, level, family, talent = GetStablePetInfo( at.slot )
		
		local tab = at.pets[ at.slot ] -- not sure what to do with the extra data yet, but I'm sure I'll think of something
		tab.id = tonumber(UnitGUID('pet'):match("-(%d+)-%x+$"), 10) -- ModelFrame:SetCreature( id )
		tab.name = name
		tab.level = level
		tab.family = family
		
		tab.icon = icon			-- why not?
		tab.talent = talent
		tab.specID = GetSpecialization(false, true) or tab.specID or 1
		tab.specialization = { GetSpecializationInfo(tab.specID, false, true) }
		tab.food = { GetStablePetFoodTypes( at.slot ) }
		
		if Pet_Called then
			tab.called = tab.called +1
			Pet_Called = false
			core:Callback('OnPetCalled')
			
		else
			core:Callback('OnPetAppeared')
			
		end
		core:Callback('OnPetUpdate')
		at.pets[ at.slot ] = tab
		
		core:RegisterUnitEvent("UNIT_NAME_UPDATE", 'pet')
		
	elseif at.slot then
		local slot = at.slot
		if Pet_Dismissed then
			at.slot = nil
			core:Callback('OnPetDismissed', slot)
			Pet_Dismissed = false
		
		elseif not UnitIsVisible("pet") then
			at.slot = nil
			core:Callback('OnPetVanished', slot)
		
		end
		
		core:UnregisterEvent("UNIT_NAME_UPDATE")
		
	end
end

core:RegisterEvent("UNIT_HEALTH")
function core:UNIT_HEALTH(token)
	if token == 'pet' and at.slot then
		self:Callback('OnPetHealthChanged')
	elseif UnitExists(token) and not UnitPlayerControlled(token) and not UnitIsTapDenied(token) and not UnitIsTrivial(token) then
		local guid = UnitGUID(token)
		if not units[ guid ] then
			units[ guid ] = UnitLevel(token)
		end
	end
end
core:RegisterEvent("PLAYER_REGEN_ENABLED")
function core:PLAYER_REGEN_ENABLED()
	units = wipe( units )
end


function core:UNIT_NAME_UPDATE()
	at.pets[ at.slot ].name = UnitName('pet')
end

core:RegisterEvent('PLAYER_LEVEL_UP')
function core:PLAYER_LEVEL_UP(level)
	if at.slot then
		at.pets[ at.slot ].level = level --UnitLevel('pet')
	end
	self:Callback('OnPlayerLevelUp', level)
end



core.VariableLoadCount = 0
local function LoadVariables(self, addon)
	-- this will run for each event that loads some form of variable; only doing something once they've all loaded.
	if addon and addon == addonName then
		self.VariableLoadCount = self.VariableLoadCount +1
		self:UnregisterEvent('ADDON_LOADED')
	else
		self.VariableLoadCount = self.VariableLoadCount +1
	end
	if self.VariableLoadCount > 2 then
		self.db = self:CopyTable(PetshipDB or self.defaults)
		at.pets = self:CopyTable(PetshipPets or {})
		
		at.playerID = UnitGUID('player')
		
		for x = 1, 55 do
			if not at.pets[x] or not at.pets[x].id then
				local icon, name, level, family, talent = GetStablePetInfo( x )
				if icon and name and level and family then
					at.pets[x] = {
						name = name,
						family = family,
						level = level,
						icon = icon, -- not needed but hey, whatever.
						talent = talent, -- ??, undocumented??
						
						called = 0,
						died = 0,
					}
					self:Callback('OnStableInfoAdded', x, icon, name, level, family, talent)
				else
					at.pets[x] = {
						called = 0,
						died = 0,
					}
					self:Callback('OnStableInfoAdded', x)
				end
			end
		end
		
		hooksecurefunc('LockPetActionBar', UpdatePet)
		hooksecurefunc('UnlockPetActionBar', UpdatePet)
		hooksecurefunc('HidePetActionBar', UpdatePet)
		hooksecurefunc('ShowPetActionBar', UpdatePet)
		
		self:Callback('AddonLoaded')
		self:CallOnce('VariablesLoaded')
		
		self.VariableLoadCount = nil
		self:UnregisterEvent('VARIABLES_LOADED')
		self:UnregisterEvent('PLAYER_ENTERING_WORLD')
		
		
		self:RegisterEvent("UNIT_PET")
	end
end

core:RegisterEvent('PLAYER_ENTERING_WORLD')
function core:PLAYER_ENTERING_WORLD()
	self.db = {}
	
	self:CallOnce('Initialize')

	self.defaults = self:CopyTable(self.db)
	LoadVariables(self)
end

core:RegisterEvent('ADDON_LOADED')
core.ADDON_LOADED = LoadVariables

core:RegisterEvent('VARIABLES_LOADED')
core.VARIABLES_LOADED = LoadVariables

core:RegisterEvent('PLAYER_LOGOUT')
function core:PLAYER_LOGOUT()
	self:Callback('Logout')
	PetshipPets = at.pets
	PetshipDB = self.db
end


-- hooks
hooksecurefunc('SetPetSlot', function(oldSlot, newSlot)
	local tab = core:CopyTable(at.pets[newSlot])
	at.pets[newSlot] = core:CopyTable(at.pets[oldSlot])
	at.pets[oldSlot] = tab
	
	if oldSlot == at.slot or newSlot == at.slot then -- "Did you just put that thing in your inventory?" - Fidget
		PetDismissed = true
		UpdatePet()
	end
end)
hooksecurefunc('PetAbandon', function()
	local tab = wipe( at.pets[ at.slot ] ) -- it will remove a table inside itself but how often will this happen...
	tab.called = 0
	tab.died = 0
	
	at.pets[ at.slot ] = tab
	core:Callback('OnPetAbandoned')
end)

function core:UNIT_PET(unit)
	if unit == 'player' then
		UpdatePet()
	end
end


core:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
function core:COMBAT_LOG_EVENT_UNFILTERED(...)
	--local timestamp, event, hideCaster, srcGUID, srcName, srcFlags, srcFlags2, destGUID, destName, destFlags, destFlags2, spellID, spellName, spellFlag, auraType, count = ...
	local _, event, _, srcGUID, _, _, _, destGUID, _, _, _, spellID, _, _, _, _ = ...

	if event == 'SPELL_CAST_SUCCESS' and srcGUID == at.playerID then
		local sub = at.spells[spellID]
		if sub then
			sub() -- individualized callback functions, since any singular part will use only 1 spellID.
		end
		
	elseif event == 'UNIT_DIED' then
		if UnitGUID('pet') == destGUID then
			self:Callback('PetDied')
			
		elseif units[destGUID] then
			self:Callback('PlayerKilledUnit', units[destGUID])
			units[destGUID] = nil

		end

	end
end





_G['SLASH_' .. addonName .. 1] = "/petship"
SlashCmdList[addonName] = function(msg)
	if InCombatLockdown() then return print('Commands disabled in combat.') end
	if msg == 'reset' then
		PetshipDB = nil
		PetshipSetting = nil
		core:UnregisterEvent('PLAYER_LOGOUT')
		ReloadUI()
	end
end
