NUM_PET_RESISTANCE_TYPES = 5;
NUM_PET_STATS = 5;

table.insert(CHARACTERFRAME_SUBFRAMES, 'PetPaperDollFrame')

PETPAPERDOLL_STATCATEGORY_DEFAULTORDER = {
	"GENERAL",
	"ATTACK",
	"SPELL",
	"DEFENSE",
};

function PetPaperDollFrame_OnLoad (self)
	PanelTemplates_SetNumTabs(CharacterFrame, 4)
	self:RegisterEvent("PET_UI_UPDATE");
	self:RegisterEvent("PET_BAR_UPDATE");
	self:RegisterEvent("PET_UI_CLOSE");
	self:RegisterEvent("UNIT_NAME_UPDATE");
	self:RegisterEvent("UNIT_PET");
	self:RegisterEvent("UNIT_MODEL_CHANGED");
	self:RegisterEvent("UNIT_LEVEL");
	self:RegisterEvent("PLAYER_ENTERING_WORLD");
	self:RegisterEvent("PET_SPELL_POWER_UPDATE");
	self:RegisterEvent("VARIABLES_LOADED");
	
	CharacterFrameTab4:SetScript('OnClick', function(self)
		--PanelTemplates_Tab_OnClick(self, CharacterFrame);
		ToggleCharacter("PetPaperDollFrame");
		PanelTemplates_SetTab(CharacterFrame, 4)
	end)
end

function PetPaperDollFrame_UpdateIsAvailable()
	if ( (not HasPetUI()) ) then
		PetPaperDollFrame.hidden = true;
		CharacterFrameTab4:Hide();
		CharacterFrameTab2:SetPoint("LEFT", "CharacterFrameTab1", "RIGHT", -16, 0);
		if ( PetPaperDollFrame:IsVisible() ) then --We have the pet frame selected, but nothing to show on it
			ToggleCharacter("PaperDollFrame");
		end
	else
		PetPaperDollFrame.hidden = false;
		CharacterFrameTab4:Show();
		CharacterFrameTab2:SetPoint("LEFT", "CharacterFrameTab4", "RIGHT", -16, 0);
	end
end

-- This makes sure the update only happens once at the end of the frame
function PetPaperDollFrame_QueuedUpdate(self)
	self:SetScript("OnUpdate", nil);
	PetPaperDollFrame_Update();
end

function PetPaperDollFrame_OnEvent (self, event, ...)
	local arg1, arg2 = ...;
	if ( event == "PET_UI_UPDATE" or event == "PET_UI_CLOSE" or event == "PET_BAR_UPDATE" or (event == "UNIT_PET" and arg1 == "player") or
		(event == "UNIT_NAME_UPDATE" and arg1 == "pet") ) then
		if (self:IsVisible()) then
			self:SetScript("OnUpdate", PetPaperDollFrame_QueuedUpdate);
		else
			PetPaperDollFrame_UpdateIsAvailable();
		end
	elseif( event == "PET_SPELL_POWER_UPDATE" ) then
		if (self:IsVisible()) then
			self:SetScript("OnUpdate", PetPaperDollFrame_QueuedUpdate);
		end
	elseif (event == "VARIABLES_LOADED") then
		PetPaperDollFrame_UpdateIsAvailable();
	elseif ( arg1 == "pet" ) then
		if (self:IsVisible()) then
			self:SetScript("OnUpdate", PetPaperDollFrame_QueuedUpdate);
		else
			PetPaperDollFrame_UpdateIsAvailable();
		end
	end
end

PetPaperDollFrame_BeenViewed = false;
function PetPaperDollFrame_OnShow(self)
	if ( self:IsVisible() ) then
		PetPaperDollFrame_BeenViewed = true;
	end
	SetButtonPulse(CharacterFrameTab4, 0, 1);	--Stop the button pulse
	
	CharacterFrame_Collapse();
	
	PetPaperDollFrame_Update();
end

function PetPaperDollFrame_OnHide()
	CharacterFrame_Collapse();
end

function PetPaperDollFrame_Update()
	local hasPetUI, canGainXP = HasPetUI();
	PetPaperDollFrame_UpdateIsAvailable();
	if ( not hasPetUI ) then
		return;
	end
	PetModelFrame:SetUnit("pet");
	if ( UnitCreatureFamily("pet") ) then
		PetLevelText:SetFormattedText(UNIT_TYPE_LEVEL_TEMPLATE, UnitEffectiveLevel("pet"), UnitCreatureFamily("pet"));
	end
	CharacterFrameTitleText:SetText(UnitName("pet"));
	PaperDollFrame_UpdateStats();
	
	local _, playerClass = UnitClass("player");
	if (playerClass == "HUNTER") then
		PetPaperDollPetModelBg:Show();
		PetPaperDollPetModelBg:SetTexture("Interface\\PetPaperDollFrame\\PetStatsBG-Hunter");
	elseif (playerClass == "WARLOCK") then
		PetPaperDollPetModelBg:Show();
		PetPaperDollPetModelBg:SetTexture("Interface\\PetPaperDollFrame\\PetStatsBG-Warlock");
	elseif (playerClass == "MAGE") then
		PetPaperDollPetModelBg:Show();
		PetPaperDollPetModelBg:SetTexture("Interface\\PetPaperDollFrame\\PetStatsBG-Mage");
	elseif (playerClass == "DEATHKNIGHT") then
		PetPaperDollPetModelBg:Show();
		PetPaperDollPetModelBg:SetTexture("Interface\\PetPaperDollFrame\\PetStatsBG-DeathKnight");
	else
		PetPaperDollPetModelBg:Hide();
	end

	if ( canGainXP ) then
		PetPaperDollPetInfo:Show();
	else
		PetPaperDollPetInfo:Hide();
	end
end
