local frame = CreateFrame("Frame", "DragFrame2", UIParent)
frame:SetMovable(true)
frame:EnableMouse(true)
frame:SetResizable(true)
frame:SetMinResize(128,128)
frame:SetMaxResize(512,512)

frame:SetScript("OnMouseDown", function(self, button)
if button == "LeftButton" and not self.isMoving then
self:StartMoving();
self.isMoving = true;
elseif button == "RightButton" then
self:StartSizing("BottomRight");
self.resizable = true;
end
end)
frame:SetScript("OnMouseUp", function(self, button)
if button == "LeftButton" and self.isMoving then
self:StopMovingOrSizing();
self.isMoving = false;
elseif button == "RightButton" then
self:StopMovingOrSizing();
self.resizable = false;
end
end)
frame:SetScript("OnHide", function(self)
if ( self.isMoving ) then
self:StopMovingOrSizing();
self.isMoving = false;
end
end)

SLASH_PETRACE1, SLASH_PETRACE2 = '/petrace', '/pr';
local function handler(msg, editbox)
if msg == 'hide' then
print("Pet race hidden!");
frame:Hide();
elseif msg == 'show' then
print("Pet race shown");
frame:Show();
end
end
SlashCmdList["PETRACE"] = handler; -- Also a valid assignment strategy

-- The code below makes the frame visible, and is not necessary to enable dragging.
frame:SetPoint("RIGHT"); frame:SetWidth(512); frame:SetHeight(512);
local tex = frame:CreateTexture("ARTWORK");
tex:SetAllPoints();
tex:SetTexture("Interface\\addons\\Petrace\\petrace.tga"); tex:SetAlpha(1);