--[[ PRD editor features:
1. Resize class specific resources 
2. Resource spacing adjustment (relative to powerbar)
3. Show/hide class specific resource 
4. Show/hide PRD buffs
5. Buffs placement fix (no reason to touch this)  
]]





--1. Scaling of each class' extra resource (holy power, death runes, combo pts etc.)
--		1=default, 0.0001 if you want to make it near invisible, if hiding function doesn't work.
ClassNameplateBarPaladinFrame:SetScale(1)
DeathKnightResourceOverlayFrame:SetScale(1.3)
ClassNameplateBarWindwalkerMonkFrame:SetScale(1.5)
ClassNameplateBarRogueDruidFrame:SetScale(1.5)
ClassNameplateBarMageFrame:SetScale(1.5)
ClassNameplateBarWarlockFrame:SetScale(1.3)





-- 2. Spacing adjustments of extra resource
--		4= blizz default, 0 = near powerbar. -30 goes above health bar, 20 goes way down etc.
--		Note: Monk is a bit wonky because it's the only class with 2 unique resources (monk=chi and brew=stagger). Reload ui/relog when switching specs should help
local dkSpacing = -0
local brewmasterSpacing = 0
local monkSpacing = -3
local rogueDruidSpacing = -1
local paladinSpacing = 0
local mageSpacing = -4
local warlockSpacing = 0





-- 3. Show/hide extra resource
--		1=show, 0=hide
local showDK = 1
local showBrewmaster = 1
local showWindwalker = 1
local showRogueDruid = 1
local showPaladin = 0
local showMage = 1
local showWarlock = 1





-- 4. Show/hide PRD buffs 
--		line below: false=buffs shown, true=buffs hidden
local enableFeature = false  

if enableFeature then
    hooksecurefunc("CompactUnitFrame_UpdateAuras", function(frame)
        if frame.optionTable.colorNameBySelection then
            if UnitGUID(frame.unit) == UnitGUID("player") then
                frame.BuffFrame:Hide()
            else
                frame.BuffFrame:Show()
            end
        end
    end)

    local function fn(...)
        for _, v in pairs(C_NamePlate.GetNamePlates()) do
            local bf = v.UnitFrame.BuffFrame
            bf.baseYOffset = 0
            bf:UpdateAnchor()
        end
    end
    NamePlateDriverFrame:HookScript("OnEvent", fn)
end

-- Death Knight runes
hooksecurefunc(DeathKnightResourceOverlayFrame, "Show", function(self)
    if self:GetParent() then
        self:GetParent().spacing = dkSpacing
    end
    if showDK == 0 then
        self:Hide()
    end
end)

-- Windwalker/Brewmaster chi/stagger (spec-aware for spacing/show)
hooksecurefunc(ClassNameplateBarWindwalkerMonkFrame, "Show", function(self)
    if self:GetParent() then
        local spec = GetSpecialization()  -- 1=Brewmaster, 2=Windwalker
        local spacing = (spec == 1 and brewmasterSpacing) or monkSpacing
        self:GetParent().spacing = spacing
    end
    local spec = GetSpecialization()  -- 1=Brewmaster, 2=Windwalker
    if (spec == 1 and showBrewmaster == 0) or (spec == 2 and showWindwalker == 0) then
        self:Hide()
    end
end)

-- Rogue/Druid combo points
hooksecurefunc(ClassNameplateBarRogueDruidFrame, "Show", function(self)
    if self:GetParent() then
        self:GetParent().spacing = rogueDruidSpacing
    end
    if showRogueDruid == 0 then
        self:Hide()
    end
end)

-- Paladin holy power
hooksecurefunc(ClassNameplateBarPaladinFrame, "Show", function(self)
    if self:GetParent() then
        self:GetParent().spacing = paladinSpacing
    end
    if showPaladin == 0 then
        self:Hide()
    end
end)

-- Mage arcane charges
hooksecurefunc(ClassNameplateBarMageFrame, "Show", function(self)
    if self:GetParent() then
        self:GetParent().spacing = mageSpacing
    end
    if showMage == 0 then
        self:Hide()
    end
end)

-- Warlock soul shards
hooksecurefunc(ClassNameplateBarWarlockFrame, "Show", function(self)
    if self:GetParent() then
        self:GetParent().spacing = warlockSpacing
    end
    if showWarlock == 0 then
        self:Hide()
    end
end)





-- 5. When you use "larger nameplates" PRD (interface>names), the buffs (such as warrior enrage) are shown properly on top of the PRD health bar, instead of floating above
local function fn(...) for _,v in pairs(C_NamePlate.GetNamePlates())do local bf=v.UnitFrame.BuffFrame bf.baseYOffset=0 bf:UpdateAnchor()end end NamePlateDriverFrame:HookScript("OnEvent",fn)
