local FACTION_ARGUSSIAN_REACH = 2170
local FACTION_LEGIONFALL = 2045
local FACTION_ARMY_OF_THE_LIGHT = 2165
local FACTION_COURT_OF_FARONDIS = 1900
local FACTION_DREAMWEAVERS = 1883
local FACTION_HIGHMOUNTAIN_TRIBE = 1828
local FACTION_NIGHTFALLEN = 1859
local FACTION_WARDENS = 1894
local FACTION_VALARJAR = 1948

--initialize the environment
local ParagonTracker = {}
--local _G = _G

--Addon settings
local ADDON_NAME = "ParagonTracker";
local ADDON_IS_LOADED = false;
local DEBUGGING = false;

--Frame for watching events
local frame = CreateFrame("FRAME");
frame:RegisterEvent("ADDON_LOADED");
frame:RegisterEvent("PLAYER_LOGOUT")
frame:RegisterEvent("UPDATE_FACTION");
frame:RegisterEvent("QUEST_LOG_UPDATE");

local characterData;
local charName = UnitName("player");
local realmName = GetRealmName();
local db;
local repFrame;
local charList = {};
local font = "Fonts\\FRIZQT__.TTF"
local currentCharacter;
ParagonTracker.CurrentDropDownItem = nil;
ParagonTracker.isToggled = false;
ParagonTracker.characterData = nil;
ParagonTracker.currentCharacter = nil
ParagonTracker.AvailableParagons = {}
--[[
TODO:
Cleanup variables
Remove things from global scope
DOCUMENTATION

FUTURE:
Make server collapsible in list?
Options page
Make a server class?
]]--

--[[
DOCUMENTATION:
Objects:
character
reputation

Many reputations can belong to a single character


]]--
function frame:OnEvent(event, arg1)
	if event=="ADDON_LOADED" and arg1 == ADDON_NAME then
		ADDON_IS_LOADED = true;
		RepDB = RepDB or {};
		db = RepDB;
		
		--load realms table if exists, else create table
		db.Realms = db.Realms or {}
		--load realm table if exists, else create table
		db.Realms[realmName] = db.Realms[GetRealmName()] or {}
		--load characters table if exists, else create table
		db.Realms[realmName].Characters = db.Realms[realmName].Characters or {}
		--load character table if exists, else create table
		db.Realms[realmName].Characters[charName] = db.Realms[realmName].Characters[charName] or {}
		
		--create object for the current character
		local c = Character:New()
		c:SetName(charName);
		c:SetServer(realmName);
		ParagonTracker.currentCharacter = c
		ParagonTracker.characterData = db.Realms[realmName].Characters[charName]
		ParagonTracker.UpdateCharacterReps(ParagonTracker.characterData, ParagonTracker.currentCharacter);
		charList = ParagonTracker.LoadCharactersFromDB()
		
		ParagonTrackerFrameCloseButton:SetScript("OnClick", function() ParagonTracker.Toggle() end)
	elseif (event=="UPDATE_FACTION" or event=="QUEST_LOG_UPDATE") and ADDON_IS_LOADED then	
		ParagonTracker.UpdateCurrentCharacterInList(ParagonTracker.characterData, ParagonTracker.currentCharacter)
		if(ParagonTrackerDropDownMenu) then
			ParagonTracker_Update();
		end
		if(ParagonTracker.IsNewParagonFound()) then
			ParagonTracker.InitDropDownFrame()
		end
	elseif event=="PLAYER_LOGOUT" then
		RepDB = RepDB;
	end
end	

frame:SetScript("OnEvent", frame.OnEvent);

SLASH_PTREP1 = "/paragontracker";
SLASH_PTREP2 = "/pt";
SLASH_PTREP3 = "/paragon";
function SlashCmdList.PTREP(msg)
	if msg=="show" or msg=="" or not(msg) then
	ParagonTracker.Toggle()
	ParagonTracker_Update();
	elseif msg=="hide" then
	ParagonTracker.Toggle()
	elseif msg=="help" then
	print("Paragon Tracker Commands:")
	print("  -  /pt help - shows this message")
	print("  -  /pt - toggle between showing and hiding the window")
	print("Aliases: /pt, /paragontracker, /paragon")
	end
end

function ParagonTracker.IsNewParagonFound()
	local uniqueReps = ParagonTracker.GetUniqueParagonsFound()
	local currentReps = ParagonTracker.AvailableParagons;
	for k,v in ipairs(uniqueReps) do
		if not(tContains(currentReps, v.repID)) then
			return true
		end
	end
end

function ParagonTracker.GetParagonReps()
	local paragonReps = {};
	for i = 1, GetNumFactions() do
		factionID = select(14, GetFactionInfo(i));
		if(factionID) then
			local hasParagon = C_Reputation.IsFactionParagon(factionID)
			if (hasParagon) then
				tinsert(paragonReps, factionID)
			end
		end
	end

	return paragonReps
end

--Need additional functionality to update the charList object on FACTION_UPDATE
function ParagonTracker.UpdateCharacterReps(charData, charObj)
	local paragonRepList = ParagonTracker.GetParagonReps();
	local charReps = {}
	if(#paragonRepList==0) then
		debugger("    No Paragon reputations found.")
		return false --just need to stop the function if there's no reps
	end
	for _,v in ipairs(paragonRepList) do
		local currentRep, thresh, qid, reward = C_Reputation.GetFactionParagonInfo(v)
		local repFound = false
		charData[v] = {repAmount=currentRep, threshold=thresh, questID=qid, hasReward=reward}
		local z = Reputation:New();
		local rName = GetFactionInfoByID(v)
		z:Init(rName, v, true, currentRep, reward, thresh)
		tinsert(charReps, z)
	end
	charObj:SetReputations(charReps)
end

function ParagonTracker.UpdateCurrentCharacterInList(charData, charObj)
	for _, obj in pairs(charList) do
		if obj:GetName()==charObj:GetName() and obj:GetServer()==charObj:GetServer() then
			ParagonTracker.UpdateCharacterReps(charData, charObj)
		end
	end
end

--need to create a charList item  for the current character if not saved in DB at this time.
function ParagonTracker.LoadCharactersFromDB()
	local characterList = {}
	for realm, realmData in pairs(db.Realms) do
		for _, characters in pairs(realmData) do
			for character, charData in pairs(characters) do
				local c = Character:New()
				c:SetName(character)
				c:SetServer(realm
				)
				local reputationsList = {}
					for repID, repData in pairs(charData) do
						if(repID) then
							local r = Reputation:New()
							local repName = GetFactionInfoByID(repID)
							r:Init(repName, repID, true, repData.repAmount, repData.hasReward, repData.threshold)
							tinsert(reputationsList, r)
						end
					end
				if(character ~= ParagonTracker.currentCharacter:GetName()) then
					c:SetReputations(reputationsList)
				else
					c = ParagonTracker.currentCharacter
				end
				tinsert(characterList, c)
			end
		end
	end
	return characterList
end

function debugger(msg)
	if DEBUGGING then
		print(msg)
	end
end

function rPrint(s, l, i) -- recursive Print (structure, limit, indent)
	l = (l) or 100; i = i or "";	-- default item limit, indent string
	if (l<1) then print "ERROR: Item limit reached."; return l-1 end;
	local ts = type(s);
	if (ts ~= "table") then print (i,ts,s); return l-1 end
	print (i,ts);           -- print "table"
	for k,v in pairs(s) do  -- print "[KEY] VALUE"
		l = rPrint(v, l, i.."    ["..tostring(k).."]");
		if (l < 0) then break end
	end
	return l
end	

function ParagonTracker.Toggle()
	if(ParagonTracker.isToggled) then
		ParagonTrackerFrame:Hide()
		ParagonTracker.isToggled = false
	else
		ParagonTracker.InitDropDownFrame()
		ParagonTrackerFrame:Show()
		ParagonTracker.isToggled = true
	end
end

function ParagonTracker.InitDropDownFrame()
	repFrame = ParagonTrackerFrame
	local repDropDown = ParagonTrackerDropDownMenu or CreateFrame("Frame", "ParagonTrackerDropDownMenu", repFrame, "UIDropDownMenuTemplate")
	repDropDown:SetPoint("TOP", 0, -20)
	UIDropDownMenu_SetWidth(repDropDown, 196)
	UIDropDownMenu_Initialize(repDropDown, ParagonTracker_DropDownListInit)
	repDropDown:Show()
	local firstRep = ParagonTracker.GetUniqueParagonsFound()
	--if updating the dropdown menu, set back to the faction we were already viewing
	if(ParagonTracker.CurrentDropDownItem) then
		UIDropDownMenu_SetSelectedValue(repDropDown, ParagonTracker.CurrentDropDownItem)
	elseif(firstRep[1]) then
		ParagonTracker.CurrentDropDownItem = firstRep[1].repID
		UIDropDownMenu_SetSelectedValue(repDropDown, firstRep[1].repID)
	else
		UIDropDownMenu_SetText(repDropDown, "No paragon reputations found.")
	end
end

function ParagonTracker_DropDownListInit(frame, level, menuList)
	local info = UIDropDownMenu_CreateInfo()
	local uniqueReps = ParagonTracker.GetUniqueParagonsFound()
	for k,v in ipairs(uniqueReps) do
		info.text, info.checked, info.value, info.arg1 =  v.repName, false, v.repID, v.repID
		info.func = ParagonTracker_DropDownSelect
		UIDropDownMenu_AddButton(info)
		tinsert(ParagonTracker.AvailableParagons, v.repID)
	end
end

function ParagonTracker_DropDownSelect(self, arg1, arg2, checked)
	UIDropDownMenu_SetSelectedValue(ParagonTrackerDropDownMenu, self.value)
	ParagonTracker_Update()
end

function ParagonTracker.GetUniqueParagonsFound()
	local reputations = {}
	local repsInList = {}
	for _, charObj in ipairs(charList) do
		if charObj.reputations then
			for iter, repObj in ipairs(charObj.reputations) do
				if not(tContains(repsInList, repObj:GetRepID())) then
					local repName = GetFactionInfoByID(repObj:GetRepID())
					tinsert(repsInList, repObj:GetRepID())
					tinsert(reputations, {repName=repName; repID=repObj:GetRepID()})
				end
			end
		end
	end
	local sortFunction = function(a,b) return a.repName<b.repName end
	table.sort(reputations, sortFunction)
	return reputations;
end

function ParagonTracker.GetUniqueRealmsFound()
	local realms = {}
	for _, charObj in ipairs(charList) do
		if not(tContains(realms, charObj:GetServer())) then
		tinsert(realms, charObj:GetServer())
		end
	end
	local sortFunction = function(a,b) return a<b end
	table.sort(realms, sortFunction)
	return realms;
end

function ParagonTracker_SetRowType(row, isRealm, isCharacter, hasRep)
	local rowName = row:GetName()
	local rowBar = _G[rowName.."ReputationBar"];
	local rowBorder = _G[rowName.."ReputationBarBorder"];
	local rowChar = _G[rowName.."RepCharName"];
	if (isRealm) then
		rowBar:Hide()
		rowBorder:Hide()
		rowChar:SetFontObject(GameFontNormalLeft)
	else
		rowChar:SetFontObject(GameFontHighlightSmall)
	end
end

function ParagonTracker_CreateList()
	local masterList = {}
	local realms = ParagonTracker.GetUniqueRealmsFound()
	local paragonDropDownValue = UIDropDownMenu_GetSelectedValue(ParagonTrackerDropDownMenu)
	local sortRealmsFunction = function(a,b) return a<b end
	local sortCharsFunction = function(a,b) return a:GetName()<b:GetName() end
	table.sort(realms, sortRealmsFunction)
	for _, realm in pairs(realms) do
		tinsert(masterList, {itemName=realm; itemType="server"})
		table.sort(charList, sortCharsFunction)
		for _, charObj in pairs(charList) do
			--debugger("Found "..charObj:GetName().." in charList")
			if charObj:GetServer() == realm then
				if(charObj.reputations) then
					for _, repObj in pairs(charObj.reputations) do
						if(repObj:GetRepID()==paragonDropDownValue) then
						--debugger("    Adding "..charObj:GetName())
							tinsert(masterList, {itemName=charObj:GetName(); itemType="charObj"; itemData=charObj})
						end
					end
				end
			end
		end
	end
	return masterList
end

function ParagonTracker_Update()
	local paragonList = ParagonTracker_CreateList();
	local paragonDropDownValue = UIDropDownMenu_GetSelectedValue(ParagonTrackerDropDownMenu)
	ParagonTracker.CurrentDropDownItem = paragonDropDownValue
	 --code for testing scrollframe functionality
	--[[
	local test = UIDropDownMenu_GetSelectedValue(ParagonTrackerDropDownMenu)
	if(test==1948) then
		for i=1, 10, 1 do
			tinsert(paragonList, paragonList[1])
			tinsert(paragonList, paragonList[2])
		end
	end
	]]--
	if(#paragonList>10) then
		if ( not FauxScrollFrame_Update(ParagonTrackerRepScrollFrame, #paragonList, 10, 24)) then
			ParagonTrackerRepScrollFrame:SetValue(0)
		end
	else
		ParagonTrackerRepScrollFrame:Hide()
		ParagonTrackerFrameSubFrame:SetPoint("TOPRIGHT", ParagonTrackerFrame, "TOPRIGHT", -20, 20)
	end
	local paragonOffset = FauxScrollFrame_GetOffset(ParagonTrackerRepScrollFrame);

	for i=1, 10, 1 do
		local paragonIndex = paragonOffset + i;
		local paragonRow = _G["ParagonTrackerFrameSubFrameRep"..i];
		local paragonBar = _G["ParagonTrackerFrameSubFrameRep"..i.."ReputationBar"];
		local paragonBarText = _G["ParagonTrackerFrameSubFrameRep"..i.."ReputationBarReputationAmount"];
		local paragonName = _G["ParagonTrackerFrameSubFrameRep"..i.."RepCharName"];

		--debugger("Iterating on "..i.. " out of "..#paragonList)
		if( paragonIndex <= #paragonList) then
			local listItem = paragonList[paragonIndex]
			local currentRep, boxesReceived, repThreshold, reward = 0,0,0, false
			paragonName:SetText(listItem.itemName)
			if listItem.itemType=="server" then
				ParagonTracker_SetRowType(paragonRow, true)
			elseif listItem.itemType=="charObj" then 
				paragonRow:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
				local repObj = listItem.itemData:GetReputationByID(paragonDropDownValue)
				if(ParagonTracker.currentCharacter:GetName() == listItem.itemData:GetName()) then
					currentRep, repThreshold, _, reward = C_Reputation.GetFactionParagonInfo(paragonDropDownValue)
					boxesReceived = math.floor(currentRep/repThreshold)
				else
				currentRep = repObj:GetReputationAmount()
				boxesReceived = repObj:GetBoxesReceived()
				repThreshold = repObj:GetThreshold()
				reward = repObj:HasReward()
				end
				
				currentRep = currentRep-(boxesReceived*repThreshold)
				paragonBar:SetMinMaxValues(0, repThreshold)
				paragonBar:SetValue(currentRep)

				if(reward) then
				paragonBarText:SetText("Reward Available!")
				else
				paragonBarText:SetText(currentRep.." / "..repThreshold)
				end
				ParagonTracker_SetRowType(paragonRow, false, true, exists)
				paragonBar:Show()
			end
			--debugger("    Show me ".. paragonBar:GetName())
			paragonRow:Show()
		else
			paragonRow:Hide()
		end
		
	end
end

	
	


