-- Quest Cache Table.  Move to player UI once I learn how to do so for better control of their stuff.
local QuestTable = {
	-- Legion
	[45540] = false,	-- A Call From The Caverns, test function.
    [46743] = true, 	-- Supplies From Highmountain
    [46745] = true, 	-- Supplies From the Court
    [46746] = true, 	-- Supplies From the Valarjar
    [46747] = true, 	-- Supplies From the Dreamweavers
    [46748] = true, 	-- Supplies From the Nightfallen
    [46749] = true, 	-- Supplies From the Wardens
	[46777] = true, 	-- The Bounties of Legionfall
    [46800] = true, 	-- Paragon of the Wardens
	[48976] = true, 	-- Supplies From the Argussian Reach
	[48977] = true, 	-- Supplies From the Army of the Light
	
	-- BfA 
		-- Neutral
	[54453] = true, 	-- Supplies from Magni
	[54451] = true, 	-- Baubles from the Seekers

		-- Alliance
	[54454] = true, 	-- Supplies from the 7th Legion
	[54456] = true, 	-- Supplies from the Order of Embers
	[54457] = true, 	-- Supplies from Storm's Wake
	[54458] = true, 	-- Supplies from the Proudmoore Admiralty
		
		-- Horde
	[54455] = true, 	-- Supplies from the Honorbound
	[54461] = true, 	-- Supplies from the Voldunai
	[54462] = true, 	-- Supplies from the Zandalari Empire
	[54460] = true, 	-- Supplies from Talanji's Expedition
}

-- Quest Cache Function.  Use this to let the player know that they have a new rep cache waiting for them.  
local QuestFrame = CreateFrame("Frame")
QuestFrame:RegisterEvent("QUEST_ACCEPTED")
QuestFrame:SetScript("OnEvent", function(self, event, questIndex)
    local title, level, _, _, _, _, _, questID = GetQuestLogTitle(questIndex)
    if QuestTable[questID] then
		local text = format("New Cache Quest added to your log:\n" ..title.. "\n\nID #:" ..questID)
        message(text)
        print(text)
    end
end)

-- UNUSED CODE (for later reference) --
	-- local text = format("New Cache Quest added to your log: %s [%d] %d", title, level, questID)
	
	-- local title, level, suggestedGroup, isHeader, isCollapsed, isComplete, frequency, questID, startEvent, displayQuestID, isOnMap, hasLocalPOI, isTask, isStory, isHidden = GetQuestLogTitle(arg1)
	
	
	
