-- ------------------------------------------------------------------------- --
-- Project: Occupied Intern module for Executive Assistant 
-- Author:  VincentSDSH				
-- Localization.Lua for English
-- ------------------------------------------------------------------------- --
local AddonName = ...
local L = LibStub('AceLocale-3.0'):NewLocale(AddonName, 'enUS', true)

L.parent_AddonName = "Executive_Assistant"
L.appName = 'Executive Assistant - Occupied Intern'
L.parent_appName = 'Executive Assistant'
L.StatusField_appName = 'Executive Assistant'
L.subSectionName = 'Occupied Intern'
L.module = 'module'
L.appName_short = 'Intern: Occupied Intern'
L.authorName = 'VincentSDSH'
L.statusText = '%s (v%s) by %s  %s: %s'
L.oi_HelpTag = "oi_Help"

L.versionData = "Module version %s updated to WoW version %s by %s"
L.mainOpts_intro = "%s is a module for %s that Resets a Completed Task based on a User-Entered, Per-Task Number of Days (%s), Number of Hours (%s), or Minutes (%s).\n\nCommand Line Options: %s\n"
L.slashCommand = "/oi"
L.slashCommand_timers = "/oi timers"
L.Help_para2 = "Both Task Types contain a section labeled '%s' which contains the '<units> Till Reset' control and the Show Notification toggle. If a Timer is active, the section is named '%s' and the reset Time & Date is displayed as well.\n\n%s contains %s\n%s contains %s\n%s contains %s\n\nEach '<units> Till Reset' has a range from 1 respective unit to 31 days.\n\nTo see a list of running timers, type %s.\n\nYou may freely change the Task Type as with native Task Types however if %s is disabled, Tasks using those Task Types will lock down with an unalterable Type of 'Missing Module' and will return to normal operation when %s is enabled.\n\n%s toggles the chat-window notifications when setting or resetting the timer (note that no reset notifications will happen at login)."

L.listTimers_string = "%c :: Current Time"
L.blizzyOpts_blurb = "%s doesn't have any explicit configuration itself, see the Help for more information. Executive Assistant Configuration Dialogs can be reached with the '%s' button below. They can alternatively be reached from the DataBroker / Minimap Button, Task Window, or Command Line (/ea config).\n\n'%s' is self-explanatory.\n"
L.blizzyOpts_buttonName_config = "Open Configuration"
L.blizzyOpts_buttonName_help = "Open Help"

L.timer_autoresetSched = " auto-reset scheduled for "
L.timer_autoresetCanceled = " timer canceled for "

L.optsTable_IsBusyForHours_label = "Is Busy for Hours"
L.optsTable_IsBusyForMinutes_label = "Is Busy for Minutes"
L.optsTable_IsBusyForDays_label = "Is Busy for Days"

L.optsTable_IsBusyForDays = {	
				module = 'Occupied Intern',
				name   = "Is Busy for Days",
				letter = "Od",
				color  = {
					["r"] = .075,
					["g"] = 1,
					["b"] = 1,
					["a"] = 1,
				}
			}

L.optsTable_IsBusyForHours = {	
				module = 'Occupied Intern',
				name   = "Is Busy for Hours",
				letter = "O",
				color  = {
					["r"] = .075,
					["g"] = 1,
					["b"] = 0.5,
					["a"] = 1,
				}
			}

L.optsTable_IsBusyForMinutes = {
				module = 'Occupied Intern',
				name   = "Is Busy for Minutes",
				letter = "o",
				color  = {
					["r"] = .075,
					["g"] = 0.5,
					["b"] = 1,
					["a"] = 1,
				}
			}

L.reminder_NextTrigger = "Occupied Intern: Busy Until..."
L.reminder_OffsetDays = "Days Till Reset"
L.reminder_OffsetDays_desc = "When the Task is Completed, Number of Days Occupied Intern waits until it is Reset"
L.reminder_OffsetHours = "Hours Till Reset"
L.reminder_OffsetHours_desc = "When the Task is Completed, Number of Hours Occupied Intern waits until it is Reset"
L.reminder_OffsetMinutes = "Minutes Till Reset"
L.reminder_OffsetMinutes_desc = "When the Task is Completed, Number of Minutes Occupied Intern waits until it is Reset"

L.Day = "Day"
L.Month = "Month"
L.Year = "Year"
L.Hour = "Hour"
L.Minute = "Minute"

L.AddonConfiguration = "Addon Configuration"
L.HelpAndInformation = "Help and Information"
L.timerCmdLine = "List Active Task Timers"
L.ActiveTimers = " -- Active Timers -- "
L.noActiveTimers = "No Currently Active Timers"
L.suppressNotify_name = "Hide Set/Reset Notification"
L.suppressNotify_desc = "Hides chat-window notifications when setting or resetting the timer (except at login)"
