-- ------------------------------------------------------------------------- --
-- Project: Occupied Intern module for Executive Assistant 
-- Author:  VincentSDSH				
-- ------------------------------------------------------------------------- --
local AddonName = ...
local debug = function(...) exOI.LEA_debug(exOI, ...) end
local L   = LibStub("AceLocale-3.0"):GetLocale(AddonName)
local exL = LibStub("AceLocale-3.0"):GetLocale(L.parent_AddonName)
local GROUP_IDENTIFIER, TASK_IDENTIFIER = "g", "t"
local MOVE_UP, MOVE_DOWN = "UP", "DOWN"

function exOI:regOptions()
	local sdbg, sdbc = self.db.global, self.db.char

	local function mkHeader(hdrName, numOrder, label) -- Give Me Similar Headers Or Give Me Death ----
		return { 
							order = true and numOrder or 0, 
							type = "description", 
							fontSize = "large",
							name = function()
								-- :doUpdateStatusField() placed /here/ is a full-on cheat to update the status field when tabs change
								--   Not the worst kludge/cheat I've done in the past few decades but there really seems no way to 
								--   trap cleanly the opt-table change in the standard Ace library. And this /is/ simple and clean...
								ExecAssist:doUpdateStatusField( label or hdrName ) -- , nil (not native)
								return hdrName:cf("fuglyYellow").."\n"
							end
					 }
	end

	-- Options Tables 
	blizzy_Opts = {
		--hdr = {order=0, type="header", name="<header name>"}, 
		type = "group",
		order = 10,
		name = self:mkLink(self.icons.defaultLDBIcon, 22).." "..L.appName,
		args = {
			introspacer = { order = 4, type = "description", name = "  "}, 
			intro = {
				order = 5,
				type = "description",
				fontSize = "medium",
				name = (L.mainOpts_intro):format(
					L.appName:cf("EAtan", "cream"),
					L.parent_appName:cf("EAtan", "cream"),
					L.optsTable_IsBusyForDays_label:cf("cyan", "cream"),
					L.optsTable_IsBusyForHours_label:cf("cyan", "cream"),
					L.optsTable_IsBusyForMinutes_label:cf("cyan", "cream"),
					L.slashCommand:cf("cyan", "cream")
				)
			},
			quickDirections = {
				type = "group",
				order = 10,
				name = "  ",
				inline = true,
				args = {			
					intro1 = {
						order = 1,
						type = "description",
						fontSize = "medium",
						name = (L.blizzyOpts_blurb):format(
							L.appName:cf("EAtan", "cream"),
							L.blizzyOpts_buttonName_config:cf("cyan", "cream"),
							L.blizzyOpts_buttonName_help:cf("cyan", "cream")
						),
					},
					configure = {
					  type = "execute",
					  name = (L.blizzyOpts_buttonName_config):cf("white"),
					  order = 50,
						func = function() self:doLoadConfig(); GameTooltip:Hide(); InterfaceOptionsFrameCancel:Click(); end, 
					},							
					help = {
					  type = "execute",
					  name = (L.blizzyOpts_buttonName_help):cf("white"),
					  order = 60,
						func = function() self:doLoadHelp(); GameTooltip:Hide(); InterfaceOptionsFrameCancel:Click(); end, 
					},							
				}							
			},
			verionData = {
				order = 20,
				type = "description",
				fontSize = "medium",
				name = ((L.versionData):cf("cream")):format(GetAddOnMetadata(AddonName, 'Version'):cf("grass", "cream"), self.wowVer:cf("grass", "cream"), L.authorName:cf("EAtan")),
			},
		},
	}
	-- Register Blizzy Options Tables, associate with ExecAssist's panel
	local RegOpts = LibStub("AceConfigRegistry-3.0")
	RegOpts:RegisterOptionsTable(AddonName, blizzy_Opts)	--------- Blizzy Opts -
	self.Dialog:AddToBlizOptions(AddonName, L.subSectionName,  LibStub("AceLocale-3.0"):GetLocale("Executive_Assistant").appName)
end 

-- Intern Functions -------------------------------------- --
function exOI:intern_getOptionsPanel() return nil end
function exOI:intern_getExtendedHelp()

	local oi_Help_OptTable = {
				type = "group",
				name = ("%s: %s"):format( L.module:cf("white", "cyan"), L.subSectionName),
				order=900, 
				args = {
					hdr = {order=0, type="header", name= L.subSectionName}, 
					intro = {
						order = 1, 
						type = "description",
						fontSize = "medium",
						name = (L.mainOpts_intro):format(
							L.appName:cf("EAtan", "cream"),
							L.parent_appName:cf("EAtan", "cream"),
							L.optsTable_IsBusyForDays_label:cf("cyan", "cream"),
							L.optsTable_IsBusyForHours_label:cf("cyan", "cream"),
							L.optsTable_IsBusyForMinutes_label:cf("cyan", "cream"),
							L.slashCommand:cf("afternoon", "cream")
						)
					},
					continue = {
						order = 10, 
						type = "description",
						fontSize = "medium",
						name = (L.Help_para2):cf("cream"):format(
						L.subSectionName:cf("fuglyYellow", "cream"),
						L.reminder_NextTrigger:cf("fuglyYellow", "cream"),

						L.optsTable_IsBusyForDays_label:cf("cyan", "cream"),
						L.reminder_OffsetDays:cf("grass", "cream"),

						L.optsTable_IsBusyForHours_label:cf("cyan", "cream"),
						L.reminder_OffsetHours:cf("grass", "cream"),
						L.optsTable_IsBusyForMinutes_label:cf("cyan", "cream"),
						L.reminder_OffsetMinutes:cf("grass", "cream"),


						L.slashCommand_timers:cf("sky", "cream"),
						L.subSectionName:cf("EAtan", "cream"),
						L.subSectionName:cf("EAtan", "cream"),
						L.suppressNotify_name:cf("cyan", "cream")
						)
					},
				}                   			
			}		
	return L.oi_HelpTag, oi_Help_OptTable
end
function exOI:intern_getInjectedControls(hTask)
	--[[ Injector Notes  -----------------------------------------------------
	 hTask allows us to see things about the Task to make show/hide decisions
	 or decisions about what controls to return, if that complexity is needed
	-- -------------------------------------------------------------------- -- 
	 Accessing vars via derivation ExecAssist context
	 	NB: this can possibly diminish what a module can accomplish
	
	 local hTask = ExecAssist.db.global.groupStem.agg[ info[ #info-n ] ]	
	 ...where n is the # of controls offsetting form the taskID root
	 Handy checker: for n = 1,#info do print(tostring(n)..": "..info[n]) end
	-- -------------------------------------------------------------------- -- 
	 To Inject controls individually (or a series of groups) use:
	local tcontrols = {
    	hdr200 = {order=720, type="header", name="<control name>"}, 
    	hdr300 = {order=730, type="header", name="<control name>"}, 
    	group400={type="group", name="<group name>", order=740, inline=true,
    		args = {}
    	}
	}
	-- -------------------------------------------------------------------- -- 
	 To ALTER EXISTING CONTROLS simply over-write their key name; this can
	 hide, disable, or change existing controls as needed
	-- -------------------------------------------------------------------- -- 
	 To Inject nothing, return nil 
	--]] ---------------------------------------------------------------------
	local ResetTypes = ExecAssist.taskTypes_Index -- ExecAssist.optValues.ResetTypes
	local hTask_clickAgg = hTask.isAcctWide and self:getAccountWideStem(hTask.id) or self:getCharacterStem(hTask.id)

	return {
		header_InternBored = {order=300, type="header", name=L.subSectionName, hidden = self:getChecked(hTask.id)},
		header_InternOccupied = {order=300, type="header", name=L.reminder_NextTrigger, hidden = not self:getChecked(hTask.id)},
		day = {
			name = L.Day,disabled = true, type="input", width = "half", hidden = not self:getChecked(hTask.id),
			order = 310,
			get = function(info) 
				return tostring(date("*t", hTask_clickAgg.resetDate_Next or time()).day)
			end,
			set = function(info, v) end, 
		},
		month = {
			name = L.Month, disabled = true, type="input", width = "half", hidden = not self:getChecked(hTask.id),
			order = 320,
			get = function(info) 
				return exL.optsTable_base.Months[date("*t", hTask_clickAgg.resetDate_Next or time()).month]
			end,
			set = function(info, v) end, 
		},
		year = {
			name = L.Year, disabled = true, type="input", width = "half", hidden = not self:getChecked(hTask.id),
			order = 330,
			get = function(info)
				local y = tostring(date("*t", hTask_clickAgg.resetDate_Next or time()).year)
				return y
			end,
			set = function(info, v) end, 
		},

		hour = {
			name = L.Hour,disabled = true, type="input", width = "half", hidden = not self:getChecked(hTask.id),
			order = 340,
			get = function(info) 
				return tostring(date("*t", hTask_clickAgg.resetDate_Next or time()).hour)
			end,
			set = function(info, v) end, 
		},
		minute = {
			name = L.Minute, disabled = true, type="input", width = "half", hidden = not self:getChecked(hTask.id),
			order = 350,
			get = function(info) return tostring(date("*t", hTask_clickAgg.resetDate_Next or time()).min) end,
			set = function(info, v) end, 
		},

		offsetDays = { 
			order=380,
			name = L.reminder_OffsetDays,
			desc = L.reminder_OffsetDays_desc,
			hidden = hTask.resetType ~= L.optsTable_IsBusyForDays_label,
			type="range", isPercent=false, min=1, max=31, step=1, -- 31 days
			get = function(info) return true and hTask.offsetDays or 1 end,
			set = function(info, v) hTask.offsetDays = v end, 
		},

		offsetHours = { 
			order=383,
			name = L.reminder_OffsetHours,
			desc = L.reminder_OffsetHours_desc,
			hidden = hTask.resetType ~= L.optsTable_IsBusyForHours_label,
			type="range", isPercent=false, min=1, max=744, step=1, -- 31 days
			get = function(info) return true and hTask.offsetHours or 1 end,
			set = function(info, v) hTask.offsetHours = v end, 
		},
		
		offsetMinutes = { 
			order=385,
			name = L.reminder_OffsetMinutes,
			desc = L.reminder_OffsetMinutes_desc,
			hidden = hTask.resetType ~= L.optsTable_IsBusyForMinutes_label,
			type="range", isPercent=false, min=1, max=44640, step=1, -- 31 days: a good intern doesn't question your sillyness
			get = function(info) return true and hTask.offsetMinutes or 1 end,
			set = function(info, v) hTask.offsetMinutes = v end, 
		},
		
		suppressNotify = {
		  name = L.suppressNotify_name,
		  desc = L.suppressNotify_desc,
		  type = "toggle",
		  width="double",
		  order = 390,
			get = function() return hTask.suppressNotify end,
			set = function(i, v) hTask.suppressNotify = v end,
		},			
	}
	
end
-- -------------------------------------- Intern Functions --
	
