-- ------------------------------------------------------------------------- --
-- Project: Occupied Intern module for Executive Assistant 
-- Author:  VincentSDSH				
-- Version: 1.1.1 - w7.3.5
-- ------------------------------------------------------------------------- --
-- Command: /oi
-- ------------------------------------------------------------------------- --
local AddonName = ...
local MODULE = "Occupied Intern"
local hExecAssist = LibStub("AceAddon-3.0"):GetAddon("Executive_Assistant")
exOI = hExecAssist:NewModule(MODULE, "AceTimer-3.0", "LibExecAssist-1.0")
exOI:SetEnabledState(true)
exOI.Dialog = LibStub("AceConfigDialog-3.0")
exOI.wowVer = "7.3.5"
local debug = function(...) exOI.LEA_debug(exOI, ...) end
local L = LibStub("AceLocale-3.0"):GetLocale(AddonName)

function exOI:OnInitialize()
	-- Plumbing --------------------------------------------- --
	self.alert = self.LEA_alert -- dev being lazy
  -- ------------------------------------------------------ --  
  
  -- Defaults -------------------------------------------------------------- --
	self.timers = {}
  self.icons = {
    ["defaultLDBIcon"]  = ([[Interface\Addons\%s\icons\LunchRunIntern_appIcon]]):format(AddonName),
  } 

  -- Setup AceDB
	self.DBDefaults = {}
  self.db = LibStub("AceDB-3.0"):New("OccupiedIntern", self.DBDefaults, true)    

	-- Prime char vars and charStem
	self.userCurrent = UnitName("player").." - "..GetRealmName(); self.userConfigDisplay = self.userCurrent

	self:LEA_msgSetup(L.appName, L.appName_short)
	self:LEA_enableDebug( exOI.db.sv.debug )
	debug("* Debugging Mode Active *") -- dev sanity check
	
	-- Register Options ------------------------------------------------------ --
	self:regOptions()

  -- Commandline ----------------------------------------------------------- --
	local cmdLine = {
		type = "group",
		name = "",
		args = {
      config = {
        type = "execute",
        name = "",
        desc = L.AddonConfiguration,
        func = function() exOI:doLoadConfig() end,
        order = 0
      },
      help = {
        type = "execute",
        name = "",
        desc = L.HelpAndInformation,
        func = function() exOI:doLoadHelp() end,
        order = 2
      },
      timers = {
        type = "execute",
        name = "",
        desc = L.timerCmdLine,
        func = function() exOI:doListTimers() end,
        order = 3      
      },
      debug = {
        cmdHidden = true, 
        type = "execute",
        name = "Toggle Debug",
        desc = "Toggles Debug Mode",
        func = function() exOI:doDebuggingMode() end,
        order = 3
      },      
    }
  }
 	LibStub("AceConfig-3.0"):RegisterOptionsTable(L.appName.." CmdLine", cmdLine, {"oi"}) -- Intern - Occupied Intern

end

function exOI:OnEnable()
	for itemID, hItem in self:IterateAgglomeration() do
		if self:isTask(itemID) then 
			if hItem.extCreate == L.subSectionName then -- it's one of ours
				if self:getChecked(itemID) then -- timer should technically be going
					local hTask_clickAgg = hItem.isAcctWide and self:getAccountWideStem(itemID) or self:getCharacterStem(itemID)
				
					-- [ Update 1.2 -> 1.3: shift resetDate_Next if in hTask ] ---- --
					if hItem.resetDate_Next then
						self:alert("1.3 Upgrade: reset-data moved for "..hTask.taskName:cf("grass", false))
						hTask_clickAgg.resetDate_Next = hItem.resetDate_Next
						hItem.resetDate_Next = nil
					end
					-- ------------------------------------------------------------ --
				
					if hTask_clickAgg.resetDate_Next > time() then -- it's within the zone					
						if self:IsAvailable_forUser(itemID) then -- last paranoia check to avoid reorg-related problems.
							self.timers[itemID] = self:ScheduleTimer( "reset_fromTimer", (hTask_clickAgg.resetDate_Next-time()) , itemID, hItem.taskName)							
						end					
					else -- past time
						self:setChecked(itemID, false)
					end		
				end
			end
		end
	end
end

function exOI:doListTimers()
	local count, hTask = 0
	self:alert(L.ActiveTimers)
	self:alert(date(L.listTimers_string, time()):cf("sky", false))
	for taskID, v in pairs(self.timers) do
		count=count+1
		hTask = self:getHandle(taskID)
		self:alert(date("%c", hTask.resetDate_Next):cf("grass", false).." "..hTask.taskName)
	end
	if count==0 then self:alert(L.noActiveTimers) end
end
function exOI:reset_fromTimer(taskID, taskName)
	local hTask = self:getHandle(taskID)
	if hTask and hTask.extCreate == L.subSectionName then -- avoids error and confusion if a task is deleted in ExecAssist
		if not hTask.suppressNotify then self:alert("Task "..taskName:cf("grass", false).." has been reset") end
		self:setChecked(taskID, false) 
		self:UpdateTaskWindow()
	end
	self:CancelTimer(self.timers[taskID])
end

-- Intern Functions ---------------------------------------------------------------------------------------- --
function exOI:intern_getClickMap() return nil end
function exOI:intern_getNewTaskTypes() 
	return { 
					[L.optsTable_IsBusyForHours_label]   = L.optsTable_IsBusyForHours,
					[L.optsTable_IsBusyForMinutes_label] = L.optsTable_IsBusyForMinutes,
					[L.optsTable_IsBusyForDays_label] = L.optsTable_IsBusyForDays
				 }
end

--  :getCharacterStem()
--  :getAccountWideStem()

function exOI:intern_clickHandler(hTask, isChecked, mouseButton) -- mouseButton, isCurrentUser, charName, source
	if mouseButton == "LeftButton" then
		if isChecked then 
		
			local hTask_clickAgg = hTask.isAcctWide and self:getAccountWideStem(hTask.id) or self:getCharacterStem(hTask.id)
			
			if hTask_clickAgg then
print("hTask_clickAgg acquired")

				-- advance the calendar
				if hTask.resetType == L.optsTable_IsBusyForDays_label then
					hTask_clickAgg.resetDate_Next = time() + (86400 * (hTask.offsetDays or 1))
				elseif hTask.resetType == L.optsTable_IsBusyForHours_label then
					hTask_clickAgg.resetDate_Next = time() + (3600 * (hTask.offsetHours or 1))
				elseif hTask.resetType == L.optsTable_IsBusyForMinutes_label then
					hTask_clickAgg.resetDate_Next = time() + (60 * (hTask.offsetMinutes or 1))
				end
				-- start / restart timer
				self.timers[hTask.id] = self:ScheduleTimer( "reset_fromTimer", (hTask_clickAgg.resetDate_Next-time()) , hTask.id, hTask.taskName)
				if not hTask.suppressNotify then self:alert(hTask.taskName:cf("grass", false)..L.timer_autoresetSched..date("%c", hTask_clickAgg.resetDate_Next):cf("sky") ) end
			else
print("hTask_clickAgg Empty")				
			end
		else
			-- end timer
			self:CancelTimer(self.timers[hTask.id])
			self.timers[hTask.id] = nil
			if not hTask.suppressNotify then self:alert(hTask.taskName:cf("grass", false)..L.timer_autoresetCanceled..hTask.taskName:cf("sky")) end
		end
		
		-- regrow leaf to update opt-table hidden=func()
		local hGroup = self:getHandle( hTask.p )
		ExecAssist:semiSmart_regrow( hGroup.G ) 		
	end
end
function exOI:intern_resetHandler() end -- ExecAssist reset agnostic
function exOI:intern_elementDeletionHandler(trashbin)
	for n=1,#trashbin do
		if self.timers[ trashbin[n] ] then
			self:CancelTimer(self.timers[ trashbin[n] ])
			self.timers[ trashbin[n] ] = nil
			-- nb: defaulting to 'no notification' as hTask is already deleted			
		end
	end
end
-- ---------------------------------------------------------------------------------------- Intern Functions --
	-- simple actions
function exOI:doDebuggingMode() exOI.db.sv.debug = not exOI.db.sv.debug; self:alert("Debugging is: "..(exOI.db.sv.debug and "on" or "off")); self:LEA_enableDebug( exOI.db.sv.debug ) end --ReloadUI() 
function exOI:doLoadConfig() ExecAssist:doOpenConfigWindow(ExecAssist.opts.f_MainOpts) end
function exOI:doLoadHelp()	 ExecAssist:doLoadHelp(L.oi_HelpTag) end

------- Misc Functions --------
	-- makes text hyperlinks for graphics to be used inline
function exOI:mkLink(path, size) return ("\124T"..path..":%d:%d:1:0\124t"):format(size, size) end
