NihongoQuestLog = NihongoQuest:New("NihongoQuestLog")

NihongoQuestLog.QUEST_DATA_INFO_TEMPLATE = "Gnome Technology"

isCarbonInitialized = false

function NihongoQuestLog:OnInitialize()
    NihongoQuestLogTitleText:SetText("Nihongo")
    NihongoQuestLogDataFrameText:SetFormattedText(self.QUEST_DATA_INFO_TEMPLATE, "unknown")

    self:Initialize()
    self.ScrollFrame = _G[self.Frame:GetName() .. "ScrollFrame"]

    self.QuestID =  _G[self.Frame:GetName() .. "QuestIdText"]
    self.QuestID:SetPoint("TOPLEFT", 0, -3)
	
    self:SetChecked(Nihongo.db.profile.quest.questlog)

end

function NihongoQuestLog:OnEnable()
    Nihongo:DebugLog("NihongoQuestLog: OnEnable.");
    NihongoQuestLogDataFrameText:SetFormattedText(self.QUEST_DATA_INFO_TEMPLATE, "")

    self:SetMovable(Nihongo.db.profile.quest.questlog_movable)

    if IsAddOnLoaded("Carbonite") then
		self:OnEnableCarbonite()
        return
    end

    if self:IsOldQuestGuru() then
        self:OnEnableQuestGuru()
    else
         hooksecurefunc("QuestLogPopupDetailFrame_Show", function(questLogIndex)
			NihongoQuestLog:QuestInfo()
         end)
		
    end
	
end

function NihongoQuestLog:OnDisable()
    Nihongo:DebugLog("NihongoQuestLog: OnDisable.");
end

function NihongoQuestLog:OnEnableCarbonite()

    hooksecurefunc("QuestInfo_Display", function(quest_template, ...)
        if quest_template == QUEST_TEMPLATE_LOG then
            NihongoQuestLog:QuestInfo()
        end
    end)
end

function NihongoQuestLog:CarboniteCheck()

	if isCarbonInitialized == true then
		return
	end
	
	if NXQuestLogDetailScrollChildFrame ~= nil then 
		self.Frame:SetParent(NxQuestD)
		self.Frame:SetPoint("TOPLEFT", NXQuestLogDetailScrollChildFrame, NXQuestLogDetailScrollChildFrame:GetWidth() + 75, 42)
		self:ResizeFrame(512)
		isCarbonInitialized = true
	end
end

function NihongoQuestLog:QuestInfo()

	self:CarboniteCheck()
	
    if not NihongoQuestLogShowJapanese:GetChecked() then
        self.Frame:Hide()
        return
    end

    local index = GetQuestLogSelection()

	local title, level, suggestedGroup, isHeader, isCollapsed, isComplete, frequency, questID, startEvent, displayQuestID, isOnMap, hasLocalPOI, isTask, isStory = GetQuestLogTitle(index)

	Nihongo:DebugLog("NihongoQuestLog:QuestInfo: " .. questID)
  
    if isHeader then
        return
    end

    self:ShowDefault(questID)

    if QuestNPCModel:IsShown() then
        local point, relativeTo, relativePoint, xOffset, yOffset = QuestNPCModel:GetPoint(1) 
        QuestNPCModel:SetPoint(point, self.Frame, relativePoint, 0, yOffset)
    end
end

function NihongoQuestLog:OnClickShowJapanese()
    self:SetChecked(NihongoQuestLogShowJapanese:GetChecked())
    if NihongoQuestLogShowJapanese:GetChecked() then
        self:QuestInfo()
    else
        self.Frame:Hide()
    end
end

function NihongoQuestLog:IsOldQuestGuru()
    if IsAddOnLoaded("QuestGuru") then
        local version = GetAddOnMetadata("QuestGuru", "Version")

        if string.match(version, "^[01]") then
            return true
        end
    end

    return false
end

function NihongoQuestLog:OnEnableQuestGuru()
    self.Frame:SetParent(QuestGuru_QuestLogDetailScrollFrame)
    self.Frame:SetPoint("TOPLEFT", QuestGuru_QuestLogDetailScrollFrame, 330, 53);

    NihongoQuestLogShowJapanese:SetParent(QuestGuru_QuestFrameOptionsButton)
    NihongoQuestLogShowJapanese:SetPoint("BOTTOMRIGHT", QuestGuru_QuestFrameOptionsButton, "BOTTOMRIGHT", -120 - NihongoQuestLogShowJapaneseText:GetWidth(), -2)

    self:ResizeFrame(QuestGuru_QuestLogFrame:GetHeight())

    for i=1, QUESTGURU_QUESTS_DISPLAYED do
        button = _G["QuestGuru_QuestLogTitle" .. i]
        button:HookScript("OnClick", function()
            NihongoQuestLog:QuestInfo()
        end)
    end
end

function NihongoQuestLog:ResizeFrame(height)
    if height > 512 then
        height = 512
    end

    self.Frame:SetHeight(height)
    self.ScrollFrame:SetHeight(height - 104)

    height = height - 256
    local bl = _G[self.Frame:GetName() .. "BottomLeft"]
    bl:SetHeight(height)
    bl:SetTexCoord(0, 1, ((256 - height) / 256), 1)

    local br = _G[self.Frame:GetName() .. "BottomRight"]
    br:SetHeight(height)
    br:SetTexCoord(0, 1, ((256 - height) / 256), 1)
end

function NihongoQuestLog:SetChecked(check)
    NihongoQuestLogShowJapanese:SetChecked(check)
end

function NihongoQuestLog:SetMovable(movable)
    self.Frame:SetMovable(movable)
    if movable then
        self.Frame:RegisterForDrag("LeftButton")
    end
end

function NihongoQuestLog:OnDragStart()
    if self.Frame:IsMovable() then
        self.Frame:StartMoving()
    end
end

function NihongoQuestLog:OnDragStop()
    if self.Frame:IsMovable() then
        self.Frame:StopMovingOrSizing()
        ValidateFramePosition(self.Frame)
    end
end
