NihongoQuestGossip = NihongoQuest:New("NihongoQuestGossip")

NihongoQuestGossip.QUEST_DATA_INFO_TEMPLATE = "QuestData: |cffffffff%s|r"

function NihongoQuestGossip:OnInitialize()
    local obj = _G[self.base .. "TitleText"]
    obj:SetText("Nihongo ("  .. Nihongo.version .. ")")
    obj = _G[self.base .. "DataFrameText"]
    obj:SetFormattedText(self.QUEST_DATA_INFO_TEMPLATE, "unknown")

    self:Initialize()
    self.ScrollFrame = _G[self.Frame:GetName() .. "ScrollFrame"]

    self.QuestID =  _G[self.Frame:GetName() .. "QuestIdText"]
    self.QuestID:SetPoint("TOPLEFT", 0, -3)

    QuestFrameGreetingPanel:HookScript("OnShow", function()
        NihongoQuestGossip.Frame:Hide()
    end)
    QuestFrameDetailPanel:HookScript("OnShow", function()
        NihongoQuestGossip:QuestInfo(QUEST_DETAIL)
    end)
    QuestFrameProgressPanel:HookScript("OnShow", function()
        NihongoQuestGossip.Frame:Hide()
    end)
    QuestFrameRewardPanel:HookScript("OnShow", function()
        NihongoQuestGossip:QuestInfo(QUEST_COMPLETE)
    end)
end

function NihongoQuestGossip:OnEnable()
    Nihongo:DebugLog("NihongoQuestGossip: OnEnable.");

    local obj = _G[self.base .. "DataFrameText"]
    obj:SetFormattedText(self.QUEST_DATA_INFO_TEMPLATE, Nihongo.version)
end

function NihongoQuestGossip:OnDisable()
    Nihongo:DebugLog("NihongoQuestGossip: OnDisable.");
end

function NihongoQuestGossip:QuestInfo(event)
    if not Nihongo.db.profile.quest.gossip then
        self.Frame:Hide()
        return
    end

    Nihongo:DebugLog("NihongoQuestGossip:QuestInfo")

    self:Clear()

    local index = self:GetID(event)

    if index.error or index.questID == 0 then
        self.Frame:Hide()
        return
    end

    if event == QUEST_DETAIL then
        self:ShowDetail(index.questID)
    elseif event == QUEST_COMPLETE then
        self:ShowComplete(index.questID)
    end

    if self.Nihongo_Quest_Version == "unknown" and IsAddOnLoaded("Nihongo_Quest") then
        self.Nihongo_Quest_Version = Nihongo.property.quest.version
        local obj = _G[self.base .. "DataFrameText"]
        obj:SetFormattedText(self.QUEST_DATA_INFO_TEMPLATE, self.Nihongo_Quest_Version)
    end

    if QuestNPCModel:IsShown() then
        local point, relativeTo, relativePoint, xOffset, yOffset = QuestNPCModel:GetPoint(1) 
        QuestNPCModel:SetPoint(point, self.Frame, relativePoint, 0, yOffset)
    end
end

function NihongoQuestGossip:ShowDetail(questID)
    self:Show(questID, {
        { type = 1, empty = false, target = "title",       text = "" },
        { type = 2, empty = true,  target = "description", text = "" },
        { type = 1, empty = false, target = "",            text = Nihongo.L["Objectives"] },
        { type = 2, empty = true,  target = "objective",   text = "" },
        { type = 1, empty = false, target = "",            text = Nihongo.L["Translation"] },
        { type = 2, empty = true,  target = "translation", text = "" },
    })
end

function NihongoQuestGossip:ShowComplete(questID)
    self:Show(questID, {
        { type = 1, empty = false, target = "title",       text = "" },
        { type = 2, empty = false, target = "completion",  text = "" },
        { type = 1, empty = false, target = "",            text = Nihongo.L["Translation"] },
        { type = 2, empty = true,  target = "translation", text = "" },
    })
end
