NihongoFurigana = { }

local AceGUI = LibStub("AceGUI-3.0")
local frame = nil
local furiganaWords = { }
local selectedQuest = { }

function NihongoFurigana:OnInitialize()

    QuestFrameDetailPanel:HookScript("OnShow", function()    
        local index = NihongoQuest:GetID(event)
        selectedQuest.questID = index.questID
        selectedQuest.type = "gossip"
        selectedQuest.event = QUEST_DETAIL
        NihongoFurigana:GetFuriganaWords(index.questID)
    end)

    QuestFrameRewardPanel:HookScript("OnShow", function()
        local index = NihongoQuest:GetID(event)
        selectedQuest.questID = index.questID
        selectedQuest.type = "gossip"
        selectedQuest.event = QUEST_COMPLETE
        NihongoFurigana:GetFuriganaWords(index.questID)
    end)

    hooksecurefunc("QuestMapFrame_ShowQuestDetails", function(questID)
        selectedQuest.questID = questID
        selectedQuest.type = "map"
        selectedQuest.event = nil
        NihongoFurigana:GetFuriganaWords(questID)
    end)
end

function NihongoFurigana:CreateWindow()
    frame = AceGUI:Create("Frame")
    frame:SetTitle("Ignore Furigana")
    frame:SetStatusText("Select the words you that you wish to exclude the furigana for")
    frame:SetLayout("List")
    frame:SetCallback("OnClose", NihongoFurigana.OnClose)

    frame.scrollcontainer = AceGUI:Create("InlineGroup")
    frame.scrollcontainer:SetFullWidth(true)
    frame.scrollcontainer:SetFullHeight(true)
    frame.scrollcontainer:SetLayout("Fill")
    frame:AddChild(frame.scrollcontainer)

    frame.scrollcontainer.scroll = AceGUI:Create("ScrollFrame")
    frame.scrollcontainer.scroll:SetLayout("Flow")
    frame.scrollcontainer:AddChild(frame.scrollcontainer.scroll)
    frame.scrollcontainer.scroll.checkboxes = {}

    frame.simplecontainer = AceGUI:Create("SimpleGroup")
    frame.simplecontainer:SetFullWidth(true)
    frame.simplecontainer:SetLayout("Flow")


    frame.simplecontainer.bAccept = AceGUI:Create("Button")
    frame.simplecontainer.bAccept:SetText("Accept")
    frame.simplecontainer.bAccept:SetCallback("OnClick", NihongoFurigana.Accept)
    frame.simplecontainer:AddChild(frame.simplecontainer.bAccept)
    frame:AddChild(frame.simplecontainer)
end

function NihongoFurigana:Show()
    -- CreateWindow
    self:CreateWindow()
    -- Create checkboxes
    self:CreateCheckboxes(furiganaWords)
    frame:Show()
end

function NihongoFurigana:GetFuriganaWords(questID)

    local quest = Nihongo_Quest:Get(questID)

    -- Search for all of the words that has furigana
    if quest ~= nil then

        local objectiveText = self:ExtractWords(quest.objective)
        local descriptionText = self:ExtractWords(quest.description)
        local completionText = self:ExtractWords(quest.completion)
        
        furiganaWords = { }

        -- Add them all to a list
        if selectedQuest.event == QUEST_DETAIL then
            if objectiveText ~= nil then
                for k, v in pairs(objectiveText) do
                    furiganaWords[#furiganaWords + 1] = v
                end
            end

            if descriptionText ~= nil then
                for k, v in pairs(descriptionText) do
                    furiganaWords[#furiganaWords + 1] = v
                end
            end
        elseif selectedQuest.event == QUEST_COMPLETE then
            if completionText ~= nil then
                for k, v in pairs(completionText) do
                    furiganaWords[#furiganaWords + 1] = v
                end
            end
        end

        self:PruneAlreadyIgnoredWords()
    end
end


-- Search the furiganaWords list for already ignored words and remove them
function NihongoFurigana:PruneAlreadyIgnoredWords()
    for i = #furiganaWords, 1, -1 do
        for j,v in pairs(Nihongo.db.profile.ignoredWords) do
            if v == furiganaWords[i] then
                table.remove(furiganaWords, i)
                break
            end
        end
    end
end

-- Create the checkboxes in the ignore furigana window
function NihongoFurigana:CreateCheckboxes(furiganaWords)
    for k, v in pairs(furiganaWords) do
        local cb = AceGUI:Create("CheckBox")
        cb:SetLabel(v)
        
        frame.scrollcontainer.scroll:AddChild(cb)
        frame.scrollcontainer.scroll.checkboxes[k] = cb
    end
end

-- For each selected checkbox, ignore the word associated with that checkbox.
function NihongoFurigana:Accept()
    for k, v in pairs(frame.scrollcontainer.scroll.checkboxes) do
        if v:GetValue() then
            Nihongo:IgnoreWord(furiganaWords[k])
        end
    end
    frame:Hide()
end

function NihongoFurigana:OnClose(widget)
     AceGUI:Release(frame)
     -- Remove any words that may have been ignored from the list we gathered
     -- so they're gone if the user opens the window again
    NihongoFurigana:PruneAlreadyIgnoredWords()
     -- Update the text being shown
    if selectedQuest.type == "gossip" then
        if selectedQuest.event == QUEST_DETAIL then
            NihongoQuestGossip:ShowDetail(selectedQuest.questID)
        elseif selectedQuest.event == QUEST_COMPLETE then
            NihongoQuestGossip:ShowComplete(selectedQuest.questID)
        end
    elseif selectedQuest.type == "map" then
        NihongoWorldMapQuest:QuestInfo(selectedQuest.questID)
    end
end

-- break when these are found
local specialCharacter = { 
    ["。"] = true,
    ["、"] = true,
    ["」"] = true,
    ["…"] = true,
}

-- ignore these
local specialCharacter2 = {
    ["ヶ"] = true,
}

function NihongoFurigana:ExtractWords(text)

    if text == nil then
        return nil
    end

    local foundKanji = false
    local currentIndex = 0
    local result = {}
    local numWords = 0

    while currentIndex ~= nil do
        foundKanji = false
        currentIndex = currentIndex + 1
        numWords = numWords + 1
    
        local firstParenthesis = string.find(text, '%(', currentIndex)
        local lastParenthesis = string.find(text, ')', currentIndex)
        
        if firstParenthesis == nil then
            break
        end

        local substr = string.sub(text, currentIndex, firstParenthesis-1)
        substr = NihongoFurigana:ReverseUTF8(substr)
        
        local substrIndex = 0
        local word = ""
        for code in substr:gmatch("[%z\1-\127\194-\244][\128-\191]*") do
            substrIndex = substrIndex + code:len()
            if specialCharacter2[code] or foundKanji and tonumber(code) ~= nil then
                word = code .. word 
             else
                if foundKanji and code:len() == 3 and self:IsKana(code) == true then
                    break
                elseif foundKanji and specialCharacter[code] then
                    break
                elseif foundKanji and code:len() == 1 then
                    break
                elseif code:len() == 3 and self:IsKana(code) == false then
                    foundKanji = true
                end
                word = code .. word 
            end
        end
        
        word = word .. string.sub(text, firstParenthesis, lastParenthesis)
        currentIndex = lastParenthesis
        result[numWords] = word
    end
    return result
end

function NihongoFurigana:IsKana(char)

                -- numeric values for: ぁ　                                   ゖ
    if self:GetNumericValue(char) >= 12353 and self:GetNumericValue(char) <= 12438 then
        return true -- numeric values for:  ァ                                    ヺ
    elseif self:GetNumericValue(char) >= 12449 and self:GetNumericValue(char) <= 12538 then
        return true
    end
    return false
end

-- Returns the numeric value of 3 byte UTF character
function NihongoFurigana:GetNumericValue(char)
    local b1 = string.byte(char, 1)
    local b2 = string.byte(char, 2)
    local b3 = string.byte(char, 3)

    local num1 = bit.band(b1, 0x0F)
    local num2 = bit.band(b2, 0x3F)
    local num3 = bit.band(b3, 0x3F)

    local result = 0x0F
    result = bit.band(result, num1)
    result = bit.lshift(result, 6)
    result = bit.bor(result, num2)
    result = bit.lshift(result, 6)
    result = bit.bor(result, num3)
    return result
end

function NihongoFurigana:ReverseUTF8(text)
    local result = ""
    for code in text:gmatch("[%z\1-\127\194-\244][\128-\191]*") do
        result = code .. result
    end
    return result
end

function NihongoFurigana:PruneIgnoredFurigana(quest)
	-- Search for kanji stored in Nihongo.db.profile.quest.enableIgnoreList, and remove the furigana. --
    if Nihongo.db.profile.quest.furigana and Nihongo.db.profile.quest.enableIgnoreList then
        local currentIndex
        local firstParenthesis
        local lastParenthesis
		for i, v in pairs(quest) do
			currentIndex = 0
			for index, kanji in pairs(Nihongo.db.profile.ignoredWords) do
				currentIndex = string.find(v, kanji, 1, true)
				while currentIndex ~= nil do
					firstParenthesis = string.find(v, '%(', currentIndex)					
					lastParenthesis = string.find(v, ')', firstParenthesis)
					v = string.sub(v, 1, firstParenthesis-1) .. string.sub(v, lastParenthesis+1)
					currentIndex = string.find(v, kanji, 1, true)
				end
			end
			quest[i] = v;
		end
	end
end