NihongoDungeonJournalToolTip = NihongoToolTip:New("NihongoDungeonJournalToolTip")
NihongoDungeonJournalToolTip.Tooltip = NihongoAssistTooltip

function NihongoDungeonJournalToolTip:OnEnable()
	hooksecurefunc("EncounterJournal_LoadUI", function()	
	
		hooksecurefunc("EncounterJournal_DisplayEncounter", function(encounterID, noButton)
			self:OnShow(encounterID, noButton);
		end)					
 
		EncounterJournal.encounter:HookScript("OnHide", function()
		    -- Nihongo:DebugLog("NihongoDungeonJournalToolTip: OnHide");
			self:OnHide();
		end)

	end)
	

end

function NihongoDungeonJournalToolTip:OnShow(encounterID, _button)
    
	local w = GameTooltip:GetWidth()
	
	self.Tooltip:SetOwner(EncounterJournal.encounter.info.overviewTab, "ANCHOR_TOPRIGHT", 530 , -200)
    
	w = w - 20
    self.Tooltip:ClearLines()
    self.Tooltip:SetMinimumWidth(w)
	
	local txt = Nihongo_DungeonJournal:Get(encounterID) 
	
	if txt == nil then	
		-- return 
		txt = "翻訳データがありません"
		self:AddText("(" .. encounterID .. ")" .. "\n\n" .. txt)	
	else
		self:AddText(txt)
	end
	
	self.Tooltip:SetWidth(600)


    self.Tooltip:Show()

end

function NihongoDungeonJournalToolTip:OnHide()
    if self.Tooltip:IsShown() then
        self.Tooltip:Hide()
        self.Tooltip:SetWidth(0)
        -- self.Tooltip:SetOwner(UIParent, "ANCHOR_NONE")
    end
end

function NihongoDungeonJournalToolTip:DebugPrint(txt)
    if NihongoDebugFrame:IsShown() then
        local editbox = NihongoDebugFrameScrollFrameText

        editbox:SetText(editbox:GetText() .. "\n" .. txt)
    end
end	




