﻿Nihongo = LibStub("AceAddon-3.0"):NewAddon("Nihongo", "AceConsole-3.0")

Nihongo.FONT = "Interface\\AddOns\\Nihongo\\font\\ipagui.ttf";
Nihongo.DEBUG = false -- false when release
Nihongo.property = {}
Nihongo.ignoreListSelectedWords = {}
Nihongo.ignoreListSelectedWordsBool = {}
Nihongo.currentProfile = 0

function Nihongo:OnInitialize()
    self.version = GetAddOnMetadata("Nihongo", "Version")
	print(string.format("Welcome to Nihongo Ver: %s.", self.version))
	print("Type /cj, /wowjapanizer or /nihongo to open config window")
	
    self.db = LibStub('AceDB-3.0'):New("NihongoDB", {}, true)
	self.db:RegisterDefaults({
        profile = {
            quest       = { questlog = true, worldmap = true, gossip = true, questlog_movable = false, furigana = false, enableIgnoreList = false},
            item        = { tooltip = true },
            spell       = { tooltip = true, buff = true },
            achievement = { tooltip = true, advice = true },
            developer   = self.DEBUG, -- false when release
            development = { debugger = self.DEBUG }, -- false when release
			config      = {fontsize = 0, tooltip = true},
			ignoredWords = { },
		}
	})
	
    -- Quest --
    NihongoQuestLog:OnInitialize()
    NihongoWorldMapQuest:OnInitialize()
    NihongoQuestGossip:OnInitialize()

    -- ToolTip --
    NihongoGameToolTip:OnInitialize()
    NihongoItemRefTooltip:OnInitialize()

    NihongoBuffToolTip:OnInitialize()
    NihongoGlyphToolTip:OnInitialize()
	NihongoGarrisonToolTip:OnInitialize()
	
	NihongoFurigana:OnInitialize()

end

function Nihongo:OnEnable()
    self:DebugLog("Nihongo: OnEnable.");

    -- Option --
    self:SetupOptions()

    -- Quest --
    NihongoQuestLog:OnEnable()
    NihongoWorldMapQuest:OnEnable()
    NihongoQuestGossip:OnEnable()

    -- ToolTip --
    NihongoGameToolTip:OnEnable()
    NihongoItemRefTooltip:OnEnable()

	-- Buff	
    NihongoBuffToolTip:OnEnable()
	-- Glyph
    NihongoGlyphToolTip:OnEnable()
	
	NihongoGarrisonToolTip:OnEnable()

end

function Nihongo:OnDisable()
    self:DebugLog("Nihongo: OnDisable.");

    -- Quest --
    NihongoQuestLog:OnDisable()
    NihongoWorldMapQuest:OnDisable()
    NihongoQuestGossip:OnDisable()

    -- ToolTip --
    NihongoGameToolTip:OnDisable()
    NihongoItemRefTooltip:OnDisable()

	-- Buff	
    NihongoBuffToolTip:OnDisable()

	-- Glyph
    NihongoGlyphToolTip:OnDisable()
	
	NihongoGarrisonToolTip:OnDisable()

end

function Nihongo:LoadAddOn(addon)
    return true
end

function Nihongo:FontSize()
	return self.db.profile.config.fontsize
end

function Nihongo:isShowQuest()
	return self.db.profile.quest.questlog
end

function Nihongo:isShowTooltip()
	return self.db.profile.config.tooltip
end

function Nihongo:uc(str)
    return string.gsub(str, "(%w)", function(s)
        return string.upper(s)
    end, 1)
end

function Nihongo:lc(str)
    return string.gsub(str, "(%w)", function(s)
        return string.lower(s)
    end, 1)
end

function Nihongo:SetupOptions()
	function GetOptions()
		return {
			type = "group",
			name = "Nihongo",
			order = 1,
			childGroups = "tab",
			args = {
				Header1 = {
					type = "header",
					name = "Plugin Options - Please /reload to apply change.",
					order = 1,
				},
				TabProfiles = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db),
				TabOptions = {
					type = "group",
					name = "Options",
					order = 101,
					args = {
						ShowQuestLog = {
							type = "toggle",
							name = "Show Quest Log",
							order = 10,
							set = function(info, value)
								self.db.profile.quest.questlog = value;
							end,
							get = function(info)
								return self.db.profile.quest.questlog;
							end,
						},
						Spacer2 = {
							type = "description",
							name = "Show Japanese Quest Log",
							fontSize = "medium",
							order = 15,
						},
						ShowToolTip = {
							type = "toggle",
							name = "Show Tooltip",
							order = 20,
							set =function(info, value)
								self.db.profile.config.tooltip = value
								self.db.profile.item.tooltip = value
								self.db.profile.spell.tooltip = value
								self.db.profile.achievement.tooltip = value
							end,
							get = function(info)
								return self.db.profile.config.tooltip;
							end,					
						},
						Spacer3 = {
							type = "description",
							name = "Show Japanese Tool Tip for Item/Spell/Achievement",
							fontSize = "medium",
							order = 25,
						},
						FuriganaMode = {
							type = "toggle",
							name = "Furigana Mode",
							order = 30,
							set = function(info, value)
								self.db.profile.quest.furigana = value;
							end,
							get = function(info)
								return self.db.profile.quest.furigana;
							end,					
						},
						Spacer4 = {
							type = "description",
							name = "Furigana will be added on Quest detail screen.",
							fontSize = "medium",
							order = 35,
						},
						IgnoreList = {
							type = "toggle",
							name = "Enable ignore list",
							order = 40,
							set = function(info, value)
								self.db.profile.quest.enableIgnoreList = value
							end,
							get = function(info)
								return self.db.profile.quest.enableIgnoreList
							end,
						},
						Spacer5 = {
							type = "description",
							name = "Alows you to ignore furigana for specific words, by typing /cjignore kanji(furigana)\nExample: /cjignore 人(ひと)",
							fontSize = "medium",
							order = 45,
						},
						FontSizeSlider = {
							type = "range",
							name = "Font Size",
							min = 0,
							max = 10,
							step = 1,
							order = 50,
							set = function(info, value)
								self.db.profile.config.fontsize = value
							end,
							get = function(info)
								return self.db.profile.config.fontsize
							end,					
						},
						Spacer_FontSize = {
							type = "description",
							name = "Make Font Size Bigger in Quest Log and Tool Tip. (0=Default Size)\nPlease /reload to apply change.",
							fontSize = "medium",
							order = 55,
						},
					}
				},
				TabIgnorelist = {
					type = "group",
					name = "Ignore list",
					order = 102,
					args = {
						IgnoreListSearchInput = {
							type = "input",
							name = "Search for a word to ignore.",
							desc = "Search for a word to unignore, or leave empty and search to show all.",
							order = 10,
							set = function(info, value)
								-- clear the tables before populating them
								for k,v in pairs(self.ignoreListSelectedWords) do self.ignoreListSelectedWords[k]=nil end
								for k,v in pairs(self.ignoreListSelectedWordsBool) do self.ignoreListSelectedWordsBool[k]=nil end
								
								-- populate tables
								for k, v in pairs(self.db.profile.ignoredWords) do
									if string.find(v, value) then
										table.insert(self.ignoreListSelectedWords, v)
										table.insert(self.ignoreListSelectedWordsBool, false)
									end
								end
							end,
						},
						IgnoreListSearchResultView = {
							type = "multiselect",
							name = "Ignore list",
							order = 15,
							values = self.ignoreListSelectedWords,
							get = function(info, value)
								return self.ignoreListSelectedWordsBool[value]
							end,
							set = function(info, value)
								self.ignoreListSelectedWordsBool[value] = not self.ignoreListSelectedWordsBool[value]
							end,
						},
						IgnoreListRemoveSelectedWords = {
							type = "execute",
							name = "Unignore",
							func = function() 
								for k, v in pairs(self.ignoreListSelectedWords) do
									if self.ignoreListSelectedWordsBool[k] == true then
										self:UnignoreWord(self.ignoreListSelectedWords[k])
										self.ignoreListSelectedWords[k]=nil 
										self.ignoreListSelectedWordsBool[v]=nil 
									end
								end
							end,
						}
					}
				}      
			},
		}
	end

    LibStub("AceConfig-3.0"):RegisterOptionsTable("Nihongo", GetOptions())	
	LibStub("AceConfigDialog-3.0"):AddToBlizOptions("Nihongo");

    self:RegisterChatCommand("cj", "ChatCommand")
    self:RegisterChatCommand("wowjapanizer", "ChatCommand")
    self:RegisterChatCommand("nihongo", "ChatCommand")
	self:RegisterChatCommand("cjignore", "IgnoreWord")
end

-- Chat commands

function Nihongo:ChatCommand(input)
    if input == 'debug' then
        -- Debug Window --
        if self.db.profile.development.debugger then
            NihongoDebugFrame:Show()
        end
    else
        self:OpenConfigDialog()
    end
end

function Nihongo:IgnoreWord(input)
	if ( string.find(input, '%(') and string.find(input, ')')) == nil then
		print("Your input was incorrectly formatted, perhaps you forgot to include furigana? example: /cjignore 人(ひと), you typed: ", input)
		return
	end
	
	if input then
		for i,v in pairs(self.db.profile.ignoredWords) do
			if v == input then
				print(input .. " is already ignored")
				return
			end
		end
		table.insert(self.db.profile.ignoredWords, input)
	end
end

function Nihongo:UnignoreWord(input)
	for i,v in pairs(self.db.profile.ignoredWords) do
		if v == input then
			table.remove(self.db.profile.ignoredWords, i)
			return
		end
	end

	print("Unable to remove the word you entered, did you forget to include furigana? example: /cjunignore 人(ひと) you typed:　", input)
end

-- End of Chat Commands

function Nihongo:OpenConfigDialog()
    LibStub("AceConfigDialog-3.0"):Open("Nihongo")
end

function Nihongo:DebugLog(args)
    if not self.DEBUG then
        return
    end

    if type(args) == 'string' then
        self:Print(args)
        return
    end

    if type(args) == 'number' then
        self:Print(tostring(args))
        return
    end

    if type(args) == 'table' then
        self:Print("----------")
        for n, v in pairs(args) do
            self:Print(n .. ' : ' .. v)
        end
        self:Print("----------")
        return
    end
end