------------------------------------------------------------------------------------
-- NiceIcons by Demorto#2660 Version 7.3.5.1 (23:15 12.07.2018)
------------------------------------------------------------------------------------

NiceIcons = LibStub("AceAddon-3.0"):NewAddon("NiceIcons", "AceHook-3.0")

function NiceIcons:OnEnable()
    self:SecureHook("ActionButton_Update")
    self:SecureHook("StanceBar_Update")
    self:SecureHook("PetActionBar_Update")
    self:SecureHook("AuraButton_Update")
    self:SecureHook("ActionButton_UpdateRangeIndicator")

    DEFAULT_CHAT_FRAME:AddMessage(GetAddOnMetadata(self:GetName(), "Title").." loaded!")
end

-- Красивые иконки экшен бара
function NiceIcons:ActionButton_Update(self)
    if self:GetName():match("ExtraActionButton") then return end

    local Button = self
    local Icon = self.icon
    local NormalTexture = self.NormalTexture
    local Border = self.Border
    local Name = self.Name

    if Name:GetText() then
        Name:Hide()
        if Border then
            -- Подсветка для макросов
            Border:SetVertexColor(0, 0, 1, 0.35);
            Border:Show();
        end
    end

    Button:SetNormalTexture("Interface\\BUTTONS\\UI-Quickslot2")
    Icon:SetTexCoord(.05, .95, .05, .95)
    Icon:SetPoint("TOPLEFT", Button, 0, 0)
    Icon:SetPoint("BOTTOMRIGHT", Button, -1, 1)
    Border:ClearAllPoints()
    Border:SetPoint("TOPLEFT", Button, -14, 15)
    Border:SetPoint("BOTTOMRIGHT", Button, 14, -13)
    NormalTexture:ClearAllPoints()
    NormalTexture:SetPoint("TOPLEFT", Button, -14, 14)
    NormalTexture:SetPoint("BOTTOMRIGHT", Button, 14, -14)
    NormalTexture:SetVertexColor(1, 1, 1, 1)
end

-- Красивые цифры клавиш, цвета иконок в зависимости от растояния и наличия манны
function NiceIcons:ActionButton_UpdateRangeIndicator(self, checksRange, inRange)
    local HotKey = self.HotKey
    local Icon = self.icon
    local NormalTexture = self.NormalTexture
    local DefaultFont, DefaultSize, _  = HotKey:GetFont()

    HotKey:SetFont(DefaultFont, DefaultSize, "THICKOUTLINE")
    HotKey:SetAlpha(0.7)

    if ( checksRange and not inRange ) then
        Icon:SetVertexColor(1.0, 0.5, 0.5)
        if self.action then NormalTexture:SetVertexColor(1.0, 0.5, 0.5) end
        HotKey:SetVertexColor(RED_FONT_COLOR:GetRGB())
    else
        if self.action then
            local isUsable, notEnoughMana = IsUsableAction(self.action)

            if ( isUsable ) then
                Icon:SetVertexColor(1.0, 1.0, 1.0)
                NormalTexture:SetVertexColor(1.0, 1.0, 1.0)
            elseif ( notEnoughMana ) then
                -- local powerType, powerToken = UnitPowerType("player")
                -- Icon:SetVertexColor(PowerBarColor[powerType].r, PowerBarColor[powerType].g, PowerBarColor[powerType].b)
                Icon:SetVertexColor(0.5, 0.5, 1.0)
                NormalTexture:SetVertexColor(0.5, 0.5, 1.0)
            else
                Icon:SetVertexColor(0.4, 0.4, 0.4)
                NormalTexture:SetVertexColor(1.0, 1.0, 1.0)
            end
        else
            Icon:SetVertexColor(1.0, 1.0, 1.0)
        end
        HotKey:SetVertexColor(1.0, 1.0, 1.0)
    end
end

-- Красивые иконки стоек
function NiceIcons:StanceBar_Update()
    for i = 1, NUM_STANCE_SLOTS do
        local Button = _G["StanceButton"..i]

        if Button then
            Button:SetNormalTexture("Interface\\BUTTONS\\UI-Quickslot2")

            local Icon = _G["StanceButton"..i.."Icon"]
            local Border = _G["StanceButton"..i.."NormalTexture2"] or _G["StanceButton"..i.."NormalTexture"]

            Icon:SetTexCoord(.05, .95, .05, .95)
            Icon:SetPoint("TOPLEFT", Button, -1, 1)
            Icon:SetPoint("BOTTOMRIGHT", Button, 1, -1)
            Border:ClearAllPoints()
            Border:SetPoint("TOPLEFT", Button, -15, 15)
            Border:SetPoint("BOTTOMRIGHT", Button, 15, -15)
            Border:SetVertexColor(1, 1, 1)
        end
    end
end

-- Красивые иконки петомца
function NiceIcons:PetActionBar_Update()
  for i = 1, NUM_PET_ACTION_SLOTS do
    local Button = _G["PetActionButton"..i]
    if Button then
      Button:SetNormalTexture("Interface\\BUTTONS\\UI-Quickslot2")
      local Icon = _G["PetActionButton"..i.."Icon"]
      local Border = _G["PetActionButton"..i.."NormalTexture2"] or _G["PetActionButton"..i.."NormalTexture"]
      Icon:SetTexCoord(.05, .95, .05, .95)
      Icon:SetPoint("TOPLEFT", Button, -1, 1)
      Icon:SetPoint("BOTTOMRIGHT", Button, 1, -1)
      Border:ClearAllPoints()
      Border:SetPoint("TOPLEFT", Button, -15, 15)
      Border:SetPoint("BOTTOMRIGHT", Button, 15, -15)
      Border:SetVertexColor(1, 1, 1)
    end
  end
end

-- Красивые иконки бафов
function NiceIcons:AuraButton_Update(buttonName, index, filter)
  local Button = _G[buttonName..index]
  local Icon = _G[buttonName..index.."Icon"]
  local Border = _G[buttonName..index.."Border"]
  local NewBorder = _G[buttonName..index.."Overlay"]
  
  if Icon then 
    Icon:SetTexCoord(.07, .93, .07, .93)
  end
  
  if Border then
    Border:SetTexture("Interface\\BUTTONS\\UI-Quickslot2")
    Border:ClearAllPoints()
    Border:SetPoint("TOPLEFT", Button, -12, 12)
    Border:SetPoint("BOTTOMRIGHT", Button, 12, -12)
    Border:SetTexCoord(0, 1, 0, 1)
    Border:SetVertexColor(1, 0, 0, 1)
  end
  
  if Button and not Border then
    if not NewBorder then
      NewBorder = Button:CreateTexture("$parentOverlay", "ARTWORK")
      NewBorder:SetParent(Button)
      NewBorder:SetTexture("Interface\\BUTTONS\\UI-Quickslot2")
      NewBorder:SetPoint("TOPLEFT", Button, -12, 12)
      NewBorder:SetPoint("BOTTOMRIGHT", Button, 12, -12)
    end
    NewBorder:Show()
    NewBorder:SetVertexColor(1, 1, 1, 1)
  end
end