------------------------------------------------------------------------------------
-- NiceColoredNames by Demorto#2660 Version 7.3.5.2 (16:10 16.07.2018)
------------------------------------------------------------------------------------

NiceColoredNames = LibStub("AceAddon-3.0"):NewAddon("NiceColoredNames", "AceHook-3.0")

function NiceColoredNames:OnEnable()
    self:SecureHook("UnitFrame_Update")
    self:SecureHook("CompactUnitFrame_UpdateName")
    self:SecureHook("FriendsList_Update", "FriendsList_Update")
    self:SecureHook("HybridScrollFrame_Update", "FriendsList_Update")
    self:RawHook("GameTooltip_UnitColor", true)

    DEFAULT_CHAT_FRAME:AddMessage(GetAddOnMetadata(self:GetName(), "Title").." loaded!")
end



function NiceColoredNames:GameTooltip_UnitColor(unit)
    local r, g, b

    if ( UnitPlayerControlled(unit) ) then
        local localizedClass, englishClass = UnitClass(unit)
        local classColor = RAID_CLASS_COLORS[englishClass]

        if ( UnitIsPlayer(unit) and classColor ) then
            r, g, b = classColor.r, classColor.g, classColor.b
        else
            r, g, b = 1, 0.8, 0
        end
    else
        local reaction = UnitReaction(unit, "player")

        if ( reaction ) then
            r = FACTION_BAR_COLORS[reaction].r
            g = FACTION_BAR_COLORS[reaction].g
            b = FACTION_BAR_COLORS[reaction].b
        else
            r = 1.0
            g = 1.0
            b = 1.0
        end
    end

    local DefaultFont, DefaultSize, DefaultStyle  = GameTooltipTextLeft1:GetFont()

    GameTooltipTextLeft1:SetFont(DefaultFont, DefaultSize, "OUTLINE")

    return r, g, b
end

function NiceColoredNames:UnitFrame_Update(self, isParty)
    if ( self.name ) then

        -- Всем фреймам делаем тень
        local unit = self.unit
        local DefaultFont, DefaultSize, DefaultStyle  = self.name:GetFont()
        local localizedClass, englishClass = UnitClass(unit)
        local classColor = RAID_CLASS_COLORS[englishClass]

        self.name:SetFont(DefaultFont, DefaultSize, "OUTLINE")

        -- Работаем с отдельными фреймами
        if ( UnitIsPlayer(unit) and classColor ) then
            self.name:SetTextColor(classColor.r, classColor.g, classColor.b)
        else
            self.name:SetTextColor(1, 0.8, 0)
        end

        -- Работаем с задником
        if ( self.nameBackground ) then
            local R, G, B, _ = UnitSelectionColor(unit)
            if ( not UnitPlayerControlled(unit) and UnitIsTapDenied(unit) ) then
                self.nameBackground:SetColorTexture(0.5, 0.5, 0.5, 0.5)
            else
                self.nameBackground:SetColorTexture(R, G, B, 0.25)
            end
        end

    end
end


function NiceColoredNames:CompactUnitFrame_UpdateName(frame)
    if ( strsub(frame.unit, 1, 9) ~= "nameplate" ) then
        if ( ShouldShowName(frame) ) then
            local ClassColorCheck = CompactUnitFrameProfilesGeneralOptionsFrameUseClassColors
            local localizedClass, englishClass = UnitClass(frame.unit)
            local classColor = RAID_CLASS_COLORS[englishClass]
            local DefaultFont, DefaultSize, DefaultStyle  = frame.name:GetFont()
            frame.name:SetFont(DefaultFont, DefaultSize, "OUTLINE")

            -- Много проверок, что бы не менять цвета когда это делает изначальный скрипт.
            if ( not CompactUnitFrame_IsTapDenied(frame) or not frame.optionTable.colorNameBySelection ) then
                if ( (frame.optionTable.allowClassColorsForNPCs or UnitIsPlayer(frame.unit)) and classColor and not frame.optionTable.useClassColors ) then
                    frame.name:SetVertexColor(classColor.r, classColor.g, classColor.b)
                else
                    frame.name:SetVertexColor(1, 1, 1)
                end
            end
        end
    end
end


function NiceColoredNames:FriendsList_Update()
    local function DecimalToHex(r,g,b)
        return string.format("|cff%02x%02x%02x", r*255, g*255, b*255)
    end
    local friendOffset = HybridScrollFrame_GetOffset(FriendsFrameFriendsScrollFrame)

    if ( not friendOffset)  then
        return
    end
    if ( friendOffset < 0 ) then
        friendOffset = 0
    end

    local numBNetTotal, numBNetOnline = BNGetNumFriends()

    if ( numBNetOnline > 0 ) then
        for i = 1, numBNetOnline, 1 do
            local _, realName, _, _, toonName, toonID, client, _, _, _, _, _, _, _, _ = BNGetFriendInfo(i)

            if ( client == BNET_CLIENT_WOW ) then
                local _, _, _, realmName, _, _, _, class, _, zoneName, level, _ = BNGetGameAccountInfo(toonID)

                for k, v in pairs(LOCALIZED_CLASS_NAMES_MALE) do if ( class == v ) then class = k end end
                if ( GetLocale() ~= "enUS" ) then
                    for k, v in pairs(LOCALIZED_CLASS_NAMES_FEMALE) do if class == v then class = k end end
                end
                local classColor = (CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS)[class]

                if ( not classColor ) then
                    return
                end
                local nameString = _G["FriendsFrameFriendsScrollFrameButton"..(i-friendOffset).."Name"]

                if ( nameString ) then
                    nameString:SetText(realName.." ("..DecimalToHex(classColor.r, classColor.g, classColor.b)..toonName.."|r, "..LEVEL_ABBR.." "..level..")")
                end
                if ( CanCooperateWithGameAccount(toonID) ~= true ) then
                    local nameString = _G["FriendsFrameFriendsScrollFrameButton"..(i-friendOffset).."Info"]

                    if ( nameString ) then
                        nameString:SetText(zoneName.." ("..realmName..")")
                    end
                end
            end
        end
    end

    local numberOfFriends, onlineFriends = GetNumFriends()

    if ( onlineFriends > 0 ) then
        for i = 1, onlineFriends, 1 do
            j = i + numBNetOnline
            local name, level, class, area, connected, status, note, RAF = GetFriendInfo(i)

            for k, v in pairs(LOCALIZED_CLASS_NAMES_MALE) do if ( class == v ) then class = k end end
            if ( GetLocale() ~= "enUS" ) then
                for k, v in pairs(LOCALIZED_CLASS_NAMES_FEMALE) do if ( class == v ) then class = k end end
            end
            local classColor = (CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS)[class]

            if ( not classColor ) then
                return
            end
            if ( connected ) then
                local nameString = _G["FriendsFrameFriendsScrollFrameButton"..(j-friendOffset).."Name"]

                if ( nameString and name ) then
                    nameString:SetText(DecimalToHex(classColor.r, classColor.g, classColor.b)..name.."|r, "..LEVEL_ABBR.." "..level)
                end
            end
        end
    end
end