------------------------------------------------------------------------------------
-- NiceButtonGlow by Demorto#2660 Version 7.3.5.2 (00:01 14.07.2018)
------------------------------------------------------------------------------------

NiceButtonGlow = LibStub("AceAddon-3.0"):NewAddon("NiceButtonGlow", "AceHook-3.0")

function NiceButtonGlow:OnEnable()
    self:SecureHook("MultiActionButtonDown")
    self:SecureHook("ActionButtonDown")

    local animationsCount = 5
    self.animations = {}
    local animationNum = 1
    local frame, texture, alpha1, scale1, scale2, rotation2

    for i = 1, animationsCount do
        frame = CreateFrame("Frame")
        texture = frame:CreateTexture()
        texture:SetTexture('Interface\\Cooldown\\star4')
        texture:SetAlpha(0)
        texture:SetAllPoints()
        texture:SetBlendMode("ADD")
        animationGroup = texture:CreateAnimationGroup()
        alpha1 = animationGroup:CreateAnimation("Alpha")
        alpha1:SetToAlpha(1)
        alpha1:SetDuration(0)
        alpha1:SetOrder(1)
        scale1 = animationGroup:CreateAnimation("Scale")
        scale1:SetScale(1.8, 1.8)
        scale1:SetDuration(0)
        scale1:SetOrder(1)
        scale2 = animationGroup:CreateAnimation("Scale")
        scale2:SetScale(0, 0)
        scale2:SetDuration(0.3)
        scale2:SetOrder(2)
        rotation2 = animationGroup:CreateAnimation("Rotation")
        rotation2:SetDegrees(-90)
        rotation2:SetDuration(0.3)
        rotation2:SetOrder(2)
        self.animations[i] = {frame = frame, animationGroup = animationGroup}
    end

    function self.AnimateButton(btn)
        if not btn:IsVisible() then return true end
        local animation = self.animations[animationNum]
        local frame = animation.frame
        local animationGroup = animation.animationGroup
        frame:SetFrameStrata("HIGH")
        frame:SetFrameLevel(btn:GetFrameLevel())
        frame:SetAllPoints(btn)
        animationGroup:Stop()
        animationGroup:Play()
        animationNum = (animationNum % animationsCount) + 1
        return true
    end

    DEFAULT_CHAT_FRAME:AddMessage(GetAddOnMetadata(self:GetName(), "Title").." loaded!")
end


function NiceButtonGlow:MultiActionButtonDown(bar, id)
    self.AnimateButton(_G[bar .. "Button" .. id])
end

function NiceButtonGlow:ActionButtonDown(id)
    local button
    if C_PetBattles.IsInBattle() then
        if PetBattleFrame then
            if id > NUM_BATTLE_PET_HOTKEYS then return end
            button = PetBattleFrame.BottomFrame.abilityButtons[id]
            if id == BATTLE_PET_ABILITY_SWITCH then
                button = PetBattleFrame.BottomFrame.SwitchPetButton;
            elseif id == BATTLE_PET_ABILITY_CATCH then
                button = PetBattleFrame.BottomFrame.CatchButton;
            end
            if not button then return end
        end
        return
    end

    if OverrideActionBar and OverrideActionBar:IsShown() then
        if id > NUM_OVERRIDE_BUTTONS then return end
        button = _G["OverrideActionBarButton"..id]
    else
        button = _G["ActionButton"..id]
    end

    if not button then return end

    self.AnimateButton(button)
end