------------------------------------------------------------------------------------
-- NiceBars by Demorto#2660 Version 7.3.5.1 (00:44 13.07.2018)
------------------------------------------------------------------------------------

-- Надо протестировать на боссах

NiceBars = LibStub("AceAddon-3.0"):NewAddon("NiceBars", "AceHook-3.0")


function NiceBars:OnEnable()
    for i, v in pairs({
        PlayerFrameHealthBar,
        PlayerFrameManaBar,
        TargetFrameHealthBar,
        TargetFrameManaBar,
        FocusFrameHealthBar,
        FocusFrameManaBar,
        PartyMemberFrame1HealthBar,
        PartyMemberFrame2HealthBar,
        PartyMemberFrame3HealthBar,
        PartyMemberFrame4HealthBar,
        PartyMemberFrame1ManaBar,
        PartyMemberFrame2ManaBar,
        PartyMemberFrame3ManaBar,
        PartyMemberFrame4ManaBar,
        Boss1TargetFrameHealhBar,
        Boss1TargetFrameManaBar,
        Boss2TargetFrameHealhBar,
        Boss2TargetFrameManaBar,
        Boss3TargetFrameHealhBar,
        Boss3TargetFrameManaBar,
        Boss4TargetFrameHealhBar,
        Boss4TargetFrameManaBar,
        Boss5TargetFrameHealhBar,
        Boss5TargetFrameManaBar,
        PetFrameHealthBar,
        PetFrameManaBar,
    }) do
        self:SecureHookScript(v, "OnEnter")
        self:SecureHookScript(v, "OnLeave")
        self:SecureHookScript(v, "OnUpdate")
    end

    -- Для фреймов арены
    self:SecureHook("UnitFrameHealthBar_OnUpdate")

    DEFAULT_CHAT_FRAME:AddMessage(GetAddOnMetadata(self:GetName(), "Title").." loaded!")
end


function NiceBars:OnEnter(frame)
    -- Пометка о том, что курсор на баре
    frame.MouseStatus = "OnEnter"
end


function NiceBars:OnLeave(frame)
    -- Пометка о том, что курсор покинул бар
    frame.MouseStatus = "OnLeave"
end


function NiceBars:OnUpdate(frame)

    -- Изменение цвета бара в зависимости от количества ХП
    for i, v in pairs({
        PlayerFrameHealthBar,
        TargetFrameHealthBar,
        PartyMemberFrame1HealthBar,
        PartyMemberFrame2HealthBar,
        PartyMemberFrame3HealthBar,
        PartyMemberFrame4HealthBar,
        Boss1TargetFrameHealhBar,
        Boss2TargetFrameHealhBar,
        Boss3TargetFrameHealhBar,
        Boss4TargetFrameHealhBar,
        Boss5TargetFrameHealhBar,
        ArenaEnemyFrame1HealthBar,
        ArenaEnemyFrame2HealthBar,
        ArenaEnemyFrame3HealthBar,
        ArenaEnemyFrame4HealthBar,
        ArenaEnemyFrame5HealthBar,
        PetFrameHealthBar,
    }) do
        if ( frame == v ) then
            local CurHP = UnitHealth(frame.unit)
            local MaxHP = UnitHealthMax(frame.unit)
            local Pct = math.ceil(100*(CurHP / MaxHP))
            local R, G, B = 0, 1, 0
            if UnitIsConnected(frame.unit) then
                if (Pct >= 75) then
                    R, G, B = 0, 1, 0
                elseif (Pct < 75 and Pct >= 50) then
                    R, G, B = 1, 1, 0
                elseif (Pct < 50 and Pct >= 25) then
                    R, G, B = 1, 0.5, 0
                else
                    R, G, B = 1, 0, 0
                end
            else
                R, G, B = 0.5, 0.5, 0.5
            end
            frame:SetStatusBarColor(R, G, B)
        end
    end

    if frame.MouseStatus == "OnLeave" or not frame.MouseStatus then
        local M = 0
        local R, G, B, _ = frame:GetStatusBarColor()
        local powerType, powerToken = UnitPowerType(frame.unit)
        local DefaultFont, DefaultSize, DefaultStyle = frame.TextString:GetFont()

        if powerType == 0 then
            G = G + 0.8
        end

        frame.TextString:SetTextColor(R + M, G + M, B + M, 0.7)
        frame.TextString:SetFont(DefaultFont, 8, "OUTLINE")

        if ( frame.LeftText and frame.RightText ) then
            frame.LeftText:SetTextColor(R + M, G + M, B + M, 0.7)
            frame.LeftText:SetFont(DefaultFont, 8, "OUTLINE")
            frame.RightText:SetTextColor(R + M, G + M, B + M, 0.7)
            frame.RightText:SetFont(DefaultFont, 8, "OUTLINE")
        end
    elseif frame.MouseStatus == "OnEnter" then
        local DefaultFont, DefaultSize, DefaultStyle = frame.TextString:GetFont()
        frame.TextString:SetTextColor(1, 1, 1, 1)
        frame.TextString:SetFont(DefaultFont, 10, "OUTLINE")

        if ( frame.LeftText and frame.RightText ) then
            frame.LeftText:SetTextColor(1, 1, 1, 1)
            frame.LeftText:SetFont(DefaultFont, 10, "OUTLINE")
            frame.RightText:SetTextColor(1, 1, 1, 1)
            frame.RightText:SetFont(DefaultFont, 10, "OUTLINE")
        end
    end

end

function NiceBars:UnitFrameHealthBar_OnUpdate(frame)

    -- Арена фреймы, манну обрабатываем тут же, костыль, но хз, остальное не срабатывает
    if _G[frame:GetName().."Text"] then
        --print(frame:GetParent():GetName())

            local CurHP = UnitHealth(frame.unit)
            local MaxHP = UnitHealthMax(frame.unit)
            local Pct = math.ceil(100*(CurHP / MaxHP))
            local R, G, B = 0, 1, 0
            if UnitIsConnected(frame.unit) then
                if (Pct >= 75) then
                    R, G, B = 0, 1, 0
                elseif (Pct < 75 and Pct >= 50) then
                    R, G, B = 1, 1, 0
                elseif (Pct < 50 and Pct >= 25) then
                    R, G, B = 1, 0.5, 0
                else
                    R, G, B = 1, 0, 0
                end
            else
                R, G, B = 0.5, 0.5, 0.5
            end
            frame:SetStatusBarColor(R, G, B)

    local M = 0
    local R, G, B, _ = frame:GetStatusBarColor()
    local DefaultFont, DefaultSize, DefaultStyle = _G[frame:GetName().."Text"]:GetFont()

    _G[frame:GetName().."Text"]:SetTextColor(R + M, G + M, B + M, 0.7)
    _G[frame:GetName().."Text"]:SetFont(DefaultFont, 8, "OUTLINE")
    end

    if _G[frame:GetParent():GetName().."ManaBarText"] then
        local M = 0
        local R, G, B, _ = _G[frame:GetParent():GetName().."ManaBar"]:GetStatusBarColor()
        local powerType, powerToken = UnitPowerType(frame.unit)
        local DefaultFont, DefaultSize, DefaultStyle = _G[frame:GetParent():GetName().."ManaBarText"]:GetFont()

        if powerType == 0 then
            G = G + 0.8
        end

        _G[frame:GetParent():GetName().."ManaBarText"]:SetTextColor(R + M, G + M, B + M, 0.7)
        _G[frame:GetParent():GetName().."ManaBarText"]:SetFont(DefaultFont, 8, "OUTLINE")
    end
end