
-- Code made by Oysi

local NAME, ENV = ...

local VER = "0.0.0.1"

-- Frame
local frame = CreateFrame("Frame", "MythicPlusScaling", UIParent)

-- Constants
local PREFIX_PING = "OYSI_MPS=1"

-- Get journal desc
local function getJournalDesc(sectionID, level, affix)
	-- Calculate multiplier
	local mul = 1
	if level >= 2 then
		mul = 1.1^(level - 1)
	end
	if affix == "T" or affix == "t" then
		mul = mul * 1.15
	end
	
	-- Temporarily force journal to mythic dungeon difficulty
	local origDifficulty = EJ_GetDifficulty()
	EJ_SetDifficulty(23)
	
	-- Scan journal
	local name, description, headerType, abilityIcon, displayInfo, siblingID, nextSectionID, fileredByDifficulty, sectionLink, startsOpen, flag1, flag2, flag3, flag4 = EJ_GetSectionInfo(sectionID)
	if not name then
		return
	end
	
	-- Revert journal back to previous difficulty
	EJ_SetDifficulty(origDifficulty)
	
	-- Processing
	local output = description
	output = output:gsub("|[Cc]%w%w%w%w%w%w%w%w", "") -- Remove color
	output = output:gsub("|[Rr]", "") -- Remove color escape
	output = output:gsub("|[Tt].-|[Tt]", "") -- Remove texture
	output = output:gsub("%s+", " ") -- Condense whitespace
	
	-- Scale all numbers with the multiplier and reformat
	output = output:gsub("(%d[%d,%.]*)( ?%w* ?%w* damage)", function(first, second)
		local amount = tonumber(first:gsub(",", ""), nil)
		local second, isMillion = second:gsub("million ", "")
		if amount then
			if isMillion > 0 then
				amount = amount * 1000000
			end
			
			amount = amount * mul
			
			local str
			if amount < 1e6 then
				str = string.format("%.0fk", amount/1e3)
			elseif amount < 1e6*100 then
				str = string.format("%.2fm", amount/1e6)
			elseif amount < 1e9 then
				str = string.format("%.0fm", amount/1e6)
			elseif amount < 1e9*100 then
				str = string.format("%.2fb", amount/1e9)
			elseif amount < 1e12 then
				str = string.format("%.0fb", amount/1e9)
			else
				str = "A LOT of"
			end
			
			return str .. second
		else
			return "!ERROR!"
		end
	end)
	
	-- Special case for Eye of Azshara - Wrath of Azshara - Crushing Depths
	output = output:gsub("(%d+)(%% of their maximum health in ?%w* damage)", function(first, second)
		local amount = tonumber(first)
		if amount then
			amount = amount * mul
			local str = string.format("%.0f", amount)
			return str .. second
		else
			return "!ERROR!"
		end
	end)
	
	-- Return
	return output
end

-- Split message
local function splitMessage255(message)
	local send = {}
	repeat
		local section = message:sub(1, 255)
		local index = section:find("[%a%%]%..-$")
		if section == message or not index then
			send[#send + 1] = section
			message = message:sub(255 + 1)
		else
			send[#send + 1] = section:sub(1, index + 1)
			message = message:sub(index + 1 + 2)
		end
	until #message == 0
	return send
end

-- On msg
local function onMSG(channel, ...)
	local message, sender, language, channelString, target, flags, _, channelNumber, channelName, _, counter, guid = ...
	if not message or guid ~= UnitGUID("player") then
		return
	end
	
	-- Scan message
	local level, affix, _, sectionID, difficultyID, title = message:match("%+(%d+)([Tt]?).-|Hjournal:(%d+):(%d+):(%d+)|h(%[.-%])|h")
	if not level then
		return
	end
	
	-- Prevent loop
	if message:reverse():match(":%w+@$") then
		return
	end
	
	level = tonumber(level)
	sectionID = tonumber(sectionID)
	
	local desc = getJournalDesc(sectionID, level, affix)
	
	-- Remove realm from sender
	local found = sender:find("%-")
	if found then
		sender = sender:sub(1, found - 1)
	end
	
	-- Final output
	local final = "@" .. sender .. ": +" .. level .. affix:upper() .. " " .. title .. " " .. desc
	local send = splitMessage255(final)
	
	-- Broadcast
	for i, msg in ipairs(send) do
		SendChatMessage(msg, channel)
	end
end

-- On update
function frame:onUpdate(delta)
end

-- On event
function frame:onEvent(event, ...)
	if event == "CHAT_MSG_SAY" then
		onMSG("SAY", ...)
	elseif event == "CHAT_MSG_PARTY" or event == "CHAT_MSG_PARTY_LEADER" then
		onMSG("PARTY", ...)
	--elseif event == "CHAT_MSG_GUILD" then
	--	onMSG("GUILD", ...)
	elseif event == "GROUP_ROSTER_UPDATE" then
		--C_Timer.After(1, function() SendAddonMessage(PREFIX_PING, VER .. ";", "PARTY") end)
		--C_Timer.After(10, function() SendAddonMessage(PREFIX_PING, VER .. ";", "PARTY") end)
	end
end

-- Events
frame:RegisterEvent("CHAT_MSG_SAY")
frame:RegisterEvent("CHAT_MSG_PARTY")
frame:RegisterEvent("CHAT_MSG_PARTY_LEADER")
frame:RegisterEvent("CHAT_MSG_GUILD")
frame:RegisterEvent("GROUP_ROSTER_UPDATE")

-- Handlers
frame:SetScript("OnEvent", frame.onEvent)
--frame:SetScript("OnUpdate", frame.onUpdate)
