--------------------------------------------------------------------------
-- SlaveGirl.lua 
--------------------------------------------------------------------------
--[[
Slave Girl
Author: Zensunim of Dragonblight

Change Log:
	v1.0 
		- Initial Release
	v1.1
		- Updated sounds to play on the Master channel instead of the SFX channel
	v1.1.1
		- Updated TOC for 4.1
	v1.1.2
		- Updated TOC for 4.2
	v1.1.3
		- Fixed bug with following a character
	v1.1.4
		- Updated TOC for 4.3
	v1.1.5
		- Updated for 5.0.4
	v1.2
		- Modified HP/Mana alerts to use less CPU
		- Updated for 5.1
	v1.2.1
		- Updated for 5.2
	v1.2.2
		- Updated for 5.3
	v1.2.3
		- Updated for 5.4.7
	v1.2.4
		- Updated for 6.0
	v1.2.5
		- Converted all sounds to .ogg format
	v1.3
		- Fixed issues with same/cross-realm communications
		- Fixed issue with auto-completing quests with a single reward
		- Fixed issue with setting a new master in the options
		- Fixed issue with sharing quests when an auto-opened quest is being displayed on the slave
		- /SG now displays the current master
	v1.3.1
		- Fixed issue with setting a new master on the same realm in a group
	v1.3.2
		- Fixed party spam issue with instances
	v1.3.3
		- Updated for 6.2
	v1.3.4
		- Updated for 7.0
	v1.4
		- Updated for 7.1
		- Fixed issue with sounds overlapping and being extremely loud
	v1.4.1
		- Fixed LUA error issue with picking up unsharable quests
	v2.0
		- Improved following system to not spam noises when following while following
	v2.0.1
		- Updated for 7.2
	v2.1
		- Added the ability to leave group when the master leaves group
		- Added the ability to suppress role selection and custom group role popups
	v2.1.1
		- Fixed a bug with assigning the master user not including the realm name
	v2.2
		- Updated for 7.3
		- Replaced UnitMana(...) with UnitPower(...,0) because UnitMana was removed
	v2.3
		- Updated for 8.0

Configuration Commands:
	/SG options - Display the options menu
	/SG master - Follow orders from this player

]]--

if (SlaveGirl) then
	-- Do nothing
else
	SlaveGirl = { };
end

SlaveGirlOptions = { };

SlaveGirl = {
	DefaultSetting = {
		LowHealthThreshold = 50;
		LowHealthCooldown = 15;
		LowManaThreshold = 40;
		LowManaCooldown = 25;
		Monitor = true;
		Broadcast = nil;
		StartFollowSound = true;
		StopFollowSound = true;
		LowHealthSound = true;
		LowManaSound = true;
		AutoAcceptGroupInvite = true;
		AutoAcceptQuest = true;
		AutoShareQuest = true;
		AutoTurnInQuest = nil;
		AutoLeaveGroup = nil;
		AutoRole = nil;
		Master = nil;
	};

-- **********************************************************************************************
--
-- DON'T EDIT BELOW THIS LINE
--
-- **********************************************************************************************

	Version = "2.3"; -- Version number (text format)
	DataCode = "1"; -- Saved Variable versioning, change this value to force a reset to default
	ModCode = "KSG"; -- Mod communication code
	Setting = { };
	ScheduleQueue = { };

	Data = {
		LastFollowingTarget = nil;
		TimerPowerInfusion = 0;
		TimerLowHealth = GetTime();
		TimerLowMana = GetTime();
		Me = UnitName("player");
		Realm = gsub(GetRealmName(), "%s", "");
		MeFull = UnitName("player").."-"..gsub(GetRealmName(), "%s", "");
		InGroup = (GetNumGroupMembers() > 0);
		SlaveInGroup = nil;
		MasterInGroup = nil;
		Slaves = { };
		LowHealthThreshold = 0;
		LowManaThreshold = 0;
		TimerSound = { };
		DebugMode = nil;
		LastFollowingAction = nil;
		AutoLeaveGroupIgnore = nil;
		BetaMode = nil;
	};
	
	Sounds = {
		["StartFollow"] = "Interface\\AddOns\\SlaveGirl\\Sounds\\follow_on.ogg",
		["StopFollow"] = "Interface\\AddOns\\SlaveGirl\\Sounds\\follow_off.ogg",
		["LowMana"] = "Interface\\AddOns\\SlaveGirl\\Sounds\\low_mana.ogg",
		["LowHealth"] = "Interface\\AddOns\\SlaveGirl\\Sounds\\low_health.ogg",
	};
}

if (select(4, GetBuildInfo()) >= 80000) then
	SlaveGirl.Data.BetaMode = true;
end


function SlaveGirl_ResetDefaults()
	SlaveGirl.Setting.LowHealthThreshold = SlaveGirl.DefaultSetting.LowHealthThreshold;
	SlaveGirl.Setting.LowHealthCooldown = SlaveGirl.DefaultSetting.LowHealthCooldown;
	SlaveGirl.Setting.LowManaThreshold = SlaveGirl.DefaultSetting.LowManaThreshold;
	SlaveGirl.Setting.LowManaCooldown = SlaveGirl.DefaultSetting.LowManaCooldown;
	SlaveGirl.Setting.Monitor = SlaveGirl.DefaultSetting.Monitor;
	SlaveGirl.Setting.Broadcast = SlaveGirl.DefaultSetting.Broadcast;
	SlaveGirl.Setting.StartFollowSound = SlaveGirl.DefaultSetting.StartFollowSound;
	SlaveGirl.Setting.StopFollowSound = SlaveGirl.DefaultSetting.StopFollowSound;
	SlaveGirl.Setting.LowHealthSound = SlaveGirl.DefaultSetting.LowHealthSound;
	SlaveGirl.Setting.LowManaSound = SlaveGirl.DefaultSetting.LowManaSound;
	SlaveGirl.Setting.AutoAcceptGroupInvite = SlaveGirl.DefaultSetting.AutoAcceptGroupInvite;
	SlaveGirl.Setting.AutoAcceptQuest = SlaveGirl.DefaultSetting.AutoAcceptQuest;
	SlaveGirl.Setting.AutoShareQuest = SlaveGirl.DefaultSetting.AutoShareQuest;
	SlaveGirl.Setting.AutoTurnInQuest = SlaveGirl.DefaultSetting.AutoTurnInQuest;
	SlaveGirl.Setting.AutoLeaveGroup = SlaveGirl.DefaultSetting.AutoLeaveGroup;
	SlaveGirl.Setting.AutoRole = SlaveGirl.DefaultSetting.AutoRole;
	SlaveGirl.Setting.Master = SlaveGirl.DefaultSetting.Master;
end

SlaveGirl_ResetDefaults();

function SlaveGirl_OnEvent(self, event, ...)
	if (event == "VARIABLES_LOADED") then
		if (SlaveGirl.Data.BetaMode) then
			C_ChatInfo.RegisterAddonMessagePrefix(SlaveGirl.ModCode);
		else
			RegisterAddonMessagePrefix(SlaveGirl.ModCode);
		end
		SlaveGirl.DebugPrint("Slave Girl "..SlaveGirl.Version.." variables loaded.");
		SlaveGirlTooltip:SetOwner(UIParent, "ANCHOR_NONE");
		SlaveGirlFrame:RegisterEvent("START_AUTOREPEAT_SPELL");
		SlaveGirlFrame:RegisterEvent("STOP_AUTOREPEAT_SPELL");
		SlaveGirlFrame:RegisterEvent("UI_ERROR_MESSAGE");
		SlaveGirlFrame:RegisterEvent("AUTOFOLLOW_BEGIN");
		SlaveGirlFrame:RegisterEvent("AUTOFOLLOW_END");
		SlaveGirlFrame:RegisterEvent("PARTY_INVITE_REQUEST");
		SlaveGirlFrame:RegisterEvent("GROUP_ROSTER_UPDATE");
		SlaveGirlFrame:RegisterEvent("QUEST_DETAIL");
		SlaveGirlFrame:RegisterEvent("QUEST_ACCEPTED");
		SlaveGirlFrame:RegisterEvent("QUEST_PROGRESS");
		SlaveGirlFrame:RegisterEvent("QUEST_COMPLETE");
		SlaveGirlFrame:RegisterEvent("CHAT_MSG_ADDON");
		SlaveGirlFrame:RegisterEvent("PLAYER_TARGET_CHANGED");
		SlaveGirlFrame:RegisterEvent("UNIT_HEALTH");
		if (SlaveGirl.Data.BetaMode) then
			SlaveGirlFrame:RegisterEvent("UNIT_POWER_UPDATE");
		else
			SlaveGirlFrame:RegisterEvent("UNIT_POWER");
		end
		SlaveGirlFrame:RegisterEvent("LFG_ROLE_CHECK_SHOW");
		SlaveGirlFrame:RegisterEvent("LFG_LIST_JOINED_GROUP");		
		SlaveGirlFrame:RegisterEvent("LFG_LIST_ACTIVE_ENTRY_UPDATE");

		if (SlaveGirlOptions.DataCode ~= SlaveGirl.DataCode or not (SlaveGirlOptions.Setting)) then
			SlaveGirlOptions = { };
			SlaveGirlOptions.DataCode = SlaveGirl.DataCode;
			SlaveGirlOptions.Setting = { };
			SlaveGirl_ErrorPrint("New database detected. Clearing settings.");
		elseif (SlaveGirlOptions.Setting[SlaveGirl.Data.Me]) then
			SlaveGirl.DebugPrint("Profile found. Loading settings");
			if (SlaveGirlOptions.Setting[SlaveGirl.Data.Me].LowHealthThreshold) then
				SlaveGirl.Setting.LowHealthThreshold = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].LowHealthThreshold;
			end
			if (SlaveGirlOptions.Setting[SlaveGirl.Data.Me].LowHealthCooldown) then
				SlaveGirl.Setting.LowHealthCooldown = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].LowHealthCooldown;
			end
			if (SlaveGirlOptions.Setting[SlaveGirl.Data.Me].LowManaThreshold) then
				SlaveGirl.Setting.LowManaThreshold = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].LowManaThreshold;
			end
			if (SlaveGirlOptions.Setting[SlaveGirl.Data.Me].LowManaCooldown) then
				SlaveGirl.Setting.LowManaCooldown = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].LowManaCooldown;
			end
			SlaveGirl.Setting.Monitor = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].Monitor;
			SlaveGirl.Setting.Broadcast = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].Broadcast;
			SlaveGirl.Setting.StartFollowSound = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].StartFollowSound;
			SlaveGirl.Setting.StopFollowSound = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].StopFollowSound;
			SlaveGirl.Setting.LowHealthSound = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].LowHealthSound;
			SlaveGirl.Setting.LowManaSound = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].LowManaSound;
			SlaveGirl.Setting.AutoAcceptGroupInvite = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].AutoAcceptGroupInvite;
			SlaveGirl.Setting.AutoAcceptQuest = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].AutoAcceptQuest;
			SlaveGirl.Setting.AutoShareQuest = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].AutoShareQuest;
			SlaveGirl.Setting.AutoTurnInQuest = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].AutoTurnInQuest;
			SlaveGirl.Setting.AutoLeaveGroup = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].AutoLeaveGroup;
			SlaveGirl.Setting.AutoRole = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].AutoRole;
			SlaveGirl.Setting.Master = SlaveGirlOptions.Setting[SlaveGirl.Data.Me].Master;
		else
			SlaveGirl_ErrorPrint("New player detected. Setting defaults.");
		end
		
		SlaveGirl_CheckGroup(true);
		SlaveGirl_RenderOptions();
		SlaveGirl_SaveSettings();
		return;
	end
	if (event == "AUTOFOLLOW_BEGIN") then
		SlaveGirl.DebugPrint("AUTOFOLLOW_BEGIN event");
		local follower = ...;
		SlaveGirl.Schedule("FollowSound", 0, nil, SlaveGirl.StartFollowing, follower, SlaveGirl.IsScheduled("FollowSound"));
		LastFollowingAction = "BEGIN";
		return;
	end
	if (event == "AUTOFOLLOW_END") then
		SlaveGirl.DebugPrint("AUTOFOLLOW_END event");
		local scheduled = SlaveGirl.IsScheduled("FollowSound");
		if (scheduled and LastFollowingAction == "END") then
			SlaveGirl.DebugPrint("Ignore duplicate end follow command");
			return;
		end
		SlaveGirl.Schedule("FollowSound", .2, nil, SlaveGirl.StopFollowing, scheduled);
		LastFollowingAction = "END";
		return;
	end		
	if (event == "PARTY_INVITE_REQUEST") then
		local partyMaster = ...;
		if (SlaveGirl.Setting.AutoAcceptGroupInvite and SlaveGirl_IsMaster(partyMaster)) then
			AcceptGroup();
		end
		return;
	end
	if (event == "GROUP_ROSTER_UPDATE") then
		if (SlaveGirl.Setting.AutoAcceptGroupInvite and SlaveGirl.Setting.Master) then
			StaticPopupDialogs["PARTY_INVITE"].inviteAccepted = 1;
			StaticPopup_Hide("PARTY_INVITE");
			StaticPopup_Hide("PARTY_INVITE_XREALM");
		end
		if not (SlaveGirl.Data.InGroup) then
			SlaveGirl_CheckGroup(true);
		end
		SlaveGirl.Data.InGroup = (GetNumSubgroupMembers() > 0)
		if (SlaveGirl.Data.InGroup) then
			SlaveGirl_CheckGroup(false);
		end
		return;
	end
	if (event == "QUEST_DETAIL") then
		if (SlaveGirl.Setting.AutoAcceptQuest and SlaveGirl.Setting.Master) then
			if (UnitName("player") == UnitName("NPC")) then
				SlaveGirl.DebugPrint("Auto-Accepting quest.");
				SlaveGirl_SendComm("O/Q/"..GetTitleText());
				AcceptQuest();
				HideUIPanel(QuestFrame);
			end
		end
		return;
	end
	if (event == "QUEST_ACCEPTED") then
		local index = ...;
		if (index and SlaveGirl.Setting.AutoShareQuest and (SlaveGirl.Data.SlaveInGroup or SlaveGirl.Data.MasterInGroup)) then
			SlaveGirl_ShareQuest(index);
		end
		if (SlaveGirl.Setting.AutoTurnInQuest) then
			if (QuestGetAutoAccept()) then
				HideUIPanel(QuestFrame);
			end
		end
    return;
	end
	if (event == "QUEST_PROGRESS") then
		if (SlaveGirl.Setting.AutoTurnInQuest) then
			SlaveGirl.DebugPrint("Quest progress");
			if (IsQuestCompletable()) then
				CompleteQuest();
			end
		end
    return;
	end
	if (event == "QUEST_COMPLETE") then
		if (SlaveGirl.Setting.AutoTurnInQuest) then
			SlaveGirl.DebugPrint("Quest choices: "..GetNumQuestChoices());
			if (GetNumQuestChoices() < 2) then
			    if (GetNumQuestChoices() == 1) then
			    	GetQuestReward(1);
			    else
			    	GetQuestReward();
			    end
			    HideUIPanel(QuestFrame);
			end
		end
    return;
	end
	if (event == "CHAT_MSG_ADDON") then
		local prefix, message, messageType, sender = ...;
		if ( sender ~= SlaveGirl.Data.Me ) then
			if (prefix == SlaveGirl.ModCode and message and sender) then
				SlaveGirl_ReceiveComm(message, sender);
			end
		end
		return;
	end
	if (event == "UNIT_HEALTH" or event == "UNIT_POWER" or event == "UNIT_POWER_UPDATE") then
		local unit, _ = ...;
		if (unit and UnitIsUnit(unit, "player")) then
			SlaveGirl_Update();
		end
	end
	if (event == "UI_ERROR_MESSAGE") then
		local message = ...;
		if ( message == ERR_SPELL_COOLDOWN ) then
			SlaveGirl_SendComm("E/C");
			return;
		end
		if ( message == ERR_SPELL_OUT_OF_RANGE ) then
			SlaveGirl_SendComm("E/R");
			return;
		end
		if ( message == SPELL_FAILED_MOVING ) then
			SlaveGirl_SendComm("E/V");
			return;
		end
		if ( message == SPELL_FAILED_LINE_OF_SIGHT ) then
			SlaveGirl_SendComm("E/L");
			return;
		end
		if ( message == SPELL_FAILED_BAD_TARGETS ) then
			SlaveGirl_SendComm("E/B");
			return;
		end
		if ( message == ERR_OUT_OF_MANA ) then
			SlaveGirl_SendComm("E/M");
			return;
		end
		if ( message == SPELL_FAILED_UNIT_NOT_INFRONT ) then
			SlaveGirl_SendComm("E/F");
			return;
		end
		if ( message == SPELL_FAILED_SILENCED ) or ( message == SPELL_FAILED_STUNNED ) then
			SlaveGirl_SendComm("E/S");
			return;
		end
		if ( message == ERR_ATTACK_PACIFIED ) or ( message == ERR_ATTACK_CHARMED ) then
			SlaveGirl_SendComm("E/S");
			return;
		end
		if ( message == ERR_ATTACK_CONFUSED ) or ( message == ERR_ATTACK_FLEEING ) then
			SlaveGirl_SendComm("E/S");
			return;
		end
		if ( message == ERR_ATTACK_PREVENTED_BY_MECHANIC_S ) or ( message == "Can't attack while polymorphed." ) then
			SlaveGirl_SendComm("E/S");
			return;
		end
	end
	if (event == "LFG_ROLE_CHECK_SHOW") then
		local role = select(5, GetSpecializationInfo(GetSpecialization()));
		if (SlaveGirl.Setting.AutoRole) then
			local oldLeader = GetLFGRoles();
			SetLFGRoles(oldLeader, role == "TANK", role == "HEALER", role == "DAMAGER");
			CompleteLFGRoleCheck(true);
		end
		return;
	end
	if (event == "LFG_LIST_JOINED_GROUP") then
		SlaveGirl.DebugPrint("LFG group joined...ignoring auto-leave for 3 seconds");
		SlaveGirl.Data.AutoLeaveGroupIgnore = GetTime() + 3;
		if (SlaveGirl.Setting.AutoRole) then
			StaticPopupSpecial_Hide(LFGListInviteDialog);
		end
		return;
	end
end

function SlaveGirl.ChatPrint(str)
	DEFAULT_CHAT_FRAME:AddMessage("[SG] "..str, 0.25, 1.0, 0.25);
end

function SlaveGirl_ErrorPrint(str)
	DEFAULT_CHAT_FRAME:AddMessage("[SG] "..str, 1.0, 0.5, 0.5);
end

function SlaveGirl.DebugPrint(str)
	if (SlaveGirl.Data.DebugMode) then
		DEFAULT_CHAT_FRAME:AddMessage("[SG] "..str, 0.75, 1.0, 0.25);
	end
end

function SlaveGirl_CommPrint(str)
	DEFAULT_CHAT_FRAME:AddMessage(str, 0.45, 0.78, 0.96);
end

function SlaveGirl_FindPattern(text, pattern)
	if (string.find(text, pattern, 1)) then
		return string.sub(text, string.find(text, pattern, 1));
	else
		return nil;
	end
end

function SlaveGirl_OnLoad()
	SlashCmdList["SG"] = SlaveGirl_Command;
	SLASH_SG1 = "/SG";
	SlashCmdList["SLAVEGIRL"] = SlaveGirl_Command;
	SLASH_SLAVEGIRL1 = "/SLAVEGIRL";
	SlaveGirlFrame:RegisterEvent("CHAT_MSG_ADDON");
	SlaveGirl.ChatPrint("Slave Girl "..SlaveGirl.Version.." loaded.");
	SlaveGirlFrame:RegisterEvent("VARIABLES_LOADED");
end

function SlaveGirl_Command(arg1)
	local Command = string.upper(arg1);
	local DescriptionOffset = string.find(arg1,"%s",1);
	local Description = nil;
	
	if (DescriptionOffset) then
		Command = string.upper(string.sub(arg1, 1, DescriptionOffset - 1));
		Description = tostring(string.sub(arg1, DescriptionOffset + 1));
	end
	
	SlaveGirl.DebugPrint("Command executed: "..Command);
	
	if (Command == "MASTER") then
		SlaveGirl_Command_Master(Description);
	elseif (Command == "MONITOR") then
		SlaveGirl_Command_Monitor();
	elseif (Command == "FOLLOW") then
		SlaveGirl_Command_Follow();
	elseif (Command == "BROADCAST") then
		SlaveGirl_Command_Broadcast();
	elseif (Command == "STATUS") then
		SlaveGirl_Command_Status();
	elseif (Command == "DEBUG") then
		SlaveGirl_Command_Debug();
	elseif (Command == "OPTION" or Command == "OPTIONS") then
		InterfaceOptionsFrame_OpenToCategory("Slave Girl")
		InterfaceOptionsFrame_OpenToCategory("Slave Girl")
	elseif (Command == "HELP" or Command == "") then
		SlaveGirl_Command_Help();
	else
		SlaveGirl_Command_Help();
	end
end

function SlaveGirl_Update()
		local currentTime = GetTime();
		if (UnitIsDeadOrGhost("player")) then
			return;
		end
		local hp = UnitHealth("player");
		if (hp > 1) then
			if (SlaveGirl.Setting.LowHealthSound and currentTime > SlaveGirl.Data.TimerLowHealth and (((hp * 100) / UnitHealthMax("player")) < SlaveGirl.Setting.LowHealthThreshold)) then
				SlaveGirl_PlaySound("LowHealth")
				SlaveGirl.Data.TimerLowHealth = GetTime() + SlaveGirl.Setting.LowHealthCooldown;
			end
			if (SlaveGirl.Setting.LowManaSound and UnitPowerMax("player", 0) > 0 and currentTime > SlaveGirl.Data.TimerLowMana and (((UnitPower("player", 0) * 100) / UnitPowerMax("player", 0)) < SlaveGirl.Setting.LowManaThreshold) and (UnitPowerType("player") == 0)) then
				SlaveGirl_PlaySound("LowMana");
				SlaveGirl.Data.TimerLowMana = GetTime() + SlaveGirl.Setting.LowManaCooldown;
			end
		end
end

function SlaveGirl_Command_Follow()
	FollowUnit("target");
end

function SlaveGirl_Command_Help()
	local currentMaster;
	if (SlaveGirl.Setting.Master) then
		currentMaster = "|cFFEEEE00"..SlaveGirl.Setting.Master.."|r";
	else
		currentMaster = "[|cFFEE0000Nobody|r]";
	end

	DEFAULT_CHAT_FRAME:AddMessage("[SG] Slave Girl "..SlaveGirl.Version, 0.25, 1.0, 0.25);
	DEFAULT_CHAT_FRAME:AddMessage("Current Master: "..currentMaster, 0.25, 1.0, 0.75);
	DEFAULT_CHAT_FRAME:AddMessage("|cFFEEEE00/sg options|r -- Display options", 0.25, 1.0, 0.75);
	DEFAULT_CHAT_FRAME:AddMessage("|cFFEEEE00/sg master|r -- Set your current target as your master (or to nobody if you have no target)", 0.25, 1.0, 0.75);

end

function SlaveGirl_Command_Master(arg1)
	if (arg1 and arg1 ~= "") then
		if (arg1 == "c" or arg1 == "C") then
			SlaveGirl.Setting.Master = nil;
			SlaveGirl.ChatPrint("You are no longer taking orders from anyone.");
		elseif (arg1 == SlaveGirl.Data.Me or arg1 == SlaveGirl.Data.MeFull) then
			SlaveGirl_ErrorPrint("You cannot be your own master.");
		else
			SlaveGirl.Setting.Master = arg1;
			SlaveGirl.ChatPrint("You are now taking orders from "..arg1..".");
			SlaveGirl_ReportToMaster(arg1);
		end
	else
		local sName, sRealm = UnitName("target");
		if (sName) then
			local fullName = SlaveGirl_FullName("target", true)
			if (fullName == SlaveGirl.Data.MeFull) then
				SlaveGirl_ErrorPrint("You cannot be your own master.");
			elseif (not UnitIsPlayer("target")) then
				SlaveGirl_ErrorPrint("Only players can be masters.");
			else
				SlaveGirl.Setting.Master = fullName;
				SlaveGirl.ChatPrint("You are now taking orders from "..sName..".");
				SlaveGirl_ReportToMaster(fullName);
		end
		else
			SlaveGirl.Setting.Master = nil;
			SlaveGirl.ChatPrint("You are no longer taking orders from anyone.");
		end
	end
	SlaveGirl_SaveSettings();
end

function SlaveGirl_PlaySound(sSound)
	local currentTime = GetTime();
	local soundTime = SlaveGirl.Data.TimerSound[sSound];
	if (not soundTime or currentTime > soundTime) then
		PlaySoundFile(SlaveGirl.Sounds[sSound], "Master");
		SlaveGirl.Data.TimerSound[sSound] = GetTime() + .5;
	end
end

function SlaveGirl_Command_Monitor()
	if (SlaveGirl.Setting.Monitor == true) then
		SlaveGirl.Setting.Monitor = nil;
		SlaveGirl.ChatPrint("Monitoring activity is off.");
	else
		SlaveGirl.Setting.Monitor = true;
		SlaveGirl.ChatPrint("Monitoring activity is on.");
	end
		SlaveGirl.DebugPrint("Monitor loaded: "..tostring(SlaveGirl.Setting.Monitor).."/"..tostring(SlaveGirlOptions.Setting[SlaveGirl.Data.Me].Monitor));
	SlaveGirl_SaveSettings();
		SlaveGirl.DebugPrint("Monitor loaded: "..tostring(SlaveGirl.Setting.Monitor).."/"..tostring(SlaveGirlOptions.Setting[SlaveGirl.Data.Me].Monitor));
end

function SlaveGirl_Command_Broadcast()
	if (SlaveGirl.Setting.Broadcast == true) then
		SlaveGirl.Setting.Broadcast = nil;
		SlaveGirl.ChatPrint("Broadcasting activity is off.");
	else
		SlaveGirl.Setting.Broadcast = true;
		SlaveGirl.ChatPrint("Broadcasting activity is on.");
	end
	SlaveGirl_SaveSettings();
end

function SlaveGirl_SendComm(sNewMessage, bOverride)
	if (SlaveGirl.Setting.Broadcast or bOverride) then	
		if (SlaveGirl.Data.BetaMode) then
			if (IsInGroup(LE_PARTY_CATEGORY_INSTANCE)) then
				C_ChatInfo.SendAddonMessage(SlaveGirl.ModCode,sNewMessage,"INSTANCE_CHAT");
			elseif (UnitInBattleground("player")) then
				C_ChatInfo.SendAddonMessage(SlaveGirl.ModCode,sNewMessage,"BATTLEGROUND");
			else		
				C_ChatInfo.SendAddonMessage(SlaveGirl.ModCode,sNewMessage,"RAID");
			end
		else
			if (IsInGroup(LE_PARTY_CATEGORY_INSTANCE)) then
				SendAddonMessage(SlaveGirl.ModCode,sNewMessage,"INSTANCE_CHAT");
			elseif (UnitInBattleground("player")) then
				SendAddonMessage(SlaveGirl.ModCode,sNewMessage,"BATTLEGROUND");
			else		
				SendAddonMessage(SlaveGirl.ModCode,sNewMessage,"RAID");
			end
		end
		--SlaveGirl.DebugPrint("Sending Comm: "..tostring(sNewMessage));
	end
end

function SlaveGirl_ReceiveComm(sMessage, sSender)
	local decodedMessage = SlaveGirl_CommDecode(sMessage, sSender);
	SlaveGirl.DebugPrint("Message from "..sSender..": "..sMessage);
	if (decodedMessage) then
		if (decodedMessage == "COMMAND:MASTER") then
			SlaveGirl_ReportToMaster(sSender);
		elseif (decodedMessage == "COMMAND:SLAVE") then
			SlaveGirl.Data.Slaves[sSender] = true;
			SlaveGirl.DebugPrint(sSender.." has reported in.");
			SlaveGirl_CheckGroup(false);
		else
			if (SlaveGirl.Setting.Monitor and SlaveGirl.Data.Slaves[sSender]) then
				SlaveGirl_CommPrint("[SG] ["..SlaveGirl.StripRealm(sSender).."]: "..decodedMessage);
			end
		end
	end
end

function SlaveGirl_CommDecode(sText, sSender)
	if (sText == "") or not (sText) then
		return nil;
	end
	
	local DecodedMessage = nil;
	local Slash = string.find(sText,"/",1);
	local Slash2 = "";
	local Slash3 = "";
	local Command = "";
	local CommandType = "";
	local Data = "";
	local Data2 = "";
	
	if (Slash) then
		CommandType = string.sub(sText,1,Slash - 1);
		Slash2 = string.find(sText,"/",Slash + 1);
		if (Slash2) then
			Command = string.sub(sText,Slash + 1,Slash2 - 1);
			Slash3 = string.find(sText,"/",Slash2 + 1);
			if (Slash3) then
				Data = string.sub(sText,Slash2 + 1,Slash3 - 1);
				Data2 = string.sub(sText,Slash3 + 1);
			else
				Data = string.sub(sText,Slash2 + 1);
			end
		else
			Command = string.sub(sText,Slash + 1)
		end
	else
		CommandType = sText;
	end
	
	if (CommandType == "X") then
		if (Command == "W") then
			DecodedMessage = "Wand: (Stop)";
		elseif (Command == "H") then
			DecodedMessage = "Heal: Aborted: "..Data;
		else
			DecodedMessage = Command;
		end
	elseif (CommandType == "W") then
		if (Command == "S") then
			DecodedMessage = "Wand: "..Data;
		else
			DecodedMessage = Command;
		end
	elseif (CommandType == "H") then
		if (Command == "HT") then
			DecodedMessage = "Heal: Healthstone";
		elseif (SlaveGirl_CommDecode_Spell(Command)) then
			DecodedMessage = "Heal: "..SlaveGirl_CommDecode_Spell(Command);
			if (Data2 ~= "") then
				DecodedMessage = DecodedMessage.." ("..Data.."): "..Data2;
			elseif (Data ~= "") then
				DecodedMessage = DecodedMessage.." ("..Data..")";
			end
		else
			DecodedMessage = Command;
		end
	elseif (CommandType == "A") then
		if (SlaveGirl_CommDecode_Spell(Command)) then
			DecodedMessage = "Attack: "..SlaveGirl_CommDecode_Spell(Command);
			if (Data2 ~= "") then
				DecodedMessage = DecodedMessage.." ("..Data.."): "..Data2;
			elseif (Data ~= "") then
				DecodedMessage = DecodedMessage.." ("..Data..")";		
			end
		else
			DecodedMessage = Command;
		end
	elseif (CommandType == "B") then
		if (SlaveGirl_CommDecode_Spell(Command)) then
			DecodedMessage = "Buff: "..SlaveGirl_CommDecode_Spell(Command);
			if (Data2 ~= "") then
				DecodedMessage = DecodedMessage.." ("..Data.."): "..Data2;
			elseif (Data ~= "") then
				DecodedMessage = DecodedMessage.." ("..Data..")";		
			end
		else
			DecodedMessage = Command;
		end
	elseif (CommandType == "R") then
		DecodedMessage = "Resurrecting: "..Command;
	elseif (CommandType == "T") then
		DecodedMessage = "Target: "..Command;
		if (Command == "X") then
			DecodedMessage = "Target: "..Data.." [Unknown]";
		elseif (Command == "F") then
			DecodedMessage = "Target: "..Data.." [Friendly]";
		elseif (Command == "E") then
			DecodedMessage = "Target: "..Data.." [Enemy]";
		elseif (Command == "P") then
			DecodedMessage = "Target: "..Data.." [Party]";
		elseif (Command == "R") then
			DecodedMessage = "Target: "..Data.." [Raid]";
		elseif (Command == "S") then
			DecodedMessage = "Target: [Self]";
		elseif (Command == "M") then
			DecodedMessage = "Target: "..Data.." [Master]";
		else
			DecodedMessage = Command;
		end
		DecodedMessage = nil;
	elseif (CommandType == "F") then
		if (Command == "S") then
			if (Data) then
				DecodedMessage = "Follow: "..Data;
			else
				DecodedMessage = "Follow: [Start]";
			end
		elseif (Command == "X") then
			DecodedMessage = "Follow: [Stop]";
		else
			DecodedMessage = Command;
		end
	elseif (CommandType == "O") then
		if (Command == "T") then
			DecodedMessage = "Order: Accepting Trade";
		elseif (Command == "Q") then
			DecodedMessage = "Order: Accepting Quest ("..Data..")";
		elseif (Command == "S" and Data) then
			SlaveGirl.DebugPrint("Requested share of quest: "..Data);
			if (SlaveGirl.Setting.AutoAcceptQuest and SlaveGirl.Setting.Master) then
				local title = GetTitleText();
				SlaveGirl.DebugPrint("Got new title: "..tostring(title));
				if (title == Data) then
					SlaveGirl.DebugPrint("Auto-Accepting quest.");
					--SlaveGirl_SendComm("O/Q/"..GetTitleText());
					AcceptQuest();
					HideUIPanel(QuestFrame);
				end
			end	
		else
			DecodedMessage = Command;
		end
	elseif (CommandType == "S") then
		if (SlaveGirl_CommDecode_Spell(Command)) then
			DecodedMessage = SlaveGirl_CommDecode_Spell(Command);
			if (Data2 ~= "") then
				DecodedMessage = DecodedMessage.." ("..Data.."): "..Data2;
			elseif (Data ~= "") then
				DecodedMessage = DecodedMessage.." ("..Data..")";		
			end
		else
			DecodedMessage = Command;
		end
	elseif (CommandType == "E") then
		if (Command == "V") then
			DecodedMessage = "Error: Can't cast -- Moving";
		elseif (Command == "C") then
			DecodedMessage = "Error: Can't cast -- Cooldown";
		elseif (Command == "L") then
			DecodedMessage = "Error: Can't cast -- No line of sight";
		elseif (Command == "B") then
			DecodedMessage = "Error: Can't cast -- Bad target";
		elseif (Command == "F") then
			DecodedMessage = "Error: Can't cast -- Target isn't in front";
		elseif (Command == "I") then
			DecodedMessage = "Error: Can't attack -- Invalid/Ignored target";
		elseif (Command == "N") then
			DecodedMessage = "Error: Can't attack -- Out of range/No Script";
		elseif (Command == "R") then
			DecodedMessage = "Error: Can't cast -- Out of range";
		elseif (Command == "X") then
			DecodedMessage = "Error: Can't cast -- In combat";
		elseif (Command == "M") then
			DecodedMessage = "Error: Can't cast -- Out of mana";
		elseif (Command == "S") then
			DecodedMessage = "Error: Can't cast -- Silenced/Stunned";
		else
			DecodedMessage = Command;
		end
	elseif (CommandType == "G") then
		if (Command == "M") then
			DecodedMessage = "COMMAND:MASTER";
		end
		if (Command == "S") then
			DecodedMessage = "COMMAND:SLAVE";
		end
	else
		DecodedMessage = sText;
	end
	
	return DecodedMessage;
end

function SlaveGirl_Command_Status()
	SlaveGirl.ChatPrint("Slave Girl Status Report:");
	if (SlaveGirl.Setting.Master) then
		SlaveGirl.ChatPrint("- Master: "..SlaveGirl.Setting.Master);
	else
		SlaveGirl.ChatPrint("- Master: [None]");
	end
	SlaveGirl.ChatPrint("- Comm Broadcasting: "..SlaveGirl_Logic(SlaveGirl.Setting.Broadcast));
end

function SlaveGirl_Logic(bValue)
	if (bValue) then
		if (bValue == false) then
			return "Off";
		else
			return "On";
		end
	else
		return "Off";
	end
end

function SlaveGirl_SaveSettings()
	SlaveGirl.DebugPrint("Saving settings");
	SlaveGirlOptions.Setting[SlaveGirl.Data.Me] = SlaveGirl.Setting;
	getglobal("SlaveGirl_MonitorButton"):SetChecked(SlaveGirl.Setting.Monitor);
	getglobal("SlaveGirl_BroadcastButton"):SetChecked(SlaveGirl.Setting.Broadcast);
	getglobal("SlaveGirl_StartFollowSoundButton"):SetChecked(SlaveGirl.Setting.StartFollowSound);
	getglobal("SlaveGirl_StopFollowSoundButton"):SetChecked(SlaveGirl.Setting.StopFollowSound);
	getglobal("SlaveGirl_LowHealthSoundButton"):SetChecked(SlaveGirl.Setting.LowHealthSound);
	getglobal("SlaveGirl_LowManaSoundButton"):SetChecked(SlaveGirl.Setting.LowManaSound);
	getglobal("SlaveGirl_AutoAcceptGroupInviteButton"):SetChecked(SlaveGirl.Setting.AutoAcceptGroupInvite);
	getglobal("SlaveGirl_AutoAcceptQuestButton"):SetChecked(SlaveGirl.Setting.AutoAcceptQuest);
	getglobal("SlaveGirl_AutoShareQuestButton"):SetChecked(SlaveGirl.Setting.AutoShareQuest);
	getglobal("SlaveGirl_AutoTurnInQuestButton"):SetChecked(SlaveGirl.Setting.AutoTurnInQuest);
	getglobal("SlaveGirl_AutoLeaveGroupButton"):SetChecked(SlaveGirl.Setting.AutoLeaveGroup);
	getglobal("SlaveGirl_AutoRoleButton"):SetChecked(SlaveGirl.Setting.AutoRole);
	if (SlaveGirl.Setting.Master) then
		getglobal("SlaveGirl_MasterInfo"):SetText("Current master: |cFFEEEE00"..SlaveGirl.Setting.Master.."|r");
		getglobal("SlaveGirl_RemoveMasterButton"):Enable();
	else
		getglobal("SlaveGirl_MasterInfo"):SetText("Current master: [|cFFEE0000Nobody|r]");
		getglobal("SlaveGirl_RemoveMasterButton"):Disable();
	end
	getglobal("SlaveGirl_LowHealthSlider"):SetValue(SlaveGirl.Setting.LowHealthThreshold);
	if (SlaveGirl.Setting.LowHealthThreshold > 0) then
		getglobal("SlaveGirl_LowHealthValue"):SetText(SlaveGirl.Setting.LowHealthThreshold.."%");
	else
		getglobal("SlaveGirl_LowHealthValue"):SetText("Disabled");			
	end
	getglobal("SlaveGirl_LowManaSlider"):SetValue(SlaveGirl.Setting.LowManaThreshold);
	if (SlaveGirl.Setting.LowManaThreshold > 0) then
		getglobal("SlaveGirl_LowManaValue"):SetText(SlaveGirl.Setting.LowManaThreshold.."%");
	else
		getglobal("SlaveGirl_LowManaValue"):SetText("Disabled");			
	end
end

function SlaveGirl_ShareQuest(index)
    local strQuestLogTitleText, strQuestLevel, strSuggestedGroup, isHeader, isCollapsed, isComplete, frequency, questId = GetQuestLogTitle(index);
    local questLink = GetQuestLink(questId);
    SelectQuestLogEntry(index)
    if (GetQuestLogPushable()) then
        QuestLogPushQuest(index)
				SlaveGirl_SendComm("O/S/"..questLink, true);
    else
    		SlaveGirl_ErrorPrint("Unable to share "..questLink);
				SlaveGirl_SendComm("O/S/"..questLink, true);
    end
end

-- Check the group for slaves
function SlaveGirl_CheckGroup(activelySearch)
	local raidmembers = GetNumGroupMembers();
	local partymembers = GetNumSubgroupMembers();
	local wasMasterInGroup = SlaveGirl.Data.MasterInGroup;
	if (raidmembers > 0 and not UnitExists("raid1")) then
		raidmembers = 0
	end

	SlaveGirl.Data.SlaveInGroup = nil;
	SlaveGirl.Data.MasterInGroup = nil;
	
	if (activelySearch and (raidmembers > 0 or partymembers > 0)) then
		SlaveGirl_SendComm("G/M", true);
		SlaveGirl.DebugPrint("Actively looking for slaves.");
	end
	if (raidmembers > 0) then
		for i = 1, raidmembers, 1 do
			local name = UnitName("raid"..i);
			local fullName = SlaveGirl_FullName("raid"..i, true);
			if (SlaveGirl.Data.Slaves[name] or SlaveGirl.Data.Slaves[fullName]) then
				SlaveGirl.Data.SlaveInGroup = true;
				SlaveGirl.DebugPrint("Slave is in group: Raid"..i);
			end
			if (SlaveGirl_IsMaster(name)) then
				SlaveGirl.Data.MasterInGroup = true;
				SlaveGirl.DebugPrint("Master is in group: Raid"..i);
			end
		end
	elseif (partymembers > 0) then
		for i = 1, partymembers, 1 do
			local name = UnitName("party"..i);
			local fullName = SlaveGirl_FullName("party"..i, true);
			if (SlaveGirl.Data.Slaves[name] or SlaveGirl.Data.Slaves[fullName]) then
				SlaveGirl.Data.SlaveInGroup = true;
				SlaveGirl.DebugPrint("Slave is in group: Party"..i);
			end
			if (SlaveGirl_IsMaster(name)) then
				SlaveGirl.Data.MasterInGroup = true;
				SlaveGirl.DebugPrint("Master is in group: Party"..i);
			end
		end
	end
	
	if (wasMasterInGroup and SlaveGirl.Setting.AutoLeaveGroup and not SlaveGirl.Data.MasterInGroup and GetTime() > (SlaveGirl.Data.AutoLeaveGroupIgnore or 0)) then
		-- Master is no longer in group, leaving...
		SlaveGirl.DebugPrint("Master is no longer in group, leaving group");
		LeaveParty();
	end

end

function SlaveGirl_ReportToMaster(master)
	if (master and SlaveGirl_IsMaster(master)) then
		if (SlaveGirl.Data.BetaMode) then
			C_ChatInfo.SendAddonMessage(SlaveGirl.ModCode, "G/S", "WHISPER", SlaveGirl.Setting.Master);
		else
			SendAddonMessage(SlaveGirl.ModCode, "G/S", "WHISPER", SlaveGirl.Setting.Master);
		end
		SlaveGirl.DebugPrint("Reporting to: "..master);
	end
end

-- Create Addon Menu options and interface
function SlaveGirl_RenderOptions()
	local ConfigurationPanel = CreateFrame("FRAME","SlaveGirl_MainFrame");
	ConfigurationPanel.name = "Slave Girl";
	InterfaceOptions_AddCategory(ConfigurationPanel);

	local IntroMessageHeader = ConfigurationPanel:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge");
	IntroMessageHeader:SetPoint("TOPLEFT", 10, -10);
	IntroMessageHeader:SetText("Slave Girl "..SlaveGirl.Version);

	local IntroMessageMaster = ConfigurationPanel:CreateFontString("SlaveGirl_MasterInfo", "ARTWORK", "GameFontNormal");
	IntroMessageMaster:SetPoint("TOPLEFT", 10, -35);
	IntroMessageMaster:SetText("Current Master: ");

	local IntroMessageFooter = ConfigurationPanel:CreateFontString(nil, "ARTWORK", "GameFontNormal");
	IntroMessageFooter:SetPoint("TOPLEFT", 10, -75);
	IntroMessageFooter:SetText("Click a player and click |cFFFFFFFFSet|r to set them as your master.");

	local SetMasterButton = CreateFrame("Button", "SlaveGirl_SetMasterButton", ConfigurationPanel, "OptionsButtonTemplate");
	SetMasterButton:SetPoint("TOPLEFT", 220, -30);
	SetMasterButton.tooltip = "Set this person as your master";
	SetMasterButton:SetScript("OnClick",SlaveGirl_Option_SetMaster);
	getglobal(SetMasterButton:GetName().."Text"):SetText("Set");

	local RemoveMasterButton = CreateFrame("Button", "SlaveGirl_RemoveMasterButton", ConfigurationPanel, "OptionsButtonTemplate");
	RemoveMasterButton:SetPoint("TOPLEFT", 310, -30);
	RemoveMasterButton.tooltip = "Remove this person as your master";
	RemoveMasterButton:SetScript("OnClick",SlaveGirl_Option_NoMaster);
	getglobal(RemoveMasterButton:GetName().."Text"):SetText("Remove");

	
	-- Communications

	local CommunicationPanel = CreateFrame("FRAME","SlaveGirl_CommunicationFrame");
	CommunicationPanel.name = "Communications";
	CommunicationPanel.parent = ConfigurationPanel.name;
	InterfaceOptions_AddCategory(CommunicationPanel);

	local MonitorButton = CreateFrame("CheckButton", "SlaveGirl_MonitorButton", CommunicationPanel, "ChatConfigCheckButtonTemplate");
	MonitorButton:SetPoint("TOPLEFT", 10, -15)
	MonitorButton.tooltip = "";
	getglobal(MonitorButton:GetName().."Text"):SetText(" Display slave communications to chat window");

	local BroadcastButton = CreateFrame("CheckButton", "SlaveGirl_BroadcastButton", CommunicationPanel, "ChatConfigCheckButtonTemplate");
	BroadcastButton:SetPoint("TOPLEFT", 10, -45)
	BroadcastButton.tooltip = "";
	getglobal(BroadcastButton:GetName().."Text"):SetText(" Broadcast error messages to master (when grouped)");

	-- Groups/Quests

	local QuestPanel = CreateFrame("FRAME","SlaveGirl_QuestFrame");
	QuestPanel.name = "Groups/Quests";
	QuestPanel.parent = ConfigurationPanel.name;
	InterfaceOptions_AddCategory(QuestPanel);

	local AutoAcceptGroupInviteButton = CreateFrame("CheckButton", "SlaveGirl_AutoAcceptGroupInviteButton", QuestPanel, "ChatConfigCheckButtonTemplate");
	AutoAcceptGroupInviteButton:SetPoint("TOPLEFT", 10, -15)
	AutoAcceptGroupInviteButton.tooltip = "";
	getglobal(AutoAcceptGroupInviteButton:GetName().."Text"):SetText(" Auto-accept master's group invite");

	local AutoAcceptQuestButton = CreateFrame("CheckButton", "SlaveGirl_AutoAcceptQuestButton", QuestPanel, "ChatConfigCheckButtonTemplate");
	AutoAcceptQuestButton:SetPoint("TOPLEFT", 10, -45)
	AutoAcceptQuestButton.tooltip = "";
	getglobal(AutoAcceptQuestButton:GetName().."Text"):SetText(" Auto-accept shared quests");

	local AutoShareQuestButton = CreateFrame("CheckButton", "SlaveGirl_AutoShareQuestButton", QuestPanel, "ChatConfigCheckButtonTemplate");
	AutoShareQuestButton:SetPoint("TOPLEFT", 10, -75)
	AutoShareQuestButton.tooltip = "";
	getglobal(AutoShareQuestButton:GetName().."Text"):SetText(" Auto-share quests (when grouped with a master or slave)");

	local AutoTurnInQuestButton = CreateFrame("CheckButton", "SlaveGirl_AutoTurnInQuestButton", QuestPanel, "ChatConfigCheckButtonTemplate");
	AutoTurnInQuestButton:SetPoint("TOPLEFT", 10, -105)
	AutoTurnInQuestButton.tooltip = "";
	getglobal(AutoTurnInQuestButton:GetName().."Text"):SetText(" Auto-start and complete quests (that don't have rewards)");

	local AutoLeaveGroupButton = CreateFrame("CheckButton", "SlaveGirl_AutoLeaveGroupButton", QuestPanel, "ChatConfigCheckButtonTemplate");
	AutoLeaveGroupButton:SetPoint("TOPLEFT", 10, -135)
	AutoLeaveGroupButton.tooltip = "";
	getglobal(AutoLeaveGroupButton:GetName().."Text"):SetText(" Auto-leave groups when master leaves the group");

	local AutoRoleButton = CreateFrame("CheckButton", "SlaveGirl_AutoRoleButton", QuestPanel, "ChatConfigCheckButtonTemplate");
	AutoRoleButton:SetPoint("TOPLEFT", 10, -165)
	AutoRoleButton.tooltip = "";
	getglobal(AutoRoleButton:GetName().."Text"):SetText(" Auto-choose roles based on current specialization and hide selection popups");

	-- Sounds

	local SoundPanel = CreateFrame("FRAME","SlaveGirl_SoundFrame");
	SoundPanel.name = "Sounds";
	SoundPanel.parent = ConfigurationPanel.name;
	InterfaceOptions_AddCategory(SoundPanel);

	local StartFollowSoundButton = CreateFrame("CheckButton", "SlaveGirl_StartFollowSoundButton", SoundPanel, "ChatConfigCheckButtonTemplate");
	StartFollowSoundButton:SetPoint("TOPLEFT", 10, -15)
	StartFollowSoundButton.tooltip = "";
	getglobal(StartFollowSoundButton:GetName().."Text"):SetText(" Start Following");

	local StartFollowSoundTestButton = CreateFrame("Button", "SlaveGirl_StartFollowSoundTestButton", SoundPanel, "OptionsButtonTemplate");
	StartFollowSoundTestButton:SetPoint("TOPLEFT", 300, -15);
	StartFollowSoundTestButton.tooltip = "Play the sound of when your character is following another";
	StartFollowSoundTestButton:SetScript("OnClick",SlaveGirl_Option_StartFollowTest);
	getglobal(StartFollowSoundTestButton:GetName().."Text"):SetText("Test");

	local StopFollowSoundButton = CreateFrame("CheckButton", "SlaveGirl_StopFollowSoundButton", SoundPanel, "ChatConfigCheckButtonTemplate");
	StopFollowSoundButton:SetPoint("TOPLEFT", 10, -45)
	StopFollowSoundButton.tooltip = "";
	getglobal(StopFollowSoundButton:GetName().."Text"):SetText(" Stop Following");

	local StopFollowSoundTestButton = CreateFrame("Button", "SlaveGirl_StopFollowSoundTestButton", SoundPanel, "OptionsButtonTemplate");
	StopFollowSoundTestButton:SetPoint("TOPLEFT", 300, -45);
	StopFollowSoundTestButton.tooltip = "Play the sound of when your character stops following another";
	StopFollowSoundTestButton:SetScript("OnClick",SlaveGirl_Option_StopFollowTest);
	getglobal(StopFollowSoundTestButton:GetName().."Text"):SetText("Test");

	local LowHealthSoundButton = CreateFrame("CheckButton", "SlaveGirl_LowHealthSoundButton", SoundPanel, "ChatConfigCheckButtonTemplate");
	LowHealthSoundButton:SetPoint("TOPLEFT", 10, -75)
	LowHealthSoundButton.tooltip = "";
	getglobal(LowHealthSoundButton:GetName().."Text"):SetText(" Low Health");

	local LowHealthSoundTestButton = CreateFrame("Button", "SlaveGirl_LowHealthSoundTestButton", SoundPanel, "OptionsButtonTemplate");
	LowHealthSoundTestButton:SetPoint("TOPLEFT", 300, -75);
	LowHealthSoundTestButton.tooltip = "Play the sound of when your character is following another";
	LowHealthSoundTestButton:SetScript("OnClick",SlaveGirl_Option_LowHealthTest);
	getglobal(LowHealthSoundTestButton:GetName().."Text"):SetText("Test");

	local LowHealthSlider = CreateFrame("Slider", "SlaveGirl_LowHealthSlider", SoundPanel, "OptionsSliderTemplate");
	LowHealthSlider:SetPoint("TOPLEFT", 45, -115);
	LowHealthSlider.tooltip = "Percentage of HP to sound alert";
	LowHealthSlider:SetScript("OnValueChanged",SlaveGirl_Option_SetLowHealth);
	getglobal(SlaveGirl_LowHealthSlider:GetName().."Text"):SetText("Health %");
	getglobal(SlaveGirl_LowHealthSlider:GetName().."High"):SetText("Max");
	getglobal(SlaveGirl_LowHealthSlider:GetName().."Low"):SetText("Min");
	LowHealthSlider:SetMinMaxValues(0,100);
	LowHealthSlider:SetValueStep(1);
	LowHealthSlider:SetValue(SlaveGirl.Setting.LowHealthThreshold);

	local LowHealthValue = SoundPanel:CreateFontString("SlaveGirl_LowHealthValue", "ARTWORK", "GameFontNormal");
	LowHealthValue:SetPoint("TOPLEFT", 200, -115);
	LowHealthValue:SetText(SlaveGirl.Setting.LowHealthThreshold.."%");

	local LowManaSoundButton = CreateFrame("CheckButton", "SlaveGirl_LowManaSoundButton", SoundPanel, "ChatConfigCheckButtonTemplate");
	LowManaSoundButton:SetPoint("TOPLEFT", 10, -145)
	LowManaSoundButton.tooltip = "";
	getglobal(LowManaSoundButton:GetName().."Text"):SetText(" Low Mana");

	local LowManaSoundTestButton = CreateFrame("Button", "SlaveGirl_LowManaSoundTestButton", SoundPanel, "OptionsButtonTemplate");
	LowManaSoundTestButton:SetPoint("TOPLEFT", 300, -145);
	LowManaSoundTestButton.tooltip = "Play the sound of when your character is following another";
	LowManaSoundTestButton:SetScript("OnClick",SlaveGirl_Option_LowManaTest);
	getglobal(LowManaSoundTestButton:GetName().."Text"):SetText("Test");

	local LowManaSlider = CreateFrame("Slider", "SlaveGirl_LowManaSlider", SoundPanel, "OptionsSliderTemplate");
	LowManaSlider:SetPoint("TOPLEFT", 45, -185);
	LowManaSlider.tooltip = "Percentage of Mana to sound alert";
	LowManaSlider:SetScript("OnValueChanged",SlaveGirl_Option_SetLowMana);
	getglobal(SlaveGirl_LowManaSlider:GetName().."Text"):SetText("Mana %");
	getglobal(SlaveGirl_LowManaSlider:GetName().."High"):SetText("Max");
	getglobal(SlaveGirl_LowManaSlider:GetName().."Low"):SetText("Min");
	LowManaSlider:SetMinMaxValues(0,100);
	LowManaSlider:SetValueStep(1);
	LowManaSlider:SetValue(SlaveGirl.Data.LowManaThreshold);

	local LowManaValue = SoundPanel:CreateFontString("SlaveGirl_LowManaValue", "ARTWORK", "GameFontNormal");
	LowManaValue:SetPoint("TOPLEFT", 200, -185);
	LowManaValue:SetText(SlaveGirl.Data.LowManaThreshold.."%");
	
	ConfigurationPanel.okay = 
		function (self)
			SlaveGirl.Setting.Monitor = MonitorButton:GetChecked();
			SlaveGirl.Setting.Broadcast = BroadcastButton:GetChecked();
			SlaveGirl.Setting.StartFollowSound = StartFollowSoundButton:GetChecked();
			SlaveGirl.Setting.StopFollowSound = StopFollowSoundButton:GetChecked();
			SlaveGirl.Setting.LowHealthSound = LowHealthSoundButton:GetChecked();
			SlaveGirl.Setting.LowManaSound = LowManaSoundButton:GetChecked();
			SlaveGirl.Setting.AutoAcceptGroupInvite = AutoAcceptGroupInviteButton:GetChecked();
			SlaveGirl.Setting.AutoAcceptQuest = AutoAcceptQuestButton:GetChecked();
			SlaveGirl.Setting.AutoShareQuest = AutoShareQuestButton:GetChecked();
			SlaveGirl.Setting.AutoTurnInQuest = AutoTurnInQuestButton:GetChecked();
			SlaveGirl.Setting.AutoLeaveGroup = AutoLeaveGroupButton:GetChecked();
			SlaveGirl.Setting.AutoRole = AutoRoleButton:GetChecked();
			SlaveGirl.Setting.LowHealthThreshold = getglobal("SlaveGirl_LowHealthSlider"):GetValue();
			SlaveGirl.Setting.LowManaThreshold = getglobal("SlaveGirl_LowManaSlider"):GetValue();
			SlaveGirl_SaveSettings();
		end
	ConfigurationPanel.cancel = 
		function (self)

		end
	ConfigurationPanel.default = 
		function (self)
			SlaveGirl_ResetDefaults();
			SlaveGirl_SaveSettings();
		end
	SoundPanel.default = 
		function (self)
			SlaveGirl_ResetDefaults();
			SlaveGirl_SaveSettings();
		end
	QuestPanel.default = 
		function (self)
			SlaveGirl_ResetDefaults();
			SlaveGirl_SaveSettings();
		end
	CommunicationPanel.default = 
		function (self)
			SlaveGirl_ResetDefaults();
			SlaveGirl_SaveSettings();
		end
end

function SlaveGirl_Option_StartFollowTest()
	SlaveGirl_PlaySound("StartFollow");
end

function SlaveGirl_Option_StopFollowTest()
	SlaveGirl_PlaySound("StopFollow");
end

function SlaveGirl_Option_LowHealthTest()
	SlaveGirl_PlaySound("LowHealth");
end

function SlaveGirl_Option_LowManaTest()
	SlaveGirl_PlaySound("LowMana");
end

function SlaveGirl_Option_SetMaster()
	if (UnitName("target")) then
		SlaveGirl_Command_Master(nil);
	end
end

function SlaveGirl_Option_NoMaster()
	SlaveGirl_Command_Master("c");
end

function SlaveGirl_Option_SetLowHealth()
	SlaveGirl.Data.LowHealthThreshold = getglobal("SlaveGirl_LowHealthSlider"):GetValue();
	if (getglobal("SlaveGirl_LowHealthValue")) then
		if (SlaveGirl.Data.LowHealthThreshold > 0) then
			getglobal("SlaveGirl_LowHealthValue"):SetText(SlaveGirl.Data.LowHealthThreshold.."%");
		else
			getglobal("SlaveGirl_LowHealthValue"):SetText("Disabled");			
		end
	end
end

function SlaveGirl_Option_SetLowMana()
	SlaveGirl.Data.LowManaThreshold = getglobal("SlaveGirl_LowManaSlider"):GetValue();
	if (getglobal("SlaveGirl_LowManaValue")) then
		if (SlaveGirl.Data.LowManaThreshold > 0) then
			getglobal("SlaveGirl_LowManaValue"):SetText(SlaveGirl.Data.LowManaThreshold.."%");
		else
			getglobal("SlaveGirl_LowManaValue"):SetText("Disabled");			
		end
	end
end

function SlaveGirl_IsMaster(name)
	if (SlaveGirl.Setting.Master and name) then
		if (SlaveGirl.Setting.Master == name) then
			return true;
		end
		if (SlaveGirl.Setting.Master.."-"..SlaveGirl.Data.Realm == name) then
			return true;
		end
		if (SlaveGirl.Setting.Master == name.."-"..SlaveGirl.Data.Realm) then
			return true;
		end
	end
end

function SlaveGirl_FullName(sUnit, bForceRealm)
	local name, realm = UnitName(sUnit);
	if (realm and realm ~= "") then
		return name.."-"..realm;
	elseif (name and bForceRealm) then
		return name.."-"..SlaveGirl.Data.Realm;
	else
		return name;
	end
end

function SlaveGirl.StopFollowing(justStarted)
	if (justStarted) then
		SlaveGirl.DebugPrint("Ignore stop following");
		return;
	end
	
	if (SlaveGirl.Setting.StopFollowSound) then
		SlaveGirl_PlaySound("StopFollow");
	end
	SlaveGirl_SendComm("F/X");
end

function SlaveGirl.StartFollowing(follower, justStopped)
	if (follower) then
		if (SlaveGirl.Data.LastFollowingTarget and SlaveGirl.Data.LastFollowingTarget == follower and justStopped) then
			SlaveGirl.DebugPrint("Ignore start following");
			return;
		end

		SlaveGirl_SendComm("F/S/"..follower);
		if (SlaveGirl.Data.LastFollowingTarget ~= follower) then
			SlaveGirl.Data.LastFollowingTarget = follower;
		end
	else
		SlaveGirl_SendComm("F/S");
	end
	if (SlaveGirl.Setting.StartFollowSound) then
		SlaveGirl_PlaySound("StartFollow");
	end
end

function SlaveGirl.StripRealm(sText)
	local result = sText;
	local i = string.find(result, "-");
	if (i) then
		result = string.sub(result, 1, i-1);
	end
	return result;
end

function SlaveGirl_Command_Debug()
		if (SlaveGirl.Data.DebugMode) then
		SlaveGirl.ChatPrint("Debug mode is off.")
		SlaveGirl.Data.DebugMode = nil;
	else
		SlaveGirl.ChatPrint("Debug mode is on.")
		SlaveGirl.Data.DebugMode = true;
	end
end
