--------------------------------------------------------------------------
-- Scheduler.lua 
--------------------------------------------------------------------------
--[[
Event Scheduling
]]--

function SlaveGirl.Schedule(sName, iDelayTime, bCombatOnly, functionEvent, ...)
	local name = sName;
	if not (name) then
		name = tostring(math.random());
	end
	
	local event = { 
		Name = name;
		Time = GetTime() + iDelayTime;
		Script = functionEvent;
		CombatOnly = bCombatOnly;
		Arguments = SlaveGirl.Pack(...);
	};
		
	SlaveGirl.ClearEvent(name);
	tinsert(SlaveGirl.ScheduleQueue, event);
	SlaveGirlFrame:SetScript("OnUpdate", SlaveGirl.OnUpdate);
end

function SlaveGirl.Timer(iDelayTime, sText)
	SlaveGirl.ChatPrint("Timer activated for "..iDelayTime.." seconds.");
	SlaveGirl.Schedule(nil, iDelayTime, false, SlaveGirl.QueueComm, sText);
end

function SlaveGirl.IsScheduled(sName)
	for index, event in pairs(SlaveGirl.ScheduleQueue) do
		if (event.Name == sName) then
			return true;
		end
	end
end

function SlaveGirl.ScheduledTimeLeft(sName)
	for index, event in pairs(SlaveGirl.ScheduleQueue) do
		if (event.Name == sName) then
			local amount = event.Time - GetTime();
			if (amount < 0) then
				amount = 0;
			end
			return amount;
		end
	end
	return 0;
end

function SlaveGirl.ClearQueue(bCombatOnly)
	if (bCombatOnly) then
		for i = #SlaveGirl.ScheduleQueue, 1, -1 do
			if (SlaveGirl.ScheduleQueue[i].CombatOnly == true) then
				SlaveGirl.DebugPrint("Clearing queue");
				table.remove(SlaveGirl.ScheduleQueue, i);
			end
		end
	else
		SlaveGirl.ScheduleQueue = { };	
	end
end

function SlaveGirl.ClearEvent(sName)
	for i = #SlaveGirl.ScheduleQueue, 1, -1 do
		if (SlaveGirl.ScheduleQueue[i].Name == sName) then
			SlaveGirl.DebugPrint("Removing event "..tostring(sName));
			table.remove(SlaveGirl.ScheduleQueue, i);
		end
	end
end

function SlaveGirl.ClearEventStartsWith(sName)
	for i = #SlaveGirl.ScheduleQueue, 1, -1 do
		if (SlaveGirl.ScheduleQueue[i].Name == sName) then
			SlaveGirl.DebugPrint("Removing event "..tostring(sName));
			table.remove(SlaveGirl.ScheduleQueue, i);
		end
	end
end

function SlaveGirl.OnUpdate()
	local currentTime = GetTime();
	for index, event in pairs(SlaveGirl.ScheduleQueue) do
		if (event.Time <= currentTime) then
			SlaveGirl.DebugPrint("Fire event "..tostring(event.Name));
			if (event.Script) then
				SlaveGirl.DebugPrint("Execute event function "..tostring(event.Name));
				event.Script(unpack(event.Arguments, 1, event.n));
			end
			SlaveGirl.ClearEvent(event.Name);
			SlaveGirl.OnUpdate();
			return;
		end
	end

	if (#SlaveGirl.ScheduleQueue <= 0) then
		SlaveGirlFrame:SetScript("OnUpdate", nil);
	end	
end

function SlaveGirl.Pack(...)
    return { n = select('#', ...), ... };
end
