function MultiFinder:CreateInfoTable(frame, group_Id)
    frame.InfoTable = { };
    local _, activityID, title, description, _, _, _, duration, _, _, _, _, leader = C_LFGList.GetSearchResultInfo(group_Id)

    --TopDPS.addDebugMessages({C_LFGList.GetSearchResultInfo(group_Id)})

    -- MultiFinder:Debug("CrateInfoTable");
    -- MultiFinder:Debug(group_Id);
    -- MultiFinder:Debug(title);
    -- MultiFinder:Debug(description);
    frame.InfoTable["bosses"] = C_LFGList.GetSearchResultEncounterInfo(group_Id);
    -- table

    frame.InfoTable["groupID"] = group_Id;
    frame.InfoTable["title"] = title;
    if activityID ~= nil then
        frame.InfoTable["type"] = C_LFGList.GetActivityInfo(activityID);
    end
    frame.InfoTable["description"] = description;
    frame.InfoTable["leader"] = leader;
    if duration ~= nil then
        frame.InfoTable["duration"] = duration;
    else
        frame.InfoTable["duration"] = 0;
    end
    local count = 0;
    frame.InfoTable["friends"] = { };
    local a = C_LFGList.GetSearchResultFriends(group_Id);
    if a ~= nil then
        for b, c in pairs(a) do
            frame.InfoTable["friends"][b] = c;
            count = count + 1;
        end
    end
    frame.InfoTable["friendsCount"] = count;

    frame.InfoTable["role"] = { };
    local a = C_LFGList.GetSearchResultMemberCounts(group_Id);
    if a ~= nil then
        for b, c in pairs(a) do
            frame.InfoTable["role"][b] = c;
        end
    end
end

function MultiFinder:CreateRoleTexture(texture, parent, xOf, yOf)
    local cIcon = parent:CreateTexture("roleCountBG" .. texture, "BACKGROUND");
    cIcon:SetTexture("Interface\\Icons\\" .. texture);
    cIcon:SetWidth(12)
    cIcon:SetHeight(12)
    cIcon:SetPoint("TOPRIGHT", parent, "TOPRIGHT", xOf, yOf);

    local tIcon = parent:CreateTexture("roleCountRorder", "MEDIUM");
    tIcon:SetTexture("Interface\\Minimap\\MiniMap-TrackingBorder");
    tIcon:SetWidth(36)
    tIcon:SetHeight(36)
    tIcon:SetPoint("TOPRIGHT", cIcon, "TOPRIGHT", 18, 3);

    local roleCount = parent:CreateFontString("roleCount", "OVERLAY");
    roleCount:SetPoint("TOPRIGHT", parent, "TOPRIGHT", xOf + 15, yOf - 3);
    roleCount:SetFont("Fonts\\FRIZQT__.TTF", 12);

    return roleCount;
end

function MultiFinder:SetDuration(duration)
    duration = duration or 0;
    local sec = math.floor(duration - math.floor(duration / 60) * 60);
    local hur = math.floor(duration / 3600);
    local min = math.floor(duration / 60) -60 * hur;

    function addZerro(val)
        if val < 10 then
            val = "0" .. val;
        end
        return val;
    end

    sec = addZerro(sec);
    hur = addZerro(hur);
    min = addZerro(min);
    duration = hur .. ":" .. min .. ":" .. sec;
    return duration;
end

------------------------------------------------------------------------------------------
function MultiFinder:CreateResult(frame, frameName, group_Id, index)
    if frame == nil then
        frame = CreateFrame("Button", frameName, MultiFinder.Results);
        -- MultiFinder.MainFrame);
        frame.width = MultiFinder.MainFrame:GetWidth();
        frame.height = 45;

        frame:SetFrameStrata("FULLSCREEN_DIALOG")
        frame:SetSize(frame.width, frame.height)
        frame:SetBackdrop( {
            bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
            -- edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
            tile = true,
            tileSize = 32,
            edgeSize = 32,
            insets = { left = 8, right = 8, top = 8, bottom = 8 }
        } )
        frame:SetBackdropColor(0, 0, 0, 1)
        frame:SetFrameStrata("LOW");
        frame:SetToplevel(true)
        frame:EnableMouse(true)
        -- frame:EnableMouseWheel(true)
        frame:SetMovable(true)
        frame:SetResizable(true)
        frame:EnableMouseWheel(true)
        frame:RegisterForClicks("AnyUp", "AnyDown")
        frame:SetPoint("TOPLEFT", MultiFinder.Results, "TOPLEFT", 0,(-1 *(index) * 30));
        --   -70);
        frame:SetUserPlaced(true)

        frame.Result_title = frame:CreateFontString("title", "OVERLAY");
        frame.Result_title:SetPoint("TOPLEFT", frame, "TOPLEFT", 10, -10);
        frame.Result_title:SetFont("Fonts\\FRIZQT__.TTF", 14, "THICKOUTLINE");
        frame.tancCount = MultiFinder:CreateRoleTexture("INV_Shield_04", frame, -95, -20)
        frame.healCount = MultiFinder:CreateRoleTexture("Spell_ChargePositive", frame, -60, -20)
        frame.dpsCount = MultiFinder:CreateRoleTexture("Ability_DualWield", frame, -25, -20)


        -- diration text
        frame.Result_duration = frame:CreateFontString("title", "OVERLAY");
        frame.Result_duration:SetPoint("TOPLEFT", frame, "TOPLEFT", 10, -22);
        frame.Result_duration:SetFont("Fonts\\FRIZQT__.TTF", 12);


    end


    -- //////////////////////////////////////////////////////

    frame:SetScript("OnShow", function(self)
        --MultiFinder:Debug("on show register");
        self:RegisterEvent("LFG_LIST_SEARCH_RESULT_UPDATED");
    end );
    frame:SetScript("OnHide", function(self)
        --MultiFinder:Debug("on hide unregister");
        self:UnregisterEvent("LFG_LIST_SEARCH_RESULT_UPDATED");
    end );


    -- trigered when group info is updated

    frame:SetScript("OnEvent", function(self, event, groupid)
       
        if (frame.InfoTable["groupID"] == groupid) then
            MultiFinder:Debug(self:GetName() .. " event trigered");
            if select(12,C_LFGList.GetSearchResultInfo(groupid)) == true then
                
                for a,c in pairs(MultiFinder.TempResultTable) do
                    if c == groupid then
                        table.remove(MultiFinder.TempResultTable,a);
                        break;
                    end
                end
                for a,c in pairs(MultiFinder.MainFrame.data_b) do
                    if c == groupid then
                        table.remove(MultiFinder.MainFrame.data_b,a);
                        break;
                    end
                end
                MultiFinder:lookForLFGMatchesCont(true);
                return;
            end
            
            MultiFinder:CreateInfoTable(self, groupid);
            frame.Result_duration:SetText(MultiFinder:SetDuration(frame.InfoTable["duration"]));
            -- frame.Result_title:SetText(frame.InfoTable["title"]);
            frame.tancCount:SetText(frame.InfoTable["role"]["TANK"]);
            frame.healCount:SetText(frame.InfoTable["role"]["HEALER"]);
            frame.dpsCount:SetText(frame.InfoTable["role"]["DAMAGER"]);
            frame.InfoTable["bosses"] = C_LFGList.GetSearchResultEncounterInfo(groupid);
            --if not self:IsVisible() == 1 then
            --    self:Show();
            --end
            -- table
        else
            local found = false;
            for a, c in pairs(MultiFinder.MainFrame.data_b) do
                if c == groupid then
                    found = true;
                    break;
                end;
            end
            if not found then
                table.insert(MultiFinder.MainFrame.data_b,groupid);
                MultiFinder:lookForLFGMatchesCont(true);
            end


        end
    end );


    frame:SetScript("OnUpdate", function(self, elapsed)
        self.InfoTable["duration"] = self.InfoTable["duration"] + elapsed;
        self.Result_duration:SetText(MultiFinder:SetDuration(self.InfoTable["duration"]));
    end );


    -- ///////////////////////////////////////////////////////

    MultiFinder:CreateInfoTable(frame, group_Id);
    if frame.InfoTable["friendsCount"] > 0 then
        frame.Result_title:SetTextColor(0.33, 0.83, 0.99, 1)
    else
        frame.Result_title:SetTextColor(0.8, 0.83, 0.25, 1)
    end

    frame.Result_duration:SetText(MultiFinder:SetDuration(frame.InfoTable["duration"]));



    frame.Result_title:SetText(frame.InfoTable["title"]);
    frame.tancCount:SetText(frame.InfoTable["role"]["TANK"]);
    frame.healCount:SetText(frame.InfoTable["role"]["HEALER"]);
    frame.dpsCount:SetText(frame.InfoTable["role"]["DAMAGER"]);



    frame:SetScript("OnEnter", function(self)
        GameTooltip_SetDefaultAnchor(GameTooltip, UIParent);
        GameTooltip:SetText(self.InfoTable["title"]);
        -- [, r [, g [, b [, a]]]])
        self.InfoTable["leader"] = self.InfoTable["leader"] or "";
        GameTooltip:AddLine("Leader: " .. self.InfoTable["leader"]);
        GameTooltip:AddLine("                                         " .. frame.InfoTable["type"]);
        GameTooltip:AddLine("-----------------------------------------------");
        function trim(s)
            return(s:gsub("^%s*(.-)%s*$", "%1"))
        end

        function devideString(str)
            local send = 45;
            if string.len(str) > send then

                send = string.find(str, " ", send);
                if not(send == nil) then
                    GameTooltip:AddLine(string.sub(str, 0, send));
                    devideString(string.sub(str, send));
                else
                    GameTooltip:AddLine(trim(str));
                end
            else
                GameTooltip:AddLine(trim(str));
            end
        end
        if string.len(self.InfoTable["description"]) >= 1 then
            devideString(self.InfoTable["description"]);
        end
        GameTooltip:AddLine("-----------------------------------------------");


        if frame.InfoTable["friendsCount"] > 0 then
            GameTooltip:AddLine("Friends: ");
            for a, b in pairs(self.InfoTable["friends"]) do
                GameTooltip:AddLine("       " .. b);
            end
        end

        for a, b in pairs(self.InfoTable["role"]) do
            if not(a == "DAMAGER") and not(a == "HEALER") and not(a == "TANK") and not(a == "NOROLE") then
                GameTooltip:AddLine(a .. ": " .. b);
            end
        end
        GameTooltip:AddLine("-----------------------------------------------");
        GameTooltip:AddLine("NOROLE: " .. self.InfoTable["role"]["NOROLE"]);
        if not(self.InfoTable["bosses"] == nil) then
            GameTooltip:AddLine("-----------------------------------------------");
            GameTooltip:AddLine("BOSSES DEFEATED:");

            for a, b in pairs(self.InfoTable["bosses"]) do
                GameTooltip:AddLine(" " .. b);
            end
        end
        GameTooltip:Show();
    end
    );

    frame:SetScript("OnLeave", function()
        GameTooltip:Hide()
    end
    );
    frame:SetScript("OnClick", function(self, button, down)
        if button == "LeftButton" then
            -- if MultiFinder.MainFrame.Role_Tank or MultiFinder.MainFrame.Role_Heal or MultiFinder.MainFrame.Role_DPS then
            C_LFGList.ApplyToGroup(self.InfoTable["groupID"], "", MultiFinder.MainFrame.Role_Tank, MultiFinder.MainFrame.Role_Heal, MultiFinder.MainFrame.Role_DPS)

            --        else
            --            LFGListApplicationDialog:Show();
            --           --frame:RegisterEvent("LFG_LIST_SEARCH_RESULT_UPDATED");
            --           frame:SetScript("OnEvent", function()
            --                MultiFinder.MainFrame.Role_Tank = LFGListApplicationDialog.TankButton.CheckButton:GetChecked();
            --                MultiFinder.MainFrame.Role_Heal = LFGListApplicationDialog.HealerButton.CheckButton:GetChecked();
            --                MultiFinder.MainFrame.Role_DPS  = LFGListApplicationDialog.DamagerButton.CheckButton:GetChecked();
            --                C_LFGList.ApplyToGroup(group_Id, "", MultiFinder.MainFrame.Role_Tank, MultiFinder.MainFrame.Role_Heal, MultiFinder.MainFrame.Role_DPS)
            --           end);
            --        end
        else
            ChatFrame1EditBox:SetText("/tell " .. self.InfoTable["leader"] .. " ");
            ChatFrame1EditBox:Show();
            ChatFrame1EditBox:SetFocus();
        end

    end )

    MultiFinder.MainFrame.results[index] = frame;
    frame:Show();

end 

