
--  Search Edit box

function MultiFinder:CreateEditBoxFrame(frame_name, parent, value, width, height, x_ofset, y_ofset)

    local frame = CreateFrame("EditBox", frame_name, parent, "InputBoxTemplate")
    frame:SetPoint("TOPLEFT", parent, "TOPLEFT", x_ofset, y_ofset)
    frame:SetText(value)
    frame:SetWidth(width)
    frame:SetHeight(height)
    frame:SetAttribute("virtual", true)
    frame:EnableMouse(true)
    frame:SetAutoFocus(false)
    frame:SetScript("OnEnterPressed", function(self)
        frame:ClearFocus();
        MultiFinder:lookForLFGMatches(true);
    end );
    -- frame:SetScript("OnTextChanged", function(self, userInput)
    --    MultiFinder:lookForLFGMatches(true);
    -- end );

    frame:Hide()

    return frame
end
    
------
function MultiFinder:InitSavedVariables(reset)
    -- ChatFrame1:AddMessage("InitSavedVariables");
    if MultiFinderSavedVariables == nil or reset then
        MultiFinderSavedVariables = { };
        MultiFinderSavedVariables["T"] = false;
        MultiFinderSavedVariables["H"] = false;
        MultiFinderSavedVariables["D"] = false;
        MultiFinderSavedVariables["Search"] = "separate serch words with ','   EX: ,+8,+9,+10";
        MultiFinderSavedVariables["SearchID"] = 2;
        MultiFinderSavedVariables["X"] = 200;
        MultiFinderSavedVariables["Y"] = -200;
    end
    MultiFinder.MainFrame.Role_Tank = MultiFinderSavedVariables["T"];
    if not MultiFinder.MainFrame.Role_Tank then
        MultiFinder_Role_T:UnlockHighlight();
    end
    MultiFinder.MainFrame.Role_Heal = MultiFinderSavedVariables["H"];
    if not MultiFinder.MainFrame.Role_Heal then
        MultiFinder_Role_H:UnlockHighlight();
    end
    MultiFinder.MainFrame.Role_DPS = MultiFinderSavedVariables["D"];
    if not MultiFinder.MainFrame.Role_DPS then
        MultiFinder_Role_D:UnlockHighlight();
    end
    MultiFinder.MainFrame.Box:SetText(MultiFinderSavedVariables["Search"]);

    MultiFinder.MainFrame.SearchID = MultiFinderSavedVariables["SearchID"];

    MultiFinder.MainFrame.Search_Category.title:SetText(C_LFGList.GetCategoryInfo(MultiFinder.MainFrame.SearchID));
    MultiFinder.MainFrame.X = MultiFinderSavedVariables["X"];
    MultiFinder.MainFrame.Y = MultiFinderSavedVariables["Y"];
    MultiFinder.MainFrame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", MultiFinder.MainFrame.X, MultiFinder.MainFrame.Y);


end

function MultiFinder:SaveSavedVariables()
    -- ChatFrame1:AddMessage("SaveSavedVariables");
    if MultiFinderSavedVariables == nil then
        MultiFinderSavedVariables = { };
    end
    MultiFinderSavedVariables["T"] = MultiFinder.MainFrame.Role_Tank;
    MultiFinderSavedVariables["H"] = MultiFinder.MainFrame.Role_Heal;
    MultiFinderSavedVariables["D"] = MultiFinder.MainFrame.Role_DPS;
    MultiFinderSavedVariables["Search"] = MultiFinder.MainFrame.Box:GetText();
    MultiFinderSavedVariables["SearchID"] = MultiFinder.MainFrame.SearchID;
    MultiFinderSavedVariables["X"] = MultiFinder.MainFrame.X;
    MultiFinderSavedVariables["Y"] = MultiFinder.MainFrame.Y;
end

-- Creates Role check Buttons
function MultiFinder:CreateRoleCheckBtn(cFrame, name, boolean, parent, texture, xOfset, yOfset)
    cFrame = CreateFrame("CheckButton", name, MultiFinder.MainFrame);
    cFrame:SetWidth(31);
    cFrame:SetHeight(31);
    cFrame:SetFrameStrata("LOW");
    cFrame:SetToplevel(true);
    -- cFrame:SetHighlightTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight");
    cFrame:SetHighlightTexture("Interface\\PVPFrame\\Icons\\PVP-Banner-Emblem-73");
    -- cFrame:SetMovable(true)
    cFrame:SetPoint("TOPRIGHT", parent, "TOPRIGHT", xOfset, yOfset);
    -- cFrame:SetUserPlaced(true)
    cFrame:SetEnabled(boolean);
    if not boolean then
        cFrame:Hide();
    else
        cFrame:LockHighlight();
    end

    local cIcon = cFrame:CreateTexture("RoleCheckTexture", "BACKGROUND");
    cIcon:SetTexture("Interface\\Icons\\" .. texture);
    cIcon:SetWidth(20)
    cIcon:SetHeight(20)
    cIcon:SetPoint("TOPLEFT", cFrame, "TOPLEFT", 7, -5);
    cFrame:RegisterForClicks("LeftButtonUp", "RightButtonUp");
    cFrame:RegisterForDrag("LeftButton");

    local cIcon = cFrame:CreateTexture("RoleCheckTexture", "BORDER");
    cIcon:SetTexture("Interface\\Minimap\\MiniMap-TrackingBorder");
    cIcon:SetWidth(50)
    cIcon:SetHeight(50)
    cIcon:SetPoint("TOPLEFT", cFrame, "TOPLEFT", 0, 0);

end


-- Creates Search Selection cattegories
function MultiFinder:CreateAvailableSearch(id, parent, xOf, yOf)
    local title = C_LFGList.GetCategoryInfo(id);
    local SearchBTN = CreateFrame("Button", "Search_" .. id .. title, parent.Search_Category_Frame)
    SearchBTN:SetPoint("TOPLEFT", parent.Search_Category_Frame, "TOPLEFT", xOf, yOf);
    SearchBTN.width = 130;
    SearchBTN.height = 20;
    SearchBTN:SetHeight(SearchBTN.height)
    SearchBTN:SetWidth(SearchBTN.width);
    SearchBTN:SetBackdrop( {
        bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
        -- edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
        tile = true,
        tileSize = 32,
        edgeSize = 32,
        insets = { left = 0, right = 0, top = 0, bottom = 0 }
    } );

    SearchBTN.id = id;

    SearchBTN.title = SearchBTN:CreateFontString(title .. id, "OVERLAY");
    SearchBTN.title:SetPoint("CENTER", SearchBTN, "CENTER", 0, 0);
    SearchBTN.title:SetFont("Fonts\\FRIZQT__.TTF", 12);
    SearchBTN.title:SetText(title);

    SearchBTN:SetScript("OnClick", function(self) MultiFinder.MainFrame.SearchID = self.id; parent.Search_Category.title:SetText(self.title:GetText()); parent.Search_Category_Frame:Hide(); MultiFinder:lookForLFGMatches(true); end);


end
-------------------------------------------------------------------------------------



-- function Wait(self, elapsed)
--    MultiFinder.waitTime = MultiFinder.waitTime + elapsed
--    if MultiFinder.waitTime >= 1 then
--        DEFAULT_CHAT_FRAME:AddMessage("ping!")
--    end
-- end



-- function MultiFinder:Wait(frame, index, time, f)
--    frame[index] = frame[index] or CreateFrame("frame", "MultiFinder_deleayFrame" .. index, UIParent)
--    frame[index].waitTime = 0;
--    local function Wait(self, elapsed)
--        frame[index].waitTime = frame[index].waitTime + elapsed;
--        if frame[index].waitTime >= time then
--            MultiFinder:Debug("click");
--            pcall(f);
--            frame[index]:SetScript("OnUpdate", nil);
--        end
--    end

--    frame[index]:SetScript("OnUpdate", Wait);
-- end



-- function MultiFinder:WaitForLFGFrames()
--    LFDMicroButton:Click();
--    GroupFinderFrameGroupButton4:Click();
--    MultiFinder.delayFrames = { };
--    MultiFinder:Wait(MultiFinder.delayFrames, 1, 1, function() LFGListFrame.CategorySelection.CategoryButtons[5]:Click() end);
--    MultiFinder:Wait(MultiFinder.delayFrames, 2, 2, function() LFGListFrame.CategorySelection.FindGroupButton:Click() end);
--    MultiFinder:Wait(MultiFinder.delayFrames, 3, 6, function() LFGListFrame.SearchPanel.RefreshButton:Click() end);
--    MultiFinder:Wait(MultiFinder.delayFrames, 4, 7, function() LFDMicroButton:Click(); end);
--    --LFDMicroButton:Click();
--    MultiFinder:Debug("WaitForLFGFrames()  ... Sucess ...");
-- end



function MultiFinder:CreateMainFrame()




    MultiFinder.MainFrame = MultiFinder.MainFrame or CreateFrame("Frame", "MultiFinder_MainFrame", UIParent);
    -- MultiFinder:WaitForLFGFrames();

    MultiFinder.MainFrame.results = MultiFinder.MainFrame.results or { };


    MultiFinder.MainFrame.width = math.max(UIParent:GetWidth() / 5, 256);
    MultiFinder.MainFrame.height = 75;
    MultiFinder.MainFrame:SetFrameStrata("FULLSCREEN_DIALOG");
    MultiFinder.MainFrame:SetSize(MultiFinder.MainFrame.width, MultiFinder.MainFrame.height)
    MultiFinder.MainFrame:SetBackdrop( {
        bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
        edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
        tile = true,
        tileSize = 32,
        edgeSize = 32,
        insets = { left = 8, right = 8, top = 8, bottom = 8 }
    } );


    MultiFinder.MainFrame:SetBackdropColor(0, 0, 0, 1);
    MultiFinder.MainFrame:SetFrameStrata("LOW");
    MultiFinder.MainFrame:SetToplevel(true);
    MultiFinder.MainFrame:EnableMouse(true);
    MultiFinder.MainFrame:EnableMouseWheel(true);
    MultiFinder.MainFrame:SetMovable(true);
    MultiFinder.MainFrame:SetResizable(true);


    MultiFinder.MainFrame:SetUserPlaced(true);
    MultiFinder.MainFrame:RegisterForDrag("LeftButton");
    MultiFinder.MainFrame:SetScript("OnDragStart", MultiFinder.MainFrame.StartMoving);
    MultiFinder.MainFrame:SetScript("OnDragStop",
    function(self)
        -- point, relativeTo, relativePoint, xOffset, yOffset = Region:GetPoint(index)
        _, _, _, MultiFinder.MainFrame.X, MultiFinder.MainFrame.Y = MultiFinder.MainFrame:GetPoint(0);
        -- ChatFrame1:AddMessage(MultiFinder.MainFrame.X .. ",".. MultiFinder.MainFrame.Y);
        MultiFinder.MainFrame:StopMovingOrSizing();
    end
    );

    -- =====Registered Events======================================================================
    -- MultiFinder.MainFrame:RegisterEvent("LFG_LIST_SEARCH_RESULT_UPDATED");
    MultiFinder.MainFrame:RegisterEvent("LFG_LIST_SEARCH_RESULTS_RECEIVED");

    MultiFinder.MainFrame:RegisterEvent("PLAYER_LOGOUT");

    MultiFinder.MainFrame:SetScript("OnEvent", function(arg1, event, arg3)

        if event == "LFG_LIST_SEARCH_RESULTS_RECEIVED" then
            MultiFinder:lookForLFGMatchesCont(false);
        end
        if event == "PLAYER_LOGOUT" then
            MultiFinder:SaveSavedVariables();
        end
    end );





    MultiFinder.MainFrame.title = MultiFinder.MainFrame:CreateFontString("title", "OVERLAY");
    MultiFinder.MainFrame.title:SetPoint("TOPLEFT", MultiFinder.MainFrame, "TOPLEFT", 10, -10);
    MultiFinder.MainFrame.title:SetFont("Fonts\\FRIZQT__.TTF", 20, "THICKOUTLINE");
    MultiFinder.MainFrame.title:SetText("MultiFinder");

    MultiFinder.MainFrame.Box = MultiFinder:CreateEditBoxFrame("MultiFinder_MainFrame_Box", MultiFinder.MainFrame, "doom,ven,terr,death", MultiFinder.MainFrame:GetWidth() -20, 25, 12, -25);
    MultiFinder.MainFrame.Box:Show();


    MultiFinder.MainFrame.Role_Tank, MultiFinder.MainFrame.Role_Heal, MultiFinder.MainFrame.Role_DPS = C_LFGList.GetAvailableRoles();

    MultiFinder:CreateRoleCheckBtn(MultiFinder_Role_T, "MultiFinder_Role_T", MultiFinder.MainFrame.Role_Tank,
    MultiFinder.MainFrame, "INV_Shield_04", -70, -2)
    MultiFinder_Role_T:SetScript("OnClick", function()
        if MultiFinder.MainFrame.Role_Tank then
            MultiFinder.MainFrame.Role_Tank = false;
            MultiFinder_Role_T:UnlockHighlight();
        else
            MultiFinder.MainFrame.Role_Tank = true;
            MultiFinder_Role_T:LockHighlight();
        end
    end );
    MultiFinder:CreateRoleCheckBtn(MultiFinder_Role_H, "MultiFinder_Role_H", MultiFinder.MainFrame.Role_Heal,
    MultiFinder.MainFrame, "Spell_ChargePositive", -40, -2)
    MultiFinder_Role_H:SetScript("OnClick", function()
        if MultiFinder.MainFrame.Role_Heal then
            MultiFinder.MainFrame.Role_Heal = false;
            MultiFinder_Role_H:UnlockHighlight();
        else
            MultiFinder.MainFrame.Role_Heal = true;
            MultiFinder_Role_H:LockHighlight();
        end
    end );
    MultiFinder:CreateRoleCheckBtn(MultiFinder_Role_D, "MultiFinder_Role_D", MultiFinder.MainFrame.Role_DPS,
    MultiFinder.MainFrame, "Ability_DualWield", -10, -2)
    MultiFinder_Role_D:SetScript("OnClick", function()
        if MultiFinder.MainFrame.Role_DPS then
            MultiFinder.MainFrame.Role_DPS = false;
            MultiFinder_Role_D:UnlockHighlight();
        else
            MultiFinder.MainFrame.Role_DPS = true;
            MultiFinder_Role_D:LockHighlight();
        end
    end );



    MultiFinder.MainFrame.searching_in_lable = MultiFinder.MainFrame:CreateFontString("MultiFinder.MainFrame.searching_in_lable", "OVERLAY");
    MultiFinder.MainFrame.searching_in_lable:SetPoint("BOTTOMLEFT", MultiFinder.MainFrame, "BOTTOMLEFT", 15, 12);
    MultiFinder.MainFrame.searching_in_lable:SetFont("Fonts\\FRIZQT__.TTF", 12);
    MultiFinder.MainFrame.searching_in_lable:SetText("Search in:");




    MultiFinder.MainFrame.Search_Category_Frame = CreateFrame("Frame", "MultiFinder.MainFrame.Search_Category_Frame", MultiFinder.MainFrame)
    MultiFinder.MainFrame.Search_Category_Frame:SetPoint("TOPLEFT", MultiFinder.MainFrame, "TOPRIGHT", 0, -20);
    MultiFinder.MainFrame.Search_Category_Frame:SetHeight(180)
    MultiFinder.MainFrame.Search_Category_Frame:SetWidth(130);
    MultiFinder.MainFrame.Search_Category_Frame:SetBackdrop( {
        bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
        -- edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
        tile = true,
        tileSize = 32,
        edgeSize = 32,
        insets = { left = 0, right = 0, top = 0, bottom = 0 }
    } );
    MultiFinder.MainFrame.Search_Category_Frame:Hide();



    MultiFinder.MainFrame.Search_Category = CreateFrame("Button", "MultiFinder.MainFrame.Search_Category", MultiFinder.MainFrame)
    MultiFinder.MainFrame.Search_Category:SetPoint("BOTTOMRIGHT", MultiFinder.MainFrame, "BOTTOMRIGHT", -12, 9);
    MultiFinder.MainFrame.Search_Category.width = 130;
    MultiFinder.MainFrame.Search_Category.height = 19;
    MultiFinder.MainFrame.Search_Category:SetHeight(MultiFinder.MainFrame.Search_Category.height);
    MultiFinder.MainFrame.Search_Category:SetWidth(MultiFinder.MainFrame.Search_Category.width);
    MultiFinder.MainFrame.Search_Category:SetBackdrop( {
        bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
        -- edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
        tile = true,
        tileSize = 32,
        edgeSize = 32,
        insets = { left = 0, right = 0, top = 0, bottom = 0 }
    } );
    MultiFinder.MainFrame.Search_Category.title = MultiFinder.MainFrame.Search_Category:CreateFontString("Search_Category_title", "OVERLAY");
    MultiFinder.MainFrame.Search_Category.title:SetPoint("CENTER", MultiFinder.MainFrame.Search_Category, "CENTER", 0, 0);
    MultiFinder.MainFrame.Search_Category.title:SetFont("Fonts\\FRIZQT__.TTF", 12);
    MultiFinder.MainFrame.Search_Category.title:SetText("Custom");
    MultiFinder.MainFrame.Search_Category.parent = MultiFinder.MainFrame;
    MultiFinder.MainFrame.Search_Category.frame = MultiFinder.MainFrame.Search_Category_Frame;
    MultiFinder.MainFrame.Search_Category:SetScript("OnClick", function(self) if self.frame:IsShown() then self.frame:Hide() else self.frame:Show(); end end);


    MultiFinder.MainFrame.SearchID = 6;
    MultiFinder:CreateAvailableSearch(9, MultiFinder.MainFrame, 0, 0)
    MultiFinder:CreateAvailableSearch(7, MultiFinder.MainFrame, 0, -20)
    MultiFinder:CreateAvailableSearch(8, MultiFinder.MainFrame, 0, -40)
    MultiFinder:CreateAvailableSearch(2, MultiFinder.MainFrame, 0, -60)
    MultiFinder:CreateAvailableSearch(1, MultiFinder.MainFrame, 0, -80)
    MultiFinder:CreateAvailableSearch(10, MultiFinder.MainFrame, 0, -100)
    MultiFinder:CreateAvailableSearch(4, MultiFinder.MainFrame, 0, -120)
    MultiFinder:CreateAvailableSearch(6, MultiFinder.MainFrame, 0, -140)
    MultiFinder:CreateAvailableSearch(3, MultiFinder.MainFrame, 0, -160)

    MultiFinder:InitSavedVariables(false)



    MultiFinder:CreateResults();


end  