-- MrGearSet 

-- Changelog
-- v1.1 Fixed a bug where the addon was triggering from other people casting spec changes
-- v1.1.1 Fixed a bug preventing the addon from detecting Retribution spec changes
-- v1.1.2 Recode/tidy of the CharacterFrame and Options screen buttons
-- v1.1.3 Move button to left side of character screen to stop the button being un clickable from certain tabs
-- v1.1.4 Add FrameStrata to Character panel button. This prevents certain addons from drawing over the top (e.g. ElvUI Shadow and Light)
-- v1.1.6 Fixed Typo preventing Subtlety Rogues from swapping gear

-- known issue. If player deletes all gear sets the MGS options screen doenst remove the drop down text or check button


MGSversion = "1.1.3"

--Load saved variables
local frame = CreateFrame("FRAME", "MrGearSetFrame");
frame:RegisterEvent("PLAYER_ENTERING_WORLD");
local function eventHandler(self, event, ...)
	if MRGEARSET_GEARSET1 then
		gearset1 = MRGEARSET_GEARSET1
	end
	if MRGEARSET_GEARSET2 then
		gearset2 = MRGEARSET_GEARSET2
	end
	if MRGEARSET_GEARSET3 then
		gearset3 = MRGEARSET_GEARSET3
	end
	if MRGEARSET_GEARSET4 then
		gearset4 = MRGEARSET_GEARSET4
	end
end
frame:SetScript("OnEvent", eventHandler);

--Event Handler to detect when player changes spec
local MGSdetectSpecSwap = CreateFrame("FRAME", "MGSDetectSpecSwap");
MGSdetectSpecSwap:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
function detectSpecSwap(self, event, ...)
	local unitID, spell, rank, lineID, spellID = select(1, ...)
	if spell == "Activating Specialization" and unitID == "player" then
	--print(unitID, "changed spec")
	MGSSwapGear()
	end
end	
MGSdetectSpecSwap:SetScript("OnEvent", detectSpecSwap);

--Function to swap gear set
function MGSSwapGear()
	local currentSpec = GetSpecialization()
	local currentSpecName = currentSpec and select(2, GetSpecializationInfo(currentSpec)) or "None"
	if currentSpecName == specs[1] and MRGEARSET_DD1 == true then gearswap = gearset1
	elseif currentSpecName == specs[2] and MRGEARSET_DD2 == true then gearswap = gearset2
	elseif currentSpecName == specs[3] and MRGEARSET_DD3 == true then gearswap = gearset3
	elseif currentSpecName == specs[4] and MRGEARSET_DD4 == true then gearswap = gearset4
	else gearswap = nil
	end	
	print("|cFFFFFF00MR. GEAR SET: Specialization changed to|r", currentSpecName)
	if gearswap ~= nil then
		print("|cFFFFFF00Changing Gear set to|r", gearswap)
		UseEquipmentSet(gearswap)
	end
	
end

--add button to character frame
local MGSGearSetsButton = CreateFrame("button", "MGSOptionsButton", PaperDollFrame, "UIPanelButtonTemplate")
MGSGearSetsButton:SetSize(80 ,22) -- width, height
MGSGearSetsButton:SetText("Mr. Gear Set")
MGSGearSetsButton:SetPoint("BOTTOMLEFT", PaperDollItemsFrame, "BOTTOMLEFT", 5,5)
MGSGearSetsButton:SetFrameStrata("FULLSCREEN")
--MGSGearSetsButton:SetPoint("BOTTOM", CharacterFrameInsetRight, "BOTTOM", 0,0)
MGSGearSetsButton:SetScript("OnClick", function()
    InterfaceOptionsFrame_OpenToCategory("Controls")
	InterfaceOptionsFrame_OpenToCategory("Mr Gear Set")
	MrGearSetDropdown1()
	MrGearSetDropdown2()
	MrGearSetDropdown3()
	MrGearSetDropdown4()
	MGSCheckSets()
end)

-- Slash Commands
SLASH_MRGEARSET1 = '/mgs';
local function handler(param, editbox)
  	InterfaceOptionsFrame_OpenToCategory("Controls")
	InterfaceOptionsFrame_OpenToCategory("Mr Gear Set") -- sometimes the blizz options panel doesnt go to the right page.. this forces it to go to the right page
	MrGearSetDropdown1()
	MrGearSetDropdown2()
	MrGearSetDropdown3()
	MrGearSetDropdown4()
	MGSCheckSets()
 end
SlashCmdList["MRGEARSET"] = handler;

--set up options screen
mrgearset = CreateFrame("Frame", "mrgearsetoptions", InterfaceOptionsFramePanelContainer)
mrgearset:Hide()
mrgearset.name = "Mr Gear Set"
title = mrgearset:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge")
title:SetPoint("TOPLEFT", 16, -16)
title:SetText("Mr Gear Set " ..MGSversion) 
InterfaceOptions_AddCategory(mrgearset)
MrGearSetOptionsTxt = ("|cFFFFFF00By Vohl - Tarren Mill (EU)|r")
MrGearSetOptionsText = mrgearsetoptions:CreateFontString("MrGearSetOptionsText", "ARTWORK", "GameFontHighlight")
MrGearSetOptionsText:SetPoint("TOPLEFT", mrgearsetoptions, 20, -50)
MrGearSetOptionsText:SetText(MrGearSetOptionsTxt)
MGSGotoEquipmentManager = CreateFrame("button", "MGSGotoEquipmentManagerOptionsButton", mrgearsetoptions, "UIPanelButtonTemplate")
		MGSGotoEquipmentManager:SetSize(160 ,22) -- width, height
		MGSGotoEquipmentManager:SetText("Open Equipement Manager")
		MGSGotoEquipmentManager:SetPoint("TOP", MrGearSetOptionsText, "BOTTOM", 10,-10)
		MGSGotoEquipmentManager:SetScript("OnClick", function()
			if CharacterFrame:IsVisible() then
				CharacterFrameTab1:Click("LeftButton", down)
				PaperDollSidebarTab3:Click("LeftButton", down)
				--CharacterStatsPane:Hide()
				--PaperDollEquipmentManagerPane:Show()
				InterfaceOptionsFrame:Hide()
			else
				ToggleCharacter("PaperDollFrame")
				PaperDollSidebarTab3:Click("LeftButton", down)
				--CharacterStatsPane:Hide()
				--PaperDollEquipmentManagerPane:Show()
				InterfaceOptionsFrame:Hide()
			end			
		end)

--Check if player has some gear sets created
function MGSCheckSets()
local MrGearSetOptionsNoSets = ("|cFFFF0000You have no gear sets. Please create some to use this addon|r")
	if GetNumEquipmentSets() == 0 then 
		gearset1 = nil
		gearset2 = nil
		gearset3 = nil
		gearset4 = nil
		MRGEARSET_DD1 = nil
		MRGEARSET_DD2 = nil
		MRGEARSET_DD3 = nil
		MRGEARSET_DD4 = nil
		MrGearSetOptionsNoSetsText = mrgearsetoptions:CreateFontString("MrGearSetOptionsNoSetsText", "ARTWORK", "GameFontHighlight")
		MrGearSetOptionsNoSetsText:SetPoint("TOPLEFT", mrgearsetoptions, 20, -110)
		MrGearSetOptionsNoSetsText:SetText(MrGearSetOptionsNoSets)
		else if GetNumEquipmentSets() >= 1 and MrGearSetOptionsNoSetsText then
			MrGearSetOptionsNoSetsText:Hide()
		end
	end
end

playerClass = UnitClass("player")
	if playerClass == "Warlock"
		then specs = {
		"Affliction",
		"Demonology",
		"Destruction",
		}
	elseif playerClass == "Druid"
		then specs = {
		"Balance",
		"Restoration",
		"Feral",
		"Guardian",
		}
	elseif playerClass == "Death Knight"
		then specs = {
		"Blood",
		"Frost",
		"Unholy",
		}
	elseif playerClass == "Demon Hunter"
		then specs = {
		"Havoc",
		"Vengeance",
		}
	elseif playerClass == "Hunter"
		then specs = {
		"Beast Mastery",
		"Marksmanship",
		"Survival",
		}
	elseif playerClass == "Mage"
		then specs = {
		"Arcane",
		"Fire",
		"Frost",
		}
	elseif playerClass == "Paladin"
		then specs = {
		"Holy",
		"Retribution",
		"Protection",
		}
	elseif playerClass == "Priest"
		then specs = {
		"Discipline",
		"Holy",
		"Shadow",
		}
	elseif playerClass == "Rogue"
		then specs = {
		"Assassination",
		"Outlaw",
		"Subtlety",
		}
	elseif playerClass == "Shaman"
		then specs = {
		"Restoration",
		"Elemental",
		"Enhancement",
		}
	elseif playerClass == "Warrior"
		then specs = {
		"Arms",
		"Fury",
		"Protection",
		}
	elseif playerClass == "Monk"
		then specs = {
		"Brewmaster",
		"Mistweaver",
		"Windwalker",
		}
end

DropDownMenu1txt = specs[1]
DropDownMenu2txt = specs[2]
DropDownMenu3txt = specs[3]
DropDownMenu4txt = specs[4]


function MrGearSetDropdown1()
if GetNumEquipmentSets() == 0 and DropDownMenu1 and DropDownMenu1txt and btnMGSDropDownMenu1 then 
DropDownMenu1:Hide()
DropDownMenu1txt:Hide()
btnMGSDropDownMenu1:Hide()
return end

if GetNumEquipmentSets() == 0 then 
return end

if not DropDownMenu1 then
   CreateFrame("Button", "DropDownMenu1", mrgearsetoptions, "UIDropDownMenuTemplate")
	if MRGEARSET_DD1 == nil then UIDropDownMenu_DisableDropDown(DropDownMenu1)
		else UIDropDownMenu_EnableDropDown(DropDownMenu1)
	end
end

DropDownMenu1:ClearAllPoints()
DropDownMenu1:SetPoint("TOPLEFT", 2, -120)
DropDownMenu1:Show()
DropDownMenu1txt = mrgearsetoptions:CreateFontString("DropDownMenu1txt", "ARTWORK", "GameFontHighlight")
DropDownMenu1txt:SetPoint("BOTTOMLEFT", DropDownMenu1, "TOPLEFT", 20, 1)
DropDownMenu1txt:SetText(specs[1])

btnMGSDropDownMenu1 = CreateFrame("CheckButton", "MGSDropDownMenu1button", mrgearsetoptions, "OptionsBaseCheckButtonTemplate")
btnMGSDropDownMenu1:SetPoint("LEFT", DropDownMenu1, "RIGHT", -10, 2)
btnMGSDropDownMenu1:SetScript("OnClick", function(frame)
	if frame:GetChecked() then
		PlaySound(SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_ON)
		UIDropDownMenu_EnableDropDown(DropDownMenu1)
		MRGEARSET_DD1 = true
	else
		PlaySound(SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_OFF)
		UIDropDownMenu_DisableDropDown(DropDownMenu1)
		MRGEARSET_DD1 = nil
	end
end)
btnMGSDropDownMenu1:SetScript("OnUpdate", function(frame)
	frame:SetChecked(MRGEARSET_DD1)
end)

local function OnClick(self, arg1)
   UIDropDownMenu_SetSelectedID(DropDownMenu1, self:GetID())
   gearset1 = arg1
   MRGEARSET_GEARSET1 = arg1
end
 
local function initialize(self, level)
   local info = UIDropDownMenu_CreateInfo()
		for i = 1, GetNumEquipmentSets() do
		local name, icon, setID, isEquipped, totalItems, equippedItems, inventoryItems, missingItems, ignoredSlots = GetEquipmentSetInfo(i)
		  info = UIDropDownMenu_CreateInfo()
		  info.text = name
		  info.icon = icon
		  info.func = OnClick
		  info.arg1 = name
		  UIDropDownMenu_AddButton(info, level)
	end
end
 
UIDropDownMenu_Initialize(DropDownMenu1, initialize)
UIDropDownMenu_SetWidth(DropDownMenu1, 100);
UIDropDownMenu_SetButtonWidth(DropDownMenu1, 124)
if gearset1 == nil then
	UIDropDownMenu_SetText(DropDownMenu1, "--Select a Set--")
	else UIDropDownMenu_SetSelectedName(DropDownMenu1, gearset1)
end
UIDropDownMenu_JustifyText(DropDownMenu1, "LEFT")
end

function MrGearSetDropdown2()
if GetNumEquipmentSets() == 0 and DropDownMenu2 and DropDownMenu2txt and btnMGSDropDownMenu2 then 
DropDownMenu2:Hide()
DropDownMenu2txt:Hide()
btnMGSDropDownMenu2:Hide()
return end

if GetNumEquipmentSets() == 0 then 
return end

if not DropDownMenu2 then
   CreateFrame("Button", "DropDownMenu2", mrgearsetoptions, "UIDropDownMenuTemplate")
	if MRGEARSET_DD2 == nil then UIDropDownMenu_DisableDropDown(DropDownMenu2)
		else UIDropDownMenu_EnableDropDown(DropDownMenu2)
	end
end

DropDownMenu2:ClearAllPoints()
DropDownMenu2:SetPoint("TOPLEFT", 2, -180)
DropDownMenu2:Show()
DropDownMenu2txt = mrgearsetoptions:CreateFontString("DropDownMenu2txt", "ARTWORK", "GameFontHighlight")
DropDownMenu2txt:SetPoint("BOTTOMLEFT", DropDownMenu2, "TOPLEFT", 20, 1)
DropDownMenu2txt:SetText(specs[2])

btnMGSDropDownMenu2 = CreateFrame("CheckButton", "MGSDropDownMenu2button", mrgearsetoptions, "OptionsBaseCheckButtonTemplate")
btnMGSDropDownMenu2:SetPoint("LEFT", DropDownMenu2, "RIGHT", -10, 2)
btnMGSDropDownMenu2:SetScript("OnClick", function(frame)
	if frame:GetChecked() then
		PlaySound(SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_ON)
		UIDropDownMenu_EnableDropDown(DropDownMenu2)
		MRGEARSET_DD2 = true
	else
		PlaySound(SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_OFF)
		UIDropDownMenu_DisableDropDown(DropDownMenu2)
		MRGEARSET_DD2 = nil
	end
end)
btnMGSDropDownMenu2:SetScript("OnUpdate", function(frame)
	frame:SetChecked(MRGEARSET_DD2)
end)

local function OnClick(self, arg1)
   UIDropDownMenu_SetSelectedID(DropDownMenu2, self:GetID())
   gearset2 = arg1
   MRGEARSET_GEARSET2 = arg1
end
 
local function initialize(self, level)
   local info = UIDropDownMenu_CreateInfo()
		for i = 1, GetNumEquipmentSets() do
	    local name, icon, setID, isEquipped, totalItems, equippedItems, inventoryItems, missingItems, ignoredSlots = GetEquipmentSetInfo(i)
		  info = UIDropDownMenu_CreateInfo()
		  info.text = name
		  info.icon = icon
		  info.func = OnClick
		  info.arg1 = name
		  UIDropDownMenu_AddButton(info, level)
	end
end
 
UIDropDownMenu_Initialize(DropDownMenu2, initialize)
UIDropDownMenu_SetWidth(DropDownMenu2, 100);
UIDropDownMenu_SetButtonWidth(DropDownMenu2, 124)
if gearset2 == nil then
	UIDropDownMenu_SetText(DropDownMenu2, "--Select a Set--")
	else UIDropDownMenu_SetSelectedName(DropDownMenu2, gearset2)
end
UIDropDownMenu_JustifyText(DropDownMenu2, "LEFT")
end

function MrGearSetDropdown3()
if GetNumEquipmentSets() == 0 and DropDownMenu3 and DropDownMenu3txt and btnMGSDropDownMenu3 then 
DropDownMenu3:Hide()
DropDownMenu3txt:Hide()
btnMGSDropDownMenu3:Hide()
return end

if GetNumEquipmentSets() == 0 then 
return end

if specs[3] == nil then return end

if not DropDownMenu3 then
   CreateFrame("Button", "DropDownMenu3", mrgearsetoptions, "UIDropDownMenuTemplate")
	if MRGEARSET_DD3 == nil then UIDropDownMenu_DisableDropDown(DropDownMenu3)
		else UIDropDownMenu_EnableDropDown(DropDownMenu3)
	end
end

DropDownMenu3:ClearAllPoints()
DropDownMenu3:SetPoint("TOPLEFT", 2, -240)
DropDownMenu3:Show()
DropDownMenu3txt = mrgearsetoptions:CreateFontString("DropDownMenu3txt", "ARTWORK", "GameFontHighlight")
DropDownMenu3txt:SetPoint("BOTTOMLEFT", DropDownMenu3, "TOPLEFT", 20, 1)
DropDownMenu3txt:SetText(specs[3])

btnMGSDropDownMenu3 = CreateFrame("CheckButton", "MGSDropDownMenu3button", mrgearsetoptions, "OptionsBaseCheckButtonTemplate")
btnMGSDropDownMenu3:SetPoint("LEFT", DropDownMenu3, "RIGHT", -10, 2)
btnMGSDropDownMenu3:SetScript("OnClick", function(frame)
	if frame:GetChecked() then
		PlaySound(SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_ON)
		UIDropDownMenu_EnableDropDown(DropDownMenu3)
		MRGEARSET_DD3 = true
	else
		PlaySound(SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_OFF)
		UIDropDownMenu_DisableDropDown(DropDownMenu3)
		MRGEARSET_DD3 = nil
	end
end)
btnMGSDropDownMenu3:SetScript("OnUpdate", function(frame)
	frame:SetChecked(MRGEARSET_DD3)
end)

local function OnClick(self, arg1)
   UIDropDownMenu_SetSelectedID(DropDownMenu3, self:GetID())
   gearset3 = arg1
   MRGEARSET_GEARSET3 = arg1
end
 
local function initialize(self, level)
   local info = UIDropDownMenu_CreateInfo()
		for i = 1, GetNumEquipmentSets() do
	    local name, icon, setID, isEquipped, totalItems, equippedItems, inventoryItems, missingItems, ignoredSlots = GetEquipmentSetInfo(i)
		  info = UIDropDownMenu_CreateInfo()
		  info.text = name
		  info.icon = icon
		  info.func = OnClick
		  info.arg1 = name
		  UIDropDownMenu_AddButton(info, level)
	end
end
 
UIDropDownMenu_Initialize(DropDownMenu3, initialize)
UIDropDownMenu_SetWidth(DropDownMenu3, 100);
UIDropDownMenu_SetButtonWidth(DropDownMenu3, 124)
if gearset3 == nil then
	UIDropDownMenu_SetText(DropDownMenu3, "--Select a Set--")
	else UIDropDownMenu_SetSelectedName(DropDownMenu3, gearset3)
end
UIDropDownMenu_JustifyText(DropDownMenu3, "LEFT")
end

function MrGearSetDropdown4()
if GetNumEquipmentSets() == 0 and DropDownMenu4 and DropDownMenu4txt and btnMGSDropDownMenu4 then 
DropDownMenu4:Hide()
DropDownMenu4txt:Hide()
btnMGSDropDownMenu4:Hide()
return end

if GetNumEquipmentSets() == 0 then 
return end

if specs[4] == nil then return end

if not DropDownMenu4 then
   CreateFrame("Button", "DropDownMenu4", mrgearsetoptions, "UIDropDownMenuTemplate")
	if MRGEARSET_DD4 == nil then UIDropDownMenu_DisableDropDown(DropDownMenu4)
		else UIDropDownMenu_EnableDropDown(DropDownMenu4)
	end
end

DropDownMenu4:ClearAllPoints()
DropDownMenu4:SetPoint("TOPLEFT", 2, -300)
DropDownMenu4:Show()
DropDownMenu4txt = mrgearsetoptions:CreateFontString("DropDownMenu4txt", "ARTWORK", "GameFontHighlight")
DropDownMenu4txt:SetPoint("BOTTOMLEFT", DropDownMenu4, "TOPLEFT", 20, 1)
DropDownMenu4txt:SetText(specs[4])

btnMGSDropDownMenu4 = CreateFrame("CheckButton", "MGSDropDownMenu4button", mrgearsetoptions, "OptionsBaseCheckButtonTemplate")
btnMGSDropDownMenu4:SetPoint("LEFT", DropDownMenu4, "RIGHT", -10, 2)
btnMGSDropDownMenu4:SetScript("OnClick", function(frame)
	if frame:GetChecked() then
		PlaySound(SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_ON)
		UIDropDownMenu_EnableDropDown(DropDownMenu4)
		MRGEARSET_DD4 = true
	else
		PlaySound(SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_OFF)
		UIDropDownMenu_DisableDropDown(DropDownMenu4)
		MRGEARSET_DD4 = nil
	end
end)
btnMGSDropDownMenu4:SetScript("OnUpdate", function(frame)
	frame:SetChecked(MRGEARSET_DD4)
end)

local function OnClick(self, arg1)
   UIDropDownMenu_SetSelectedID(DropDownMenu4, self:GetID())
   gearset4 = arg1
   MRGEARSET_GEARSET4 = arg1
end
 
local function initialize(self, level)
   local info = UIDropDownMenu_CreateInfo()
		for i = 1, GetNumEquipmentSets() do
	    local name, icon, setID, isEquipped, totalItems, equippedItems, inventoryItems, missingItems, ignoredSlots = GetEquipmentSetInfo(i)
		  info = UIDropDownMenu_CreateInfo()
		  info.text = name
		  info.icon = icon
		  info.func = OnClick
		  info.arg1 = name
		  UIDropDownMenu_AddButton(info, level)
	end
end
 
UIDropDownMenu_Initialize(DropDownMenu4, initialize)
UIDropDownMenu_SetWidth(DropDownMenu4, 100);
UIDropDownMenu_SetButtonWidth(DropDownMenu4, 124)
if gearset4 == nil then
	UIDropDownMenu_SetText(DropDownMenu4, "--Select a Set--")
	else UIDropDownMenu_SetSelectedName(DropDownMenu4, gearset4)
end
UIDropDownMenu_JustifyText(DropDownMenu4, "LEFT")
end



