local function AnchorFrameToMouse(frame)
    local x, y = GetCursorPosition()
    local effScale = frame:GetEffectiveScale()
    frame:ClearAllPoints()
    frame:SetPoint("BOTTOMRIGHT", UIParent, "BOTTOMLEFT", (x / effScale), (y / effScale))
    frame:SetClampedToScreen(true)
end

hooksecurefunc("GameTooltip_SetDefaultAnchor", function(tooltip, parent)
    if GetMouseFocus() ~= WorldFrame then return end
    tooltip:SetOwner(parent, "ANCHOR_CURSOR")
    AnchorFrameToMouse(tooltip)
end)

MouseTooltipDB = MouseTooltipDB or { opacity = 1, scale = 1 }

local function AnchorToMouse(self)
    local x, y = GetCursorPosition()
    local uiScale = self:GetEffectiveScale()
    self:ClearAllPoints()
    self:SetPoint("BOTTOMRIGHT", UIParent, "BOTTOMLEFT", x/uiScale + 12, y/uiScale + 12)
    self:SetScale(MouseTooltipDB.scale)
    self:SetAlpha(MouseTooltipDB.opacity)
end

hooksecurefunc("GameTooltip_SetDefaultAnchor", function(tooltip, parent)
    tooltip:SetOwner(parent or UIParent, "ANCHOR_CURSOR")
end)

GameTooltip:HookScript("OnShow", AnchorToMouse)
GameTooltip:HookScript("OnUpdate", AnchorToMouse)
ItemRefTooltip:HookScript("OnShow", AnchorToMouse)
ItemRefTooltip:HookScript("OnUpdate", AnchorToMouse)

-- Panel
local panel = CreateFrame("Frame")
panel.name = "MouseTooltip"
InterfaceOptions_AddCategory(panel)

panel.title = panel:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge")
panel.title:SetPoint("TOPLEFT", 16, -16)
panel.title:SetText("MouseTooltip")

-- Opacidad precisa
local opacity = CreateFrame("Slider", "MTT_Opacity", panel, "OptionsSliderTemplate")
opacity:SetPoint("TOP", 0, -70)
opacity:SetMinMaxValues(0.1, 1)
opacity:SetValueStep(0.01)
opacity:SetObeyStepOnDrag(true)
opacity:SetWidth(240)
opacity:SetValue(MouseTooltipDB.opacity)

_G[opacity:GetName().."Low"]:SetText("0.10")
_G[opacity:GetName().."High"]:SetText("1.00")
_G[opacity:GetName().."Text"]:SetText("Opacidad")

local opacityValue = opacity:CreateFontString(nil, "OVERLAY", "GameFontHighlight")
opacityValue:SetPoint("TOP", opacity, "BOTTOM", 0, -6)
opacityValue:SetText(format("%.2f", MouseTooltipDB.opacity))

opacity:SetScript("OnValueChanged", function(_, value)
    value = tonumber(format("%.2f", value))
    MouseTooltipDB.opacity = value
    GameTooltip:SetAlpha(value)
    ItemRefTooltip:SetAlpha(value)
    opacityValue:SetText(format("%.2f", value))
end)

-- Escala precisa
local scale = CreateFrame("Slider", "MTT_Scale", panel, "OptionsSliderTemplate")
scale:SetPoint("TOP", opacityValue, "BOTTOM", 0, -30)
scale:SetMinMaxValues(0.5, 2.0)
scale:SetValueStep(0.01)
scale:SetObeyStepOnDrag(true)
scale:SetWidth(240)
scale:SetValue(MouseTooltipDB.scale)

_G[scale:GetName().."Low"]:SetText("0.50")
_G[scale:GetName().."High"]:SetText("2.00")
_G[scale:GetName().."Text"]:SetText("Escala")

local scaleValue = scale:CreateFontString(nil, "OVERLAY", "GameFontHighlight")
scaleValue:SetPoint("TOP", scale, "BOTTOM", 0, -6)
scaleValue:SetText(format("%.2f", MouseTooltipDB.scale))

scale:SetScript("OnValueChanged", function(_, value)
    value = tonumber(format("%.2f", value))
    MouseTooltipDB.scale = value
    GameTooltip:SetScale(value)
    ItemRefTooltip:SetScale(value)
    scaleValue:SetText(format("%.2f", value))
end)

-- Texto informativo
local info = panel:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
info:SetPoint("TOP", scaleValue, "BOTTOM", 0, -20)
info:SetTextColor(0.7, 0.7, 0.7)
info:SetText("Valor por defecto del juego:\nOpacidad: 1.00 | Escala: 1.00")

-- Autor
local authorLabel = panel:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall")
authorLabel:SetPoint("BOTTOMRIGHT", -90, 14)
authorLabel:SetText("Autor:")
authorLabel:SetTextColor(1, 0.82, 0)

local authorName = panel:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
authorName:SetPoint("LEFT", authorLabel, "RIGHT", 4, 0)
authorName:SetText("Vainillaice")
authorName:SetTextColor(1, 1, 1)