local L = LibStub("AceLocale-3.0"):GetLocale("MouseLook")

-- Screen settings so we can do placement of the cursor correctly.
local screenWidth, screenHeight = WorldFrame:GetSize()
local midOffsetX = (screenWidth * WorldFrame:GetEffectiveScale()) / 2
local midOffsetY = (screenHeight * WorldFrame:GetEffectiveScale()) / 2

-- Cursor replacement for whenever we are mouselooking so we know where our cursor is, and so we know that we are mouselooking.
local cursorFrame = CreateFrame("Frame")
cursorFrame:SetFrameStrata("Tooltip")
cursorFrame:SetFrameLevel(0)
cursorFrame:SetWidth(16)
cursorFrame:SetHeight(16)
cursorFrame:SetAlpha(1)
cursorFrame:SetPoint("CENTER", 0, 0);
cursorFrame:SetScript("OnShow", function() MouseLook:OnCursorShow() end)
local cursorTexture = cursorFrame:CreateTexture("Texture", "Background")
cursorTexture:SetTexture("Interface\\CURSOR\\Crosshairs.blp")
cursorTexture:SetWidth(16)
cursorTexture:SetHeight(16)
cursorTexture:SetAllPoints(cursorFrame)
cursorFrame:Hide()


-- Toggle on Mouselook and set our cursor placeholder.	
function MouseLook:ToggleMouseLook()
	if IsMouselooking() then
		cursorFrame:Hide()
		MouselookStop()
	else
		local x, y = GetCursorPosition()
		MouselookStart()
		cursorFrame:SetPoint("CENTER", WorldFrame, x - midOffsetX, y - midOffsetY)
		cursorFrame:Show()
	end
end

function MouseLook:OnCursorUpdate()
	self:HideCursorIfNotMouselooking()
end

-- When we show the cursor, start polling to see when we need to stop showing it.
-- Mouselook mode can be cancelled by the user right-clicking, which is why we need this.
-- There is no event for exiting mouselook, so we must poll for it.
function MouseLook:OnCursorShow()
	self:CursorTickerStart()
end

function MouseLook:HideCursorIfNotMouselooking()
	if not IsMouselooking() then
		cursorFrame:Hide()
		self:CursorTickerStop()
	end
end

local cursorTicker = {}
function MouseLook:CursorTickerStart()
	cursorTicker = C_Timer.NewTicker(self.db.profile.throttle_time, function() MouseLook:HideCursorIfNotMouselooking() end)
end

function MouseLook:CursorTickerStop()
	if cursorTicker and not cursorTicker._cancelled and cursorTicker.Cancel then
		cursorTicker:Cancel()
	end
end


