local L = LibStub("AceLocale-3.0"):GetLocale("MouseLook")
local AceAddon = LibStub("AceAddon-3.0")

-- these are used here but also need scope in the config file
MouseLook.config = {}				-- overridden in config file
MouseLook.perfconfig = {}			-- overridden in config file
MouseLook.defaults = {}				-- overridden in config file

-- Initialize
function MouseLook:OnInitialize()

	-- load the db
	self.db = LibStub("AceDB-3.0"):New("MouseLookDB", MouseLook.defaults)

	-- register config options
	LibStub("AceConfig-3.0"):RegisterOptionsTable("MouseLook", MouseLook.config, {"ml", "MouseLook"})
	LibStub("AceConfigDialog-3.0"):AddToBlizOptions("MouseLook", L["ADDON_NAME"])
	
	-- create sub table for perf options
	LibStub("AceConfig-3.0"):RegisterOptionsTable("MouseLook.perfconfig", MouseLook.perfconfig)
	LibStub("AceConfigDialog-3.0"):AddToBlizOptions("MouseLook.perfconfig", L["OPTIONS_CATEGORY_PERFORMANCE"], "MouseLook")
	
	-- create sub table in options for profile management
	local profiles = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
	LibStub("AceConfig-3.0"):RegisterOptionsTable("MouseLook.profiles", profiles)
	LibStub("AceConfigDialog-3.0"):AddToBlizOptions("MouseLook.profiles", L["OPTIONS_CATEGORY_PROFILES"], "MouseLook")
	
	-- free up memory of no-longer used vars
	MouseLook.config = nil
	MouseLook.defaults = nil
end

-- user enabled addon
function MouseLook:OnEnable()
	
	-- set up events
	
	-- Fired anytime the raid or party changes, to pick up whether a new person requires summoning.
	self:RegisterEvent("CURSOR_UPDATE", "OnCursorUpdate")

	-- init msg
	self:Debug(L["ENABLED"])
end

-- user disabled
function MouseLook:OnDisable()

	-- ACE handles deregistration of events
	self:UnhookAll()
	self:Debug(L["DISABLED"])
end


