local L = LibStub("AceLocale-3.0"):GetLocale("MouseLook")

-- this file contains default db settings and config settings
-- it's best to put this at the end of all processing so it has access to any function in any file

MouseLook.defaults = {
	profile = {
		debug = false,
		throttle_time = .5,
	},
}

MouseLook.config = {
	name = L["ADDON_NAME"],
	handler = MouseLook,
	type = 'group',
	args = {
		-- CORE
		titledesc = {
			name= L["OPTIONS_TITLE_ADDON"],
			type = 'description',
			order = 0,
		},
		debug = {
			name = L["OPTIONS_SETTINGNAME_DEBUG"],
			desc = L["OPTIONS_SETTINGDESC_DEBUG"],
			type = 'toggle',
			set = function(info,val) info.handler.db.profile.debug = val end,
			get = function(info) return info.handler.db.profile.debug end,
			order = 10,
		},
		b1 = {
			name = "\n\n",
			type = 'description',
			order = 99,
		},
		
		-- Console only commands
		settings = {
			name = L["CMD_SETTINGS_NAME"] ,
			desc = L["CMD_SETTINGS_DESC"] ,
			guiHidden = true,
			type = 'execute',
			func = 'OpenSettings_Cmd',
		},
	},
}

MouseLook.perfconfig = {
	name = L["OPTIONS_CATEGORY_PERFORMANCE"],
	handler = MouseLook,
	type = 'group',
	args = {
		titledesc = {
			name= L["OPTIONS_TITLE_PERFORMANCE"],
			type = 'description',
			order = 0,
		},
		h1 = {
			name = L["OPTIONS_HEADER_THROTTLES"],
			type = 'header',
			order = 100,
		},
		d1 = {
			name = L["OPTIONS_DESC_THROTTLES"],
			type = 'description',
			order = 110,
		},
		throttle_time = {
			name = L["OPTIONS_SETTINGNAME_THROTTLE_TIME"],
			desc = L["OPTIONS_SETTINGDESC_THROTTLE_TIME"],
			type = 'input',
			order = 120,
			pattern = '%d+',
			cmdHidden = true,
			validate = function(info, val) if not tonumber(val) or tonumber(val) < .1 then return L["OPTIONS_SETTINGINVALID_THROTTLE_TIME"] end return true end,
			set = function(info, val) info.handler.db.profile.throttle_time = tonumber(val) end,
			get = function(info) return tostring(info.handler.db.profile.throttle_time) end,
		},
	},
}
