local panel = CreateFrame("Frame", "MountUpOptions")

local scaleSlider = CreateFrame("Slider", "ScaleSlider", panel, "OptionsSliderTemplate")
local numRowsSlider = CreateFrame("Slider", "NumRowsSlider", panel, "OptionsSliderTemplate")

local function createNumRowsSlider(sliderName, parentFrame)

	local minVal = 1
	local maxVal = 5

	numRowsSlider:SetMinMaxValues(minVal, maxVal)
	numRowsSlider:SetValue(minVal)
	numRowsSlider:SetObeyStepOnDrag(true)
	numRowsSlider:SetValueStep(1)
	
	numRowsSlider.text = _G[sliderName.."Text"]
	numRowsSlider.textLow = _G[sliderName.."Low"]
	numRowsSlider.textHigh = _G[sliderName.."High"]
	
	numRowsSlider.text:SetText("Number of Rows")
	numRowsSlider.textLow:SetText(tostring(minVal))
	numRowsSlider.textHigh:SetText(tostring(maxVal))
	
	numRowsSlider:SetWidth(150)
	numRowsSlider:SetHeight(20)
	numRowsSlider:SetOrientation('HORIZONTAL')
	numRowsSlider:SetPoint("CENTER", parentFrame, 0, 40)
	
	numRowsSlider:SetScript("OnValueChanged", function(self, value)
		--print(value)
		setNumRows(value)
	end)
	
	numRowsSlider:Show()
	
	_G["numRowsSlider"] = numRowsSlider

end

local function createScaleSlider(sliderName, parentFrame)

	local minVal = 0.5
	local maxVal = 1.0

	scaleSlider:SetMinMaxValues(minVal, maxVal)
	scaleSlider:SetValue(minVal)
	scaleSlider:SetObeyStepOnDrag(true)
	scaleSlider:SetValueStep(0.1)
	
	scaleSlider.text = _G[sliderName.."Text"]
	scaleSlider.textLow = _G[sliderName.."Low"]
	scaleSlider.textHigh = _G[sliderName.."High"]
	
	scaleSlider.text:SetText("Scale")
	scaleSlider.textLow:SetText(tostring(minVal))
	scaleSlider.textHigh:SetText(tostring(maxVal))
	
	scaleSlider:SetWidth(150)
	scaleSlider:SetHeight(20)
	scaleSlider:SetOrientation('HORIZONTAL')
	scaleSlider:SetPoint("CENTER", parentFrame)
	
	scaleSlider:SetScript("OnValueChanged", function(self, value)
		--print(value)
		setScale(value)
	end)
	
	scaleSlider:Show()

	_G["scaleSlider"] = scaleSlider

end

function mountUpConfigFrame_OnShow()
	--print("OnShow")

	createNumRowsSlider("NumRowsSlider", panel)
	createScaleSlider("ScaleSlider", panel)

	panel.name = "Mount Up"
	panel.ok = function(self)
		MountUpOptions_Close();
	end
	panel.cancel = function(self)
		MountUpOptions_CancelOrLoad();
	end
	InterfaceOptions_AddCategory(panel)
end

function mountUpConfigFrame_OnLoad(panel)
	--print("OnLoad")
end

function MountUpOptions_CancelOrLoad()
	--print("CancelOrLoad")
end

function MountUpOptions_Close()
	--print("Close")
end