-- Mount Up by Michael Gaines
-- Special thanks to the people that actually answer questions on the WoW Interface forums, because the docs for addons is bleh.
-- Lots of Tangerine Dream was used to write this addon.
-- Shout outs to Phaedra, Tangram, Rubycon, Hyperborea, Green Desert, and Ricochet.
-- Also, shout out to the people outside the Lion's Pride in on Moon Guard. You people are weird :D

local scale = 0.5

local prevpos = false

local frame = CreateFrame("Frame","MountUp_Frame",UIParent)

local getFavoriteMounts
local favoriteMountIndexArray = {}
local numFavoriteMounts = 0

local numRows = 3
local currentRow = 1
local lastX = 0

MountUpFramePos = {
	from = "CENTER",
	to = "CENTER",
	x = 0,
	y = 0
}

MountUpOptions = {
	scale = 0.5,
	numRows = 3
}

function saveOptions()
	--print("Saving...numRows: "..tostring(numRows)..", scale: "..tostring(scale) )
	MountUpOptions.numRows = numRows
	MountUpOptions.scale = scale
end

function loadOptions()
	if(MountUpOptions.scale ~= nil) then
		scale = MountUpOptions.scale
	else
		MountUpOptions.scale = scale
	end
	
	if(MountUpOptions.numRows ~= nil) then
		numRows = MountUpOptions.numRows
	else
		MountUpOptions.numRows = numRows
	end
	
	--print("Loaded...numRows: "..tostring(numRows)..", scale: "..tostring(scale) )

end

local function createMountFrame(x, y, from, to)
	if(from==nil or to==nil) then
		frame:SetPoint("CENTER",UIParent)
	else
		frame:SetPoint(from, UIParent, to, x,y)
	end
	frame:SetMovable(true)
end

local function updateMountFrame(numMounts)
	frame:EnableMouse(true)
	frame:SetWidth(( ceil((numMounts / numRows))*40)+20)
	frame:SetHeight((numRows * 40)+20)
	--print("Frame: "..frame:GetWidth())
	frame:SetScript("OnMouseDown", function(self, button)
		if button == "RightButton" then
			getFavoriteMounts(true)
		end
	end)
	frame:RegisterForDrag("LeftButton")
	--frame:SetScript("OnDragStart", frame.StartMoving)
	frame:SetScript("OnDragStart", function(self)
		if IsShiftKeyDown() then
			self:StartMoving()
		end
	end)
	frame:SetScript("OnDragStop", function(self, button)
		self:StopMovingOrSizing()
		local from, _, to, x, y = self:GetPoint()
		MountUpFramePos.x = x
		MountUpFramePos.y = y
		MountUpFramePos.from = from
		MountUpFramePos.to = to
		--print("From, to: "..from..", "..to.." - X, Y: "..MountUpFramePos.x..", "..MountUpFramePos.y)
		end)
	frame:SetBackdrop(StaticPopup1:GetBackdrop())
	frame:SetScale(scale)
	frame:Show()
end

function MountUpOptions_Start(self)
    self:RegisterEvent("ADDON_LOADED")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("PLAYER_LOGIN")
	self:RegisterEvent("SPELLS_CHANGED")
	self:RegisterEvent("PLAYER_LEVEL_UP")
	--self:RegisterEvent("PLAYER_TARGET_CHANGED")
end

function MountUpOptions_OnEvent(this, event, ...)
    local argin1, argin2, argin3, argin4, _, argin6 = ...
    if (event == "ADDON_LOADED") then
        if(argin1 == "MountUp") then
			--print("Loaded")
			loadOptions()
			createMountFrame(MountUpFramePos.x, MountUpFramePos.y, MountUpFramePos.from, MountUpFramePos.to)
			--print(MountUpFramePos.x..", "..MountUpFramePos.y)
        end
	elseif (event == "PLAYER_LOGIN") then
		getFavoriteMounts(true)
		DEFAULT_CHAT_FRAME:AddMessage("|cff55BFFF".."Mount Up".."|cffffffff "..numFavoriteMounts.." favorite mounts")
		--print("login")

		local scaleSlider = _G["scaleSlider"]
		scaleSlider:SetValue(scale)
		
		local numRowsSlider = _G["numRowsSlider"]
		numRowsSlider:SetValue(numRows)
	elseif (event == "PLAYER_LEVEL_UP") then
		-- reload on a ding.
		getFavoriteMounts(true)
	end
end

function setScale(newScale)
	scale = newScale
	frame:SetScale(scale)
	for index, info in pairs(favoriteMountIndexArray) do
		--print(index, info.creatureName)
		local button = _G[info.creatureName]
		--button:SetScale(scale)
	end
	local randomButton = _G["Random"]
	--randomButton:SetScale(scale)
	saveOptions()
end

function setNumRows(newNumRows)
	numRows = newNumRows
	getFavoriteMounts()
end

local function addMount(creatureName, id, mountID)

	-- Test if the button exists yet.
	local button = GetClickFrame(creatureName)

	if(button == nil) then
		button = CreateFrame("Button", creatureName, frame, "ActionButtonTemplate")
	else
		button:ClearAllPoints()
	end

	--button:SetScale(scale)

	-- If we're one the first left position, just place it
	if not prevpos then
		button:SetPoint("TOPLEFT",frame,"TOPLEFT",13,(-13 - ( (currentRow - 1) * 40)) )
		prevpos = creatureName
	else
		if( (lastX + 40) >= (frameWidth - 20)) then
			lastX = 0
			currentRow = currentRow + 1
			button:SetPoint("TOPLEFT",frame,"TOPLEFT",13,(-13 - ( (currentRow - 1) * 40)))
			prevpos = creatureName
		else
			lastX = lastX + 40
			button:SetPoint("LEFT",prevpos,"RIGHT",4, 0)
			prevpos = creatureName
		end
	end

	local needsFanfare = C_MountJournal.NeedsFanfare(mountID)
	_G[button:GetName().."Icon"]:SetTexture(needsFanfare and COLLECTIONS_FANFARE_ICON or id)
	_G[button:GetName().."Name"]:SetText(creatureName)

	button:SetScript("OnClick", function()
		--print("MOUNT")
		-- Don't dismount while flying. That would be bad.
		if(IsFlying()) then
			return
		end
		if(mountID ~= -1) then
			C_MountJournal.SummonByID(mountID)
		else
			--print("Random")
			local rndMountIndex = math.random(1, numFavoriteMounts)
			
			local info = favoriteMountIndexArray[rndMountIndex]

			C_MountJournal.SummonByID(info.mountID)
		end
	end )
end

function countFavoriteMounts()

local index = 1
local endFound = false
local numMounts = C_MountJournal.GetNumDisplayedMounts()


	while ( (endFound == false) and (index <= numMounts) ) do
			local creatureName, spellID, icon, active, isUsable, sourceType, isFavorite, isFactionSpecific, faction, hideOnChar, isCollected, mountID = C_MountJournal.GetDisplayedMountInfo(index)
			if(isFavorite ~= true) then
				endFound = true
			else
				index = index + 1
			end
	end

	return index
end

function getFavoriteMounts(bFakeLevel)

	local newFavoriteMountCount = countFavoriteMounts()
	--print(newFavoriteMountCount.." favorite mounts")

	-- If we ding and we didn't bump the number of mounts, then there's nothing to do here.
	if(newFavoriteMountCount == numFavoriteMounts) then
		return
	end

	local numMounts = C_MountJournal.GetNumDisplayedMounts()
 
	--print(numMounts)
	
	favoriteMountIndexArray = {}
	numFavoriteMounts = 0
 
 -- LUA is 1-based, not 0-based
 
	-- If we're here, that means we have new mounts to add.
	-- Make sure to reuse the buttons that were already made.
	for index = 1, numMounts do
  
		local creatureName, spellID, icon, active, isUsable, sourceType, isFavorite, isFactionSpecific, faction, hideOnChar, isCollected, mountID = C_MountJournal.GetDisplayedMountInfo(index)
	
		if(isFavorite and isUsable) then-- or bFakeLevel)) then
			
			numFavoriteMounts = numFavoriteMounts + 1

			local mountInfo = {}
			mountInfo["mountID"] = mountID
			mountInfo["creatureName"] = creatureName
			mountInfo["icon"] = icon

			--print("Mountinfo: "..mountInfo["creatureName"])
			favoriteMountIndexArray[numFavoriteMounts] = mountInfo
--			print(favoriteMountIndexArray[numFavoriteMounts])

			--print(creatureName.." - "..tostring(index).." - "..tostring(isFavorite))
			--print(icon)
			--print(mountID)
		end
	end

	--print("Num of favorite mounts: "..tostring(numFavoriteMounts))

	frameWidth = ( (( ceil((numFavoriteMounts + 1) / numRows)) * 40) + 20)
	frameHeight = ( (numRows * 40) + 20)
	
	frame:SetWidth(frameWidth)
	frame:SetHeight(frameHeight)
	currentRow = 1
	lastX = 0

	--print(frameWidth, frameHeight)

	prevpos = nil

	for index, info in pairs(favoriteMountIndexArray) do
		--print(index, info.creatureName)

		addMount(info.creatureName, info.icon, info.mountID)
	end

	addMount("Random", 134400, -1)

	updateMountFrame(numFavoriteMounts + 1)

	saveOptions()

 end
