MountJournalEnhancedSource = {
    ["Drop"] = {
        -- sourceType = 1
        ------------------------------
        -- Alliance & Horde ----------
        ------------------------------

        [24242] = "Swift Razzashi Raptor", -- no longer available
        [24252] = "Swift Zulian Tiger", -- no longer available

        [60002] = "Time-Lost Proto-Drake", -- The Storm Peaks, Time-Lost Proto-Drake
        [88718] = "Phosphorescent Stone Drake", -- Deepholm, Aeonaxx
        [88750] = "Grey Riding Camel", -- Uldum, Mysterious Camel Figurine
        [98718] = "Subdued Seahorse", -- Shimmering Expanse, Poseidus
        [127158] = "Heavenly Onyx Cloud Serpent", -- Kun-Lai Summit, Sha of Anger
        [130965] = "Son of Galleon", -- Valley of the Four Winds, Galleon
        [132036] = "Thundering Ruby Cloud Serpent", -- 10x Skyshard, needs reputation to learn
        [138423] = "Cobalt Primordial Direhorn", -- Isle of Giants, Oondasta
        [139442] = "Thundering Cobalt Cloud Serpent", -- Isle of Thunder, Nalak
        [148476] = "Thundering Onyx Cloud Serpent", -- Timeless Isle, Huolon
        [179478] = "Voidtalon of the Dark Star", -- Edge of Reality

        -- Zandalari Warbringer
        [138424] = "Amber Primordial Direhorn",
        [138425] = "Slate Primordial Direhorn",
        [138426] = "Jade Primordial Direhorn",

        -- Mysterious Egg
        [61294] = "Green Proto-Drake",

        -- Primal Egg
        [138641] = "Red Primal Raptor",
        [138642] = "Black Primal Raptor",
        [138643] = "Green Primal Raptor",

        -- Warlords of Draenor Rare
        [171636] = "Great Greytusk",
        [171620] = "Bloodhoof Bull",
        [171622] = "Mottled Meadowstomper",
        [171849] = "Sunhide Gronnling",
        [171824] = "Sapphire Riverbeast",
        [171830] = "Swift Breezestrider",
        [171619] = "Tundra Icehoof", -- Vengeance, Deathtalon, Terrorfist, Doomroller
        [171630] = "Armored Razorback", -- Vengeance, Deathtalon, Terrorfist, Doomroller
        [171837] = "Warsong Direfang", -- Vengeance, Deathtalon, Terrorfist, Doomroller

        -- Warlords of Draenor Elite
        [171851] = "Garn Nighthowl",

        -- Warlords of Draenor World Boss
        [171828] = "Solar Spirehawk", -- Rukhmar

        -- Legion
        [223018] = "Fathom Dweller", -- World Boss, Kosumoth the Hungering
        [243025] = "Riddler's Mind-Worm",
        [242881] = "Cloudwing Hippogryph", -- Farondis cache (paragon)
        [242874] = "Highmountain Elderhorn", -- Highmountain Supplies (paragon)
        [233364] = "Leywoven Flying Carpet", -- Nightfallen Cache (paragon)
        [242882] = "Valarjar Stormwing", -- Valarjar Strongbox (paragon)
        [242875] = "Wild Dreamrunner", -- Dreamweaver Cache (paragon)
        [254258] = "Blessed Felcrusher", -- Army of the Light Cache (paragon)
        [254259] = "Avenging Felcrusher", -- Army of the Light Cache (paragon)
        [254069] = "Glorious Felcrusher", -- Army of the Light Cache (paragon)
        [253058] = "Maddened Chaosrunner",
        [243652] = "Vile Fiend",
        [253661] = "Crimson Slavermaw",
        [253662] = "Acid Belcher",
        [253660] = "Biletooth Gnasher",
        [253106] = "Vibrant Mana Ray",
        [253107] = "Lambent Mana Ray",
        [253108] = "Felglow Mana Ray",
        [253109] = "Scintillating Mana Ray",
        [235764] = "Darkspore Mana Ray",
        [247402] = "Lucid Nightmare",
    },

    ["Quest"] = {
        -- sourceType = 2
        ------------------------------
        -- Alliance & Horde ----------
        ------------------------------

        [26656] = "Black Qiraji Battle Tank", -- no longer available
        [54753] = "White Polar Bear", -- Quest from Gretta the Arbiter, needs reputation to be able to accept the quest
        [73313] = "Crimson Deathcharger", -- Mograine's Reunion
        [75207] = "Abyssal Seahorse", -- The Abyssal Ride
        [127154] = "Onyx Cloud Serpent", -- Quest Surprise Attack!, needs reputation to be able to accept the quest
        [138640] = "Bone-White Primal Raptor", -- A Mountain of Giant Dinosaur Bones
        [171850] = "Llothien Prowler", -- Volpin the Elusive
        [213164] = "Brilliant Direbeak", -- Direbeak Reunion
        [213165] = "Viridian Sharptalon", -- Sharptalon Reunion
        [213163] = "Snowfeather Hunter", -- Snowfeather Reunion
        [213158] = "Predatory Bloodgazer", -- Bloodgazer Reunion
        [215159] = "Long-Forgotten Hippogryph", -- Ephemeral Crystal x5
        [230987] = "Arcanist's Manasaber", -- Fate of the Nightborne
        [239770] = "Black Qiraji War Tank", -- newer high res version of the Black Qiraji Battle Tank

        ------------------------------
        -- Alliance ------------------
        ------------------------------

        -- Operation: Shieldwall
        [136163] = "Grand Gryphon", -- The Silence

        ------------------------------
        -- Horde ---------------------
        ------------------------------

        -- Dominance Offensive
        [136164] = "Grand Wyvern", -- Breath of Darkest Shadow
    },

    ["Vendor"] = {
        -- sourceType = 3
        ------------------------------
        -- Alliance & Horde ----------
        ------------------------------

        [122708] = "Grand Expedition Yak",
        [127216] = "Grey Riding Yak",
        [127220] = "Blonde Riding Yak",
        [171825] = "Mosshide Riverwallow",
        [171616] = "Witherhide Cliffstomper",
        [171628] = "Rocktusk Battleboar", -- Trader Araanda, Trader Darakk
        [213115] = "Bloodfang Widow", -- The Mad Merchant
        [227956] = "Arcadian War Turtle", -- Xur'ios
        [214791] = "Brinedeep Bottom-Feeder", -- Conjurer Margoss
        [230844] = "Brawler's Burly Basilisk", -- brawler guild mount (season 2)

        ------------------------------
        -- Alliance ------------------
        ------------------------------

        [171846] = "Champion's Treadblade",

        -- pre 1.4, no longer available
        [15779] = "White Mechanostrider Mod B",
        [16055] = "Black Nightsaber",
        [16056] = "Ancient Frostsaber",
        [16082] = "Palomino",
        [16083] = "White Stallion",
        [17459] = "Icy Blue Mechanostrider Mod A",
        [17460] = "Frost Ram",
        [17461] = "Black Ram",

        -- Stormwind
        [32235] = "Golden Gryphon",
        [32239] = "Ebon Gryphon",
        [32240] = "Snowy Gryphon",
        [32242] = "Swift Blue Gryphon",
        [32289] = "Swift Red Gryphon",
        [32290] = "Swift Green Gryphon",
        [32292] = "Swift Purple Gryphon",

        -- Kirin Tor
        [59791] = "Wooly Mammoth", -- Alliance
        [60114] = "Armored Brown Bear", -- Alliance
        [61229] = "Armored Snowy Gryphon",
        [61425] = "Traveler's Tundra Mammoth", -- Alliance

        ------------------------------
        -- Horde ---------------------
        ------------------------------

        -- pre 1.4, no longer available
        [16080] = "Red Wolf",
        [16081] = "Arctic Wolf",
        [16084] = "Mottled Red Raptor",
        [17450] = "Ivory Raptor",
        [18991] = "Green Kodo",
        [18992] = "Teal Kodo",

        -- Orgrimmar
        [32243] = "Tawny Wind Rider",
        [32244] = "Blue Wind Rider",
        [32245] = "Green Wind Rider",
        [32246] = "Swift Red Wind Rider",
        [32295] = "Swift Green Wind Rider",
        [32296] = "Swift Yellow Wind Rider",
        [32297] = "Swift Purple Wind Rider",

        -- Kirin Tor
        [59793] = "Wooly Mammoth", -- Horde
        [60116] = "Armored Brown Bear", -- Horde
        [61230] = "Armored Blue Wind Rider",
        [61447] = "Traveler's Tundra Mammoth", -- Horde
    },

    ["Profession"] = {
        -- sourceType = 4
        ------------------------------
        -- Alliance & Horde ----------
        ------------------------------

        -- Engineering
        [44151] = "Turbo-Charged Flying Machine",
        [44153] = "Flying Machine",
        [126507] = "Depleted-Kyparium Rocket",
        [126508] = "Geosynchronous World Spinner",
        [134359] = "Sky Golem",

        -- Tailoring
        [61309] = "Magnificent Flying Carpet",
        [61451] = "Flying Carpet",
        [75596] = "Frosty Flying Carpet",
        [169952] = "Creeping Carpet",

        -- Fishing
        [30174] = "Riding Turtle",
        [64731] = "Sea Turtle",
        [253711] = "Pond Nettle",

        -- Archaeology
        [84751] = "Fossilized Raptor",
        [92155] = "Ultramarine Qiraji Battle Tank",
        [93326] = "Sandstone Drake",
        [196681] = "Spirit of Eche'ro",

        -- Jewelcrafting
        [120043] = "Jeweled Onyx Panther",
        [121838] = "Ruby Panther",
        [121837] = "Jade Panther",
        [121836] = "Sapphire Panther",
        [121839] = "Sunstone Panther",

        -- Leatherworking
        [171844] = "Dustmane Direwolf",
        [213339] = "Great Northern Elderhorn",

        -- Blacksmithing
        [213209] = "Steelbound Devourer",

        ------------------------------
        -- Alliance ------------------
        ------------------------------

        -- Engineering
        [60424] = "Mekgineer's Chopper",

        ------------------------------
        -- Horde ---------------------
        ------------------------------

        -- Engineering
        [55531] = "Mechano-Hog",
    },

    ["Instance"] = {
        ------------------------------
        -- Alliance & Horde ----------
        ------------------------------

        -- Dungeon
        [17481] = "Rivendare's Deathcharger", -- Stratholme, Lord Aurius Rivendare
        [41252] = "Raven Lord", -- Sethekk Halls, Anzu
        [46628] = "Swift White Hawkstrider", -- Magisters' Terrace, Kael'thas Sunstrider
        [59569] = "Bronze Drake", -- The Culling of Stratholme, Infinite Corruptor
        [59996] = "Blue Proto-Drake", -- Utgarde Pinnacle, Skadi
        [88742] = "Drake of the North Wind", -- The Vortex Pinnacle, Altarius
        [88746] = "Vitreous Stone Drake", -- The Stonecore, Slabhide
        [96491] = "Armored Razzashi Raptor", -- Zul'Gurub, Bloodlord Mandokir
        [96499] = "Swift Zulian Panther", -- Zul'Gurub, High Priestess Kilnara
        [231428] = "Smoldering Ember Wyrm", -- Return to Karazhan timerun
        [229499] = "Midnight", -- Return to Karazhan

        -- Raid
        [25953] = "Blue Qiraji Battle Tank", -- Temple of Ahn'Qiraj
        [26054] = "Red Qiraji Battle Tank", -- Temple of Ahn'Qiraj
        [26055] = "Yellow Qiraji Battle Tank", -- Temple of Ahn'Qiraj
        [26056] = "Green Qiraji Battle Tank", -- Temple of Ahn'Qiraj
        [36702] = "Fiery Warhorse", -- Karazhan, Attumen the Huntsman
        [40192] = "Ashes of Al'ar", -- The Eye, Kael'thas Sunstrider
        [59567] = "Azure Drake", -- The Eye of Eternity, Malygos
        [59568] = "Blue Drake", -- The Eye of Eternity, Malygos
        [59571] = "Twilight Drake", -- The Obsidian Sanctum, Sartharion
        [59650] = "Black Drake", -- The Obsidian Sanctum, Sartharion
        [69395] = "Onyxian Drake", -- Onyxia's Lair, Onyxia
        [63796] = "Mimiron's Head", -- Ulduar, Yogg-Saron
        [72286] = "Invincible", -- Icecrown Citadel, The Lich King
        [88744] = "Drake of the South Wind", -- Throne of Four Winds, Al'Akir
        [97493] = "Pureblood Fire Hawk", -- Firelands, Ragnaros
        [101542] = "Flametalon of Alysrazor", -- Firelands, Alysrazor
        [107842] = "Blazing Drake", -- Dragon Soul, Deathwing
        [107845] = "Life-Binder's Handmaiden", -- Dragon Soul, Deathwing
        [110039] = "Experiment 12-B", -- Dragon Soul, Ultraxion
        [127170] = "Astral Cloud Serpent", -- Mogu'shan Vaults, Elegon
        [136471] = "Spawn of Horridon", -- Throne of Thunder, Horridon
        [139448] = "Clutch of Ji-Kun", -- Throne of Thunder, Ji-Kun
        [148417] = "Kor'kron Juggernaut", -- Siege of Orgrimmar, Garrosh Hellscream
        [171621] = "Ironhoof Destroyer", -- Blackrock Foundry, Blackhand
        [182912] = "Felsteel Annihilator", -- Hellfire Citadel, Archimonde
        [189999] = "Grove Warden", -- Hellfire Citadel, Archimonde
        [213134] = "Felblaze Infernal", -- The Nighthold, Gul'dan
        [171827] = "Hellfire Infernal", -- The Nighthold, Gul'dan (Mythic)
        [232519] = "Abyss Worm", -- Tomb of Sargeras, Mistress Sassz'ine
        [253088] = "Antoran Charhound", -- Antorus, Shatug
        [253639] = "Violet Spellwing", -- Antorus, Argus
        [243651] = "Shackled Ur'zul", -- Antorus, Argus Mythic

        ------------------------------
        -- Alliance ------------------
        ------------------------------

        -- Vault of Archavon
        [61465] = "Grand Black War Mammoth", -- Alliance

        ------------------------------
        -- Horde ---------------------
        ------------------------------

        -- Vault of Archavon
        [61467] = "Grand Black War Mammoth", -- Horde
    },

    ["Reputation"] = {
        ------------------------------
        -- Alliance & Horde ----------
        ------------------------------

        -- Sha'tari Skyguard
        [39798] = "Green Riding Nether Ray",
        [39800] = "Red Riding Nether Ray",
        [39801] = "Purple Riding Nether Ray",
        [39802] = "Silver Riding Nether Ray",
        [39803] = "Blue Riding Nether Ray",

        -- Netherwing
        [41513] = "Onyx Netherwing Drake",
        [41514] = "Azure Netherwing Drake",
        [41515] = "Cobalt Netherwing Drake",
        [41516] = "Purple Netherwing Drake",
        [41517] = "Veridian Netherwing Drake",
        [41518] = "Violet Netherwing Drake",

        -- Cenarion Expedition
        [43927] = "Cenarion War Hippogryph",

        -- The Storm Peaks
        [54753] = "White Polar Bear", -- Quest from Gretta the Arbiter

        -- The Wyrmrest Accord
        [59570] = "Red Drake",

        -- Argent Tournament
        [63844] = "Argent Hippogryph",
        [66906] = "Argent Charger",
        [67466] = "Argent Warhorse",

        -- Ramkahen
        [88748] = "Brown Riding Camel",
        [88749] = "Tan Riding Camel",

        -- Tol Barad
        [88741] = "Drake of the West Wind",

        -- The Anglers
        [118089] = "Azure Water Strider",

        -- The Klaxxi
        [123886] = "Amber Scorpion",

        -- Order of the Cloud Serpent
        [113199] = "Jade Cloud Serpent",
        [123992] = "Azure Cloud Serpent",
        [123993] = "Golden Cloud Serpent",

        -- Golden Lotus
        [127174] = "Azure Riding Crane",
        [127176] = "Golden Riding Crane",
        [127177] = "Regal Riding Crane",

        -- Tushui Pandaren/Huojin Pandaren
        [120822] = "Great Red Dragon Turtle",
        [120395] = "Green Dragon Turtle",
        [127286] = "Black Dragon Turtle",
        [127287] = "Blue Dragon Turtle",
        [127288] = "Brown Dragon Turtle",
        [127289] = "Purple Dragon Turtle",
        [127290] = "Red Dragon Turtle",
        [127293] = "Great Green Dragon Turtle",
        [127295] = "Great Black Dragon Turtle",
        [127302] = "Great Blue Dragon Turtle",
        [127308] = "Great Brown Dragon Turtle",
        [127310] = "Great Purple Dragon Turtle",

        -- Shado-Pan
        [127154] = "Onyx Cloud Serpent", -- From Quest Surprise Attack!
        [129932] = "Green Shado-Pan Riding Tiger",
        [129934] = "Blue Shado-Pan Riding Tiger",
        [129935] = "Red Shado-Pan Riding Tiger",

        -- The Tillers
        [130086] = "Brown Riding Goat",
        [130137] = "White Riding Goat",
        [130138] = "Black Riding Goat",

        -- The August Celestials
        [129918] = "Thundering August Cloud Serpent",
        [132036] = "Thundering Ruby Cloud Serpent", -- 10x Skyshard

        -- The Lorewalkers
        [130092] = "Red Flying Cloud",

        -- Emperor Shaohao
        [127164] = "Heavenly Golden Cloud Serpent",

        -- The Saberstalkers
        [171633] = "Wild Goretusk",
        [190690] = "Bristling Hellboar",

        -- Steamwheedle Preservation Society
        [171634] = "Domesticated Razorback",

        -- Arakkoa Outcasts
        [171829] = "Shadowmane Charger",

        -- Order of the Awakened
        [183117] = "Corrupted Dreadwing",

        -- Vol'jin's Headhunters, Hand of the Prophet
        [190977] = "Deathtusk Felboar",

        -- Talon's Vengeance
        [230401] = "White Hawkstrider",

        -- Argussian Reach
        [242305] = "Sable Ruinstrider",
        [253004] = "Amethyst Ruinstrider",
        [253005] = "Beryl Ruinstrider",
        [253006] = "Russet Ruinstrider",
        [253007] = "Cerulean Ruinstrider",
        [253008] = "Umber Ruinstrider",

        -- Army of the Light
        [239013] = "Lightforged Warframe",

        ------------------------------
        -- Alliance ------------------
        ------------------------------

        -- Stormwind
        [458] = "Brown Horse",
        [470] = "Black Stallion",
        [472] = "Pinto",
        [6648] = "Chestnut Mare",
        [23227] = "Swift Palomino",
        [23228] = "Swift White Steed",
        [23229] = "Swift Brown Steed",

        -- Ironforge
        [6777] = "Gray Ram",
        [6898] = "White Ram",
        [6899] = "Brown Ram",
        [23238] = "Swift Brown Ram",
        [23239] = "Swift Gray Ram",
        [23240] = "Swift White Ram",

        -- Gnomeregan
        [10873] = "Red Mechanostrider",
        [10969] = "Blue Mechanostrider",
        [17453] = "Green Mechanostrider",
        [17454] = "Unpainted Mechanostrider",
        [23222] = "Swift Yellow Mechanostrider",
        [23223] = "Swift White Mechanostrider",
        [23225] = "Swift Green Mechanostrider",

        -- Darnassus
        [8394] = "Striped Frostsaber",
        [10793] = "Striped Nightsaber",
        [10789] = "Spotted Frostsaber",
        [23219] = "Swift Mistsaber",
        [23221] = "Swift Frostsaber",
        [23338] = "Swift Stormsaber",
        [66847] = "Striped Dawnsaber",

        -- Exodar
        [34406] = "Brown Elekk",
        [35710] = "Gray Elekk",
        [35711] = "Purple Elekk",
        [35712] = "Great Green Elekk",
        [35713] = "Great Blue Elekk",
        [35714] = "Great Purple Elekk",

        -- Gilneas
        [103195] = "Mountain Horse",
        [103196] = "Swift Mountain Horse",

        -- Wintersaber Trainers
        [17229] = "Winterspring Frostsaber",

        -- Kurenai
        [34896] = "Cobalt War Talbuk",
        [34897] = "White War Talbuk",
        [34898] = "Silver War Talbuk",
        [34899] = "Tan War Talbuk",
        [39315] = "Cobalt Riding Talbuk",
        [39317] = "Silver Riding Talbuk",
        [39318] = "Tan Riding Talbuk",
        [39319] = "White Riding Talbuk",

        -- The Sons of Hodir
        [59799] = "Ice Mammoth", -- Alliance
        [61470] = "Grand Ice Mammoth", -- Alliance

        -- Argent Tournament
        [63232] = "Stormwind Steed",
        [63636] = "Ironforge Ram",
        [63637] = "Darnassian Nightsaber",
        [63638] = "Gnomeregan Mechanostrider",
        [63639] = "Exodar Elekk",
        [65637] = "Great Red Elekk",
        [65638] = "Swift Moonsaber",
        [65640] = "Swift Gray Steed",
        [65642] = "Turbostrider",
        [65643] = "Swift Violet Ram",

        -- The Silver Covenant
        [66087] = "Silver Covenant Hippogryph",
        [66090] = "Quel'dorei Steed",

        -- Tol Barad
        [92231] = "Spectral Steed",

        -- Operation: Shieldwall
        [135416] = "Grand Armored Gryphon",

        -- Kirin Tor Offensive
        [140249] = "Golden Primal Direhorn",

        -- Council of Exarchs
        [171625] = "Dusty Rockhide",

        ------------------------------
        -- Horde ---------------------
        ------------------------------

        -- Orgrimmar
        [580] = "Timber Wolf",
        [6653] = "Dire Wolf",
        [6654] = "Brown Wolf",
        [23250] = "Swift Brown Wolf",
        [23251] = "Swift Timber Wolf",
        [23252] = "Swift Gray Wolf",
        [64658] = "Black Wolf",

        -- Darkspear Trolls
        [8395] = "Emerald Raptor",
        [10796] = "Turquoise Raptor",
        [10799] = "Violet Raptor",
        [23241] = "Swift Blue Raptor",
        [23242] = "Swift Olive Raptor",
        [23243] = "Swift Orange Raptor",

        -- Undercity
        [17462] = "Red Skeletal Horse",
        [17463] = "Blue Skeletal Horse",
        [17464] = "Brown Skeletal Horse",
        [17465] = "Green Skeletal Warhorse",
        [23246] = "Purple Skeletal Warhorse",
        [64977] = "Black Skeletal Horse",
        [66846] = "Ochre Skeletal Warhorse",

        -- Thunder Bluff
        [18989] = "Gray Kodo",
        [18990] = "Brown Kodo",
        [23247] = "Great White Kodo",
        [23248] = "Great Gray Kodo",
        [23249] = "Great Brown Kodo",
        [64657] = "White Kodo",

        -- Silvermoon City
        [35027] = "Swift Purple Hawkstrider",
        [33660] = "Swift Pink Hawkstrider",
        [34795] = "Red Hawkstrider",
        [35018] = "Purple Hawkstrider",
        [35020] = "Blue Hawkstrider",
        [35022] = "Black Hawkstrider",
        [35025] = "Swift Green Hawkstrider",

        -- Bilgewater Cartel
        [87090] = "Goblin Trike",
        [87091] = "Goblin Turbo-Trike",

        -- Darkspear Trolls in Un'Goro Crater
        [64659] = "Venomhide Ravasaur",

        -- The Mag'har
        [34896] = "Cobalt War Talbuk",
        [34897] = "White War Talbuk",
        [34898] = "Silver War Talbuk",
        [34899] = "Tan War Talbuk",
        [39315] = "Cobalt Riding Talbuk",
        [39317] = "Silver Riding Talbuk",
        [39318] = "Tan Riding Talbuk",
        [39319] = "White Riding Talbuk",

        -- The Sons of Hodir
        [59797] = "Ice Mammoth", -- Horde
        [61469] = "Grand Ice Mammoth", -- Horde

        -- The Sunreavers
        [66088] = "Sunreaver Dragonhawk",
        [66091] = "Sunreaver Hawkstrider",

        -- Argent Tournament
        [63635] = "Darkspear Raptor",
        [63641] = "Thunder Bluff Kodo",
        [63640] = "Orgrimmar Wolf",
        [63642] = "Silvermoon Hawkstrider",
        [63643] = "Forsaken Warhorse",
        [65645] = "White Skeletal Warhorse",
        [65639] = "Swift Red Hawkstrider",
        [65641] = "Great Golden Kodo",
        [65644] = "Swift Purple Raptor",
        [65646] = "Swift Burgundy Wolf",

        -- Tol Barad
        [92232] = "Spectral Wolf",

        -- Sunreaver Onslaught
        [140250] = "Crimson Primal Direhorn",

        -- Dominance Offensive
        [135418] = "Grand Armored Wyvern",

        -- Frostwolf Orcs
        [171842] = "Swift Frostwolf",
    },

    ["Achievement"] = {
        -- sourceType = 6
        ------------------------------
        -- Alliance & Horde ----------
        ------------------------------

        [43688] = "Amani War Bear", -- no longer available
        [59976] = "Black Proto-Drake", -- no longer available
        [60024] = "Violet Proto-Drake", -- What a Long, Strange Trip It's Been
        [60025] = "Albino Drake", -- Leading the Cavalry
        [98204] = "Amani Battle Bear", -- Bear-ly Made It
        [133023] = "Jade Pandaren Kite", -- Jade Pandaren Kite
        [142641] = "Brawler's Burly Mushan Beast", -- I've Got the Biggest Brawls of Them All (Season 1)
        [127169] = "Heavenly Azure Cloud Serpent", -- Lord of the Reins

        -- Wrath of the Lichking
        [59961] = "Red Proto-Drake", -- Glory of the Hero
        [63956] = "Ironbound Proto-Drake", -- Glory of the Ulduar Raider (25 player)
        [63963] = "Rusted Proto-Drake", -- Glory of the Ulduar Raider (10 player)
        [72807] = "Icebound Frostbrood Vanquisher", -- Glory of the Icecrown Raider (25 player)
        [72808] = "Bloodbathed Frostbrood Vanquisher", -- Glory of the Icecrown Raider (10 player)

        -- Cataclysm
        [97359] = "Flameward Hippogryph", -- The Molten Front Offensive
        [88331] = "Volcanic Stone Drake", -- Glory of the Cataclysm Hero
        [88335] = "Drake of the East Wind", -- Glory of the Cataclysm Raider
        [88990] = "Dark Phoenix", -- Guild Glory of the Cataclysm Raider
        [97560] = "Corrupted Fire Hawk", -- Glory of the Firelands Raider
        [107844] = "Twilight Harbinger", -- Glory of the Dragon Soul Raider

        -- Mists of Pandaria
        [124408] = "Thundering Jade Cloud Serpent", -- Guild Glory of the Pandaria Raider
        [127156] = "Crimson Cloud Serpent", -- Glory of the Pandaria Hero
        [127161] = "Heavenly Crimson Cloud Serpent", -- Glory of the Pandaria Raider
        [136400] = "Armored Skyscreamer", -- Glory of the Thundering Raider
        [148392] = "Spawn of Galakras", -- Glory of the Orgrimmar Raider
        [148396] = "Kor'kron War Wolf", -- Ahead of the Curve: Garrosh Hellscream (10/25 player)

        -- Challenge Mode
        [129552] = "Crimson Pandaren Phoenix", -- Challenge Conqueror: Silver
        [132117] = "Ashen Pandaren Phoenix", -- Challenge Conqueror: Silver
        [132118] = "Emerald Pandaren Phoenix", -- Challenge Conqueror: Silver
        [132119] = "Violet Pandaren Phoenix", -- Challenge Conqueror: Silver

        -- Warlords of Draenor
        [97501] = "Felfire Hawk", -- Mountacular
        [170347] = "Core Hound", -- Boldly, You Sought the Power of Ragnaros
        [175700] = "Emerald Drake", --  Awake the Drakes
        [171436] = "Gorestrider Gronnling", -- Glory of the Draenor Raider
        [171627] = "Blacksteel Battleboar", -- Guild Glory of the Draenor Raider
        [171632] = "Frostplains Battleboar", -- Glory of the Draenor Hero
        [171848] = "Challenger's War Yeti", -- Challenge Warlord: Silver
        [186305] = "Infernal Direwolf", -- Glory of the Hellfire Raider
        [191633] = "Soaring Skyterror", -- Draenor Pathfinder

        -- Legion
        [223814] = "Mechanized Lumber Extractor", -- Remember to Share
        [225765] = "Leyfeather Hippogryph", -- Glory of the Legion Hero
        [215558] = "Ratstallion", -- Underbelly Tycoon
        [193007] = "Grove Defiler", -- Glory of the Legion Raider
        [254260] = "Bleakhoof Ruinstrider", -- ...And Chew Mana Buns
        [253087] = "Antoran Gloomhound", -- Glory of the Argus Raider
        [258022] = "Lightforged Felcrusher", -- Allied Races: Lightforged Draenei
        [258060] = "Highmountain Thunderhoof", -- Allied Races: Highmountain Tauren
        [258845] = "Nightborne Manasaber", -- Allied Races: Nightborne
        [259202] = "Starcursed Voidstrider", -- Allied Races: Void Elf

        ------------------------------
        -- Alliance ------------------
        ------------------------------

        [68057] = "Swift Alliance Steed", -- no longer available
        [68187] = "Crusader's White Warhorse", -- no longer available
        [90621] = "Golden King", -- Guild Level 25
        [130985] = "Pandaren Kite", -- Pandaren Ambassador, Alliance

        [61996] = "Blue Dragonhawk", -- Mountain o' Mounts, Alliance
        [142478] = "Armored Blue Dragonhawk", -- Mount Parade, Alliance
        [179245] = "Chauffeur", -- Heirloom Hoarder, Alliance

        ------------------------------
        -- Horde ---------------------
        ------------------------------

        [68056] = "Swift Horde Wolf", -- no longer available
        [68188] = "Crusader's Black Warhorse", -- no longer available
        [93644] = "Kor'kron Annihilator", -- Guild Level 25
        [118737] = "Pandaren Kite", -- Pandaren Ambassador, Horde
        [171845] = "Warlord's Deathwheel", --  Warlord's Deathwheel
        [179244] = "Chauffeur", -- Heirloom Hoarder, Horde

        [61997] = "Red Dragonhawk", -- Mountain o' Mounts, Horde
        [142266] = "Armored Red Dragonhawk", -- Mount Parade, Horde
    },

    ["Garrison"] = {
        ------------------------------
        -- Alliance & Horde ----------
        ------------------------------

        -- Stables
        [171617] = "Trained Icehoof",
        [171623] = "Trained Meadowstomper",
        [171637] = "Trained Rocktusk",
        [171638] = "Trained Riverwallow",
        [171831] = "Trained Silverpelt",
        [171841] = "Trained Snarler",
        [171629] = "Armored Frostboar", -- Advanced Husbandry
        [171838] = "Armored Frostwolf", -- The Stable Master

        -- Fishing Shack
        [127271] = "Crimson Water Strider",

        -- Garrison Invasion
        [171624] = "Shadowhide Pearltusk",
        [171635] = "Giant Coldsnout",
        [171836] = "Garn Steelmaw",
        [171843] = "Smoky Direwolf",

        -- Garrison Mission
        [189364] = "Coalfist Gronnling", -- Breaker Two
        [171826] = "Mudback Riverbeast", -- It's a Boat, It's a Plane, It's... Just a Riverbeast.

        ------------------------------
        -- Alliance ------------------
        ------------------------------

        -- Trading Post
        [171626] = "Armored Irontusk", -- Alliance

        ------------------------------
        -- Horde ---------------------
        ------------------------------

        -- Trading Post
        [171839] = "Ironside Warwolf", -- Horde
    },

    ["PVP"] = {
        ------------------------------
        -- Alliance & Horde ----------
        ------------------------------

        -- Halaa
        [39316] = "Dark Riding Talbuk",
        [34790] = "Dark War Talbuk",

        -- Tol Barad
        [88741] = "Drake of the West Wind",

        -- Timeless Isle
        [148428] = "Ashhide Mushan Beast",

        -- Arena
        [37015] = "Swift Nether Drake", -- Season 1
        [44744] = "Merciless Nether Drake", -- Season 2
        [49193] = "Vengeful Nether Drake", -- Season 3
        [58615] = "Brutal Nether Drake", -- Season 4
        [64927] = "Deadly Gladiator's Frost Wyrm", -- Season 5
        [65439] = "Furious Gladiator's Frost Wyrm", -- Season 6
        [67336] = "Relentless Gladiator's Frost Wyrm", -- Season 7
        [71810] = "Wrathful Gladiator's Frost Wyrm", -- Season 8
        [101282] = "Vicious Gladiator's Twilight Drake", -- Season 9
        [101821] = "Ruthless Gladiator's Twilight Drake", -- Season 10
        [124550] = "Cataclysmic Gladiator's Twilight Drake", -- Season 11
        [139407] = "Malevolent Gladiator's Cloud Serpent", -- Season 12
        [148618] = "Tyrannical Gladiator's Cloud Serpent", -- Season 13
        [148619] = "Grievous Gladiator's Cloud Serpent", -- Season 14
        [148620] = "Prideful Gladiator's Cloud Serpent", -- Season 15
        [186828] = "Primal Gladiator's Felblood Gronnling", -- Season 16
        [189043] = "Wild Gladiator's Felblood Gronnling", -- Season 17
        [189044] = "Warmongering Gladiator's Felblood Gronnling", -- Season 18

        [227986] = "Vindictive Gladiator's Storm Dragon", -- Gladiator: Legion Season 1
        [227988] = "Fearless Gladiator's Storm Dragon", -- Gladiator: Legion Season 2
        [227989] = "Cruel Gladiator's Storm Dragon", -- Gladiator: Legion Season 3
        [227991] = "Ferocious Gladiator's Storm Dragon", -- Gladiator: Legion Season 4
        [227994] = "Fierce Gladiator's Storm Dragon",
        [227995] = "Dominating Gladiator's Storm Dragon",
        [243201] = "Demonic Gladiator's Storm Dragon",

        -- Prestige Reward
        [222202] = "Prestigious Bronze Courser",
        [222236] = "Prestigious Royal Courser",
        [222237] = "Prestigious Forest Courser",
        [222238] = "Prestigious Ivory Courser",
        [222240] = "Prestigious Azure Courser",
        [222241] = "Prestigious Midnight Courser",

        ------------------------------
        -- Alliance ------------------
        ------------------------------

        -- War Mounts
        [22717] = "Black War Steed",
        [22719] = "Black Battlestrider",
        [22720] = "Black War Ram",
        [22723] = "Black War Tiger",
        [48027] = "Black War Elekk",
        [183889] = "Vicious War Mechanostrider",
        [223578] = "Vicious War Elekk",
        [223341] = "Vicious Gilnean Warhorse",
        [229487] = "Vicious War Bear",
        [229512] = "Vicious War Lion",
        [232523] = "Vicious War Turtle",
        [242896] = "Vicious War Fox",

        -- Achievement
        [60118] = "Black War Bear", -- For The Alliance!
        [100332] = "Vicious War Steed", -- Veteran of the Alliance
        [146615] = "Vicious Warsaber", -- Grievous Combatant
        [171834] = "Vicious War Ram", -- Primal Combatant
        [193695] = "Prestigious War Steed", -- Free For All, More For Me

        -- Stormpike Guard
        [23510] = "Stormpike Battle Charger",

        -- Wintergrasp
        [59785] = "Black War Mammoth", -- Alliance

        -- Tol Barad
        [92231] = "Spectral Steed",

        -- Wrynn's Vanguard
        [171833] = "Pale Thorngrazer",

        ------------------------------
        -- Horde ---------------------
        ------------------------------

        -- War Mounts
        [22718] = "Black War Kodo",
        [22724] = "Black War Wolf",
        [22722] = "Red Skeletal Warhorse",
        [35028] = "Swift Warstrider",
        [22721] = "Black War Raptor",
        [185052] = "Vicious War Kodo",
        [223354] = "Vicious War Trike",
        [223363] = "Vicious Warstrider",
        [229486] = "Vicious War Bear",
        [232525] = "Vicious War Turtle",
        [230988] = "Vicious War Scorpion",
        [242897] = "Vicious War Fox",

        -- Achievement
        [60119] = "Black War Bear", -- For The Horde!
        [100333] = "Vicious War Wolf", -- Veteran of the Horde
        [146622] = "Vicious Skeletal Warhorse", -- Grievous Combatant
        [171835] = "Vicious War Raptor", -- Primal Combatant
        [204166] = "Prestigious War Wolf", -- Free For All, More For Me

        -- Frostwolf Clan
        [23509] = "Frostwolf Howler",

        -- Wintergrasp
        [59788] = "Black War Mammoth", -- Horde

        -- Tol Barad
        [92232] = "Spectral Wolf",

        -- Vol'jin's Spear
        [171832] = "Breezestrider Stallion",
    },

    ["Class"] = {
        ------------------------------
        -- Alliance & Horde ----------
        ------------------------------

        --Warlock
        [5784] = "Felsteed",
        [23161] = "Dreadsteed",
        [232412] = "Netherlord's Chaotic Wrathsteed",
        [238452] = "Netherlord's Brimstone Wrathsteed",
        [238454] = "Netherlord's Accursed Wrathsteed",

        -- Death Knight
        [48778] = "Acherus Deathcharger",
        [54729] = "Winged Steed of the Ebon Blade",
        [229387] = "Deathlord's Vilebrood Vanquisher",

        -- Paladin
        [66906] = "Argent Charger",

        -- Demon Hunter
        [200175] = "Felsaber",
        [229417] = "Slayer's Felbroken Shrieker",

        -- Mage
        [229376] = "Archmage's Prismatic Disc",

        -- Paladin
        [231435] = "Highlord's Golden Charger",
        [231587] = "Highlord's Vengeful Charger",
        [231588] = "Highlord's Vigilant Charger",
        [231589] = "Highlord's Valorous Charger",

        -- Priest
        [229377] = "High Priest's Lightsworn Seeker",

        -- Monk
        [229385] = "Ban-Lu, Grandmaster's Companion",

        --Hunter
        [229438] = "Huntmaster's Fierce Wolfhawk",
        [229439] = "Huntmaster's Dire Wolfhawk",
        [229386] = "Huntmaster's Loyal Wolfhawk",

        -- Warrior
        [229388] = "Battlelord's Bloodthirsty War Wyrm",

        -- Shaman
        [231442] = "Farseer's Raging Tempest",

        -- Rogue
        [231434] = "Shadowblade's Murderous Omen",
        [231523] = "Shadowblade's Lethal Omen",
        [231524] = "Shadowblade's Baneful Omen",
        [231525] = "Shadowblade's Crimson Omen",

        ------------------------------
        -- Alliance ------------------
        ------------------------------

        -- Paladin
        [23214] = "Summon Charger",
        [13819] = "Summon Warhorse",
        [73629] = "Summon Exarch's Elekk",
        [73630] = "Summon Great Exarch's Elekk",

        ------------------------------
        -- Horde ---------------------
        ------------------------------

        -- Paladin
        [34767] = "Summon Thalassian Charger",
        [34769] = "Summon Thalassian Warhorse",
        [69820] = "Summon Sunwalker Kodo",
        [69826] = "Summon Great Sunwalker Kodo",
    },

    ["World Event"] = {
        -- sourcetype = 7
        -- Love is in the Air
        [71342] = "Big Love Rocket",
        [102350] = "Swift Lovebird",

        -- Brewfest
        [43899] = "Brewfest Ram",
        [43900] = "Swift Brewfest Ram",
        [49378] = "Brewfest Riding Kodo",
        [49379] = "Great Brewfest Kodo",

        -- Hallow's End
        [48025] = "Headless Horseman's Mount",

        -- Noblegarden
        [102349] = "Swift Springstrider",

        -- Feast of Winter Veil
        [191314] = "Minion of Grumpus",

        -- Darkmoon Faire
        [103081] = "Darkmoon Dancing Bear",
        [102346] = "Swift Forest Strider",
        [228919] = "Darkwater Skate",
        [247448] = "Darkmoon Dirigible",

        -- Timewalking
        [142910] = "Ironbound Wraithcharger",
        [194464] = "Eclipse Dragonhawk",
        [201098] = "Infinite Timereaver",
        [127165] = "Yu'lei, Daughter of Jade",

        -- Call of the Scarab (Micro)
        [239766] = "Blue Qiraji War Tank",
        [239767] = "Red Qiraji War Tank",
    },

    ["Black Market"] = {
        [17481] = "Rivendare's Deathcharger",
        [30174] = "Riding Turtle",
        [36702] = "Fiery Warhorse",
        [40192] = "Ashes of Al'ar",
        [41252] = "Raven Lord",
        [46199] = "X-51 Nether-Rocket X-TREME",
        [46628] = "Swift White Hawkstrider",
        [54753] = "White Polar Bear",
        [59567] = "Azure Drake",
        [59568] = "Blue Drake",
        [59996] = "Blue Proto-Drake",
        [60021] = "Plagued Proto-Drake", -- Black Market only
        [61294] = "Green Proto-Drake",
        [63796] = "Mimiron's Head",
        [63963] = "Rusted Proto-Drake",
        [69395] = "Onyxian Drake",
        [72286] = "Invincible",
        [74918] = "Wooly White Rhino",
        [88742] = "Drake of the North Wind",
        [88744] = "Drake of the South Wind",
        [88746] = "Vitreous Stone Drake",
        [97493] = "Pureblood Fire Hawk",
        [101542] = "Flametalon of Alysrazor",
        [107842] = "Blazing Drake",
        [107845] = "Life-Binder's Handmaiden",
        [110039] = "Experiment 12-B",
        [127170] = "Astral Cloud Serpent",
        [127158] = "Heavenly Onyx Cloud Serpent",
        [130965] = "Son of Galleon",
        [132036] = "Thundering Ruby Cloud Serpent",
        [139442] = "Thundering Cobalt Cloud Serpent",
        [139448] = "Clutch of Ji-Kun",
        [148476] = "Thundering Onyx Cloud Serpent",
    },

    ["Promotion"] = {
        ------------------------------
        -- Alliance & Horde ----------
        ------------------------------

        -- Recruit-A-Friend
        [49322] = "Swift Zhevra",
        [75973] = "X-53 Touring Rocket",
        [121820] = "Obsidian Nightwing",
        [149801] = "Emerald Hippogryph",
        [171847] = "Cindermane Charger",

        -- Trading Card Game
        [30174] = "Riding Turtle",
        [46197] = "X-51 Nether-Rocket",
        [46199] = "X-51 Nether-Rocket X-TREME",
        [42776] = "Spectral Tiger",
        [42777] = "Swift Spectral Tiger",
        [51412] = "Big Battle Bear",
        [65917] = "Magic Rooster",
        [74856] = "Blazing Hippogryph",
        [74918] = "Wooly White Rhino",
        [93623] = "Mottled Drake",
        [96503] = "Amani Dragonhawk",
        [97581] = "Savage Raptor",
        [101573] = "Swift Shorestrider",
        [102488] = "White Riding Camel",
        [102514] = "Corrupted Hippogryph",
        [113120] = "Feldrake",
        [136505] = "Ghastly Charger",

        -- Blizzard Store
        [75614] = "Celestial Steed",
        [98727] = "Winged Guardian",
        [110051] = "Heart of the Aspects",
        [134573] = "Swift Windsteed",
        [139595] = "Armored Bloodwing",
        [142878] = "Enchanted Fey Dragon",
        [153489] = "Iron Skyreaver",
        [163024] = "Warforged Nightmare",
        [163025] = "Grinning Reaver",
        [180545] = "Mystic Runesaber",
        [189999] = "Grove Warden",
        [243512] = "Luminous Starseeker",
        [259395] = "Shu-zen, the Divine Sentinel",

        -- Promotion
        [58983] = "Big Blizzard Bear", -- BlizzCon
        [107203] = "Tyrael's Charger", -- no longer available, Diablo III Annual Pass
        [142073] = "Hearthsteed", -- Hearthstone
        [232405] = "Primal Flamesaber", -- Heroes of the Storm

        -- Collector's Edition
        [124659] = "Imperial Quilen", -- Mists of Pandaria Collector's Edition
        [155741] = "Dread Raven", -- Warlords of Draenor Collector's Edition
        [189998] = "Illidari Felstalker", -- Legion Collector's Edition

        ------------------------------
        -- Alliance ------------------
        ------------------------------

        [107516] = "Spectral Gryphon", -- Scroll of Resurrection
        [245723] = "Stormwind Skychaser", -- Blizzcon 2017
        [255695] = "Seabraid Stallion", -- BoA CE

        ------------------------------
        -- Horde ---------------------
        ------------------------------

        [107517] = "Spectral Wind Rider", -- Scroll of Resurrection
        [245725] = "Orgrimmar Interceptor", -- Blizzcon 2017
        [255696] = "Gilded Ravasaurn", -- BoA CE
    },
}

MountJournalEnhancedExpansion = {

	["Classic"] = {
        ["minID"] = 0,
        ["maxID"] = 30000,
    },
	
	["The Burning Crusade"] = {
        ["minID"] = 30001,
        ["maxID"] = 50000,
		[58983] = "Big Blizzard Bear",
    },
	
	["Wrath of the Lich King"] = {
        ["minID"] = 50001,
        ["maxID"] = 76000,
		[48778] = "Acherus Deathcharger",
		[46197] = "X-51 Nether-Rocket",
		[46199] = "X-51 Nether-Rocket X-TREME",
    },
	
	["Cataclysm"] = {
        ["minID"] = 76001,
        ["maxID"] = 113120,
        [71810] = "Wrathful Gladiator's Frost Wyrm",
        [75207] = "Abyssal Seahorse",
    },
	
	["Mists of Pandaria"] = {
        ["minID"] = 113121,
        ["maxID"] = 160000,
    },
	
	["Warlords of Draenor"] = {
        ["minID"] = 160001,
        ["maxID"] = 193000,
		[142910] = "Ironbound Wraithcharger",
		[194464] = "Eclipse Dragonhawk",
		[201098] = "Infinite Timereaver",
        [155741] = "Dread Raven", -- Warlords of Draenor Collector's Edition
    },

    ["Legion"] = {
        ["minID"] = 193001,
        ["maxID"] = 999999,
        [171827] = "Hellfire Infernal",
        [171850] = "Llothien Prowler",
        [127165] = "Yu'lei, Daughter of Jade",
        [189998] = "Illidari Felstalker", -- Legion Collector's Edition
    },
}

MountJournalEnhancedType = {
    ground = {
        typeIDs = {230, 231, 241, 269, 284}
    },
    flying = {
        typeIDs = {247, 248}
    },
    waterWalking = {
        typeIDs = {269}
    },
    underwater = {
        typeIDs = {232, 254},
        [30174] = "Riding Turtle",
        [64731] = "Sea Turtle",
    },
    repair = {
        [61425] = "Traveler's Tundra Mammoth",
        [122708] = "Grand Expedition Yak",
    },
    passenger = {
        [61425] = "Traveler's Tundra Mammoth",
        [122708] = "Grand Expedition Yak",
        [61469] = "Grand Ice Mammoth",
        [61470] = "Grand Ice Mammoth",
        [61465] = "Grand Black War Mammoth",
        [61467] = "Grand Black War Mammoth",
        [121820] = "Obsidian Nightwing",
        [93326] = "Sandstone Drake",
        [55531] = "Mechano-Hog",
        [60424] = "Mekgineer's Chopper",
        [75973] = "X-53 Touring Rocket",
        [245723] = "Stormwind Skychaser", -- Blizzcon 2017
        [245725] = "Orgrimmar Interceptor", -- Blizzcon 2017
    },
}

MountJournalEnhancedIgnored = {
    [459] = "Gray Wolf",
    [468] = "White Stallion",
    [578] = "Black Wolf",
    [579] = "Red Wolf",
    [581] = "Winter Wolf",
    [8980] = "Skeletal Horse",
    [6896] = "Black Ram",
    [10795] = "Ivory Raptor",
    [15780] = "Green Mechanostrider",
    [18363] = "Riding Kodo",
    [25863] = "Black Qiraji Battle Tank",
    [26655] = "Black Qiraji Battle Tank",
    [28828] = "Nether Drake",
    [33630] = "Blue Mechanostrider",
    [44317] = "Merciless Nether Drake",
    [48954] = "Swift Zhevra",
    [59572] = "Black Polar Bear",
    [60136] = "Grand Caravan Mammoth",
    [60140] = "Grand Caravan Mammoth",
    [62048] = "Black Dragonhawk Mount",
    [64656] = "Blue Skeletal Warhorse",
    [66122] = "Magic Rooster",
    [66123] = "Magic Rooster",
    [66124] = "Magic Rooster",
    [123182] = "White Riding Yak",
    [127209] = "Black Riding Yak",
    [127213] = "Brown Riding Yak",

    -- ghost
    [55164] = "Swift Spectral Gryphon",
    [194046] = "Swift Spectral Rylak",
    
    -- Legion Unknown Source
    [239363] = "Swift Spectral Hippogryph",
}
