﻿--[[
	Copyright (C) 2018  Fuhrbolg - Hyjal

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>

	Author's note: Under no circumstances should this Addon be used under any situation.
	It is dangerous and will cause significant harm to your computer. You have been warned.
--]]

--[[
 -	Import variables from other MongoMon source files here.
--]]
local ADDON_NAME, T = ...
local tablelength = T["tablelength"]
local clone = T["clone"]
local LOOKUP_SPEC_ID = T["LOOKUP_SPEC_ID"]
local LOOKUP_CLASS_ID = T["LOOKUP_CLASS_ID"]
local MongoMonPatch = T["MongoMonPatch"]
local getDamageHealingDiffText = T["getDamageHealingDiffText"]
local L = LibStub("AceLocale-3.0"):GetLocale("MongoMon")

--[[
-	Patch from various versions.
-]]
local MongoMonTest = {}
MongoMonTest.__index = MongoMonTest

-- Register this thing as a module so we can run it from a macro
LibStub("AceAddon-3.0"):GetAddon("MongoMon"):NewModule("MongoMonTest", MongoMonTest)

--[[
-	Used for testing, bind this to a macro via:
-	/run LibStub("AceAddon-3.0"):GetAddon("MongoMon"):GetModule("MongoMonTest"):Run()
-
-]]
function MongoMonTest:Run()
	print("Running Tests")
	
	-- Only run when using enUS
	self:TestUpgradeTo4enUS()
	self:TestShouldNotUpgradeTo4enUs()
	self:TestGetDamageHealingDiffTextRank1Healer()
	self:TestGetDamageHealingDiffTextNotRank1Healer()
	self:TestGetDamageHealingDiffTextRank1Damage()
	self:TestGetDamageHealingDiffTextNotRank1Damage()
	
	-- Only run when using ptBR
	--self:TestUpgradeTo4ptBR()
	
	print("All tests passed")
	
	local LOCAL_CLASS_TO_CLASS_TOKEN = {}
	for classID = 1, MAX_CLASSES do
		local class, classToken = GetClassInfoByID(classID)
		LOCAL_CLASS_TO_CLASS_TOKEN[class] = classToken
		--sprint(class, " -> ", classToken)
	end
end

--[[
-	Here we are looking at generating the correct text for the damageHealingDiffFontString 
-	text box. This needs to	take into consideration whether the player is a healer or not, 
-	as well as his current rank. If he is number 1 then it should report how far ahead he is,
-	if he is not rank 1 it should show how far behind the leader he is.
--]]
function MongoMonTest:TestGetDamageHealingDiffTextRank1Healer()
	local player = {
		name = "Fuhrbolg-Hyjal",
		isHealer = true,
		healing = 1000,
		damage = 0
	}
	local players = {
		{
			name = "Raul-Mexico",
			isHealer = true,
			healing = 999,
			damage = 0
		},
		{
			name = "Fuhrbolg-Hyjal",
			isHealer = true,
			healing = 1000,
			damage = 0
		},
		{
			name = "Surly-Hyjal",
			isHealer = false,
			healing = 0,
			damage = 100000000
		},
		{
			name = "MrsBleem-Hyjal",
			isHealer = true,
			healing = 750,
			damage = 10000
		}
	}
	local text = getDamageHealingDiffText(player, players)
	assert(text == "(ahead by 1)")
end

--[[
-	Player is not rank 1 healer
-]]
function MongoMonTest:TestGetDamageHealingDiffTextNotRank1Healer()
	local player = {
		name = "Fuhrbolg-Hyjal",
		isHealer = true,
		healing = 1000,
		damage = 0
	}
	local players = {
		{
			name = "Raul-Mexico",
			isHealer = true,
			healing = 1500,
			damage = 0
		},
		{
			name = "Fuhrbolg-Hyjal",
			isHealer = true,
			healing = 1000,
			damage = 0
		},
		{
			name = "Surly-Hyjal",
			isHealer = false,
			healing = 0,
			damage = 100000000
		},
		{
			name = "MrsBleem-Hyjal",
			isHealer = true,
			healing = 2000,
			damage = 10000
		}
	}
	local text = getDamageHealingDiffText(player, players)
	assert(text == "(1000 behind leader)")
end

--[[
-	Testing when player is rank 1 damage
-]]
function MongoMonTest:TestGetDamageHealingDiffTextRank1Damage()
	local player = {
		name = "Fuhrbolg-Hyjal",
		isHealer = false,
		healing = 1000,
		damage = 2500000
	}
	local players = {
		{
			name = "Raul-Mexico",
			isHealer = true,
			healing = 1500,
			damage = 0
		},
		{
			name = "Fuhrbolg-Hyjal",
			isHealer = false,
			healing = 1000,
			damage = 2500000
		},
		{
			name = "Surly-Hyjal",
			isHealer = false,
			healing = 0,
			damage = 1000000
		},
		{
			name = "MrsBleem-Hyjal",
			isHealer = true,
			healing = 2000,
			damage = 10000
		},
		{
			name = "Bleem-Hyjal",
			isHealer = false,
			healing = 10000000,
			damage = 999500
		}
	}
	local text = getDamageHealingDiffText(player, players)
	assert(text == "(ahead by 1.5 mil)")
end


--[[
- 	Testing when player is not rank 1 damage
--]]
function MongoMonTest:TestGetDamageHealingDiffTextNotRank1Damage()
	local player = {
		name = "Fuhrbolg-Hyjal",
		isHealer = false,
		healing = 1000,
		damage = 2500000
	}
	local players = {
		{
			name = "Raul-Mexico",
			isHealer = true,
			healing = 1500,
			damage = 0
		},
		{
			name = "Fuhrbolg-Hyjal",
			isHealer = false,
			healing = 1000,
			damage = 2500000
		},
		{
			name = "Surly-Hyjal",
			isHealer = false,
			healing = 0,
			damage = 45000000000
		},
		{
			name = "MrsBleem-Hyjal",
			isHealer = true,
			healing = 2000,
			damage = 10000
		},
		{
			name = "Bleem-Hyjal",
			isHealer = false,
			healing = 10000000,
			damage = 999500
		}
	}
	local text = getDamageHealingDiffText(player, players)
	assert(text == "(45.0 bil behind leader)")
end

--[[
-	Verify this crap actually works eh.
-]]
function MongoMonTest:TestUpgradeTo4enUS()
	-- Record from version 1, 2, and 3
	local records = {
		{
			["playerPercentHealingOfTeam"] = "2.82",
			["class"] = "Mage",
			["kills"] = 10,
			["isHealer"] = false,
			["damageRank"] = 5,
			["enemyHealing"] = 132288342,
			["healing"] = 3768291,
			["enemyDamage"] = 181397072,
			["teamDeaths"] = 13,
			["name"] = "Fatman",
			["teamDamage"] = 254579560,
			["healingRank"] = 16,
			["killHistory"] = {
				{
					["spellName"] = "Glacial Spike",
					["time"] = 1481511348,
					["amount"] = 271372,
					["playerName"] = "Tinhat-Quel'Thalas",
					["class"] = "Druid",
					["spellId"] = 228600,
					["overkill"] = 103134,
				}, -- [1]
				{
					["spellName"] = "Frostbolt",
					["time"] = 1481511407,
					["amount"] = 235551,
					["playerName"] = "Shademyst-EmeraldDream",
					["class"] = "Rogue",
					["spellId"] = 228597,
					["overkill"] = 166664,
				}, -- [2]
			},
			["avgTeamKills"] = 4.4,
			["time"] = 1481511763,
			["enemyDeaths"] = 55,
			["playerPercentKillsOfTeam"] = "18.52",
			["avgTeamDamage"] = 22097708.8,
			["teamHealing"] = 133659154,
			["players"] = {
				["all"] = {
					["Druid-Restoration"] = 1,
					["Priest-Holy"] = 1,
					["Mage-Frost"] = 1,
					["Rogue-Subtlety"] = 1,
					["Paladin-Retribution"] = 3,
					["Mage-Fire"] = 2,
					["Druid-Balance"] = 2,
					["Warrior-Protection"] = 1,
					["Warlock-Destruction"] = 2,
					["Warlock-Demonology"] = 1,
					["Monk-Mistweaver"] = 1,
					["Shaman-Enhancement"] = 1,
					["Warrior-Fury"] = 1,
					["Demon Hunter-Havoc"] = 1,
					["Priest-Discipline"] = 1,
					["Rogue-Outlaw"] = 1,
				},
				["kills"] = {
					["Warlock-Destruction"] = 1,
					["Mage-Frost"] = 2,
					["Druid-Balance"] = 3,
				},
				["healing"] = {
					["Priest-Holy"] = 1,
					["Monk-Mistweaver"] = 2,
					["Druid-Restoration"] = 3,
				},
				["damage"] = {
					["Warlock-Destruction"] = 1,
					["Demon Hunter-Havoc"] = 2,
					["Druid-Balance"] = 3,
				},
			},
			["deaths"] = 0,
			["mapId"] = 856,
			["isRated"] = false,
			["season"] = 19,
			["teamKills"] = 54,
			["didPlayerWin"] = true,
			["enemyKills"] = 13,
			["playerPercentDamageOfTeam"] = "13.20",
			["avgTeamDeaths"] = 1.3,
			["faction"] = "Horde",
			["avgTeamHealing"] = 12989086.3,
			["damage"] = 33602472,
			["spec"] = "Frost",
			["rank"] = 2,
		}, -- [1]
	}
	
	MongoMonPatch:Upgrade(records, nil, "4.0")
	
	-- Should upgrade to 4.0
	assert(records[1].mercenaryMode == false, "MercenaryMode should be set, but default to false")
	assert(records[1].classId == 8, "Mage classId is 8")
	assert(records[1].classToken == "MAGE", "Mage classToken is MAGE")
	assert(records[1].specId == 64, "Mage specId for Frost is 64")
	
	assert(records[1].killHistory[1].class == nil)
	assert(records[1].killHistory[2].class == nil)
	assert(records[1].killHistory[1].classToken == "DRUID", "Victim should be a DRUID")
	assert(records[1].killHistory[2].classToken == "ROGUE", "Victim should be a ROGUE")
	
	assert(records[1].players.kills["WARLOCK-9-267"] == 1)
	assert(records[1].players.kills["MAGE-8-64"] == 2)
	assert(records[1].players.kills["DRUID-11-102"] == 3)
	
	assert(records[1].players.healing["PRIEST-5-257"] == 1)
	assert(records[1].players.healing["MONK-10-270"] == 2)
	assert(records[1].players.healing["DRUID-11-105"] == 3)
	
	assert(records[1].players.damage["WARLOCK-9-267"] == 1)
	assert(records[1].players.damage["DEMONHUNTER-12-577"] == 2)
	assert(records[1].players.damage["DRUID-11-102"] == 3)
end

--[[
-	Should not upgrade because we are coming from a higher version
-]]
function MongoMonTest:TestShouldNotUpgradeTo4enUs()
	-- Record from version 1, 2, and 3
	local records = {
		{
			["playerPercentHealingOfTeam"] = "2.82",
			["class"] = "Mage",
			["kills"] = 10,
			["isHealer"] = false,
			["damageRank"] = 5,
			["enemyHealing"] = 132288342,
			["healing"] = 3768291,
			["enemyDamage"] = 181397072,
			["teamDeaths"] = 13,
			["name"] = "Fatman",
			["teamDamage"] = 254579560,
			["healingRank"] = 16,
			["killHistory"] = {
				{
					["spellName"] = "Glacial Spike",
					["time"] = 1481511348,
					["amount"] = 271372,
					["playerName"] = "Tinhat-Quel'Thalas",
					["class"] = "Druid",
					["spellId"] = 228600,
					["overkill"] = 103134,
				}, -- [1]
				{
					["spellName"] = "Frostbolt",
					["time"] = 1481511407,
					["amount"] = 235551,
					["playerName"] = "Shademyst-EmeraldDream",
					["class"] = "Rogue",
					["spellId"] = 228597,
					["overkill"] = 166664,
				}, -- [2]
			},
			["avgTeamKills"] = 4.4,
			["time"] = 1481511763,
			["enemyDeaths"] = 55,
			["playerPercentKillsOfTeam"] = "18.52",
			["avgTeamDamage"] = 22097708.8,
			["teamHealing"] = 133659154,
			["players"] = {
				["all"] = {
					["Druid-Restoration"] = 1,
					["Priest-Holy"] = 1,
					["Mage-Frost"] = 1,
					["Rogue-Subtlety"] = 1,
					["Paladin-Retribution"] = 3,
					["Mage-Fire"] = 2,
					["Druid-Balance"] = 2,
					["Warrior-Protection"] = 1,
					["Warlock-Destruction"] = 2,
					["Warlock-Demonology"] = 1,
					["Monk-Mistweaver"] = 1,
					["Shaman-Enhancement"] = 1,
					["Warrior-Fury"] = 1,
					["Demon Hunter-Havoc"] = 1,
					["Priest-Discipline"] = 1,
					["Rogue-Outlaw"] = 1,
				},
				["kills"] = {
					["Warlock-Destruction"] = 1,
					["Mage-Frost"] = 2,
					["Druid-Balance"] = 3,
				},
				["healing"] = {
					["Priest-Holy"] = 1,
					["Monk-Mistweaver"] = 2,
					["Druid-Restoration"] = 3,
				},
				["damage"] = {
					["Warlock-Destruction"] = 1,
					["Demon Hunter-Havoc"] = 2,
					["Druid-Balance"] = 3,
				},
			},
			["deaths"] = 0,
			["mapId"] = 856,
			["isRated"] = false,
			["season"] = 19,
			["teamKills"] = 54,
			["didPlayerWin"] = true,
			["enemyKills"] = 13,
			["playerPercentDamageOfTeam"] = "13.20",
			["avgTeamDeaths"] = 1.3,
			["faction"] = "Horde",
			["avgTeamHealing"] = 12989086.3,
			["damage"] = 33602472,
			["spec"] = "Frost",
			["rank"] = 2,
		}, -- [1]
	}
	
	MongoMonPatch:Upgrade(records, "4.0", "4.1")
	
	-- Verify records
	assert(records[1].players.kills["Warlock-Destruction"] == 1)
	assert(records[1].players.kills["Mage-Frost"] == 2)
	assert(records[1].players.kills["Druid-Balance"] == 3)
end

--[[
-	Verify this crap actually works eh.
-]]
function MongoMonTest:TestUpgradeTo4ptBR()
	-- Record from version 1, 2, and 3
	local records = {
		{
			["playerPercentHealingOfTeam"] = "1.02",
			["class"] = "Sacerdote",
			["kills"] = 0,
			["isHealer"] = false,
			["damageRank"] = 30,
			["enemyHealing"] = 312958413,
			["healing"] = 3082780,
			["enemyDamage"] = 471986393,
			["teamDeaths"] = 23,
			["name"] = "Fuhrbolg",
			["teamDamage"] = 441658676,
			["healingRank"] = 26,
			["season"] = 25,
			["race"] = "Morto-vivo",
			["time"] = 1525324935,
			["enemyDeaths"] = 32,
			["playerPercentKillsOfTeam"] = "0.00",
			["avgTeamDamage"] = 31530420.7857143,
			["teamHealing"] = 301578724,
			["killHistory"] = {
				{
					["spellName"] = "Glacial Spike",
					["time"] = 1481511348,
					["amount"] = 271372,
					["playerName"] = "Tinhat-Quel'Thalas",
					["class"] = "Druidesa",
					["spellId"] = 228600,
					["overkill"] = 103134,
				}, -- [1]
				{
					["spellName"] = "Frostbolt",
					["time"] = 1481511407,
					["amount"] = 235551,
					["playerName"] = "Shademyst-EmeraldDream",
					["class"] = "Ladino",
					["spellId"] = 228597,
					["overkill"] = 166664,
				}, -- [2]
			},
			["players"] = {
				["all"] = {
					["Druidesa-Feral"] = 1,
					["Caçadora-Precisão"] = 2,
					["Caçador-Precisão"] = 2,
					["Mago-Fogo"] = 1,
					["Sacerdotisa-Sagrado"] = 2,
					["Cavaleiro da Morte-Gélido"] = 1,
					["Guerreiro-Fúria"] = 1,
					["Druidesa-Equilíbrio"] = 1,
					["Druidesa-Guardião"] = 1,
					["Xamã-Elemental"] = 1,
					["Sacerdotisa-Disciplina"] = 1,
					["Bruxo-Destruição"] = 1,
					["Mago-Gélido"] = 1,
					["Caçador de Demônios-Devastação"] = 1,
					["Cavaleira da Morte-Sangue"] = 1,
					["Maga-Fogo"] = 2,
					["Caçadora de Demônios-Devastação"] = 2,
					["Druidesa-Restauração"] = 1,
					["Guerreira-Armas"] = 1,
					["Monge-Andarilho do Vento"] = 1,
					["Bruxo-Demonologia"] = 1,
					["Paladino-Retribuição"] = 1,
					["Sacerdote-Sagrado"] = 1,
					["Ladino-Assassinato"] = 1,
					["Bruxo-Suplício"] = 1,
				},
				["kills"] = {
					["Caçadora-Precisão"] = 1,
					["Bruxo-Destruição"] = 2,
					["Mago-Gélido"] = 3,
				},
				["healing"] = {
					["Sacerdotisa-Disciplina"] = 1,
					["Druidesa-Restauração"] = 2,
					["Sacerdotisa-Sagrado"] = 3,
				},
				["damage"] = {
					["Cavaleiro da Morte-Gélido"] = 1,
					["Caçadora-Precisão"] = 2,
					["Caçadora de Demônios-Devastação"] = 3,
				},
			},
			["deaths"] = 0,
			["mapId"] = 482,
			["isRated"] = false,
			["didPlayerWin"] = true,
			["enemyKills"] = 23,
			["teamKills"] = 28,
			["playerPercentDamageOfTeam"] = "0.05",
			["avgTeamHealing"] = 21321138.8571429,
			["mercenaryMode"] = false,
			["avgTeamDeaths"] = 1.64285714285714,
			["faction"] = "Horde",
			["avgTeamKills"] = 2,
			["damage"] = 232785,
			["spec"] = "Sagrado",
			["rank"] = 24,
		}, -- [4]
	}
	
	MongoMonPatch:Upgrade(records, nil, "4.0")
	
	-- Can't make this work, too dumb.
	--[[assert(records[1].mercenaryMode == false, "MercenaryMode should be set, but default to false")
	assert(records[1].classId == 8, "Priest classId is 5")
	assert(records[1].classToken == "PRIEST", "Priest classToken is PRIEST")
	assert(records[1].specId == 257, "Priest specId for Holy is 257")
	
	assert(records[1].killHistory[1].class == nil)
	assert(records[1].killHistory[2].class == nil)
	assert(records[1].killHistory[1].classToken == "DRUID", "Victim should be a DRUID")
	assert(records[1].killHistory[2].classToken == "ROGUE", "Victim should be a ROGUE")
	
	assert(records[1].players.kills["HUNTER-3-254"] == 1)
	assert(records[1].players.kills["WARLOCK-9-267"] == 2)
	assert(records[1].players.kills["MAGE-8-64"] == 3)
	
	assert(records[1].players.healing["PRIEST-5-256"] == 1)
	assert(records[1].players.healing["DRUID-11-105"] == 2)
	assert(records[1].players.healing["PRIEST-5-257"] == 3)
	
	assert(records[1].players.damage["DEATHKNIGHT-6-251"] == 1)	
	assert(records[1].players.damage["HUNTER-3-254"] == 2)
	assert(records[1].players.damage["DEMONHUNTER-12-577"] == 3)--]]
	assert(tablelength(records) == 0)
end

--[[
 -	Export variables that may be used by other MongoMon source files.
--]]
T["MongoMonTest"] = MongoMonTest