--[[
MobileVault_Sharing - Optional module to enable sharing and syncing of the guild bank
using LibGuildBankComm-1.0
Author: Michael Joseph Murray aka Lyte of Lothar(US)
Please see license.txt for details.
$Revision: 240 $
$Date: 2015-04-02 16:21:00 +0000 (Thu, 02 Apr 2015) $
Project Version: 3.3.01
contact: codemaster2010 AT gmail DOT com

Copyright (c) 2007-2011 Michael J. Murray aka Lyte of Lothar(US)
All rights reserved unless otherwise explicitly stated.
]]

local MGV = LibStub("AceAddon-3.0"):GetAddon("MobileVault")
local LGBC = LibStub("LibGuildBankComm-1.0")

local Sharing = MGV:NewModule("MobileVault_Sharing")

local function canViewTab(page)
	local _, _, view = GetGuildBankTabInfo(page)
	return view == 1 and true or false
end

function Sharing:OnEnable()
	--expects LibGuildBankComm v42b or greater
	LGBC.RegisterCallback(self, "GuildBankComm_PageUpdate", "OnPageSync")
	LGBC.RegisterCallback(self, "GuildBankComm_FundsUpdate", "OnMoneySync")
	LGBC.RegisterCallback(self, "GuildBankComm_TabsUpdate", "OnTabSync")
end

function Sharing:OnPageSync(event, sender, page, guildName)
	--now repopulate our image with the more recent data from the library
	for slot, link, stack in LGBC:IteratePage(page) do
		MGV.guilds[guildName][page].links[slot] = link
		MGV.guilds[guildName][page].stacks[slot] = stack
	end
	
	local name, icon = LGBC:GetTabInfo(page)
	--update tab name/texture and view permissions
	MGV.guilds[guildName][page].texture = icon
	MGV.guilds[guildName][page].name = name
	MGV.guilds[guildName][page].canView = canViewTab(page)
	
	--finally get the timestamp for this page
	MGV.guilds[guildName][page].lastUpdate = LGBC:GetPageTimestamp(page)
end

function Sharing:OnMoneySync(event, sender, newFunds, guildName)
	MGV.guilds[guildName].guildfunds = newFunds
end

function Sharing:OnTabSync(event, sender, numTabs, guildName)
	MGV.guilds[guildName].numtabs = numTabs
end
