--[[
MobileVault_Options - LoD options module for MobileVault
Author: Michael Joseph Murray aka Lyte of Lothar(US)
Please see license.txt for details.
$Revision: 240 $
$Date: 2015-04-02 16:21:00 +0000 (Thu, 02 Apr 2015) $
Project Version: 3.3.01
contact: codemaster2010 AT gmail DOT com

Copyright (c) 2007-2011 Michael J. Murray aka Lyte of Lothar(US)
All rights reserved unless otherwise explicitly stated.
]]
local L = LibStub("AceLocale-3.0"):GetLocale("MobileVault")
local MGV = LibStub("AceAddon-3.0"):GetAddon("MobileVault")

--color functions for tooltips
local function HexToRGBPerc(hex)
	local rhex, ghex, bhex = string.sub(hex, 1, 2), string.sub(hex, 3, 4), string.sub(hex, 5, 6)
	return tonumber(rhex, 16)/255, tonumber(ghex, 16)/255, tonumber(bhex, 16)/255
end

local function RGBPercToHex(r, g, b)
	r = r <= 1 and r >= 0 and r or 0
	g = g <= 1 and g >= 0 and g or 0
	b = b <= 1 and b >= 0 and b or 0
	return string.format("%02x%02x%02x", r*255, g*255, b*255)
end

local guildlist = {}
local handler = {}

function handler:Set(info, ...)
	if info.type == "multiselect" then
		local value, flag = ...
		MGV.db.profile[info.arg][value] = flag
	elseif info.type == "color" then
		local color = MGV.db.profile[info.arg]
		color[1], color[2], color[3] = ...
	else
		MGV.db.profile[info.arg] = ...
	end
	MGV:Update()
end

function handler:Get(info, ...)
	if info.type == "multiselect" then
		return MGV.db.profile[info.arg][...]
	elseif info.type == "color" then
		return unpack(MGV.db.profile[info.arg])
	else
		return MGV.db.profile[info.arg]
	end
end

local opts = {
	type = 'group',
	handler = handler,
	args = {
		tooltips = {
			type = 'group',
			name = L["Tooltip Options"],
			order = 2,
			args = {
				guilds = {
					type = 'multiselect',
					name = L["Guilds"],
					desc = L["Choose which guilds will display item counts on tooltips"],
					get = "Get",
					set = "Set",
					arg = "guildTooltips",
					values = function()
						wipe(guildlist)
						for k, v in pairs(MGV.guilds) do
							guildlist[k] = k
						end
						return guildlist
					end,
				},
				colors = {
					type = 'color',
					name = L["Tooltip Text Color"],
					desc = L["Set the color for the tooltip text"],
					get = function() return HexToRGBPerc(MGV.db.profile.tooltipColor) end,
					set = function(info, r, g, b) MGV.db.profile.tooltipColor = RGBPercToHex(r, g, b) end,
				},
			},
		},
		deleteGuilds = {
			type = 'group',
			name = L["Remove Guilds"],
			order = 3,
			args = {},
		},
		vault = {
			type = 'group',
			name = L["Vault Options"],
			order = 1,
			args = {
				frameColor = {
					type = 'color',
					name = L["Vault Frame Color"],
					desc = L["Set the color of the vault frame."],
					get = "Get",
					set = "Set",
					arg = "frameColor",
					order = 1,
				},
				highlightColor = {
					type = 'color',
					name = L["Border Highlight Color"],
					desc = L["Set the color of the borders when highlighted."],
					get = "Get",
					set = "Set",
					arg = "highlightColor",
					order = 2,
				},
				itemColor = {
					type = 'color',
					name = L["Item Border Color"],
					desc = L["Set the color of the item slot borders."],
					get = "Get",
					set = "Set",
					arg = "itemBorderColor",
					order = 5,
				},
				selectedColor = {
					type = 'color',
					name = L["Selected Tab Color"],
					desc = L["Set the color of the selected tab's border."],
					get = "Get",
					set = "Set",
					arg = "selectedColor",
					order = 3,
				},
				tabColor = {
					type = 'color',
					name = L["Tab Border Color"],
					desc = L["Set the color of the tab button borders."],
					get = "Get",
					set = "Set",
					arg = "tabBorderColor",
					order = 4,
				},
				textColor = {
					type = 'color',
					name = L["Text Color"],
					desc = L["Set the color of all the vault text."],
					get = "Get",
					set = "Set",
					arg = "textColor",
					order = 6,
				},
				frameAlpha = {
					type = 'range',
					name = L["Frame Alpha"],
					desc = L["Set the alpha of the vault frame."],
					get = "Get",
					set = "Set",
					min = 0,
					max = 1,
					step = 0.1,
					arg = "frameAlpha",
					order = 7,
				},
				strata = {
					type = 'select',
					name = L["Frame Strata"],
					desc = L["Set the strata level of the frame."],
					get = "Get",
					set = "Set",
					arg = "strata",
					values = {["FULLSCREEN"] = "Fullscreen", ["HIGH"] = "High", ["MEDIUM"] = "Medium", ["LOW"] = "Low", ["BACKGROUND"] = "Background",},
					order = 11,
				},
				itemPadding = {
					type = 'range',
					name = L["Item Slot Padding"],
					desc = L["Set the amount of space between the item slots."],
					get = "Get",
					set = "Set",
					min = 0,
					max = 7,
					step = 0.5,
					arg = "itemPadding",
					order = 10,
				},
				tabSpacing = {
					type = 'range',
					name = L["Tab Button Spacing"],
					desc = L["Set the amount of spacing between the tab buttons."],
					get = "Get",
					set = "Set",
					min = 0,
					max = 14,
					step = 1,
					arg = "tabButtonSpacing",
					order = 9,
				},
				scale = {
					type = 'range',
					name = L["Global Scale"],
					desc = L["Set the global scale."],
					get = "Get",
					set = "Set",
					min = 0.8,
					max = 1.5,
					step = 0.01,
					arg = "scale",
					order = 8,
				},
			},
		},
	},
}

local function removeGuild(info)
	local guild = info.arg
	local deleteOpts = opts.args.deleteGuilds.args
	
	deleteOpts[guild.."Name"] = nil
	deleteOpts[guild.."Delete"] = nil
	deleteOpts[guild.."Spacer"] = nil
	MGV.db.realm[guild] = nil
end

local i = 1
for gname in pairs(MGV.guilds) do
	local deleteOpts = opts.args.deleteGuilds.args
	
	deleteOpts[gname.."Name"] = {
		type = 'description',
		name = gname,
		order = i,
	}
	
	deleteOpts[gname.."Delete"] = {
		type = 'execute',
		name = _G.DELETE,
		func = removeGuild,
		arg = gname,
		order = i+1,
	}
	
	deleteOpts[gname.."Spacer"] = {
		type = 'header',
		name = "",
		order = i+2,
	}
	
	i = i*3
end

--add profile controls
opts.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(MGV.db)

LibStub("AceConfig-3.0"):RegisterOptionsTable("MobileVault", opts)
LibStub("AceConfigDialog-3.0"):AddToBlizOptions("MobileVault", "MobileVault")
LibStub("AceConfigDialog-3.0"):SetDefaultSize("MobileVault", 650, 400)
