--$Revision: 240 $
--$Date: 2015-04-02 16:21:00 +0000 (Thu, 02 Apr 2015) $
--project version: 3.3.01

local L = LibStub("AceLocale-3.0"):GetLocale("MobileVault")
local MAX_GUILDBANK_TABS = MAX_GUILDBANK_TABS
local MAX_GUILDBANK_TABS_PLUS1 = MAX_GUILDBANK_TABS + 1

--upvalue the menu button functions
local function switchGuilds(dropdownbutton, arg1, arg2, checked)
	if not checked then
		for i = 1, MAX_GUILDBANK_TABS do
			MobileVault.frame.tabButtons[i]:Hide()
			MobileVault.frame.tabButtons[i]:SetBackdropBorderColor(unpack(MobileVault.db.profile.tabBorderColor))
			MobileVault.frame.tabButtons[i].clicked = false
		end
		MobileVault.activeGuild = arg1
		MobileVault.activePage = next(MobileVault.guilds[arg1])
		MobileVault:ShowVaultFrame()
	end
end

local function closeAll() CloseDropDownMenus() end

--create the dropdown menu for selecting guilds
local guildActionMenu = CreateFrame("FRAME", "MGV_GuildMenu")
guildActionMenu.displayMode = "MENU"
local gMenuInfo = {}
guildActionMenu.initialize = function(self, level)
	if not level then return end
	wipe(gMenuInfo)
	if level == 1 then
		gMenuInfo.isTitle = 1
		gMenuInfo.text = "Guilds"
		gMenuInfo.notCheckable = 1
		UIDropDownMenu_AddButton(gMenuInfo, level)
		
		gMenuInfo.disabled = nil
		gMenuInfo.isTitle = nil
		gMenuInfo.notCheckable = nil
		
		--one entry for each guild, show a check on the currently selected guild
		for name, data in pairs(MobileVault.guilds) do
			if type(data) == "table" then
				gMenuInfo.text = name
				gMenuInfo.func = switchGuilds
				gMenuInfo.arg1 = name
				gMenuInfo.checked = MobileVault.activeGuild == name
				UIDropDownMenu_AddButton(gMenuInfo, level)
			end
		end
		wipe(gMenuInfo)
		
		--add a black space
		gMenuInfo.disabled = 1
		UIDropDownMenu_AddButton(gMenuInfo, level)
		gMenuInfo.disabled = nil
		
		--close the menu
		gMenuInfo.text = CLOSE
		gMenuInfo.func = closeAll
		gMenuInfo.checked = nil
		gMenuInfo.notCheckable = 1
		UIDropDownMenu_AddButton(gMenuInfo, level)
	end
end

local function dummy() end

local function item_onEnter(frame)
	frame:SetBackdropBorderColor(unpack(MobileVault.db.profile.highlightColor))
	if frame.item then
		GameTooltip:SetOwner(frame)
		GameTooltip:ClearLines()
		GameTooltip:SetHyperlink(frame.item)
		GameTooltip:Show()
	end
end

local function item_onLeave(frame)
	frame:SetBackdropBorderColor(unpack(MobileVault.db.profile.itemBorderColor))
	if frame.item then
		GameTooltip:Hide()
	end
end

local function item_onClick(frame, button, down)
	if frame.item and IsShiftKeyDown() then
		local box = ChatEdit_ChooseBoxForSend()
		ChatEdit_ActivateChat(box)
		box:Insert(frame.item)
	end
end

local function tab_onEnter(frame)
	GameTooltip:SetOwner(frame)
	GameTooltip:ClearLines()
	GameTooltip:AddLine(MobileVault.guilds[MobileVault.activeGuild][frame.num].name or L["Tab"] .. " "..frame.num)
	GameTooltip:Show()
	
	frame:SetBackdropBorderColor(unpack(MobileVault.db.profile.highlightColor))
end

local function tab_onLeave(frame)
	GameTooltip:Hide()
	
	if frame.clicked then
		frame:SetBackdropBorderColor(unpack(MobileVault.db.profile.selectedColor))
	else
		frame:SetBackdropBorderColor(unpack(MobileVault.db.profile.tabBorderColor))
	end
end

local function tab_onClick(frame, button, down)
	if MobileVault.activePage ~= 0 then
		if MobileVault.activePage == MAX_GUILDBANK_TABS_PLUS1 then
			MobileVault.frame.moneyButton:SetBackdropBorderColor(unpack(MobileVault.db.profile.tabBorderColor))
			MobileVault.frame.moneyButton.clicked = false
		else
			MobileVault.frame.tabButtons[MobileVault.activePage]:SetBackdropBorderColor(unpack(MobileVault.db.profile.tabBorderColor))
			MobileVault.frame.tabButtons[MobileVault.activePage].clicked = false
		end
	end
	
	frame.clicked = true
	MobileVault.activePage = frame.num
	frame:SetBackdropBorderColor(unpack(MobileVault.db.profile.selectedColor))
	MobileVault.frame.subtext:SetText(MobileVault.guilds[MobileVault.activeGuild][frame.num].name or L["Tab"] .. " "..frame.num)
	
	MobileVault.frame.scan:SetText(MobileVault:GetDatestampString(MobileVault.activeGuild, frame.num) or "")
	MobileVault.frame.scan:SetWidth(MobileVault.frame.scan:GetStringWidth()+20)
	
	--clear the old tab and populate the new tab
	MobileVault:Unpopulate()
	MobileVault:Populate(MobileVault.activeGuild, frame.num)
end

local function tab_onShow(frame)
	if MobileVault.guilds[MobileVault.activeGuild][frame.num].canView then
		frame.tab:SetDesaturated(false)
		frame:SetScript("OnClick", tab_onClick)
	else
		frame.tab:SetDesaturated(true)
		frame:SetScript("OnClick", dummy)
	end
end

function MobileVault:CreateVaultFrame()
	local f = CreateFrame("FRAME", "MOBILEVAULT_MAIN_FRAME", UIParent)
	table.insert(UISpecialFrames, "MOBILEVAULT_MAIN_FRAME")
	
	f.close = CreateFrame("BUTTON", nil, f, "UIPanelCloseButton")
	f.close:SetPoint("TOPRIGHT", f, "TOPRIGHT", -2, -1)
	
	f:SetWidth(600*self.db.profile.scale)
	f:SetHeight(390*self.db.profile.scale)
	
	f:SetFrameStrata(self.db.profile.strata)
	
	if self.db.profile.position.x then
		f:ClearAllPoints()
		f:SetPoint(self.db.profile.position.point, UIParent, self.db.profile.position.anchor, self.db.profile.position.x, self.db.profile.position.y)
	else
		f:SetPoint("CENTER", UIParent, "CENTER", 0, 200)
	end
	
	f:SetScript("OnDragStart", function() f:StartMoving() end )
	f:SetScript("OnDragStop", function(frame)
		f:StopMovingOrSizing()
		local point, _, anchor, x, y = f:GetPoint()
		MobileVault.db.profile.position.x = math.floor(x)
		MobileVault.db.profile.position.y = math.floor(y)
		MobileVault.db.profile.position.anchor = anchor
		MobileVault.db.profile.position.point = point
	end)
	
	f:SetBackdrop({
		bgFile = [[Interface\Buttons\WHITE8X8]],
		edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
		tile = false, tileSize = 16, edgeSize = 16,
		insets = { left = 3, right = 3, top = 3, bottom = 0 }
	})
	
	f:SetBackdropColor(unpack(self.db.profile.frameColor))
	f:SetAlpha(self.db.profile.frameAlpha)
	f:SetBackdropBorderColor(1, 1, 1, self.db.profile.frameAlpha)
	
	f:EnableMouse(true)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")
	f:SetClampedToScreen(true)
	
	f.actionbutton = CreateFrame("BUTTON", "MGV_VaultActionButton", f, "UIPanelButtonTemplate")
	f.actionbutton:SetWidth(100*self.db.profile.scale)
	f.actionbutton:SetHeight(22*self.db.profile.scale)
	f.actionbutton:SetText(L["Guilds"])
	f.actionbutton:SetPoint("TOPLEFT", f, "TOPLEFT", 15, -15)
	f.actionbutton:SetScript("OnClick", function(self, button, down) ToggleDropDownMenu(1, nil, MGV_GuildMenu, self:GetName(), 0, 0) end)
	f.actionbutton:Show()
	
	f.text = f:CreateFontString(nil, "OVERLAY")
	f.text:SetFontObject(GameFontNormal)
	f.text:ClearAllPoints()
	f.text:SetTextColor(unpack(self.db.profile.textColor))
	f.text:SetWidth(600*self.db.profile.scale)
	f.text:SetHeight(20*self.db.profile.scale)
	f.text:SetPoint("TOP", f, "TOP")
	f.text:SetJustifyH("CENTER")
	f.text:SetJustifyV("MIDDLE")
	f.text:SetText(L["Mobile Guild Vault"])
	
	f.subtext = f:CreateFontString(nil, "OVERLAY")
	f.subtext:SetFontObject(GameFontNormal)
	f.subtext:ClearAllPoints()
	f.subtext:SetTextColor(unpack(self.db.profile.textColor))
	f.subtext:SetWidth(600*self.db.profile.scale)
	f.subtext:SetHeight(20*self.db.profile.scale)
	f.subtext:SetPoint("TOP", f, "TOP", 0, -22)
	f.subtext:SetJustifyH("CENTER")
	f.subtext:SetJustifyV("MIDDLE")
	
	f.scan = f:CreateFontString(nil, "OVERLAY")
	f.scan:SetFontObject(GameFontNormal)
	f.scan:ClearAllPoints()
	f.scan:SetTextColor(unpack(self.db.profile.textColor))
	f.scan:SetHeight(20*self.db.profile.scale)
	f.scan:SetPoint("BOTTOMLEFT", f, "BOTTOMLEFT", 6, 3)
	f.scan:SetJustifyH("LEFT")
	f.scan:SetJustifyV("MIDDLE")
	
	f.gold = f:CreateFontString(nil, "OVERLAY")
	f.gold:SetFontObject(GameFontNormal)
	f.gold:ClearAllPoints()
	f.gold:SetTextColor(unpack(self.db.profile.textColor))
	f.gold:SetHeight(20*self.db.profile.scale)
	f.gold:SetPoint("BOTTOMRIGHT", f, "BOTTOMRIGHT", -6, 3)
	f.gold:SetJustifyH("RIGHT")
	f.gold:SetJustifyV("MIDDLE")
	
	f.items = self:CreateItemButtons(f)
	f.tabButtons = self:CreateTabButtons(f)
	f.moneyLogFrame = self:CreateMoneyLog(f)
	
	f.moneyButton = CreateFrame("BUTTON", nil, f)
	f.moneyButton.tab = f.moneyButton:CreateTexture(nil, "BORDER")
	f.moneyButton.tab:SetWidth(30*self.db.profile.scale)
	f.moneyButton.tab:SetHeight(30*self.db.profile.scale)
	f.moneyButton.num = MAX_GUILDBANK_TABS_PLUS1
	f.moneyButton.tab:SetTexCoord(0, 1, 0, 1)
	f.moneyButton.tab:SetPoint("CENTER", f.moneyButton, "CENTER")
	f.moneyButton.tab:SetTexture([[Interface\Icons\inv_misc_coin_02]])
	f.moneyButton:SetWidth(40*self.db.profile.scale)
	f.moneyButton:SetHeight(40*self.db.profile.scale)
	f.moneyButton:SetAlpha(self.db.profile.frameAlpha)
	f.moneyButton:SetBackdrop({
		bgFile = [[Interface\Buttons\WHITE8X8]],
		edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
		tile = false, tileSize = 16, edgeSize = 14,
		insets = { left = 3, right = 3, top = 3, bottom = 3 }
	})
	f.moneyButton:SetBackdropBorderColor(unpack(self.db.profile.tabBorderColor))
	f.moneyButton:SetBackdropColor(unpack(self.db.profile.frameColor))
	f.moneyButton:EnableMouse(true)
	f.moneyButton:RegisterForClicks("LeftButtonUp")
	f.moneyButton:ClearAllPoints()
	f.moneyButton:SetPoint("LEFT", f.tabButtons[1], "RIGHT", 2, 0)
	
	f.moneyButton:SetScript("OnClick", function(frame)
		if MobileVault.activePage ~= 0 and MobileVault.activePage ~= MAX_GUILDBANK_TABS_PLUS1 then
			MobileVault.frame.tabButtons[MobileVault.activePage]:SetBackdropBorderColor(unpack(MobileVault.db.profile.tabBorderColor))
			MobileVault.frame.tabButtons[MobileVault.activePage].clicked = false
		end
		
		frame.clicked = true
		MobileVault.activePage = frame.num
		frame:SetBackdropBorderColor(unpack(MobileVault.db.profile.selectedColor))
		
		MobileVault.frame.subtext:SetText(GUILD_BANK_MONEY_LOG)
	
		MobileVault.frame.scan:SetText(MobileVault:GetDatestampString(MobileVault.activeGuild, 1) or "")
		MobileVault.frame.scan:SetWidth(MobileVault.frame.scan:GetStringWidth()+20)
		
		--clear the old tab and populate the new tab
		MobileVault:Unpopulate()
		f.moneyLogFrame:Show()
	end)
	f.moneyButton:SetScript("OnEnter", function(frame)
		GameTooltip:SetOwner(frame)
		GameTooltip:ClearLines()
		GameTooltip:AddLine(GUILD_BANK_MONEY_LOG)
		GameTooltip:Show()
		
		frame:SetBackdropBorderColor(unpack(MobileVault.db.profile.highlightColor))
	end)
	f.moneyButton:SetScript("OnLeave", tab_onLeave)
	f.moneyButton:Hide()
	
	
	f:SetAlpha(self.db.profile.frameAlpha)
	f:SetFrameStrata(self.db.profile.strata)
	f:Hide()
	
	return f
end

function MobileVault:CreateTabButtons(parent)
	local t = {}
	local padding = self.db.profile.tabButtonSpacing
	
	for i = 1, MAX_GUILDBANK_TABS do
		t[i] = CreateFrame("BUTTON", nil, parent)
		
		t[i].tab = t[i]:CreateTexture(nil, "BORDER")
		t[i].tab:SetWidth(30*self.db.profile.scale)
		t[i].tab:SetHeight(30*self.db.profile.scale)
		t[i].tab:SetTexCoord(0, 1, 0, 1)
		t[i].tab:SetPoint("CENTER", t[i], "CENTER")
		
		t[i]:SetScript("OnEnter", tab_onEnter)
		t[i]:SetScript("OnLeave", tab_onLeave)
		t[i]:SetScript("OnClick", tab_onClick)
		t[i]:SetScript("OnShow", tab_onShow)
		
		t[i]:SetWidth(40*self.db.profile.scale)
		t[i]:SetHeight(40*self.db.profile.scale)
		t[i]:SetAlpha(self.db.profile.frameAlpha)
		
		t[i]:SetBackdrop({
			bgFile = [[Interface\Buttons\WHITE8X8]],
			edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
			tile = false, tileSize = 16, edgeSize = 14,
			insets = { left = 3, right = 3, top = 3, bottom = 3 }
		})
		
		t[i]:SetBackdropBorderColor(unpack(self.db.profile.tabBorderColor))
		t[i]:SetBackdropColor(unpack(self.db.profile.frameColor))
		t[i]:EnableMouse(true)
		t[i]:RegisterForClicks("LeftButtonUp")
		
		t[i]:ClearAllPoints()
		
		if i == 1 then
			t[i]:SetPoint("LEFT", parent, "RIGHT", 3, 160)
		else
			t[i]:SetPoint("TOP", t[i-1], "BOTTOM", 0, -padding)
		end
		
		t[i].num = i
		t[i].clicked = false
		t[i]:Hide()
	end
	
	return t
end

function MobileVault:CreateItemButtons(parent)
	local t = {}
	local padding = self.db.profile.itemPadding
	
	for i = 1, 98 do
		t[i] = CreateFrame("BUTTON", nil, parent)
		
		--texture for the item
		t[i].tex = t[i]:CreateTexture(nil, "BORDER")
		t[i].tex:SetWidth(32*self.db.profile.scale)
		t[i].tex:SetHeight(32*self.db.profile.scale)
		t[i].tex:SetPoint("CENTER", t[i], "CENTER")
		
		--item count for stacks
		t[i].count = t[i]:CreateFontString(nil, "BORDER")
		t[i].count:SetWidth(32*self.db.profile.scale)
		t[i].count:SetHeight(32*self.db.profile.scale)
		t[i].count:SetFontObject(NumberFontNormalSmallGray)
		t[i].count:SetTextColor(unpack(self.db.profile.textColor))
		t[i].count:SetJustifyH("RIGHT")
		t[i].count:SetJustifyV("BOTTOM")
		t[i].count:SetPoint("BOTTOMRIGHT", t[i], "BOTTOMRIGHT", -2, 3)
		
		--frame settings
		t[i]:SetWidth(40*self.db.profile.scale)
		t[i]:SetHeight(40*self.db.profile.scale)
		
		t[i]:SetBackdrop({
			bgFile = nil,
			edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
			tile = false, tileSize = 16, edgeSize = 14,
			insets = { left = 3, right = 3, top = 3, bottom = 3 }
		})
		
		t[i]:SetBackdropBorderColor(unpack(self.db.profile.itemBorderColor))
		t[i]:EnableMouse(true)
		
		t[i]:SetScript("OnEnter", item_onEnter)
		t[i]:SetScript("OnLeave", item_onLeave)
		t[i]:SetScript("OnClick", item_onClick)
		
		--position and show the frame
		t[i]:ClearAllPoints()
		
		if i == 1 then
			t[i]:SetPoint("TOPLEFT", parent, "TOPLEFT", 20, -60)
		else
			if (i % 7 > 1) or (i % 7 == 0) then
				t[i]:SetPoint("TOP", t[i-1], "BOTTOM", 0, -padding)
			elseif (i % 7 == 1) then
				t[i]:SetPoint("LEFT", t[i-7], "RIGHT", padding, 0)
			end
		end
		
		t[i]:Show()
	end
	
	return t
end

function MobileVault:CreateMoneyLog(parent)
	local f = CreateFrame("FRAME", nil, parent)
	
	f:SetWidth(596*self.db.profile.scale)
	f:SetHeight(315*self.db.profile.scale)
	f:SetFrameLevel(parent:GetFrameLevel()+3)
	f:ClearAllPoints()
	f:SetPoint("TOP", parent, "TOP", 0, -42)
	f:SetBackdrop({
		bgFile = [[Interface\Buttons\WHITE8X8]],
		edgeFile = nil,
		tile = false, tileSize = 16, edgeSize = 16,
		insets = { left = 3, right = 3, top = 3, bottom = 0 }
	})
	f:SetBackdropColor(unpack(self.db.profile.frameColor))
	f:SetAlpha(self.db.profile.frameAlpha)
	
	f.strings = {}
	for i = 1, 25 do
		f.strings[i] = f:CreateFontString(nil, "OVERLAY")
		f.strings[i]:SetFontObject(GameFontNormal)
		f.strings[i]:ClearAllPoints()
		f.strings[i]:SetTextColor(unpack(self.db.profile.textColor))
		f.strings[i]:SetHeight(12*self.db.profile.scale)
		f.strings[i]:SetWidth(600*self.db.profile.scale)
		f.strings[i]:SetJustifyH("LEFT")
		f.strings[i]:SetJustifyV("MIDDLE")
		if i == 1 then
			f.strings[i]:SetPoint("TOPLEFT", f, "TOPLEFT", 50, 0)
		else
			f.strings[i]:SetPoint("TOP", f.strings[i-1], "BOTTOM", 0, -1)
		end
	end
	
	f:SetScript("OnShow", function(frame)
		local k = 1
		for i = #MobileVault.guilds[MobileVault.activeGuild].moneyLog, 1, -1 do
			trans, name, amount, timestamp = strsplit(",", MobileVault.guilds[MobileVault.activeGuild].moneyLog[i])
			amount = tonumber(amount)
			money = GetDenominationsFromCopper(amount)
			timestamp = tonumber(timestamp)			
			name = format("|cffffd200%s|r", name)
			
			if trans == "deposit" then
				msg = format(GUILDBANK_DEPOSIT_MONEY_FORMAT, name, money)
			elseif trans == "withdraw" then
				msg = format(GUILDBANK_WITHDRAW_MONEY_FORMAT, name, money)
			elseif trans == "repair" then
				msg = format(GUILDBANK_REPAIR_MONEY_FORMAT, name, money)
			elseif trans == "withdrawForTab" then
				msg = format(GUILDBANK_WITHDRAWFORTAB_MONEY_FORMAT, name, money)
			elseif trans == "buyTab" then
				msg = format(GUILDBANK_BUYTAB_MONEY_FORMAT, name, money)
			end
			
			frame.strings[k]:SetFormattedText("%s |cff009999( %s )|r", msg, date("%x", timestamp))
			k = k + 1
		end
	end)
	
	f:Hide()
	
	return f
end

local function getFirstViewablePage(vault)
	for i = 1, MAX_GUILDBANK_TABS do
		if vault[i] and vault[i].canView then
			return i
		end
	end
	
	return 0
end

function MobileVault:ShowVaultFrame()
	if not self.frame then self.frame = self:CreateVaultFrame() end
	if self.activePage == 0 then self.activePage = getFirstViewablePage(self.guilds[self.activeGuild]) end
	if not self.guilds[self.activeGuild].hasData then
		--bail if no data is saved
		self:Unpopulate()
		for i = 1, MAX_GUILDBANK_TABS do
			self.frame.tabButtons[i]:Hide()
			self.frame.tabButtons[i]:SetBackdropBorderColor(unpack(self.db.profile.tabBorderColor))
			self.frame.tabButtons[i].clicked = false
		end
		self.frame.moneyButton:Hide()
		self.frame:Show()
		return
	end 
	
	local moneytab = MAX_GUILDBANK_TABS_PLUS1
	
	self:Unpopulate()
	if self.activePage < moneytab then
		self:Populate(self.activeGuild, self.activePage)
	else
		self.frame.moneyLogFrame:Show()
	end
	self:SetupTabs(self.activeGuild)
	
	self.frame.gold:SetText(self:GetMoneyString(self.guilds[self.activeGuild].guildfunds) or "")
	self.frame.gold:SetWidth(self.frame.gold:GetStringWidth()+20)
	
	self.frame.scan:SetText(self:GetDatestampString(self.activeGuild, self.activePage) or "")
	self.frame.scan:SetWidth(self.frame.scan:GetStringWidth()+20)
	
	self.frame.text:SetText(self.activeGuild)
	if self.activePage < moneytab then
		self.frame.subtext:SetText(self.guilds[self.activeGuild][self.activePage].name or L["Tab"] .. " "..self.activePage)
	else
		self.frame.subtext:SetText(GUILD_BANK_MONEY_LOG)
	end
	
	if self.activePage < moneytab then
		self.frame.tabButtons[self.activePage].clicked = true
		self.frame.tabButtons[self.activePage]:SetBackdropBorderColor(unpack(self.db.profile.selectedColor))
	else
		self.frame.moneyButton.clicked = true
		self.frame.moneyButton:SetBackdropBorderColor(unpack(self.db.profile.selectedColor))
	end
	
	self.frame:Show()
end
