--[[
Name: LibBabble-DigSites-3.0
Revision: $Rev: 66 $
Maintainers: ckknight, nevcairiel, Ackis
Website: http://www.wowace.com/projects/libbabble-digsites-3-0/
Dependencies: None
License: MIT
]]

local MAJOR_VERSION = "LibBabble-DigSites-3.0"
local MINOR_VERSION = 90000 + tonumber(("$Rev: 66 $"):match("%d+"))

if not LibStub then error(MAJOR_VERSION .. " requires LibStub.") end
local lib = LibStub("LibBabble-3.0"):New(MAJOR_VERSION, MINOR_VERSION)
if not lib then return end

local GAME_LOCALE = GetLocale()

lib:SetBaseTranslations (
	{
	["Abyssal Sands Fossil Ridge"] = "Abyssal Sands Fossil Ridge",
	["Aerie Peak Digsite"] = "Aerie Peak Digsite",
	["Agol'watha Digsite"] = "Agol'watha Digsite",
	["Akhenet Fields Digsite"] = "Akhenet Fields Digsite",
	["Altar of Quetz'lun Digsite"] = "Altar of Quetz'lun Digsite",
	["Altar of Sseratus Digsite"] = "Altar of Sseratus Digsite",
	["Altar of Zul Digsite"] = "Altar of Zul Digsite",
	["Amber Quarry Digsite"] = "Amber Quarry Digsite",
	["Ancestral Grounds Digsite"] = "Ancestral Grounds Digsite",
	["Andorhal Fossil Bank"] = "Andorhal Fossil Bank",
	["Ango'rosh Digsite"] = "Ango'rosh Digsite",
	["Anguish Fortress Digsite"] = "Anguish Fortress Digsite",
	["Apexis Excavation Digsite"] = "Apexis Excavation Digsite",
	["Arklon Ruins Digsite"] = "Arklon Ruins Digsite",
	["Bael Modan Digsite"] = "Bael Modan Digsite",
	["Baleheim Digsite"] = "Baleheim Digsite",
	["Balia'mah Digsite"] = "Balia'mah Digsite",
	["Bal'lal Ruins Digsite"] = "Bal'lal Ruins Digsite",
	["Biel'aran Ridge Digsite"] = "Biel'aran Ridge Digsite",
	["Bleeding Hollow Ruins Digsite"] = "Bleeding Hollow Ruins Digsite",
	["Bloodmane Pridelands Digsite"] = "Bloodmane Pridelands Digsite",
	["Bloodmane Valley Digsite"] = "Bloodmane Valley Digsite",
	["Boha'mu Ruins Digsite"] = "Boha'mu Ruins Digsite",
	["Bonechewer Ruins Digsite"] = "Bonechewer Ruins Digsite",
	["Bone Wastes Digsite"] = "Bone Wastes Digsite",
	["Broken Commons Digsite"] = "Broken Commons Digsite",
	["Broken Pillar Digsite"] = "Broken Pillar Digsite",
	["Brunnhildar Village Digsite"] = "Brunnhildar Village Digsite",
	["Burial Fields Digsite"] = "Burial Fields Digsite",
	["Burning Blade Digsite"] = "Burning Blade Digsite",
	["Burning Plateau Digsite"] = "Burning Plateau Digsite",
	["Chow Farmstead Digsite"] = "Chow Farmstead Digsite",
	["Coilskar Point Digsite"] = "Coilskar Point Digsite",
	["Coldsnap Bluffs Digsite"] = "Coldsnap Bluffs Digsite",
	["Constellas Digsite"] = "Constellas Digsite",
	["Cursed Landing Digsite"] = "Cursed Landing Digsite",
	["Cursed Woods Digsite"] = "Cursed Woods Digsite",
	["Daggermaw Flows Digsite"] = "Daggermaw Flows Digsite",
	["Darkmist Digsite"] = "Darkmist Digsite",
	["Deadgrin Ruins Digsite"] = "Deadgrin Ruins Digsite",
	["Den of Sorrow Digsite"] = "Den of Sorrow Digsite",
	["Destroyed Village Digsite"] = "Destroyed Village Digsite",
	["Dire Maul Digsite"] = "Dire Maul Digsite",
	["Dragonmaw Fortress"] = "Dragonmaw Fortress",
	["Drakil'Jin Ruins Digsite"] = "Drakil'Jin Ruins Digsite",
	["Dreadmaul Fossil Field"] = "Dreadmaul Fossil Field",
	["Drowning Plateau Digsite"] = "Drowning Plateau Digsite",
	["Dunemaul Fossil Ridge"] = "Dunemaul Fossil Ridge",
	["Dun Garok Digsite"] = "Dun Garok Digsite",
	["Duskfall Island Digsite"] = "Duskfall Island Digsite",
	["Dunwald Ruins Digsite"] = "Dunwald Ruins Digsite",
	["East Auchindoun Digsite"] = "East Auchindoun Digsite",
	["East Coldsnap Bluffs Digsite"] = "East Coldsnap Bluffs Digsite",
	["East Snow Covered Hills Digsite"] = "East Snow Covered Hills Digsite",
	["East Sra'vess Digsite"] = "East Sra'vess Digsite",
	["East Summer Fields Digsite"] = "East Summer Fields Digsite",
	["Eastern Ruins of Thaurissan"] = "Eastern Ruins of Thaurissan",
	["Eastern Zul'Kunda Digsite"] = "Eastern Zul'Kunda Digsite",
	["Eastern Zul'Mamwe Digsite"] = "Eastern Zul'Mamwe Digsite",
	["Eastmoon Ruins Digsite"] = "Eastmoon Ruins Digsite",
	["Eclipse Point Digsite"] = "Eclipse Point Digsite",
	["Emperor's Approach Digsite"] = "Emperor's Approach Digsite",
	["Emperor's Omen Digsite"] = "Emperor's Omen Digsite",
	["En'kilah Digsite"] = "En'kilah Digsite",
	["Ethel Rethor Digsite"] = "Ethel Rethor Digsite",
	["Fallsong Village Digsite"] = "Fallsong Village Digsite",
	["Felstone Fossil Field"] = "Felstone Fossil Field",
	["Fields of Blood Fossil Bank"] = "Fields of Blood Fossil Bank",
	["Fire Camp Osul Digsite"] = "Fire Camp Osul Digsite",
	["Five Sisters Digsite"] = "Five Sisters Digsite",
	["Forest Heart Digsite"] = "Forest Heart Digsite",
	["Forest Song Digsite"] = "Forest Song Digsite",
	["Forgotten Ogre Ruin Digsite"] = "Forgotten Ogre Ruin Digsite",
	["Frostboar Drifts Digsite"] = "Frostboar Drifts Digsite",
	["Frostwhisper Gorge Digsite"] = "Frostwhisper Gorge Digsite",
	["Frostwind Crag Digsite"] = "Frostwind Crag Digsite",
	["Frozen Lake Digsite"] = "Frozen Lake Digsite",
	["Gate to Golden Valley Digsite"] = "Gate to Golden Valley Digsite",
	["Gjalerbron Digsite"] = "Gjalerbron Digsite",
	["Gloomshade Digsite"] = "Gloomshade Digsite",
	["Gong of Hope Digsite"] = "Gong of Hope Digsite",
	["Gordal Fortress Digsite"] = "Gordal Fortress Digsite",
	["Gor'gaz Outpost Digsite"] = "Gor'gaz Outpost Digsite",
	["Grangol'var Village Digsite"] = "Grangol'var Village Digsite",
	["Great Bridge Digsite"] = "Great Bridge Digsite",
	["Greenwarden's Fossil Bank"] = "Greenwarden's Fossil Bank",
	["Grim Batol Digsite"] = "Grim Batol Digsite",
	["Grimesilt Digsite"] = "Grimesilt Digsite",
	["Grimsilt Digsite"] = "Grimsilt Digsite",
	["Grom'gar Digsite"] = "Grom'gar Digsite",
	["Grove of Aessina Digsite"] = "Grove of Aessina Digsite",
	["Grumblepaw Ranch Digsite"] = "Grumblepaw Ranch Digsite",
	["Gurubashi Arena Digsite"] = "Gurubashi Arena Digsite",
	["Halaa Digsite"] = "Halaa Digsite",
	["Halgrind Digsite"] = "Halgrind Digsite",
	["Hammertoe's Digsite"] = "Hammertoe's Digsite",
	["Hatred's Vice Digsite"] = "Hatred's Vice Digsite",
	["Hellfire Basin Digsite"] = "Hellfire Basin Digsite",
	["Hellfire Citadel Digsite"] = "Hellfire Citadel Digsite",
	["Highmaul Watchtower Digsite"] = "Highmaul Watchtower Digsite",
	["Howling Plateau Digsite"] = "Howling Plateau Digsite",
	["Humboldt Conflagration Digsite"] = "Humboldt Conflagration Digsite",
	["Icewind Drifts Digsite"] = "Icewind Drifts Digsite",
	["Ikz'ka Ridge Digsite"] = "Ikz'ka Ridge Digsite",
	["Illidari Point Digsite"] = "Illidari Point Digsite",
	["Infectis Scar Fossil Field"] = "Infectis Scar Fossil Field",
	["Ironband's Excavation Site"] = "Ironband's Excavation Site",
	["Ironbeard's Tomb"] = "Ironbeard's Tomb",
	["Ironwood Digsite"] = "Ironwood Digsite",
	["Jade Temple Grounds Digsite"] = "Jade Temple Grounds Digsite",
	["Jaedenar Digsite"] = "Jaedenar Digsite",
	["Jintha'Alor Lower City Digsite"] = "Jintha'Alor Lower City Digsite",
	["Jintha'Alor Upper City Digsite"] = "Jintha'Alor Upper City Digsite",
	["Jotunheim Digsite"] = "Jotunheim Digsite",
	["Kag'ah Digsite"] = "Kag'ah Digsite",
	["Keset Pass Digsite"] = "Keset Pass Digsite",
	["Khartut's Tomb Digsite"] = "Khartut's Tomb Digsite",
	["Kodo Graveyard"] = "Kodo Graveyard",
	["Kolramas Digsite"] = "Kolramas Digsite",
	["Kor'vess Digsite"] = "Kor'vess Digsite",
	["Krasarang Wilds Digsite"] = "Krasarang Wilds Digsite",
	["Kun-Lai Peak Digsite"] = "Kun-Lai Peak Digsite",
	["Kypari'ik Digsite"] = "Kypari'ik Digsite",
	["Kypari Vor Digsite"] = "Kypari Vor Digsite",
	["Kypari'zar Digsite"] = "Kypari'zar Digsite",
	["Kzzok Warcamp Digsite"] = "Kzzok Warcamp Digsite",
	["Lake Kel'Theril Digsite"] = "Lake Kel'Theril Digsite",
	["Lake of Stars Digsite"] = "Lake of Stars Digsite",
	["Lakeridge Highway Fossil Bank"] = "Lakeridge Highway Fossil Bank",
	["Lashwind Cleft Digsite"] = "Lashwind Cleft Digsite",
	["Laughing Skull Digsite"] = "Laughing Skull Digsite",
	["Lost Dynasty Digsite"] = "Lost Dynasty Digsite",
	["Lower Lakkari Tar Pits"] = "Lower Lakkari Tar Pits",
	["Mannoroc Coven Digsite"] = "Mannoroc Coven Digsite",
	["Mar'gok's Overwatch Digsite"] = "Mar'gok's Overwatch Digsite",
	["Marshlands Fossil Bank"] = "Marshlands Fossil Bank",
	["Mistfall Village Digsite"] = "Mistfall Village Digsite",
	["Misty Reed Fossil Bank"] = "Misty Reed Fossil Bank",
	["Moonrest Gardens Digsite"] = "Moonrest Gardens Digsite",
	["Morlos'Aran Digsite"] = "Morlos'Aran Digsite",
	["Nar'shola (Middle Tier) Digsite"] = "Nar'shola (Middle Tier) Digsite",
	["Nazj'vel Digsite"] = "Nazj'vel Digsite",
	["Neferset Digsite"] = "Neferset Digsite",
	["Nek'mani Wellspring Digsite"] = "Nek'mani Wellspring Digsite",
	["Nifflevar Digsite"] = "Nifflevar Digsite",
	["Nightmare Scar Digsite"] = "Nightmare Scar Digsite",
	["Niuzao Temple Digsite"] = "Niuzao Temple Digsite",
	["Njorndar Village Digsite"] = "Njorndar Village Digsite",
	["North Fruited Fields Digsite"] = "North Fruited Fields Digsite",
	["North Great Wall Digsite"] = "North Great Wall Digsite",
	["North Isildien Digsite"] = "North Isildien Digsite",
	["North Ruins of Dojan Digsite"] = "North Ruins of Dojan Digsite",
	["North Ruins of Guo-Lai Digsite"] = "North Ruins of Guo-Lai Digsite",
	["North Sik'vess Digsite"] = "North Sik'vess Digsite",
	["North Spirit Woods Digsite"] = "North Spirit Woods Digsite",
	["North Summer Fields Digsite"] = "North Summer Fields Digsite",
	["North Temple of the Red Crane Digsite"] = "North Temple of the Red Crane Digsite",
	["Northridge Fossil Field"] = "Northridge Fossil Field",
	["Obelisk of the Stars Digsite"] = "Obelisk of the Stars Digsite",
	["Old Village Digsite"] = "Old Village Digsite",
	["Oneiros Digsite"] = "Oneiros Digsite",
	["Orchard Digsite"] = "Orchard Digsite",
	["Orsis Digsite"] = "Orsis Digsite",
	["Overgrown Highmaul Road Digsite"] = "Overgrown Highmaul Road Digsite",
	["Overlook Ruins Digsite"] = "Overlook Ruins Digsite",
	["Owl Wing Thicket Digsite"] = "Owl Wing Thicket Digsite",
	["Paoquan Hollow Digsite"] = "Paoquan Hollow Digsite",
	["Pinchwhistle Point Digsite"] = "Pinchwhistle Point Digsite",
	["Pit of Fiends Digsite"] = "Pit of Fiends Digsite",
	["Pit of Narjun Digsite"] = "Pit of Narjun Digsite",
	["Plaguewood Digsite"] = "Plaguewood Digsite",
	["Pools of Purity Digsite"] = "Pools of Purity Digsite",
	["Pyrox Flats Digsite"] = "Pyrox Flats Digsite",
	["Quagmire Fossil Field"] = "Quagmire Fossil Field",
	["Quel'Dormir Gardens Digsite"] = "Quel'Dormir Gardens Digsite",
	["Quel'Lithien Lodge Digsite"] = "Quel'Lithien Lodge Digsite",
	["Ravenwind Digsite"] = "Ravenwind Digsite",
	["Razed Warsong Outpost Digsite"] = "Razed Warsong Outpost Digsite",
	["Red Reaches Fossil Bank"] = "Red Reaches Fossil Bank",
	["Remote Village Digsite"] = "Remote Village Digsite",
	["Ring of Trials Sludge Digsite"] = "Ring of Trials Sludge Digsite",
	["Riplash Ruins Digsite"] = "Riplash Ruins Digsite",
	["River Delta Digsite"] = "River Delta Digsite",
	["Ruins of Aboraz"] = "Ruins of Aboraz",
	["Ruins of Ahmtul Digsite"] = "Ruins of Ahmtul Digsite",
	["Ruins of Ammon Digsite"] = "Ruins of Ammon Digsite",
	["Ruins of Arkkoran"] = "Ruins of Arkkoran",
	["Ruins of Baa'ri Digsite"] = "Ruins of Baa'ri Digsite",
	["Ruins of Eldarath"] = "Ruins of Eldarath",
	["Ruins of Eldre'Thar"] = "Ruins of Eldre'Thar",
	["Ruins of Enkaat Digsite"] = "Ruins of Enkaat Digsite",
	["Ruins of Farahlon Digsite"] = "Ruins of Farahlon Digsite",
	["Ruins of Gan Shi Digsite"] = "Ruins of Gan Shi Digsite",
	["Ruins of Jubuwal"] = "Ruins of Jubuwal",
	["Ruins of Khintaset Digsite"] = "Ruins of Khintaset Digsite",
	["Ruins of Korja Digsite"] = "Ruins of Korja Digsite",
	["Ruins of Lar'donir Digsite"] = "Ruins of Lar'donir Digsite",
	["Ruins of Na'gwa Digsite"] = "Ruins of Na'gwa Digsite",
	["Ruins of Ordil'Aran"] = "Ruins of Ordil'Aran",
	["Ruins of Shandaral Digsite"] = "Ruins of Shandaral Digsite",
	["Ruins of Stardust"] = "Ruins of Stardust",
	["Ruins of the First Bastion Digsite"] = "Ruins of the First Bastion Digsite",
	["Rumbling Plateau Digsite"] = "Rumbling Plateau Digsite",
	["Sahket Wastes Digsite"] = "Sahket Wastes Digsite",
	["Sanctuary of Malorne Digsite"] = "Sanctuary of Malorne Digsite",
	["Sands of Nasam"] = "Sands of Nasam",
	["Sargeron Digsite"] = "Sargeron Digsite",
	["Savage Coast Raptor Fields"] = "Savage Coast Raptor Fields",
	["Schnottz's Landing"] = "Schnottz's Landing",
	["Scorched Plain Digsite"] = "Scorched Plain Digsite",
	["Scourgeholme Digsite"] = "Scourgeholme Digsite",
	["Screaming Reaches Fossil Field"] = "Screaming Reaches Fossil Field",
	["Sethekk Hollow North Digsite"] = "Sethekk Hollow North Digsite",
	["Sethekk Hollow South Digsite"] = "Sethekk Hollow South Digsite",
	["Setting Sun Garrison Digsite"] = "Setting Sun Garrison Digsite",
	["Shadra'Alor Digsite"] = "Shadra'Alor Digsite",
	["Sha'naar Digsite"] = "Sha'naar Digsite",
	["Shanze'Dao Digsite"] = "Shanze'Dao Digsite",
	["Shaz'gul Digsite"] = "Shaz'gul Digsite",
	["Shield Hill Digsite"] = "Shield Hill Digsite",
	["Shimmering Moor Digsite"] = "Shimmering Moor Digsite",
	["Shrine Meadow Digsite"] = "Shrine Meadow Digsite",
	["Shrine of Goldrinn Digsite"] = "Shrine of Goldrinn Digsite",
	["Shrine of the Dawn Digsite"] = "Shrine of the Dawn Digsite",
	["Sifreldar Village Digsite"] = "Sifreldar Village Digsite",
	["Sik'vess Digsite"] = "Sik'vess Digsite",
	["Singing Marshes Digsite"] = "Singing Marshes Digsite",
	["Skorn Digsite"] = "Skorn Digsite",
	["Slitherblade Shore Digsite"] = "Slitherblade Shore Digsite",
	["Small Gate Digsite"] = "Small Gate Digsite",
	["Snow Covered Hills Digsite"] = "Snow Covered Hills Digsite",
	["Solarsal Digsite"] = "Solarsal Digsite",
	["South Fruited Fields Digsite"] = "South Fruited Fields Digsite",
	["South Great Wall Digsite"] = "South Great Wall Digsite",
	["South Isildien Digsite"] = "South Isildien Digsite",
	["South Orchard Digsite"] = "South Orchard Digsite",
	["South Ruins of Dojan Digsite"] = "South Ruins of Dojan Digsite",
	["South Ruins of Guo-Lai Digsite"] = "South Ruins of Guo-Lai Digsite",
	["Southmoon Ruins Digsite"] = "Southmoon Ruins Digsite",
	["Southshore Fossil Field"] = "Southshore Fossil Field",
	["Southwind Cliffs Digsite"] = "Southwind Cliffs Digsite",
	["Southwind Village Digsite"] = "Southwind Village Digsite",
	["Sra'thik Digsite"] = "Sra'thik Digsite",
	["Sra'thik Swarmdock Digsite"] = "Sra'thik Swarmdock Digsite",
	["Steps of Fate Digsite"] = "Steps of Fate Digsite",
	["Stonecrag Excavation Digsite"] = "Stonecrag Excavation Digsite",
	["Stonetalon Peak"] = "Stonetalon Peak",
	["Sunken Temple Digsite"] = "Sunken Temple Digsite",
	["Sunspring Post Digsite"] = "Sunspring Post Digsite",
	["Talramas Digsite"] = "Talramas Digsite",
	["Temple of Uldum Digsite"] = "Temple of Uldum Digsite",
	["Terrace of Gurthan Digsite"] = "Terrace of Gurthan Digsite",
	["Terror Run Fossil Field"] = "Terror Run Fossil Field",
	["Terrorweb Tunnel Digsite"] = "Terrorweb Tunnel Digsite",
	["Terror Wing Fossil Field"] = "Terror Wing Fossil Field",
	["Thandol Span"] = "Thandol Span",
	["The Arboretum Digsite"] = "The Arboretum Digsite",
	["The Briny Muck Digsite"] = "The Briny Muck Digsite",
	["The Broken Spine Digsite"] = "The Broken Spine Digsite",
	["The Clutches of Shek'zeer Digsite"] = "The Clutches of Shek'zeer Digsite",
	["The Crackling Plains Digsite"] = "The Crackling Plains Digsite",
	["The Feeding Pits Digsite"] = "The Feeding Pits Digsite",
	["The Spring Road Digsite"] = "The Spring Road Digsite",
	["The Underbough Digsite"] = "The Underbough Digsite",
	["Thoradin's Wall"] = "Thoradin's Wall",
	["Thundermar Ruins Digsite"] = "Thundermar Ruins Digsite",
	["Thunderwood Digsite"] = "Thunderwood Digsite",
	["Tian Digsite"] = "Tian Digsite",
	["Tiger's Wood Digsite"] = "Tiger's Wood Digsite",
	["Tomb of the Watchers Digsite"] = "Tomb of the Watchers Digsite",
	["Tombs of the Precursors Digsite"] = "Tombs of the Precursors Digsite",
	["Torjari Pit Digsite"] = "Torjari Pit Digsite",
	["Tu Shen Digsite"] = "Tu Shen Digsite",
	["Tuurem Digsite"] = "Tuurem Digsite",
	["Twilight Grove Digsite"] = "Twilight Grove Digsite",
	["Twin Spire Ruins Digsite"] = "Twin Spire Ruins Digsite",
	["Uldaman Entrance Digsite"] = "Uldaman Entrance Digsite",
	["Umbrafen Digsite"] = "Umbrafen Digsite",
	["Unearthed Grounds"] = "Unearthed Grounds",
	["Upper Lakkari Tar Pits"] = "Upper Lakkari Tar Pits",
	["Valkyrion Digsite"] = "Valkyrion Digsite",
	["Valley of Bones"] = "Valley of Bones",
	["Valley of Kings Digsite"] = "Valley of Kings Digsite",
	["Veil Akraz Digsite"] = "Veil Akraz Digsite",
	["Veil Shadar Digsite"] = "Veil Shadar Digsite",
	["Veil Zekk Digsite"] = "Veil Zekk Digsite",
	["Venomous Ledge Digsite"] = "Venomous Ledge Digsite",
	["Veridian Grove Digsite"] = "Veridian Grove Digsite",
	["Violet Stand Digsite"] = "Violet Stand Digsite",
	["Voldrune Digsite"] = "Voldrune Digsite",
	["Vul'Gol Fossil Bank"] = "Vul'Gol Fossil Bank",
	["Warden's Cage Digsite"] = "Warden's Cage Digsite",
	["West Auchindoun Digsite"] = "West Auchindoun Digsite",
	["West Old Village Digsite"] = "West Old Village Digsite",
	["West Ruins of Guo-Lai Digsite"] = "West Ruins of Guo-Lai Digsite",
	["West Sik'vess Digsite"] = "West Sik'vess Digsite",
	["West Sra'vess Digsite"] = "West Sra'vess Digsite",
	["West Summer Fields Digsite"] = "West Summer Fields Digsite",
	["Western Ruins of Thaurissan"] = "Western Ruins of Thaurissan",
	["Western Zul'Kunda Digsite"] = "Western Zul'Kunda Digsite",
	["Western Zul'Mamwe Digsite"] = "Western Zul'Mamwe Digsite",
	["Whelgar's Excavation Site"] = "Whelgar's Excavation Site",
	["Wildwood Wash Dam Digsite"] = "Wildwood Wash Dam Digsite",
	["Winterbough Digsite"] = "Winterbough Digsite",
	["Witherbark Digsite"] = "Witherbark Digsite",
	["Wor'gol Ridge Digsite"] = "Wor'gol Ridge Digsite",
	["Writhing Mire Digsite"] = "Writhing Mire Digsite",
	["Writhingwood Digsite"] = "Writhingwood Digsite",
	["Wyrmbog Fossil Field"] = "Wyrmbog Fossil Field",
	["Wyrmskull Digsite"] = "Wyrmskull Digsite",
	["Ymirheim Digsite"] = "Ymirheim Digsite",
	["Zangarra Digsite"] = "Zangarra Digsite",
	["Zan'vess Digsite"] = "Zan'vess Digsite",
	["Zeth'Gor Digsite"] = "Zeth'Gor Digsite",
	["Zhu Province Digsite"] = "Zhu Province Digsite",
	["Ziata'jai Digsite"] = "Ziata'jai Digsite",
	["Zim'Rhuk Digsite"] = "Zim'Rhuk Digsite",
	["Zol'Heb Digsite"] = "Zol'Heb Digsite",
	["Zoram Strand Digsite"] = "Zoram Strand Digsite",
	["Zul'Farrak Digsite"] = "Zul'Farrak Digsite",
	["Zul'Mashar Digsite"] = "Zul'Mashar Digsite",
	}
)

if GAME_LOCALE == "enUS" then
	lib:SetCurrentTranslations(true)

elseif GAME_LOCALE == "deDE" then
	lib:SetCurrentTranslations (
	--@localization(locale="deDE", format="lua_table", handle-unlocalized="english")@
)

elseif GAME_LOCALE == "frFR" then
	lib:SetCurrentTranslations (
	--@localization(locale="frFR", format="lua_table", handle-unlocalized="english")@
)

elseif GAME_LOCALE == "koKR" then
	lib:SetCurrentTranslations (
	--@localization(locale="koKR", format="lua_table", handle-unlocalized="english")@
)

elseif GAME_LOCALE == "esES" or GAME_LOCALE == "esMX" then
	lib:SetCurrentTranslations (
	--@localization(locale="esES", format="lua_table", handle-unlocalized="english")@
)

elseif GAME_LOCALE == "ruRU" then
	lib:SetCurrentTranslations (
	--@localization(locale="ruRU", format="lua_table", handle-unlocalized="english")@
)

elseif GAME_LOCALE == "zhCN" then
	lib:SetCurrentTranslations (
	--@localization(locale="zhCN", format="lua_table", handle-unlocalized="english")@
)

elseif GAME_LOCALE == "zhTW" then
	lib:SetCurrentTranslations (
	--@localization(locale="zhTW", format="lua_table", handle-unlocalized="english")@
)

elseif GAME_LOCALE == "ptBR" then
	lib:SetCurrentTranslations (
	--@localization(locale="ptBR", format="lua_table", handle-unlocalized="english")@
)

elseif GAME_LOCALE == "itIT" then
	lib:SetCurrentTranslations (
	--@localization(locale="itIT", format="lua_table", handle-unlocalized="english")@
)

else
	error(("%s: Locale %q not supported"):format(MAJOR_VERSION, GAME_LOCALE))
end
