-- Settings
RealmPlayer = GetRealmName().. ", "..UnitName("player");
MerchConfig_VariablesLoaded = false;
MERCHANTHELPER_VERSION = "V3.4b for WoW Build 7.3"

local MerchConfig_MHAutoRepair = false;
local MerchConfig_MHAnnounceRepair = false;
local MerchConfig_MHAutoVendor = false;
local MerchConfig_VendorList = false;
local MerchConfig_VendorTotal = false;
local MerchConfig_MHMerchantBags = false;
local MerchConfig_MHMailBags = false;
local MerchConfig_MHAuctionBags = false;
local MerchConfig_MHBankBags = false;
local MerchConfig_MHGuildBankBags = false;
local MerchConfig_MHGuildBankRepair = false;
local MerchConfig_MHTradeBags = false;
local MerchConfig_MHVendorLimit = false;
local MerchConfig_MHDestroyJunkValue = 5;
local MerchConfig_MHTooltips = true;
local MerchConfig_VendorWhitesList = { }
local MerchConfig_MerchSafeList = { }

-- OnLoad function
-- Register events, loaded message

function MerchantHelper_OnLoad(self)
	MHPrint("Loaded MerchantHelper " ..MERCHANTHELPER_VERSION);
	MHPrint("Type /merch to configure, or /merch help for Vendor List and Safe List commands");

	self:RegisterEvent("MERCHANT_SHOW");
	self:RegisterEvent("MERCHANT_CLOSED", arg1);
	self:RegisterEvent("BANKFRAME_OPENED");
	self:RegisterEvent("BANKFRAME_CLOSED");
	self:RegisterEvent("AUCTION_HOUSE_SHOW");
	self:RegisterEvent("AUCTION_HOUSE_CLOSED");
	self:RegisterEvent("GUILDBANKFRAME_OPENED");
	self:RegisterEvent("GUILDBANKFRAME_CLOSED");
	self:RegisterEvent("MAIL_SHOW");
	self:RegisterEvent("MAIL_CLOSED");
	self:RegisterEvent("VARIABLES_LOADED");
	self:RegisterEvent("TRADE_SHOW");
	self:RegisterEvent("TRADE_CLOSED");

	SLASH_MERCHANTHELPER1 = "/merch";
	SLASH_MERCHANTHELPER2 = "/merchanthelper";
	SLASH_MERCHANTHELPER3 = "/mhconfig";
	SlashCmdList["MERCHANTHELPER"] = function(msg, editbox)
		local comm, rest = msg:match("^(%S*)%s*(.-)$")
		local command = string.lower(comm)
		if command == "add" and rest ~= "" then
			Merch_VendorWhitesList_Add(rest)
		elseif command == "add" and rest == "" then
			MHPrint("Please link an item to add");
		elseif command == "remove" and rest ~= "" then
			Merch_VendorWhitesList_Remove(rest)
		elseif command ==  "remove" and rest == "" then
			MHPrint("Please link an item to remove from list");
		elseif command == "list" then
			Merch_VendorWhitesList_List()
		elseif command == "clearlist" then
			StaticPopup_Show("CLEAR_LIST")
		elseif command == "help" then
			Merch_Help()
		elseif command == "show" or "" then
			MerchConfigFrame:Show();
		end
	end
	SLASH_MERCHSAFE1 = "/merchsafe";
	SLASH_MERCHSAFE2 = "/safe";
	SlashCmdList["MERCHSAFE"] = function(msg, editbox)
		local comm, rest = msg:match("^(%S*)%s*(.-)$")
		local command = string.lower(comm)
		if command == "add" and rest ~= "" then
			Merch_SafeList_Add(rest)
		elseif command == "add" and rest == "" then
			MHPrint("Please link an item to add");
		elseif command == "remove" and rest ~= "" then
			Merch_SafeList_Remove(rest)
		elseif command ==  "remove" and rest == "" then
			MHPrint("Please link an item to remove from list");
		elseif command == "list" then
			Merch_SafeList_List()
		elseif command == "clearlist" then
			StaticPopup_Show("CLEAR_SAFE_LIST")
		end
	end
end


function MHPrint(printmsg)
	DEFAULT_CHAT_FRAME:AddMessage(printmsg, 0, 1, 1);
end
function MHPrintRed(printmsg)
	DEFAULT_CHAT_FRAME:AddMessage(printmsg, 1, 0, 0);
end
function MHPrintGreen(printmsg)
	DEFAULT_CHAT_FRAME:AddMessage(printmsg, 0, 1, 0);
end
function MHPrintYellow(printmsg)
	DEFAULT_CHAT_FRAME:AddMessage(printmsg, 1, 1, 0);
end


function MerchantHelper_OnEvent(self, event, ...)
	if ( event == "VARIABLES_LOADED" ) then
		MerchantHelper_VARIABLES_LOADED();
	end
	if ( event == "MERCHANT_SHOW") then
		local isRepairer = CanMerchantRepair();
		if ( MerchConfig[RealmPlayer].MHMerchantBags ) then
			MerchOpenBags()
		end
		if ( MerchConfig[RealmPlayer].MHAutoVendor ) then
			MerchAutoVendor()
		end
		if ( isRepairer and MerchConfig[RealmPlayer].MHAutoRepair ) then
			MerchRepair()
		end
	end
	if ( event == "MAIL_SHOW" and MerchConfig[RealmPlayer].MHMailBags ) then
		MerchOpenBags()
	end
	if ( event == "AUCTION_HOUSE_SHOW" and MerchConfig[RealmPlayer].MHAuctionBags ) then
		MerchOpenBags()
	end
	if ( event == "BANKFRAME_OPENED" and MerchConfig[RealmPlayer].MHBankBags ) then
		MerchOpenBags()
		MerchBankBags()
	end
	if ( event == "GUILDBANKFRAME_OPENED" and MerchConfig[RealmPlayer].MHGuildBankBags ) then
		MerchOpenBags()
	end
	if ( event == "TRADE_SHOW" and MerchConfig[RealmPlayer].MHTradeBags ) then
		MerchOpenBags()
	end
	if ( event == "MERCHANT_CLOSED" and MerchConfig[RealmPlayer].MHMerchantBags ) then
		MerchCloseBags();
	end
	if ( event == "MAIL_CLOSED" and MerchConfig[RealmPlayer].MHMailBags ) then
		MerchCloseBags();
	end
	if ( event == "AUCTION_HOUSE_CLOSED" and MerchConfig[RealmPlayer].MHAuctionBags ) then
		MerchCloseBags();
	end
	if ( event == "BANKFRAME_CLOSED" and MerchConfig[RealmPlayer].MHBankBags ) then
		MerchCloseBags();
	end
	if ( event == "GUILDBANKFRAME_CLOSED" and MerchConfig[RealmPlayer].MHGuildBankBags ) then
		MerchCloseBags();
	end
	if ( event == "TRADE_CLOSED" and MerchConfig[RealmPlayer].MHTradeBags ) then
		MerchCloseBags();
	end
end

function MerchCloseBags()
	ContainerFrame1.backpackWasOpen = nil;
	CloseAllBags()
end

function MerchOpenBags()
	for i = 0, NUM_BAG_SLOTS do
		OpenBag(i)
	end
end

function MerchBankBags()
	for i = 0, (NUM_BAG_SLOTS + NUM_BANKBAGSLOTS) do
		OpenBag(i)
	end
end

function MerchAutoVendor()
	local itemTotal = 0
	local totalSaleProfit = 0
	for x = 0, 4 do 
		for y = 1, GetContainerNumSlots(x) do
			local b = GetContainerItemLink(x,y);
			if ( b ) then
				local _, bItemId = strsplit(":", b)
				local _, iLink, iRarity, _, _, _, _, _, _, _, iSellValue = GetItemInfo(b);
				if ( ( ( iRarity == 0 ) or (MerchConfig[RealmPlayer].MHVendorWhitesList[bItemId]) ) and not MerchConfig[RealmPlayer].MHMerchSafeList[bItemId] ) then
					if ( iSellValue >= 1 ) then
						PickupContainerItem(x,y);
						local _, itemCount = GetContainerItemInfo(x,y);
						PickupMerchantItem();
						local merchItemProfit = itemCount * iSellValue;
						if ( MerchConfig[RealmPlayer].MHVendorList ) then
							MHPrint("Item " ..iLink.. " x" ..itemCount.. " sold for " ..MerchMoney(merchItemProfit).."!");
						end
						itemTotal = itemTotal + 1;
						totalSaleProfit = totalSaleProfit + merchItemProfit;
						if ( MerchConfig[RealmPlayer].MHVendorLimit and ( itemTotal == 12) ) then
							MHPrint("12 Items Sold for total profit of " ..MerchMoney(totalSaleProfit).. "");
							MHPrint("Please reopen the merchant window to sell anymore grey items you may have");
							return;
						end
					elseif ( iSellValue == 0 and MerchConfig[RealmPlayer].MHVendorList ) then
						MHPrint(iLink.. "not able to be sold");
					end
				elseif ( MerchConfig[RealmPlayer].MHMerchSafeList[bItemId] ) then
					MHPrint(iLink.. "not sold as it is on the Safe List");
				end
			end
		end
	end

	if ( MerchConfig[RealmPlayer].MHVendorTotal ) then
		if ( itemTotal == 0 ) then
			return;
		else
			MHPrint("Total items sold: " ..itemTotal.. "  Total profit: " ..MerchMoney(totalSaleProfit).. "!" );
		end
	elseif ( not MerchConfig[RealmPlayer].MHVendorTotal ) then
		return;
	end
end

function MerchRepair()
	local repairAllCost, canRepair = GetRepairAllCost();
	local playerMoney = GetMoney();
	if not canRepair then
		return;
	elseif ( canRepair and not MerchConfig[RealmPlayer].MHGuildBankRepair ) then
		if ( playerMoney > repairAllCost ) then
			RepairAllItems();
			if ( MerchConfig[RealmPlayer].MHAnnounceRepair ) then
				MHPrintRed("Repairs made: " ..MerchMoney(repairAllCost).. "!");
			elseif ( not MerchConfig[RealmPlayer].MHAnnounceRepair ) then
				return;
			end
		elseif ( playerMoney < repairAllCost ) then
			MHPrintRed("Insufficient funds to make repairs");
		elseif ( playerMoney == repairAllCost ) then
			MHPrintRed("Total repairs will cost all your available funds, please repair manually");
			MHPrintRed("WHAT ARE THE ODDS OF THAT HAPPENING!");
		end
--  GUILD BANK REPAIR
	elseif ( canRepair and MerchConfig[RealmPlayer].MHGuildBankRepair ) then
		local withdrawLimit = GetGuildBankWithdrawMoney();
		local guildRepair = CanGuildBankRepair();
		local gbBalance = GetGuildBankMoney();
		local gbAvailable = min(withdrawLimit, gbBalance);
		if ( withdrawLimit == -1 ) then
			gbAvailable = gbBalance;
		end
		if ( MerchConfig[RealmPlayer].MHGuildBankRepair and ( not guildRepair ) ) then
			MHPrintGreen("You do not have authority to repair using guild funds, or are not in a guild.  Please type /merch to update your configuration options");
		elseif ( gbAvailable > repairAllCost ) then
			RepairAllItems(1);
			if ( MerchConfig[RealmPlayer].MHAnnounceRepair ) then
				MHPrintGreen("Repairs made using Guild Bank funds: " ..MerchMoney(repairAllCost).. "!");
			end
		elseif ( gbAvailable < repairAllCost ) then
			MHPrintGreen("Insufficient guild bank funds to make repairs");
		elseif ( gbAvailable == repairAllCost ) then
			MHPrintGreen("Total repairs will use the exact remainder of your guild bank withdrawal balance, please repair manually");
			MHPrintGreen("WHAT ARE THE ODDS OF THAT HAPPENING!");
		end
	end
end

-- taken from http://www.wowwiki.com/User:Egingell/PLAYER_MONEY
function MerchMoney(money)
    local ret = ""
    local gold = floor(money / (COPPER_PER_SILVER * SILVER_PER_GOLD));
    local silver = floor((money - (gold * COPPER_PER_SILVER * SILVER_PER_GOLD)) / COPPER_PER_SILVER);
    local copper = mod(money, COPPER_PER_SILVER);
    if gold > 0 then
        ret = gold .. "g "
    end
    if silver > 0 or gold > 0 then
        ret = ret .. silver .. "s "
    end
    ret = ret .. copper .. "c"
    return ret
end


function MerchantHelperTooltip(frame)
	if (  MerchConfig[RealmPlayer].MHTooltips ) then
		if not frame.tooltip then
			return;
		end

		GameTooltip:SetOwner(frame, "ANCHOR_RIGHT");
		GameTooltip:ClearLines();
		GameTooltip:AddLine(frame.tooltip);
		GameTooltip:Show();
	elseif ( not MerchConfig[RealmPlayer].MHTooltips ) then
		return;
	end
end


StaticPopupDialogs["DESTROY_JUNK"] = {
	text = "Do you really want to destroy the grey items and Vendor List items to the value selected? |CFF00FF00Once destroyed these items will not be recoverable.",
	button1 = "Yes",
	button2 = "No",
	OnAccept = function()
		DestroyJunk();
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
	showAlert = 1,
	exclusive = 1
};


StaticPopupDialogs["CLEAR_LIST"] = {
	text = "Do you really want to remove all the items from your Vendor List?",
	button1 = "Yes",
	button2 = "No",
	OnAccept = function()
		Merch_VendorWhitesList_Clear();
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1
};

StaticPopupDialogs["CLEAR_SAFE_LIST"] = {
	text = "Do you really want to remove all the items from your SAFE List?",
	button1 = "Yes",
	button2 = "No",
	OnAccept = function()
		Merch_SafeList_Clear();
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1
};


function DestroyJunk()
	local destroyedItems = 0
	local destroyLimit = MerchConfig[RealmPlayer].MHDestroyJunkValue * 100
	for x = 0, 4 do
		for y = 1, GetContainerNumSlots(x) do
			local dj = GetContainerItemLink(x,y);
			if (dj) then
				local _, djItemId = strsplit(":", dj)
				local djName, djLink, djRarity, _, _, _, _, djStackCount, _, _, djSellValue = GetItemInfo(dj);
				local djTotalValue = djStackCount * djSellValue;
				if ( ( ( djRarity == 0 ) or (MerchConfig[RealmPlayer].MHVendorWhitesList[djItemId] ) ) and not MerchConfig[RealmPlayer].MHMerchSafeList[djItemId] ) then
					if ( ( djTotalValue > 0 ) and ( djTotalValue < destroyLimit ) ) then
						PickupContainerItem(x,y);
						local _, djItemCount = GetContainerItemInfo(x,y);
						if CursorHasItem() then
							DeleteCursorItem();
						end
						destroyedItems = destroyedItems + 1;
						MHPrint("Destroyed " ..djLink.. " x" ..djItemCount );
					elseif ( djTotalValue == 0 ) then
						if ( MerchConfig[RealmPlayer].MHVendorWhitesList[djItemId] ~= nil ) then
							PickupContainerItem(x,y);
							if CursorHasItem() then
								DeleteCursorItem();
							end
							destroyedItems = destroyedItems + 1;
							MHPrint("Destroyed " ..djLink.. ""); 
						elseif ( MerchConfig[RealmPlayer].MHVendorWhitesList[djItemId] == nil ) then
							MHPrint("Did not destroy " ..djLink.. ", please delete manually if required");
						end
					end
				elseif MerchConfig[RealmPlayer].MHMerchSafeList[djItemId] then
					-- MHPrint(djLink.. "not destroyed as it is on the Safe list");
				end
			end
		end
	end
	-- Print number of items destroyed
	if destroyedItems == 0 then
		return;
	elseif destroyedItems > 0 then
		MHPrint("Number of Items destroyed: " ..destroyedItems.. "");
	end
end
					
function Merch_VendorWhitesList_Add(VWItem)
	local _, VWItemId = strsplit(":", VWItem)
	if (MerchConfig[RealmPlayer].MHVendorWhitesList[VWItemId] ~= nil) then
		MHPrint(VWItem.." is already on your Vendor list.")
	else
		MHPrint(VWItem.." has been added to the Vendor list.")
		MerchConfig[RealmPlayer].MHVendorWhitesList[VWItemId] = VWItemId
	end
end

function Merch_VendorWhitesList_Remove(VWItem)
	local _, VWItemId = strsplit(":", VWItem)
	if (MerchConfig[RealmPlayer].MHVendorWhitesList[VWItemId] == nil) then
		MHPrint(VWItem.." is not in your Vendor list.")
	else
		MHPrint(VWItem.." has been removed from the Vendor list.")
		MerchConfig[RealmPlayer].MHVendorWhitesList[VWItemId] = nil
	end
end

function Merch_VendorWhitesList_List()
	MHPrint("Vendor List: ");
	local VWListItems = 0
	for i in pairs(MerchConfig[RealmPlayer].MHVendorWhitesList) do
		_, VWLink = GetItemInfo(i)
		if VWLink then
			MHPrint(VWLink)
			VWListItems = VWListItems + 1
		end
	end
	MHPrint("Vendor List contains " ..VWListItems.. "");
end

function Merch_VendorWhitesList_Clear()
	MHPrint("Vendor List has been cleared");
	MerchConfig[RealmPlayer].MHVendorWhitesList = { }
end

function Merch_SafeList_Add(SafeItem)
	local _, SafeItemId = strsplit(":", SafeItem)
	if (MerchConfig[RealmPlayer].MHMerchSafeList[SafeItemId] ~= nil) then
		MHPrint(SafeItem.." is already on your Safe Items list.")
	else
		MHPrint(SafeItem.." has been added to the Safe Items list.")
		MerchConfig[RealmPlayer].MHMerchSafeList[SafeItemId] = SafeItemId
	end
end


function Merch_SafeList_Remove(SafeItem)
	local _, SafeItemId = strsplit(":", SafeItem)
	if (MerchConfig[RealmPlayer].MHMerchSafeList[SafeItemId] == nil) then
		MHPrint(SafeItem.." is not in your Safe Items list.")
	else
		MHPrint(SafeItem.." has been removed from the Safe Items list.")
		MerchConfig[RealmPlayer].MHMerchSafeList[SafeItemId] = nil
	end
end

function Merch_SafeList_List()
	MHPrint("Safe Items List (will not be sold): ");
	local SafeListItems = 0
	for i in pairs(MerchConfig[RealmPlayer].MHMerchSafeList) do
		_, SafeLink = GetItemInfo(i)
		if SafeLink then
			MHPrint(SafeLink)
			SafeListItems = SafeListItems + 1
		end
	end
	MHPrint("Safe Items List contains " ..SafeListItems.. " items.");
end

function Merch_SafeList_Clear()
	MHPrint("Safe Items List has been cleared");
	MerchConfig[RealmPlayer].MHMerchSafeList = { }
end

function Merch_Help()
	MHPrint("Type |cFFFFFFFF/merch|r to bring up the configuration window.");
	MHPrint("Type |cFFFFFFFF/merch add [link]|r to add an item to the Vendor List.");
	MHPrint("Type |cFFFFFFFF/merch remove [link]|r to remove an item from the Vendor List.");
	MHPrint("Type |cFFFFFFFF/merch list|r to print a list of all items in your vendor List.");
	MHPrint("Type |cFFFFFFFF/merch clearlist|r to completely clear the Vendor List.");
	MHPrint("Items in the Vendor List will be automatically sold to vendors if Auto Sell is enabled");
	MHPrint("They will also be destroyed (based on sell price) if the destroy function is used");
	MHPrint("Items in the Vendor List (including grey items) will be destroyed if they have no sell price");
	MHPrint("New Feature: Safe List - add junk items to the safe list so they will not be sold or destroyed")
	MHPrint("Type |cFFFFFFFF/safe add [link]|r to add an item to the Safe Items List.");
	MHPrint("Type |cFFFFFFFF/safe remove [link]|r to remove an item from the Safe Items List.");
	MHPrint("Type |cFFFFFFFF/safe list|r to print a list of all items in your Safe Items List.");
	MHPrint("Type |cFFFFFFFF/safe clearlist|r to completely clear the Safe Items List.");
end


---------------------------------------------------
--- Set up for Options Menu & Saved Variables -----
---------------------------------------------------

function MerchantHelper_VARIABLES_LOADED()

	if ( not MerchConfig ) then
		MerchConfig = {};
	end
	if ( not MerchConfig[RealmPlayer] ) then
		MerchConfig[RealmPlayer] = {};
	end
	if ( not MerchConfig[RealmPlayer].MHAutoRepair ) then
		MerchConfig[RealmPlayer].MHAutoRepair = MerchConfig_MHAutoRepair;
	end
	if ( not MerchConfig[RealmPlayer].MHAnnounceRepair ) then
		MerchConfig[RealmPlayer].MHAnnounceRepair = MerchConfig_AnnounceRepair;
	end
	if ( not MerchConfig[RealmPlayer].MHAutoVendor ) then
		MerchConfig[RealmPlayer].MHAutoVendor = MerchConfig_MHAutoVendor;
	end
	if ( not MerchConfig[RealmPlayer].MHVendorList ) then
		MerchConfig[RealmPlayer].MHVendorList = MerchConfig_MHVendorList;
	end
	if ( not MerchConfig[RealmPlayer].MHVendorTotal ) then
		MerchConfig[RealmPlayer].MHVendorTotal = MerchConfig_MHVendorTotal;
	end
	if ( not MerchConfig[RealmPlayer].MHMerchantBags ) then
		MerchConfig[RealmPlayer].MHMerchantBags = MerchConfig_MHMerchantBags;
	end
	if ( not MerchConfig[RealmPlayer].MHMerchantBags ) then
		MerchConfig[RealmPlayer].MHMailBags = MerchConfig_MHMailBags;
	end
	if ( not MerchConfig[RealmPlayer].MHAuctionBags ) then
		MerchConfig[RealmPlayer].MHAuctionBags = MerchConfig_MHAuctionBags;
	end
	if ( not MerchConfig[RealmPlayer].MHBankBags ) then
		MerchConfig[RealmPlayer].MHBankBags = MerchConfig_MHBankBags;
	end
	if ( not MerchConfig[RealmPlayer].MHGuildBankBags ) then
		MerchConfig[RealmPlayer].MHGuildBankBags = MerchConfig_MHGuildBankBags;
	end
	if ( not MerchConfig[RealmPlayer].MHGuildBankRepair ) then
		MerchConfig[RealmPlayer].MHGuildBankRepair = MerchConfig_MHGuildBankRepair;
	end
	if ( not MerchConfig[RealmPlayer].MHTradeBags ) then
		MerchConfig[RealmPlayer].MHTradeBags = MerchConfig_MHTradeBags;
	end
	if ( not MerchConfig[RealmPlayer].MHVendorLimit ) then
		MerchConfig[RealmPlayer].MHVendorLimit = MerchConfig_MHVendorLimit;
	end
	if ( not MerchConfig[RealmPlayer].MHDestroyJunkValue ) then
		MerchConfig[RealmPlayer].MHDestroyJunkValue = MerchConfig_MHDestroyJunkValue;
	end
	if ( not MerchConfig[RealmPlayer].MHTooltips ) then
		MerchConfig[RealmPlayer].MHTooltips = MerchConfig_MHTooltips;
	end
	if ( not MerchConfig[RealmPlayer].MHVendorWhitesList ) then
		MerchConfig[RealmPlayer].MHVendorWhitesList = MerchConfig_VendorWhitesList;
	end
	if ( not MerchConfig[RealmPlayer].MHMerchSafeList ) then
		MerchConfig[RealmPlayer].MHMerchSafeList = MerchConfig_MerchSafeList;
	end

	MerchConfig_VariablesLoaded = true;  -- record that variables have been loaded
end

function MerchConfigDefaults()
	if (not MerchConfig_VariablesLoaded ) then
		MerchantHelperFrame:Hide();
		return;
	end

	MerchConfig[RealmPlayer].MHAutoRepair = MerchConfig_MHAutoRepair;
	MerchConfig[RealmPlayer].MHAnnounceRepair = MerchConfig_AnnounceRepair;
	MerchConfig[RealmPlayer].MHAutoVendor = MerchConfig_MHAutoVendor;
	MerchConfig[RealmPlayer].MHVendorList = MerchConfig_VendorList;
	MerchConfig[RealmPlayer].MHVendorTotal = MerchConfig_VendorTotal;
	MerchConfig[RealmPlayer].MHMerchantBags = MerchConfig_MHMerchantBags;
	MerchConfig[RealmPlayer].MHMailBags = MerchConfig_MHMailBags;
	MerchConfig[RealmPlayer].MHAuctionBags = MerchConfig_MHAuctionBags;
	MerchConfig[RealmPlayer].MHBankBags = MerchConfig_MHBankBags;
	MerchConfig[RealmPlayer].MHGuildBankBags = MerchConfig_MHGuildBankBags;
	MerchConfig[RealmPlayer].MHGuildBankRepair = MerchConfig_MHGuildBankRepair;
	MerchConfig[RealmPlayer].MHTradeBags = MerchConfig_MHTradeBags;
	MerchConfig[RealmPlayer].MHVendorLimit = MerchConfig_MHVendorLimit;
	MerchConfig[RealmPlayer].MHDestroyJunkValue = 10;
end

function MerchConfigEnableAll()
	if (not MerchConfig_VariablesLoaded ) then
		MerchantHelperFrame:Hide();
		return;
	end
	MerchConfig[RealmPlayer].MHAutoRepair = true;
	MerchConfig[RealmPlayer].MHAnnounceRepair = true;
	MerchConfig[RealmPlayer].MHAutoVendor = true;
	MerchConfig[RealmPlayer].MHVendorList = true;
	MerchConfig[RealmPlayer].MHVendorTotal = true;
	MerchConfig[RealmPlayer].MHMerchantBags = true;
	MerchConfig[RealmPlayer].MHMailBags = true;
	MerchConfig[RealmPlayer].MHAuctionBags = true;
	MerchConfig[RealmPlayer].MHBankBags = true;
	MerchConfig[RealmPlayer].MHGuildBankBags = true;
	MerchConfig[RealmPlayer].MHGuildBankRepair = true;
	MerchConfig[RealmPlayer].MHTradeBags = true;
	MerchConfig[RealmPlayer].MHVendorLimit = true;
	MerchConfig[RealmPlayer].MHDestroyJunkValue = MerchConfig_MHDestroyJunkValue;
end

